/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.pubsub;

import com.typesafe.config.Config;
import java.util.concurrent.TimeUnit;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.cluster.pubsub.DistributedPubSubSettings;
import org.apache.pekko.routing.BroadcastRoutingLogic;
import org.apache.pekko.routing.RandomRoutingLogic;
import org.apache.pekko.routing.RoundRobinRoutingLogic;
import org.apache.pekko.routing.RoutingLogic;
import scala.None$;
import scala.Option;
import scala.Option$;
import scala.concurrent.duration.package;
import scala.concurrent.duration.package$;

public final class DistributedPubSubSettings$ {
    public static final DistributedPubSubSettings$ MODULE$ = new DistributedPubSubSettings$();

    public DistributedPubSubSettings apply(ActorSystem system) {
        return this.apply(system.settings().config().getConfig("pekko.cluster.pub-sub"));
    }

    /*
     * Enabled force condition propagation
     * Lifted jumps to return sites
     */
    public DistributedPubSubSettings apply(Config config) {
        Option<String> option = this.roleOption(config.getString("role"));
        String string = config.getString("routing-logic");
        switch (string == null ? 0 : string.hashCode()) {
            case -1662301013: {
                if (!"round-robin".equals(string)) throw new IllegalArgumentException(new StringBuilder(27).append("Unknown 'routing-logic': [").append(string).append("]").toString());
                RoundRobinRoutingLogic roundRobinRoutingLogic = new RoundRobinRoutingLogic();
                return new DistributedPubSubSettings(option, (RoutingLogic)roundRobinRoutingLogic, new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("gossip-interval", TimeUnit.MILLISECONDS))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("removed-time-to-live", TimeUnit.MILLISECONDS))).millis(), config.getInt("max-delta-elements"), config.getBoolean("send-to-dead-letters-when-no-subscribers"));
            }
            case -1618876223: {
                if (!"broadcast".equals(string)) throw new IllegalArgumentException(new StringBuilder(27).append("Unknown 'routing-logic': [").append(string).append("]").toString());
                RoundRobinRoutingLogic roundRobinRoutingLogic = new BroadcastRoutingLogic();
                return new DistributedPubSubSettings(option, (RoutingLogic)roundRobinRoutingLogic, new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("gossip-interval", TimeUnit.MILLISECONDS))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("removed-time-to-live", TimeUnit.MILLISECONDS))).millis(), config.getInt("max-delta-elements"), config.getBoolean("send-to-dead-letters-when-no-subscribers"));
            }
            case -938285885: {
                if (!"random".equals(string)) throw new IllegalArgumentException(new StringBuilder(27).append("Unknown 'routing-logic': [").append(string).append("]").toString());
                RoundRobinRoutingLogic roundRobinRoutingLogic = new RandomRoutingLogic();
                return new DistributedPubSubSettings(option, (RoutingLogic)roundRobinRoutingLogic, new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("gossip-interval", TimeUnit.MILLISECONDS))).millis(), new package.DurationLong(package$.MODULE$.DurationLong(config.getDuration("removed-time-to-live", TimeUnit.MILLISECONDS))).millis(), config.getInt("max-delta-elements"), config.getBoolean("send-to-dead-letters-when-no-subscribers"));
            }
            case -560580647: {
                if (!"consistent-hashing".equals(string)) throw new IllegalArgumentException(new StringBuilder(27).append("Unknown 'routing-logic': [").append(string).append("]").toString());
                throw new IllegalArgumentException("'consistent-hashing' routing logic can't be used by the pub-sub mediator");
            }
            default: {
                throw new IllegalArgumentException(new StringBuilder(27).append("Unknown 'routing-logic': [").append(string).append("]").toString());
            }
        }
    }

    public DistributedPubSubSettings create(ActorSystem system) {
        return this.apply(system);
    }

    public DistributedPubSubSettings create(Config config) {
        return this.apply(config);
    }

    public Option<String> roleOption(String role) {
        String string = role;
        String string2 = "";
        if (string != null && string.equals(string2)) {
            return None$.MODULE$;
        }
        return Option$.MODULE$.apply((Object)role);
    }

    private DistributedPubSubSettings$() {
    }
}

