/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import java.io.Serializable;
import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.internal.ActiveEntities;
import org.apache.pekko.cluster.sharding.internal.ActiveEntities$;
import org.apache.pekko.cluster.sharding.internal.AdmissionFilter;
import org.apache.pekko.cluster.sharding.internal.AdmissionFilter$;
import org.apache.pekko.cluster.sharding.internal.AdmissionOptimizer$;
import org.apache.pekko.cluster.sharding.internal.CompositeEntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.DisabledEntityPassivationStrategy$;
import org.apache.pekko.cluster.sharding.internal.EntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.IdleCheck;
import org.apache.pekko.cluster.sharding.internal.IdleEntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.LeastFrequentlyUsedEntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.LeastRecentlyUsedEntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.MostRecentlyUsedEntityPassivationStrategy;
import org.apache.pekko.cluster.sharding.internal.NoActiveEntities$;
import org.apache.pekko.cluster.sharding.internal.NoAdmissionOptimizer$;
import org.apache.pekko.cluster.sharding.internal.SegmentedLeastRecentlyUsedEntityPassivationStrategy;
import scala.Function1;
import scala.Option;
import scala.collection.immutable.Seq;
import scala.concurrent.duration.FiniteDuration;

@InternalApi
public final class EntityPassivationStrategy$ {
    public static final EntityPassivationStrategy$ MODULE$ = new EntityPassivationStrategy$();

    public EntityPassivationStrategy apply(ClusterShardingSettings settings) {
        ClusterShardingSettings.PassivationStrategy passivationStrategy = settings.passivationStrategy();
        if (passivationStrategy instanceof ClusterShardingSettings.IdlePassivationStrategy) {
            ClusterShardingSettings.IdlePassivationStrategy idlePassivationStrategy = (ClusterShardingSettings.IdlePassivationStrategy)passivationStrategy;
            FiniteDuration timeout = idlePassivationStrategy.timeout();
            FiniteDuration interval = idlePassivationStrategy.interval();
            return new IdleEntityPassivationStrategy(new IdleCheck(timeout, interval));
        }
        if (passivationStrategy instanceof ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy) {
            ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy leastRecentlyUsedPassivationStrategy = (ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy)passivationStrategy;
            int limit = leastRecentlyUsedPassivationStrategy.limit();
            Seq<Object> segmented = leastRecentlyUsedPassivationStrategy.segmented();
            Option idleCheck = leastRecentlyUsedPassivationStrategy.idle().map((Function1 & Serializable)idle2 -> new IdleCheck(idle2.timeout(), idle2.interval()));
            if (segmented.isEmpty()) {
                return new LeastRecentlyUsedEntityPassivationStrategy(limit, (Option<IdleCheck>)idleCheck);
            }
            return new SegmentedLeastRecentlyUsedEntityPassivationStrategy(limit, segmented, (Option<IdleCheck>)idleCheck);
        }
        if (passivationStrategy instanceof ClusterShardingSettings.MostRecentlyUsedPassivationStrategy) {
            ClusterShardingSettings.MostRecentlyUsedPassivationStrategy mostRecentlyUsedPassivationStrategy = (ClusterShardingSettings.MostRecentlyUsedPassivationStrategy)passivationStrategy;
            int limit = mostRecentlyUsedPassivationStrategy.limit();
            Option idleCheck = mostRecentlyUsedPassivationStrategy.idle().map((Function1 & Serializable)idle2 -> new IdleCheck(idle2.timeout(), idle2.interval()));
            return new MostRecentlyUsedEntityPassivationStrategy(limit, (Option<IdleCheck>)idleCheck);
        }
        if (passivationStrategy instanceof ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy) {
            ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy leastFrequentlyUsedPassivationStrategy = (ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy)passivationStrategy;
            int limit = leastFrequentlyUsedPassivationStrategy.limit();
            boolean dynamicAging = leastFrequentlyUsedPassivationStrategy.dynamicAging();
            Option idleCheck = leastFrequentlyUsedPassivationStrategy.idle().map((Function1 & Serializable)idle2 -> new IdleCheck(idle2.timeout(), idle2.interval()));
            return new LeastFrequentlyUsedEntityPassivationStrategy(limit, dynamicAging, (Option<IdleCheck>)idleCheck);
        }
        if (passivationStrategy instanceof ClusterShardingSettings.CompositePassivationStrategy) {
            ClusterShardingSettings.CompositePassivationStrategy compositePassivationStrategy = (ClusterShardingSettings.CompositePassivationStrategy)passivationStrategy;
            ActiveEntities main = ActiveEntities$.MODULE$.apply(compositePassivationStrategy.mainStrategy(), compositePassivationStrategy.idle().isDefined());
            if (main == NoActiveEntities$.MODULE$) {
                return DisabledEntityPassivationStrategy$.MODULE$;
            }
            int initialLimit = compositePassivationStrategy.limit();
            ActiveEntities window = ActiveEntities$.MODULE$.apply(compositePassivationStrategy.windowStrategy(), compositePassivationStrategy.idle().isDefined());
            double initialWindowProportion = window == NoActiveEntities$.MODULE$ ? 0.0 : compositePassivationStrategy.initialWindowProportion();
            double minimumWindowProportion = window == NoActiveEntities$.MODULE$ ? 0.0 : compositePassivationStrategy.minimumWindowProportion();
            double maximumWindowProportion = window == NoActiveEntities$.MODULE$ ? 0.0 : compositePassivationStrategy.maximumWindowProportion();
            NoAdmissionOptimizer$ windowOptimizer = window == NoActiveEntities$.MODULE$ ? NoAdmissionOptimizer$.MODULE$ : AdmissionOptimizer$.MODULE$.apply(compositePassivationStrategy.limit(), compositePassivationStrategy.windowOptimizer());
            AdmissionFilter admissionFilter = AdmissionFilter$.MODULE$.apply(compositePassivationStrategy.limit(), compositePassivationStrategy.admissionFilter());
            Option idleCheck = compositePassivationStrategy.idle().map((Function1 & Serializable)idle2 -> new IdleCheck(idle2.timeout(), idle2.interval()));
            return new CompositeEntityPassivationStrategy(initialLimit, window, initialWindowProportion, minimumWindowProportion, maximumWindowProportion, windowOptimizer, admissionFilter, main, (Option<IdleCheck>)idleCheck);
        }
        return DisabledEntityPassivationStrategy$.MODULE$;
    }

    private EntityPassivationStrategy$() {
    }
}

