/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.sharding.internal;

import org.apache.pekko.annotation.InternalApi;
import org.apache.pekko.cluster.sharding.ClusterShardingSettings;
import org.apache.pekko.cluster.sharding.internal.ActiveEntities;
import org.apache.pekko.cluster.sharding.internal.LeastFrequentlyUsedReplacementPolicy;
import org.apache.pekko.cluster.sharding.internal.LeastRecentlyUsedReplacementPolicy;
import org.apache.pekko.cluster.sharding.internal.MostRecentlyUsedReplacementPolicy;
import org.apache.pekko.cluster.sharding.internal.NoActiveEntities$;
import org.apache.pekko.cluster.sharding.internal.SegmentedLeastRecentlyUsedReplacementPolicy;
import scala.collection.immutable.Seq;

@InternalApi
public final class ActiveEntities$ {
    public static final ActiveEntities$ MODULE$ = new ActiveEntities$();

    public ActiveEntities apply(ClusterShardingSettings.PassivationStrategy strategy, boolean idleEnabled) {
        ClusterShardingSettings.PassivationStrategy passivationStrategy = strategy;
        if (passivationStrategy instanceof ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy) {
            ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy leastRecentlyUsedPassivationStrategy = (ClusterShardingSettings.LeastRecentlyUsedPassivationStrategy)passivationStrategy;
            Seq<Object> segmented = leastRecentlyUsedPassivationStrategy.segmented();
            if (segmented.isEmpty()) {
                return new LeastRecentlyUsedReplacementPolicy(0);
            }
            return new SegmentedLeastRecentlyUsedReplacementPolicy(0, segmented, idleEnabled);
        }
        if (passivationStrategy instanceof ClusterShardingSettings.MostRecentlyUsedPassivationStrategy) {
            return new MostRecentlyUsedReplacementPolicy(0);
        }
        if (passivationStrategy instanceof ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy) {
            ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy leastFrequentlyUsedPassivationStrategy = (ClusterShardingSettings.LeastFrequentlyUsedPassivationStrategy)passivationStrategy;
            boolean dynamicAging = leastFrequentlyUsedPassivationStrategy.dynamicAging();
            return new LeastFrequentlyUsedReplacementPolicy(0, dynamicAging, idleEnabled);
        }
        return NoActiveEntities$.MODULE$;
    }

    private ActiveEntities$() {
    }
}

