/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.metrics;

import java.io.Serializable;
import java.util.Arrays;
import org.apache.pekko.actor.ActorRef;
import org.apache.pekko.actor.ActorSelection;
import org.apache.pekko.actor.Address;
import org.apache.pekko.routing.ActorRefRoutee;
import org.apache.pekko.routing.ActorSelectionRoutee;
import org.apache.pekko.routing.Routee;
import scala.Function0;
import scala.Function1;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.collection.StringOps$;
import scala.collection.immutable.IndexedSeq;
import scala.collection.immutable.Map;
import scala.collection.immutable.Seq;
import scala.math.Numeric;
import scala.math.package$;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxedUnit;
import scala.runtime.BoxesRunTime;
import scala.runtime.IntRef;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005}3Qa\u0003\u0007\u0001\u0019YA\u0001\"\b\u0001\u0003\u0002\u0003\u0006Ia\b\u0005\t[\u0001\u0011\t\u0011)A\u0005]!AA\u0007\u0001B\u0001B\u0003%Q\u0007C\u0003D\u0001\u0011\u0005A\tC\u0004K\u0001\t\u0007I\u0011B&\t\r=\u0003\u0001\u0015!\u0003M\u0011\u0015\u0001\u0006\u0001\"\u0001R\u0011\u0015)\u0006\u0001\"\u0001W\u0011\u00159\u0006\u0001\"\u0001Y\u0011\u0015Y\u0006\u0001\"\u0003]\u0005=9V-[4ii\u0016$'k\\;uK\u0016\u001c(BA\u0007\u000f\u0003\u001diW\r\u001e:jGNT!a\u0004\t\u0002\u000f\rdWo\u001d;fe*\u0011\u0011CE\u0001\u0006a\u0016\\7n\u001c\u0006\u0003'Q\ta!\u00199bG\",'\"A\u000b\u0002\u0007=\u0014xm\u0005\u0002\u0001/A\u0011\u0001dG\u0007\u00023)\t!$A\u0003tG\u0006d\u0017-\u0003\u0002\u001d3\t1\u0011I\\=SK\u001a\fqA]8vi\u0016,7o\u0001\u0001\u0011\u0007\u0001*s%D\u0001\"\u0015\t\u00113%A\u0005j[6,H/\u00192mK*\u0011A%G\u0001\u000bG>dG.Z2uS>t\u0017B\u0001\u0014\"\u0005)Ie\u000eZ3yK\u0012\u001cV-\u001d\t\u0003Q-j\u0011!\u000b\u0006\u0003UA\tqA]8vi&tw-\u0003\u0002-S\t1!k\\;uK\u0016\f1b]3mM\u0006#GM]3tgB\u0011qFM\u0007\u0002a)\u0011\u0011\u0007E\u0001\u0006C\u000e$xN]\u0005\u0003gA\u0012q!\u00113ee\u0016\u001c8/A\u0004xK&<\u0007\u000e^:\u0011\tYjd\u0006\u0011\b\u0003om\u0002\"\u0001O\r\u000e\u0003eR!A\u000f\u0010\u0002\rq\u0012xn\u001c;?\u0013\ta\u0014$\u0001\u0004Qe\u0016$WMZ\u0005\u0003}}\u00121!T1q\u0015\ta\u0014\u0004\u0005\u0002\u0019\u0003&\u0011!)\u0007\u0002\u0004\u0013:$\u0018A\u0002\u001fj]&$h\b\u0006\u0003F\u000f\"K\u0005C\u0001$\u0001\u001b\u0005a\u0001\"B\u000f\u0005\u0001\u0004y\u0002\"B\u0017\u0005\u0001\u0004q\u0003\"\u0002\u001b\u0005\u0001\u0004)\u0014a\u00022vG.,Go]\u000b\u0002\u0019B\u0019\u0001$\u0014!\n\u00059K\"!B!se\u0006L\u0018\u0001\u00032vG.,Go\u001d\u0011\u0002\u000f%\u001cX)\u001c9usV\t!\u000b\u0005\u0002\u0019'&\u0011A+\u0007\u0002\b\u0005>|G.Z1o\u0003\u0015!x\u000e^1m+\u0005\u0001\u0015!B1qa2LHCA\u0014Z\u0011\u0015Q\u0016\u00021\u0001A\u0003\u00151\u0018\r\\;f\u0003\rIG\r\u001f\u000b\u0003\u0001vCQA\u0018\u0006A\u0002\u0001\u000b\u0011!\u001b")
public class WeightedRoutees {
    private final IndexedSeq<Routee> routees;
    private final Address selfAddress;
    private final int[] buckets;

    private int[] buckets() {
        return this.buckets;
    }

    public boolean isEmpty() {
        return this.buckets().length == 0 || this.buckets()[this.buckets().length - 1] == 0;
    }

    public int total() {
        Predef$.MODULE$.require(!this.isEmpty(), (Function0 & Serializable)() -> "WeightedRoutees must not be used when empty");
        return this.buckets()[this.buckets().length - 1];
    }

    public Routee apply(int value) {
        Predef$.MODULE$.require(1 <= value && value <= this.total(), (Function0 & Serializable)() -> StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("value must be between [1 - %s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)this.total())})));
        return (Routee)this.routees.apply(this.idx(Arrays.binarySearch(this.buckets(), value)));
    }

    private int idx(int i) {
        if (i >= 0) {
            return i;
        }
        int j = package$.MODULE$.abs(i + 1);
        if (j >= this.buckets().length) {
            throw new IndexOutOfBoundsException(StringOps$.MODULE$.format$extension(Predef$.MODULE$.augmentString("Requested index [%s] is > max index [%s]"), (Seq)ScalaRunTime$.MODULE$.genericWrapArray((Object)new Object[]{BoxesRunTime.boxToInteger((int)i), BoxesRunTime.boxToInteger((int)this.buckets().length)})));
        }
        return j;
    }

    private final Address fullAddress$1(Routee routee) {
        Address a;
        Address address;
        Routee routee2 = routee;
        if (routee2 instanceof ActorRefRoutee) {
            ActorRefRoutee actorRefRoutee = (ActorRefRoutee)routee2;
            ActorRef ref = actorRefRoutee.ref();
            address = ref.path().address();
        } else if (routee2 instanceof ActorSelectionRoutee) {
            ActorSelectionRoutee actorSelectionRoutee = (ActorSelectionRoutee)routee2;
            ActorSelection sel = actorSelectionRoutee.selection();
            address = sel.anchor().path().address();
        } else {
            throw new RuntimeException();
        }
        Address address2 = a = address;
        if (address2 != null) {
            Option option = address2.host();
            Option option2 = address2.port();
            if (None$.MODULE$.equals(option) && None$.MODULE$.equals(option2)) {
                return this.selfAddress;
            }
        }
        return address2;
    }

    public static final /* synthetic */ void $anonfun$buckets$1(WeightedRoutees $this, IntRef sum$1, Map w$1, int[] buckets$1, IntRef i$1, Routee r) {
        sum$1.elem += BoxesRunTime.unboxToInt((Object)w$1.apply((Object)$this.fullAddress$1(r)));
        buckets$1[i$1.elem] = sum$1.elem;
        ++i$1.elem;
    }

    public WeightedRoutees(IndexedSeq<Routee> routees, Address selfAddress, Map<Address, Object> weights) {
        this.routees = routees;
        this.selfAddress = selfAddress;
        int[] buckets = new int[routees.size()];
        int meanWeight = weights.isEmpty() ? 1 : BoxesRunTime.unboxToInt((Object)weights.values().sum((Numeric)Numeric.IntIsIntegral$.MODULE$)) / weights.size();
        Map w = weights.withDefaultValue((Object)BoxesRunTime.boxToInteger((int)meanWeight));
        IntRef i = IntRef.create((int)0);
        IntRef sum = IntRef.create((int)0);
        routees.foreach((Function1 & Serializable)r -> {
            WeightedRoutees.$anonfun$buckets$1(this, sum, w, buckets, i, r);
            return BoxedUnit.UNIT;
        });
        this.buckets = buckets;
    }
}

