/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.metrics;

import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.metrics.ClusterMetricsExtension;
import org.apache.pekko.cluster.metrics.ClusterMetricsExtension$;
import org.apache.pekko.cluster.metrics.ClusterMetricsSettings;
import org.apache.pekko.cluster.metrics.DefaultSigarProvider;
import org.apache.pekko.cluster.metrics.EWMA$;
import org.apache.pekko.cluster.metrics.JmxMetricsCollector;
import org.apache.pekko.cluster.metrics.Metric;
import org.apache.pekko.cluster.metrics.Metric$;
import org.apache.pekko.cluster.metrics.SigarProvider$;
import org.hyperic.sigar.CpuPerc;
import org.hyperic.sigar.SigarProxy;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.Set;
import scala.collection.immutable.Seq;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005i4A\u0001E\t\u00019!A\u0011\u0005\u0001B\u0001B\u0003%!\u0005\u0003\u0005)\u0001\t\u0005\t\u0015!\u0003*\u0011!y\u0003A!A!\u0002\u0013\u0001\u0004\"B\u001c\u0001\t\u0003A\u0004\"B\u001c\u0001\t\u0003i\u0004\"B\u001c\u0001\t\u0003)\u0005\"B\u001c\u0001\t\u0003A\u0005b\u0002(\u0001\u0005\u0004%Ia\u0014\u0005\u0007'\u0002\u0001\u000b\u0011\u0002)\t\u000bI\u0001A\u0011\t+\t\u000b\r\u0004A\u0011\t3\t\u000b!\u0004A\u0011A5\t\u000b=\u0004A\u0011\u00019\t\u000bI\u0004A\u0011A:\t\u000bU\u0004A\u0011\t<\u0003+MKw-\u0019:NKR\u0014\u0018nY:D_2dWm\u0019;pe*\u0011!cE\u0001\b[\u0016$(/[2t\u0015\t!R#A\u0004dYV\u001cH/\u001a:\u000b\u0005Y9\u0012!\u00029fW.|'B\u0001\r\u001a\u0003\u0019\t\u0007/Y2iK*\t!$A\u0002pe\u001e\u001c\u0001a\u0005\u0002\u0001;A\u0011adH\u0007\u0002#%\u0011\u0001%\u0005\u0002\u0014\u00156DX*\u001a;sS\u000e\u001c8i\u001c7mK\u000e$xN]\u0001\bC\u0012$'/Z:t!\t\u0019c%D\u0001%\u0015\t)S#A\u0003bGR|'/\u0003\u0002(I\t9\u0011\t\u001a3sKN\u001c\u0018a\u00033fG\u0006Lh)Y2u_J\u0004\"AK\u0017\u000e\u0003-R\u0011\u0001L\u0001\u0006g\u000e\fG.Y\u0005\u0003]-\u0012a\u0001R8vE2,\u0017!B:jO\u0006\u0014\bCA\u00196\u001b\u0005\u0011$BA\u00184\u0015\t!\u0014$A\u0004isB,'/[2\n\u0005Y\u0012$AC*jO\u0006\u0014\bK]8ys\u00061A(\u001b8jiz\"B!\u000f\u001e<yA\u0011a\u0004\u0001\u0005\u0006C\u0011\u0001\rA\t\u0005\u0006Q\u0011\u0001\r!\u000b\u0005\u0006_\u0011\u0001\r\u0001\r\u000b\u0005syzD\tC\u0003\"\u000b\u0001\u0007!\u0005C\u0003A\u000b\u0001\u0007\u0011)\u0001\u0005tKR$\u0018N\\4t!\tq\")\u0003\u0002D#\t12\t\\;ti\u0016\u0014X*\u001a;sS\u000e\u001c8+\u001a;uS:<7\u000fC\u00030\u000b\u0001\u0007\u0001\u0007F\u0002:\r\u001eCQ!\t\u0004A\u0002\tBQ\u0001\u0011\u0004A\u0002\u0005#\"!O%\t\u000b);\u0001\u0019A&\u0002\rML8\u000f^3n!\t\u0019C*\u0003\u0002NI\tY\u0011i\u0019;peNK8\u000f^3n\u0003E!WmY1z\r\u0006\u001cGo\u001c:PaRLwN\\\u000b\u0002!B\u0019!&U\u0015\n\u0005I[#\u0001B*p[\u0016\f!\u0003Z3dCf4\u0015m\u0019;pe>\u0003H/[8oAQ\tQ\u000bE\u0002W;\u0002t!aV.\u0011\u0005a[S\"A-\u000b\u0005i[\u0012A\u0002\u001fs_>$h(\u0003\u0002]W\u00051\u0001K]3eK\u001aL!AX0\u0003\u0007M+GO\u0003\u0002]WA\u0011a$Y\u0005\u0003EF\u0011a!T3ue&\u001c\u0017!E:zgR,W\u000eT8bI\u00063XM]1hKV\tQ\rE\u0002+M\u0002L!aZ\u0016\u0003\r=\u0003H/[8o\u0003-\u0019\u0007/^\"p[\nLg.\u001a3\u0015\u0005\u0015T\u0007\"B6\r\u0001\u0004a\u0017aB2qkB+'o\u0019\t\u0003c5L!A\u001c\u001a\u0003\u000f\r\u0003X\u000fU3sG\u0006I1\r];Ti>dWM\u001c\u000b\u0003KFDQa[\u0007A\u00021\fqa\u00199v\u0013\u0012dW\r\u0006\u0002fi\")1N\u0004a\u0001Y\u0006)1\r\\8tKR\tq\u000f\u0005\u0002+q&\u0011\u0011p\u000b\u0002\u0005+:LG\u000f")
public class SigarMetricsCollector
extends JmxMetricsCollector {
    private final SigarProxy sigar;
    private final Some<Object> decayFactorOption;

    private Some<Object> decayFactorOption() {
        return this.decayFactorOption;
    }

    @Override
    public scala.collection.immutable.Set<Metric> metrics() {
        CpuPerc cpuPerc = this.sigar.getCpuPerc();
        return (scala.collection.immutable.Set)super.metrics().union((Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.cpuCombined(cpuPerc), this.cpuStolen(cpuPerc)}))).flatten(Predef$.MODULE$.$conforms()));
    }

    @Override
    public Option<Metric> systemLoadAverage() {
        return Metric$.MODULE$.create("system-load-average", BoxesRunTime.boxToDouble((double)this.sigar.getLoadAverage()[0]), (Option<Object>)None$.MODULE$);
    }

    public Option<Metric> cpuCombined(CpuPerc cpuPerc) {
        return Metric$.MODULE$.create("cpu-combined", BoxesRunTime.boxToDouble((double)cpuPerc.getCombined()), (Option<Object>)this.decayFactorOption());
    }

    public Option<Metric> cpuStolen(CpuPerc cpuPerc) {
        return Metric$.MODULE$.create("cpu-stolen", BoxesRunTime.boxToDouble((double)cpuPerc.getStolen()), (Option<Object>)this.decayFactorOption());
    }

    public Option<Metric> cpuIdle(CpuPerc cpuPerc) {
        return Metric$.MODULE$.create("cpu-idle", BoxesRunTime.boxToDouble((double)cpuPerc.getIdle()), (Option<Object>)this.decayFactorOption());
    }

    @Override
    public void close() {
        SigarProvider$.MODULE$.close(this.sigar);
    }

    public SigarMetricsCollector(Address address, double decayFactor, SigarProxy sigar) {
        this.sigar = sigar;
        super(address, decayFactor);
        this.decayFactorOption = new Some((Object)BoxesRunTime.boxToDouble((double)decayFactor));
        this.metrics();
    }

    public SigarMetricsCollector(Address address, ClusterMetricsSettings settings, SigarProxy sigar) {
        this(address, EWMA$.MODULE$.alpha(settings.CollectorMovingAverageHalfLife(), settings.CollectorSampleInterval()), sigar);
    }

    public SigarMetricsCollector(Address address, ClusterMetricsSettings settings) {
        this(address, settings, new DefaultSigarProvider(settings).createSigarInstance());
    }

    public SigarMetricsCollector(ActorSystem system) {
        this(((Cluster)Cluster$.MODULE$.apply(system)).selfAddress(), ((ClusterMetricsExtension)ClusterMetricsExtension$.MODULE$.apply(system)).settings());
    }
}

