/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pekko.cluster.metrics;

import java.lang.management.ManagementFactory;
import java.lang.management.MemoryMXBean;
import java.lang.management.MemoryUsage;
import java.lang.management.OperatingSystemMXBean;
import org.apache.pekko.actor.ActorSystem;
import org.apache.pekko.actor.Address;
import org.apache.pekko.cluster.Cluster;
import org.apache.pekko.cluster.Cluster$;
import org.apache.pekko.cluster.metrics.ClusterMetricsExtension;
import org.apache.pekko.cluster.metrics.ClusterMetricsExtension$;
import org.apache.pekko.cluster.metrics.ClusterMetricsSettings;
import org.apache.pekko.cluster.metrics.EWMA$;
import org.apache.pekko.cluster.metrics.Metric;
import org.apache.pekko.cluster.metrics.Metric$;
import org.apache.pekko.cluster.metrics.MetricsCollector;
import org.apache.pekko.cluster.metrics.NodeMetrics;
import scala.None$;
import scala.Option;
import scala.Predef$;
import scala.Some;
import scala.collection.IterableOps;
import scala.collection.immutable.Seq;
import scala.collection.immutable.Set;
import scala.reflect.ScalaSignature;
import scala.runtime.BoxesRunTime;
import scala.runtime.ScalaRunTime$;

@ScalaSignature(bytes="\u0006\u0005\u0005\rb\u0001B\u000b\u0017\u0001\u0005B\u0001B\f\u0001\u0003\u0002\u0003\u0006Ia\f\u0005\tk\u0001\u0011\t\u0011)A\u0005m!)A\b\u0001C\u0001{!)A\b\u0001C\u0005\u0003\")A\b\u0001C\u0001\u0011\"9a\n\u0001b\u0001\n\u0013y\u0005BB*\u0001A\u0003%\u0001\u000bC\u0004U\u0001\t\u0007I\u0011B+\t\rq\u0003\u0001\u0015!\u0003W\u0011\u001di\u0006A1A\u0005\nyCaA\u0019\u0001!\u0002\u0013y\u0006\"B2\u0001\t\u0003!\u0007\"B\f\u0001\t\u0003A\u0007\"B<\u0001\t\u0003A\b\"\u0002?\u0001\t\u0003A\b\"B?\u0001\t\u0003q\bbBA\u0003\u0001\u0011\u0005\u0011q\u0001\u0005\b\u0003\u001b\u0001A\u0011AA\b\u0011\u001d\t\u0019\u0002\u0001C\u0001\u0003+Aq!!\u0007\u0001\t\u0003\nYBA\nK[blU\r\u001e:jGN\u001cu\u000e\u001c7fGR|'O\u0003\u0002\u00181\u00059Q.\u001a;sS\u000e\u001c(BA\r\u001b\u0003\u001d\u0019G.^:uKJT!a\u0007\u000f\u0002\u000bA,7n[8\u000b\u0005uq\u0012AB1qC\u000eDWMC\u0001 \u0003\ry'oZ\u0002\u0001'\r\u0001!E\u000b\t\u0003G!j\u0011\u0001\n\u0006\u0003K\u0019\nA\u0001\\1oO*\tq%\u0001\u0003kCZ\f\u0017BA\u0015%\u0005\u0019y%M[3diB\u00111\u0006L\u0007\u0002-%\u0011QF\u0006\u0002\u0011\u001b\u0016$(/[2t\u0007>dG.Z2u_J\fq!\u00193ee\u0016\u001c8\u000f\u0005\u00021g5\t\u0011G\u0003\u000235\u0005)\u0011m\u0019;pe&\u0011A'\r\u0002\b\u0003\u0012$'/Z:t\u0003-!WmY1z\r\u0006\u001cGo\u001c:\u0011\u0005]RT\"\u0001\u001d\u000b\u0003e\nQa]2bY\u0006L!a\u000f\u001d\u0003\r\u0011{WO\u00197f\u0003\u0019a\u0014N\\5u}Q\u0019ah\u0010!\u0011\u0005-\u0002\u0001\"\u0002\u0018\u0004\u0001\u0004y\u0003\"B\u001b\u0004\u0001\u00041Dc\u0001 C\u0007\")a\u0006\u0002a\u0001_!)A\t\u0002a\u0001\u000b\u0006A1/\u001a;uS:<7\u000f\u0005\u0002,\r&\u0011qI\u0006\u0002\u0017\u00072,8\u000f^3s\u001b\u0016$(/[2t'\u0016$H/\u001b8hgR\u0011a(\u0013\u0005\u0006\u0015\u0016\u0001\raS\u0001\u0007gf\u001cH/Z7\u0011\u0005Ab\u0015BA'2\u0005-\t5\r^8s'f\u001cH/Z7\u0002#\u0011,7-Y=GC\u000e$xN](qi&|g.F\u0001Q!\r9\u0014KN\u0005\u0003%b\u0012AaU8nK\u0006\u0011B-Z2bs\u001a\u000b7\r^8s\u001fB$\u0018n\u001c8!\u0003-iW-\\8ss6\u0013U-\u00198\u0016\u0003Y\u0003\"a\u0016.\u000e\u0003aS!!\u0017\u0013\u0002\u00155\fg.Y4f[\u0016tG/\u0003\u0002\\1\naQ*Z7pefl\u0005LQ3b]\u0006aQ.Z7pefl%)Z1oA\u00059qn]'CK\u0006tW#A0\u0011\u0005]\u0003\u0017BA1Y\u0005Uy\u0005/\u001a:bi&twmU=ti\u0016lW\n\u0017\"fC:\f\u0001b\\:N\u0005\u0016\fg\u000eI\u0001\u0007g\u0006l\u0007\u000f\\3\u0015\u0003\u0015\u0004\"a\u000b4\n\u0005\u001d4\"a\u0003(pI\u0016lU\r\u001e:jGN$\u0012!\u001b\t\u0004UF$hBA6p!\ta\u0007(D\u0001n\u0015\tq\u0007%\u0001\u0004=e>|GOP\u0005\u0003ab\na\u0001\u0015:fI\u00164\u0017B\u0001:t\u0005\r\u0019V\r\u001e\u0006\u0003ab\u0002\"aK;\n\u0005Y4\"AB'fiJL7-A\ttsN$X-\u001c'pC\u0012\fe/\u001a:bO\u0016,\u0012!\u001f\t\u0004oi$\u0018BA>9\u0005\u0019y\u0005\u000f^5p]\u0006Q\u0001O]8dKN\u001cxN]:\u0002\u001f!,\u0017\r]'f[>\u0014\u00180V:bO\u0016,\u0012a \t\u0004/\u0006\u0005\u0011bAA\u00021\nYQ*Z7pef,6/Y4f\u0003!AW-\u00199Vg\u0016$GcA=\u0002\n!1\u00111B\tA\u0002}\fA\u0001[3ba\u0006i\u0001.Z1q\u0007>lW.\u001b;uK\u0012$2!_A\t\u0011\u0019\tYA\u0005a\u0001\u007f\u00069\u0001.Z1q\u001b\u0006DHcA=\u0002\u0018!1\u00111B\nA\u0002}\fQa\u00197pg\u0016$\"!!\b\u0011\u0007]\ny\"C\u0002\u0002\"a\u0012A!\u00168ji\u0002")
public class JmxMetricsCollector
implements MetricsCollector {
    private final Address address;
    private final Some<Object> decayFactorOption;
    private final MemoryMXBean memoryMBean;
    private final OperatingSystemMXBean osMBean;

    private Some<Object> decayFactorOption() {
        return this.decayFactorOption;
    }

    private MemoryMXBean memoryMBean() {
        return this.memoryMBean;
    }

    private OperatingSystemMXBean osMBean() {
        return this.osMBean;
    }

    @Override
    public NodeMetrics sample() {
        return new NodeMetrics(this.address, System.currentTimeMillis(), this.metrics());
    }

    public Set<Metric> metrics() {
        MemoryUsage heap = this.heapMemoryUsage();
        return (Set)((IterableOps)Predef$.MODULE$.Set().apply((Seq)ScalaRunTime$.MODULE$.wrapRefArray((Object[])new Option[]{this.systemLoadAverage(), this.heapUsed(heap), this.heapCommitted(heap), this.heapMax(heap), this.processors()}))).flatten(Predef$.MODULE$.$conforms());
    }

    public Option<Metric> systemLoadAverage() {
        return Metric$.MODULE$.create("system-load-average", Predef$.MODULE$.double2Double(this.osMBean().getSystemLoadAverage()), (Option<Object>)None$.MODULE$);
    }

    public Option<Metric> processors() {
        return Metric$.MODULE$.create("processors", Predef$.MODULE$.int2Integer(this.osMBean().getAvailableProcessors()), (Option<Object>)None$.MODULE$);
    }

    public MemoryUsage heapMemoryUsage() {
        return this.memoryMBean().getHeapMemoryUsage();
    }

    public Option<Metric> heapUsed(MemoryUsage heap) {
        return Metric$.MODULE$.create("heap-memory-used", Predef$.MODULE$.long2Long(heap.getUsed()), (Option<Object>)this.decayFactorOption());
    }

    public Option<Metric> heapCommitted(MemoryUsage heap) {
        return Metric$.MODULE$.create("heap-memory-committed", Predef$.MODULE$.long2Long(heap.getCommitted()), (Option<Object>)this.decayFactorOption());
    }

    public Option<Metric> heapMax(MemoryUsage heap) {
        return Metric$.MODULE$.create("heap-memory-max", Predef$.MODULE$.long2Long(heap.getMax()), (Option<Object>)None$.MODULE$);
    }

    @Override
    public void close() {
    }

    public JmxMetricsCollector(Address address, double decayFactor) {
        this.address = address;
        this.decayFactorOption = new Some((Object)BoxesRunTime.boxToDouble((double)decayFactor));
        this.memoryMBean = ManagementFactory.getMemoryMXBean();
        this.osMBean = ManagementFactory.getOperatingSystemMXBean();
    }

    private JmxMetricsCollector(Address address, ClusterMetricsSettings settings) {
        this(address, EWMA$.MODULE$.alpha(settings.CollectorMovingAverageHalfLife(), settings.CollectorSampleInterval()));
    }

    public JmxMetricsCollector(ActorSystem system) {
        this(((Cluster)Cluster$.MODULE$.apply(system)).selfAddress(), ((ClusterMetricsExtension)ClusterMetricsExtension$.MODULE$.apply(system)).settings());
    }
}

