/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.shading;

import java.awt.PaintContext;
import java.awt.color.ColorSpace;
import java.awt.geom.AffineTransform;
import java.awt.geom.NoninvertibleTransformException;
import java.awt.image.ColorModel;
import java.awt.image.ComponentColorModel;
import java.awt.image.Raster;
import java.awt.image.WritableRaster;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.pdmodel.common.function.PDFunction;
import org.apache.pdfbox.pdmodel.graphics.color.PDColorSpace;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceN;
import org.apache.pdfbox.pdmodel.graphics.color.PDDeviceRGB;
import org.apache.pdfbox.pdmodel.graphics.color.PDSeparation;
import org.apache.pdfbox.pdmodel.graphics.shading.PDShadingType1;
import org.apache.pdfbox.util.Matrix;

class Type1ShadingContext
implements PaintContext {
    private static final Log LOG = LogFactory.getLog(Type1ShadingContext.class);
    private ColorModel outputColorModel;
    private ColorSpace shadingColorSpace;
    private PDFunction shadingTinttransform;
    private PDShadingType1 shadingType;
    private AffineTransform rat;
    private float[] domain;
    private Matrix matrix;
    private float[] background;

    public Type1ShadingContext(PDShadingType1 shadingType1, ColorModel colorModelValue, AffineTransform xform, Matrix currentTransformationMatrix, int pageHeight) {
        this.shadingType = shadingType1;
        xform.scale(1.0, -1.0);
        xform.translate(0.0, -pageHeight);
        try {
            PDColorSpace cs = this.shadingType.getColorSpace();
            if (!(cs instanceof PDDeviceRGB)) {
                this.shadingColorSpace = cs.getJavaColorSpace();
                if (cs instanceof PDDeviceN) {
                    this.shadingTinttransform = ((PDDeviceN)cs).getTintTransform();
                } else if (cs instanceof PDSeparation) {
                    this.shadingTinttransform = ((PDSeparation)cs).getTintTransform();
                }
            }
        }
        catch (IOException exception) {
            LOG.error("error while creating colorSpace", exception);
        }
        ColorSpace outputCS = ColorSpace.getInstance(1000);
        this.outputColorModel = new ComponentColorModel(outputCS, true, false, 3, 0);
        this.domain = this.shadingType.getDomain() != null ? this.shadingType.getDomain().toFloatArray() : new float[]{0.0f, 1.0f, 0.0f, 1.0f};
        this.matrix = this.shadingType.getMatrix();
        if (this.matrix == null) {
            this.matrix = new Matrix();
        }
        try {
            this.rat = this.matrix.createAffineTransform().createInverse();
            this.rat.concatenate(currentTransformationMatrix.createAffineTransform().createInverse());
            this.rat.concatenate(xform.createInverse());
        }
        catch (NoninvertibleTransformException ex) {
            LOG.error(ex, ex);
        }
        COSArray bg = shadingType1.getBackground();
        if (bg != null) {
            this.background = bg.toFloatArray();
        }
    }

    public void dispose() {
        this.outputColorModel = null;
        this.shadingColorSpace = null;
        this.shadingTinttransform = null;
        this.shadingType = null;
    }

    public ColorModel getColorModel() {
        return this.outputColorModel;
    }

    public Raster getRaster(int x, int y, int w, int h) {
        WritableRaster raster = this.getColorModel().createCompatibleWritableRaster(w, h);
        int[] data = new int[w * h * 4];
        for (int j = 0; j < h; ++j) {
            for (int i = 0; i < w; ++i) {
                int index = (j * w + i) * 4;
                boolean useBackground = false;
                float[] values = new float[]{x + i, y + j};
                this.rat.transform(values, 0, values, 0, 1);
                if (values[0] < this.domain[0] || values[0] > this.domain[1] || values[1] < this.domain[2] || values[1] > this.domain[3]) {
                    if (this.background == null) continue;
                    useBackground = true;
                }
                try {
                    values = useBackground ? this.background : this.shadingType.evalFunction(values);
                    if (this.shadingColorSpace != null) {
                        if (this.shadingTinttransform != null) {
                            values = this.shadingTinttransform.eval(values);
                        }
                        values = this.shadingColorSpace.toRGB(values);
                    }
                }
                catch (IOException exception) {
                    LOG.error("error while processing a function", exception);
                }
                data[index] = (int)(values[0] * 255.0f);
                data[index + 1] = (int)(values[1] * 255.0f);
                data[index + 2] = (int)(values[2] * 255.0f);
                data[index + 3] = 255;
            }
        }
        raster.setPixels(0, 0, w, h, data);
        return raster;
    }

    public float[] getDomain() {
        return this.domain;
    }

    public PDFunction getShadingTintTransform() {
        return this.shadingTinttransform;
    }
}

