/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.encoding;

import java.nio.charset.Charset;
import java.nio.charset.spi.CharsetProvider;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import org.apache.pdfbox.encoding.PDFDocEncodingCharset;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFBoxCharsetProvider
extends CharsetProvider {
    private final Set<Charset> available = new HashSet<Charset>();
    private final Map<String, Charset> map = new HashMap<String, Charset>();

    public PDFBoxCharsetProvider() {
        this.available.add(PDFDocEncodingCharset.INSTANCE);
        for (Charset cs : this.available) {
            this.map.put(cs.name(), cs);
            for (String alias : cs.aliases()) {
                this.map.put(alias, cs);
            }
        }
    }

    @Override
    public Iterator<Charset> charsets() {
        return Collections.unmodifiableSet(this.available).iterator();
    }

    @Override
    public Charset charsetForName(String charsetName) {
        return this.map.get(charsetName);
    }
}

