/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.util;

import java.io.File;
import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Vector;
import org.apache.pdfbox.cos.COSArray;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSInteger;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSNumber;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.cos.COSString;
import org.apache.pdfbox.exceptions.COSVisitorException;
import org.apache.pdfbox.io.RandomAccess;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.PDDocumentInformation;
import org.apache.pdfbox.pdmodel.PDDocumentNameDictionary;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.common.COSArrayList;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDNumberTreeNode;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDMarkInfo;
import org.apache.pdfbox.pdmodel.documentinterchange.logicalstructure.PDStructureTreeRoot;
import org.apache.pdfbox.pdmodel.interactive.annotation.PDAnnotation;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDDocumentOutline;
import org.apache.pdfbox.pdmodel.interactive.documentnavigation.outline.PDOutlineItem;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.pdmodel.interactive.form.PDField;
import org.apache.pdfbox.pdmodel.interactive.form.PDFieldFactory;
import org.apache.pdfbox.util.PDFCloneUtility;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class PDFMergerUtility {
    private static final String STRUCTURETYPE_DOCUMENT = "Document";
    private List<InputStream> sources = new ArrayList<InputStream>();
    private String destinationFileName;
    private OutputStream destinationStream;
    private boolean ignoreAcroFormErrors = false;
    private int nextFieldNum = 1;

    public String getDestinationFileName() {
        return this.destinationFileName;
    }

    public void setDestinationFileName(String destination) {
        this.destinationFileName = destination;
    }

    public OutputStream getDestinationStream() {
        return this.destinationStream;
    }

    public void setDestinationStream(OutputStream destStream) {
        this.destinationStream = destStream;
    }

    public void addSource(String source) {
        try {
            this.sources.add(new FileInputStream(new File(source)));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSource(File source) {
        try {
            this.sources.add(new FileInputStream(source));
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    public void addSource(InputStream source) {
        this.sources.add(source);
    }

    public void addSources(List<InputStream> sourcesList) {
        this.sources.addAll(sourcesList);
    }

    public void mergeDocuments() throws IOException, COSVisitorException {
        this.mergeDocuments(false, null);
    }

    public void mergeDocumentsNonSeq(RandomAccess scratchFile) throws IOException, COSVisitorException {
        this.mergeDocuments(true, scratchFile);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void mergeDocuments(boolean isNonSeq, RandomAccess scratchFile) throws IOException, COSVisitorException {
        PDDocument destination = null;
        if (this.sources != null && this.sources.size() > 0) {
            Vector<PDDocument> tobeclosed = new Vector<PDDocument>();
            try {
                Iterator<InputStream> sit = this.sources.iterator();
                InputStream sourceFile = sit.next();
                destination = isNonSeq ? PDDocument.loadNonSeq(sourceFile, scratchFile) : PDDocument.load(sourceFile);
                while (sit.hasNext()) {
                    sourceFile = sit.next();
                    PDDocument source = isNonSeq ? PDDocument.loadNonSeq(sourceFile, null) : PDDocument.load(sourceFile);
                    tobeclosed.add(source);
                    this.appendDocument(destination, source);
                }
                if (this.destinationStream == null) {
                    destination.save(this.destinationFileName);
                } else {
                    destination.save(this.destinationStream);
                }
            }
            finally {
                if (destination != null) {
                    destination.close();
                }
                for (PDDocument doc : tobeclosed) {
                    doc.close();
                }
            }
        }
    }

    public void appendDocument(PDDocument destination, PDDocument source) throws IOException {
        PDFCloneUtility cloner;
        PDDocumentCatalog srcCatalog;
        PDDocumentCatalog destCatalog;
        block41: {
            if (destination.isEncrypted()) {
                throw new IOException("Error: destination PDF is encrypted, can't append encrypted PDF documents.");
            }
            if (source.isEncrypted()) {
                throw new IOException("Error: source PDF is encrypted, can't append encrypted PDF documents.");
            }
            PDDocumentInformation destInfo = destination.getDocumentInformation();
            PDDocumentInformation srcInfo = source.getDocumentInformation();
            destInfo.getDictionary().mergeInto(srcInfo.getDictionary());
            destCatalog = destination.getDocumentCatalog();
            srcCatalog = source.getDocumentCatalog();
            float destVersion = destination.getDocument().getVersion();
            float srcVersion = source.getDocument().getVersion();
            if (destVersion < srcVersion) {
                destination.getDocument().setVersion(srcVersion);
            }
            if (destCatalog.getOpenAction() == null) {
                destCatalog.setOpenAction(srcCatalog.getOpenAction());
            }
            COSDictionary srcPages = (COSDictionary)srcCatalog.getCOSDictionary().getDictionaryObject(COSName.PAGES);
            COSDictionary srcResources = (COSDictionary)srcPages.getDictionaryObject(COSName.RESOURCES);
            COSDictionary destPages = (COSDictionary)destCatalog.getCOSDictionary().getDictionaryObject(COSName.PAGES);
            COSDictionary destResources = (COSDictionary)destPages.getDictionaryObject(COSName.RESOURCES);
            if (srcResources != null) {
                if (destResources != null) {
                    destResources.mergeInto(srcResources);
                } else {
                    destPages.setItem(COSName.RESOURCES, (COSBase)srcResources);
                }
            }
            cloner = new PDFCloneUtility(destination);
            try {
                PDAcroForm destAcroForm = destCatalog.getAcroForm();
                PDAcroForm srcAcroForm = srcCatalog.getAcroForm();
                if (destAcroForm == null) {
                    cloner.cloneForNewDocument(srcAcroForm);
                    destCatalog.setAcroForm(srcAcroForm);
                } else if (srcAcroForm != null) {
                    this.mergeAcroForm(cloner, destAcroForm, srcAcroForm);
                }
            }
            catch (Exception e) {
                if (this.ignoreAcroFormErrors) break block41;
                throw (IOException)e;
            }
        }
        COSArray destThreads = (COSArray)destCatalog.getCOSDictionary().getDictionaryObject(COSName.THREADS);
        COSArray srcThreads = (COSArray)cloner.cloneForNewDocument(destCatalog.getCOSDictionary().getDictionaryObject(COSName.THREADS));
        if (destThreads == null) {
            destCatalog.getCOSDictionary().setItem(COSName.THREADS, (COSBase)srcThreads);
        } else {
            destThreads.addAll(srcThreads);
        }
        PDDocumentNameDictionary destNames = destCatalog.getNames();
        PDDocumentNameDictionary srcNames = srcCatalog.getNames();
        if (srcNames != null) {
            if (destNames == null) {
                destCatalog.getCOSDictionary().setItem(COSName.NAMES, cloner.cloneForNewDocument(srcNames));
            } else {
                cloner.cloneMerge(srcNames, destNames);
            }
        }
        PDDocumentOutline destOutline = destCatalog.getDocumentOutline();
        PDDocumentOutline srcOutline = srcCatalog.getDocumentOutline();
        if (srcOutline != null) {
            if (destOutline == null) {
                PDDocumentOutline cloned = new PDDocumentOutline((COSDictionary)cloner.cloneForNewDocument(srcOutline));
                destCatalog.setDocumentOutline(cloned);
            } else {
                PDOutlineItem first = srcOutline.getFirstChild();
                if (first != null) {
                    PDOutlineItem clonedFirst = new PDOutlineItem((COSDictionary)cloner.cloneForNewDocument(first));
                    destOutline.appendChild(clonedFirst);
                }
            }
        }
        String destPageMode = destCatalog.getPageMode();
        String srcPageMode = srcCatalog.getPageMode();
        if (destPageMode == null) {
            destCatalog.setPageMode(srcPageMode);
        }
        COSDictionary destLabels = (COSDictionary)destCatalog.getCOSDictionary().getDictionaryObject(COSName.PAGE_LABELS);
        COSDictionary srcLabels = (COSDictionary)srcCatalog.getCOSDictionary().getDictionaryObject(COSName.PAGE_LABELS);
        if (srcLabels != null) {
            int destPageCount = destination.getNumberOfPages();
            COSArray destNums = null;
            if (destLabels == null) {
                destLabels = new COSDictionary();
                destNums = new COSArray();
                destLabels.setItem(COSName.NUMS, (COSBase)destNums);
                destCatalog.getCOSDictionary().setItem(COSName.PAGE_LABELS, (COSBase)destLabels);
            } else {
                destNums = (COSArray)destLabels.getDictionaryObject(COSName.NUMS);
            }
            COSArray srcNums = (COSArray)srcLabels.getDictionaryObject(COSName.NUMS);
            if (srcNums != null) {
                for (int i = 0; i < srcNums.size(); i += 2) {
                    COSNumber labelIndex = (COSNumber)srcNums.getObject(i);
                    long labelIndexValue = labelIndex.intValue();
                    destNums.add(COSInteger.get(labelIndexValue + (long)destPageCount));
                    destNums.add(cloner.cloneForNewDocument(srcNums.getObject(i + 1)));
                }
            }
        }
        COSStream destMetadata = (COSStream)destCatalog.getCOSDictionary().getDictionaryObject(COSName.METADATA);
        COSStream srcMetadata = (COSStream)srcCatalog.getCOSDictionary().getDictionaryObject(COSName.METADATA);
        if (destMetadata == null && srcMetadata != null) {
            PDStream newStream = new PDStream(destination, srcMetadata.getUnfilteredStream(), false);
            newStream.getStream().mergeInto(srcMetadata);
            newStream.addCompression();
            destCatalog.getCOSDictionary().setItem(COSName.METADATA, (COSObjectable)newStream);
        }
        boolean mergeStructTree = false;
        int destParentTreeNextKey = -1;
        COSDictionary destParentTreeDict = null;
        COSDictionary srcParentTreeDict = null;
        COSArray destNumbersArray = null;
        COSArray srcNumbersArray = null;
        PDMarkInfo destMark = destCatalog.getMarkInfo();
        PDStructureTreeRoot destStructTree = destCatalog.getStructureTreeRoot();
        PDMarkInfo srcMark = srcCatalog.getMarkInfo();
        PDStructureTreeRoot srcStructTree = srcCatalog.getStructureTreeRoot();
        if (destStructTree != null) {
            PDNumberTreeNode destParentTree = destStructTree.getParentTree();
            destParentTreeNextKey = destStructTree.getParentTreeNextKey();
            if (destParentTree != null && (destNumbersArray = (COSArray)(destParentTreeDict = destParentTree.getCOSDictionary()).getDictionaryObject(COSName.NUMS)) != null) {
                PDNumberTreeNode srcParentTree;
                if (destParentTreeNextKey < 0) {
                    destParentTreeNextKey = destNumbersArray.size() / 2;
                }
                if (destParentTreeNextKey > 0 && srcStructTree != null && (srcParentTree = srcStructTree.getParentTree()) != null && (srcNumbersArray = (COSArray)(srcParentTreeDict = srcParentTree.getCOSDictionary()).getDictionaryObject(COSName.NUMS)) != null) {
                    mergeStructTree = true;
                }
            }
            if (destMark != null && destMark.isMarked() && !mergeStructTree) {
                destMark.setMarked(false);
            }
            if (!mergeStructTree) {
                destCatalog.setStructureTreeRoot(null);
            }
        }
        List pages = srcCatalog.getAllPages();
        Iterator pageIter = pages.iterator();
        HashMap<COSDictionary, COSDictionary> objMapping = new HashMap<COSDictionary, COSDictionary>();
        while (pageIter.hasNext()) {
            PDPage page = (PDPage)pageIter.next();
            PDPage newPage = new PDPage((COSDictionary)cloner.cloneForNewDocument(page.getCOSDictionary()));
            newPage.setCropBox(page.findCropBox());
            newPage.setMediaBox(page.findMediaBox());
            newPage.setRotation(page.findRotation());
            if (mergeStructTree) {
                this.updateStructParentEntries(newPage, destParentTreeNextKey);
                objMapping.put(page.getCOSDictionary(), newPage.getCOSDictionary());
                List<PDAnnotation> oldAnnots = page.getAnnotations();
                List<PDAnnotation> newAnnots = newPage.getAnnotations();
                for (int i = 0; i < oldAnnots.size(); ++i) {
                    objMapping.put(oldAnnots.get(i).getDictionary(), newAnnots.get(i).getDictionary());
                }
            }
            destination.addPage(newPage);
        }
        if (mergeStructTree) {
            this.updatePageReferences(srcNumbersArray, objMapping);
            for (int i = 0; i < srcNumbersArray.size() / 2; ++i) {
                destNumbersArray.add(COSInteger.get(destParentTreeNextKey + i));
                destNumbersArray.add(srcNumbersArray.getObject(i * 2 + 1));
            }
            destParentTreeDict.setItem(COSName.NUMS, (COSBase)destNumbersArray);
            PDNumberTreeNode newParentTreeNode = new PDNumberTreeNode(destParentTreeDict, COSBase.class);
            destStructTree.setParentTree(newParentTreeNode);
            destStructTree.setParentTreeNextKey(destParentTreeNextKey += srcNumbersArray.size() / 2);
            COSDictionary kDictLevel0 = new COSDictionary();
            COSArray newKArray = new COSArray();
            COSArray destKArray = destStructTree.getKArray();
            COSArray srcKArray = srcStructTree.getKArray();
            if (destKArray != null && srcKArray != null) {
                this.updateParentEntry(destKArray, kDictLevel0);
                newKArray.addAll(destKArray);
                if (mergeStructTree) {
                    this.updateParentEntry(srcKArray, kDictLevel0);
                }
                newKArray.addAll(srcKArray);
            }
            kDictLevel0.setItem(COSName.K, (COSBase)newKArray);
            kDictLevel0.setItem(COSName.P, (COSObjectable)destStructTree);
            kDictLevel0.setItem(COSName.S, (COSBase)new COSString(STRUCTURETYPE_DOCUMENT));
            destStructTree.setK(kDictLevel0);
        }
    }

    private void mergeAcroForm(PDFCloneUtility cloner, PDAcroForm destAcroForm, PDAcroForm srcAcroForm) throws IOException {
        COSArrayList<PDField> destFields = destAcroForm.getFields();
        List srcFields = srcAcroForm.getFields();
        if (srcFields != null) {
            if (destFields == null) {
                destFields = new COSArrayList<PDField>();
                destAcroForm.setFields(destFields);
            }
            for (PDField srcField : srcFields) {
                PDField destField = PDFieldFactory.createField(destAcroForm, (COSDictionary)cloner.cloneForNewDocument(srcField.getDictionary()));
                if (destAcroForm.getField(destField.getFullyQualifiedName()) != null) {
                    destField.setPartialName("dummyFieldName" + this.nextFieldNum++);
                }
                destFields.add(destField);
            }
        }
    }

    public boolean isIgnoreAcroFormErrors() {
        return this.ignoreAcroFormErrors;
    }

    public void setIgnoreAcroFormErrors(boolean ignoreAcroFormErrorsValue) {
        this.ignoreAcroFormErrors = ignoreAcroFormErrorsValue;
    }

    private void updatePageReferences(COSDictionary parentTreeEntry, HashMap<COSDictionary, COSDictionary> objMapping) {
        COSBase kSubEntry;
        COSBase obj;
        COSBase page = parentTreeEntry.getDictionaryObject(COSName.PG);
        if (page instanceof COSDictionary && objMapping.containsKey(page)) {
            parentTreeEntry.setItem(COSName.PG, (COSBase)objMapping.get(page));
        }
        if ((obj = parentTreeEntry.getDictionaryObject(COSName.OBJ)) instanceof COSDictionary && objMapping.containsKey(obj)) {
            parentTreeEntry.setItem(COSName.OBJ, (COSBase)objMapping.get(obj));
        }
        if ((kSubEntry = parentTreeEntry.getDictionaryObject(COSName.K)) instanceof COSArray) {
            this.updatePageReferences((COSArray)kSubEntry, objMapping);
        } else if (kSubEntry instanceof COSDictionary) {
            this.updatePageReferences((COSDictionary)kSubEntry, objMapping);
        }
    }

    private void updatePageReferences(COSArray parentTreeEntry, HashMap<COSDictionary, COSDictionary> objMapping) {
        for (int i = 0; i < parentTreeEntry.size(); ++i) {
            COSBase subEntry = parentTreeEntry.getObject(i);
            if (subEntry instanceof COSArray) {
                this.updatePageReferences((COSArray)subEntry, objMapping);
                continue;
            }
            if (!(subEntry instanceof COSDictionary)) continue;
            this.updatePageReferences((COSDictionary)subEntry, objMapping);
        }
    }

    private void updateParentEntry(COSArray kArray, COSDictionary newParent) {
        for (int i = 0; i < kArray.size(); ++i) {
            COSDictionary dictEntry;
            COSBase subEntry = kArray.getObject(i);
            if (!(subEntry instanceof COSDictionary) || (dictEntry = (COSDictionary)subEntry).getDictionaryObject(COSName.P) == null) continue;
            dictEntry.setItem(COSName.P, (COSBase)newParent);
        }
    }

    private void updateStructParentEntries(PDPage page, int structParentOffset) throws IOException {
        page.setStructParents(page.getStructParents() + structParentOffset);
        List<PDAnnotation> annots = page.getAnnotations();
        ArrayList<PDAnnotation> newannots = new ArrayList<PDAnnotation>();
        for (PDAnnotation annot : annots) {
            annot.setStructParent(annot.getStructParent() + structParentOffset);
            newannots.add(annot);
        }
        page.setAnnotations(newannots);
    }
}

