/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.font;

import java.awt.Font;
import java.awt.FontFormatException;
import java.io.IOException;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.font.FontManager;
import org.apache.pdfbox.pdmodel.font.PDCIDFont;
import org.apache.pdfbox.pdmodel.font.PDFontDescriptorDictionary;

public class PDCIDFontType2Font
extends PDCIDFont {
    private static final Log LOG = LogFactory.getLog(PDCIDFontType2Font.class);
    private Boolean hasCIDToGIDMap = null;
    private int[] cid2gid = null;

    public PDCIDFontType2Font() {
        this.font.setItem(COSName.SUBTYPE, (COSBase)COSName.CID_FONT_TYPE2);
    }

    public PDCIDFontType2Font(COSDictionary fontDictionary) {
        super(fontDictionary);
    }

    public Font getawtFont() throws IOException {
        Font awtFont = null;
        PDFontDescriptorDictionary fd = (PDFontDescriptorDictionary)this.getFontDescriptor();
        PDStream ff2Stream = fd.getFontFile2();
        if (ff2Stream != null) {
            try {
                awtFont = Font.createFont(0, ff2Stream.createInputStream());
            }
            catch (FontFormatException f) {
                LOG.info("Can't read the embedded font " + fd.getFontName());
            }
            if (awtFont == null) {
                awtFont = FontManager.getAwtFont(fd.getFontName());
                if (awtFont != null) {
                    LOG.info("Using font " + awtFont.getName() + " instead");
                }
                this.setIsFontSubstituted(true);
            }
        }
        return awtFont;
    }

    private void readCIDToGIDMapping() {
        COSBase map = this.font.getDictionaryObject(COSName.CID_TO_GID_MAP);
        if (map instanceof COSStream) {
            COSStream stream = (COSStream)map;
            try {
                byte[] mapAsBytes = IOUtils.toByteArray(stream.getUnfilteredStream());
                int numberOfInts = mapAsBytes.length / 2;
                this.cid2gid = new int[numberOfInts];
                int offset = 0;
                for (int index = 0; index < numberOfInts; ++index) {
                    this.cid2gid[index] = this.getCodeFromArray(mapAsBytes, offset, 2);
                    offset += 2;
                }
            }
            catch (IOException exception) {
                LOG.error("Can't read the CIDToGIDMap", exception);
            }
        }
    }

    public boolean hasCIDToGIDMap() {
        if (this.hasCIDToGIDMap == null) {
            COSBase map = this.font.getDictionaryObject(COSName.CID_TO_GID_MAP);
            this.hasCIDToGIDMap = map != null && map instanceof COSStream ? Boolean.TRUE : Boolean.FALSE;
        }
        return this.hasCIDToGIDMap;
    }

    public int mapCIDToGID(int cid) {
        if (this.hasCIDToGIDMap()) {
            if (this.cid2gid == null) {
                this.readCIDToGIDMapping();
            }
            if (this.cid2gid != null && cid < this.cid2gid.length) {
                return this.cid2gid[cid];
            }
            return -1;
        }
        return cid;
    }
}

