/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.pdmodel.graphics.xobject;

import java.io.IOException;
import java.util.List;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.apache.pdfbox.cos.COSBase;
import org.apache.pdfbox.cos.COSName;
import org.apache.pdfbox.cos.COSStream;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.common.COSObjectable;
import org.apache.pdfbox.pdmodel.common.PDMetadata;
import org.apache.pdfbox.pdmodel.common.PDStream;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDCcitt;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDJpeg;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDPixelMap;
import org.apache.pdfbox.pdmodel.graphics.xobject.PDXObjectForm;

public abstract class PDXObject
implements COSObjectable {
    private static final Log LOG = LogFactory.getLog(PDXObject.class);
    private PDStream xobject;

    public PDXObject(COSStream xobj) {
        this.xobject = new PDStream(xobj);
        this.getCOSStream().setItem(COSName.TYPE, (COSBase)COSName.XOBJECT);
    }

    public PDXObject(PDStream xobj) {
        this.xobject = xobj;
        this.getCOSStream().setItem(COSName.TYPE, (COSBase)COSName.XOBJECT);
    }

    public PDXObject(PDDocument doc) {
        this.xobject = new PDStream(doc);
        this.getCOSStream().setItem(COSName.TYPE, (COSBase)COSName.XOBJECT);
    }

    public COSBase getCOSObject() {
        return this.xobject.getCOSObject();
    }

    public COSStream getCOSStream() {
        return this.xobject.getStream();
    }

    public PDStream getPDStream() {
        return this.xobject;
    }

    public static PDXObject createXObject(COSBase xobject) throws IOException {
        return PDXObject.commonXObjectCreation(xobject, false);
    }

    protected static PDXObject commonXObjectCreation(COSBase xobject, boolean isThumb) {
        PDXObject retval = null;
        if (xobject == null) {
            retval = null;
        } else if (xobject instanceof COSStream) {
            COSStream xstream = (COSStream)xobject;
            String subtype = xstream.getNameAsString(COSName.SUBTYPE);
            if ("Image".equals(subtype) || subtype == null && isThumb) {
                PDStream image = new PDStream(xstream);
                List<COSName> filters = image.getFilters();
                if (filters != null && filters.contains(COSName.DCT_DECODE)) {
                    return new PDJpeg(image);
                }
                if (filters != null && filters.contains(COSName.CCITTFAX_DECODE)) {
                    return new PDCcitt(image);
                }
                if (filters != null && filters.contains(COSName.JPX_DECODE)) {
                    return new PDPixelMap(image);
                }
                retval = new PDPixelMap(image);
            } else if ("Form".equals(subtype)) {
                retval = new PDXObjectForm(xstream);
            } else {
                LOG.warn("Skipping unknown XObject subtype '" + subtype + "'");
            }
        }
        return retval;
    }

    public PDMetadata getMetadata() {
        PDMetadata retval = null;
        COSStream mdStream = (COSStream)this.getCOSStream().getDictionaryObject(COSName.METADATA);
        if (mdStream != null) {
            retval = new PDMetadata(mdStream);
        }
        return retval;
    }

    public void setMetadata(PDMetadata meta) {
        this.getCOSStream().setItem(COSName.METADATA, (COSObjectable)meta);
    }

    public int getStructParent() {
        return this.getCOSStream().getInt(COSName.STRUCT_PARENT, 0);
    }

    public void setStructParent(int structParent) {
        this.getCOSStream().setInt(COSName.STRUCT_PARENT, structParent);
    }
}

