/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.File;
import java.io.IOException;
import java.io.PrintStream;
import java.util.concurrent.Callable;
import org.apache.pdfbox.Loader;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDDocumentCatalog;
import org.apache.pdfbox.pdmodel.fdf.FDFDocument;
import org.apache.pdfbox.pdmodel.interactive.form.PDAcroForm;
import org.apache.pdfbox.tools.ImportFDF;
import org.apache.pdfbox.tools.Version;
import picocli.CommandLine;

@CommandLine.Command(name="importxfdf", header={"Imports AcroForm form data from XFDF"}, versionProvider=Version.class, mixinStandardHelpOptions=true)
public class ImportXFDF
implements Callable<Integer> {
    private static final PrintStream SYSERR = System.err;
    @CommandLine.Option(names={"-i", "--input"}, description={"the PDF file to import to"}, required=true)
    private File infile;
    @CommandLine.Option(names={"-o", "--output"}, description={"the PDF file to save to. If omitted the original file will be used"})
    private File outfile;
    @CommandLine.Option(names={"--data"}, description={"the XFDF data file to import from"}, required=true)
    private File xfdffile;

    public void importFDF(PDDocument pdfDocument, FDFDocument fdfDocument) throws IOException {
        PDDocumentCatalog docCatalog = pdfDocument.getDocumentCatalog();
        PDAcroForm acroForm = docCatalog.getAcroForm();
        acroForm.setCacheFields(true);
        acroForm.importFDF(fdfDocument);
    }

    public static void main(String[] args) {
        System.setProperty("apple.awt.UIElement", "true");
        int exitCode = new CommandLine((Object)new ImportXFDF()).execute(args);
        System.exit(exitCode);
    }

    @Override
    public Integer call() {
        ImportFDF importer = new ImportFDF();
        try (PDDocument pdf = Loader.loadPDF((File)this.infile);
             FDFDocument fdf = Loader.loadXFDF((File)this.xfdffile);){
            importer.importFDF(pdf, fdf);
            if (this.outfile == null) {
                this.outfile = this.infile;
            }
            pdf.save(this.outfile);
        }
        catch (IOException ioe) {
            SYSERR.println("Error importing XFDF data [" + ioe.getClass().getSimpleName() + "]: " + ioe.getMessage());
            return 4;
        }
        return 0;
    }
}

