/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.io.BufferedReader;
import java.io.File;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.HashMap;
import java.util.Map;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.pdmodel.PDPageContentStream;
import org.apache.pdfbox.pdmodel.common.PDRectangle;
import org.apache.pdfbox.pdmodel.font.PDFont;
import org.apache.pdfbox.pdmodel.font.PDType0Font;
import org.apache.pdfbox.pdmodel.font.PDType1Font;

public class TextToPDF {
    private static final int FONTSCALE = 1000;
    private static final PDType1Font DEFAULT_FONT = PDType1Font.HELVETICA;
    private static final int DEFAULT_FONT_SIZE = 10;
    private static final float LINE_HEIGHT_FACTOR = 1.05f;
    private int fontSize = 10;
    private boolean landscape = false;
    private PDFont font = DEFAULT_FONT;
    private static final Map<String, PDType1Font> STANDARD_14 = new HashMap<String, PDType1Font>();

    public PDDocument createPDFFromText(Reader text) throws IOException {
        PDDocument doc = new PDDocument();
        this.createPDFFromText(doc, text);
        return doc;
    }

    public void createPDFFromText(PDDocument doc, Reader text) throws IOException {
        try {
            int margin = 40;
            float height = this.font.getBoundingBox().getHeight() / 1000.0f;
            PDRectangle mediaBox = PDRectangle.LETTER;
            if (this.landscape) {
                mediaBox = new PDRectangle(mediaBox.getHeight(), mediaBox.getWidth());
            }
            height = height * (float)this.fontSize * 1.05f;
            BufferedReader data = new BufferedReader(text);
            String nextLine = null;
            PDPage page = new PDPage(mediaBox);
            PDPageContentStream contentStream = null;
            float y = -1.0f;
            float maxStringLength = page.getMediaBox().getWidth() - 80.0f;
            boolean textIsEmpty = true;
            while ((nextLine = data.readLine()) != null) {
                textIsEmpty = false;
                String[] lineWords = nextLine.replaceAll("[\\n\\r]+$", "").split(" ");
                int lineIndex = 0;
                while (lineIndex < lineWords.length) {
                    StringBuilder nextLineToDraw = new StringBuilder();
                    float lengthIfUsingNextWord = 0.0f;
                    boolean ff = false;
                    do {
                        String word1;
                        String word2 = "";
                        int indexFF = lineWords[lineIndex].indexOf(12);
                        if (indexFF == -1) {
                            word1 = lineWords[lineIndex];
                        } else {
                            ff = true;
                            word1 = lineWords[lineIndex].substring(0, indexFF);
                            if (indexFF < lineWords[lineIndex].length()) {
                                word2 = lineWords[lineIndex].substring(indexFF + 1);
                            }
                        }
                        if (word1.length() > 0 || !ff) {
                            nextLineToDraw.append(word1);
                            nextLineToDraw.append(" ");
                        }
                        if (!ff || word2.length() == 0) {
                            ++lineIndex;
                        } else {
                            lineWords[lineIndex] = word2;
                        }
                        if (ff) break;
                        if (lineIndex >= lineWords.length) continue;
                        String nextWord = lineWords[lineIndex];
                        indexFF = nextWord.indexOf(12);
                        if (indexFF != -1) {
                            nextWord = nextWord.substring(0, indexFF);
                        }
                        String lineWithNextWord = nextLineToDraw.toString() + " " + nextWord;
                        lengthIfUsingNextWord = this.font.getStringWidth(lineWithNextWord) / 1000.0f * (float)this.fontSize;
                    } while (lineIndex < lineWords.length && lengthIfUsingNextWord < maxStringLength);
                    if (y < 40.0f) {
                        page = new PDPage(mediaBox);
                        doc.addPage(page);
                        if (contentStream != null) {
                            contentStream.endText();
                            contentStream.close();
                        }
                        contentStream = new PDPageContentStream(doc, page);
                        contentStream.setFont(this.font, (float)this.fontSize);
                        contentStream.beginText();
                        y = page.getMediaBox().getHeight() - 40.0f + height;
                        contentStream.newLineAtOffset(40.0f, y);
                    }
                    if (contentStream == null) {
                        throw new IOException("Error:Expected non-null content stream.");
                    }
                    contentStream.newLineAtOffset(0.0f, -height);
                    y -= height;
                    contentStream.showText(nextLineToDraw.toString());
                    if (!ff) continue;
                    page = new PDPage(mediaBox);
                    doc.addPage(page);
                    contentStream.endText();
                    contentStream.close();
                    contentStream = new PDPageContentStream(doc, page);
                    contentStream.setFont(this.font, (float)this.fontSize);
                    contentStream.beginText();
                    y = page.getMediaBox().getHeight() - 40.0f + height;
                    contentStream.newLineAtOffset(40.0f, y);
                }
            }
            if (textIsEmpty) {
                doc.addPage(page);
            }
            if (contentStream != null) {
                contentStream.endText();
                contentStream.close();
            }
        }
        catch (IOException io) {
            if (doc != null) {
                doc.close();
            }
            throw io;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws IOException {
        System.setProperty("apple.awt.UIElement", "true");
        TextToPDF app = new TextToPDF();
        PDDocument doc = new PDDocument();
        try {
            if (args.length < 2) {
                app.usage();
            } else {
                for (int i = 0; i < args.length - 2; ++i) {
                    if (args[i].equals("-standardFont")) {
                        app.setFont((PDFont)TextToPDF.getStandardFont(args[++i]));
                        continue;
                    }
                    if (args[i].equals("-ttf")) {
                        PDType0Font font = PDType0Font.load((PDDocument)doc, (File)new File(args[++i]));
                        app.setFont((PDFont)font);
                        continue;
                    }
                    if (args[i].equals("-fontSize")) {
                        app.setFontSize(Integer.parseInt(args[++i]));
                        continue;
                    }
                    if (args[i].equals("-landscape")) {
                        app.setLandscape(true);
                        continue;
                    }
                    throw new IOException("Unknown argument:" + args[i]);
                }
                app.createPDFFromText(doc, new FileReader(args[args.length - 1]));
                doc.save(args[args.length - 2]);
            }
        }
        finally {
            doc.close();
        }
    }

    private void usage() {
        String[] std14 = TextToPDF.getStandard14Names();
        StringBuilder message = new StringBuilder();
        message.append("Usage: jar -jar pdfbox-app-x.y.z.jar TextToPDF [options] <outputfile> <textfile>\n");
        message.append("\nOptions:\n");
        message.append("  -standardFont <name> : ").append(DEFAULT_FONT.getBaseFont()).append(" (default)\n");
        for (String std14String : std14) {
            message.append("                         ").append(std14String).append("\n");
        }
        message.append("  -ttf <ttf file>      : The TTF font to use.\n");
        message.append("  -fontSize <fontSize> : default: 10");
        message.append("  -landscape           : sets orientation to landscape");
        System.err.println(message.toString());
        System.exit(1);
    }

    private static PDType1Font getStandardFont(String name) {
        return STANDARD_14.get(name);
    }

    private static String[] getStandard14Names() {
        return STANDARD_14.keySet().toArray(new String[14]);
    }

    public PDFont getFont() {
        return this.font;
    }

    public void setFont(PDFont aFont) {
        this.font = aFont;
    }

    public int getFontSize() {
        return this.fontSize;
    }

    public void setFontSize(int aFontSize) {
        this.fontSize = aFontSize;
    }

    public boolean isLandscape() {
        return this.landscape;
    }

    public void setLandscape(boolean landscape) {
        this.landscape = landscape;
    }

    static {
        STANDARD_14.put(PDType1Font.TIMES_ROMAN.getBaseFont(), PDType1Font.TIMES_ROMAN);
        STANDARD_14.put(PDType1Font.TIMES_BOLD.getBaseFont(), PDType1Font.TIMES_BOLD);
        STANDARD_14.put(PDType1Font.TIMES_ITALIC.getBaseFont(), PDType1Font.TIMES_ITALIC);
        STANDARD_14.put(PDType1Font.TIMES_BOLD_ITALIC.getBaseFont(), PDType1Font.TIMES_BOLD_ITALIC);
        STANDARD_14.put(PDType1Font.HELVETICA.getBaseFont(), PDType1Font.HELVETICA);
        STANDARD_14.put(PDType1Font.HELVETICA_BOLD.getBaseFont(), PDType1Font.HELVETICA_BOLD);
        STANDARD_14.put(PDType1Font.HELVETICA_OBLIQUE.getBaseFont(), PDType1Font.HELVETICA_OBLIQUE);
        STANDARD_14.put(PDType1Font.HELVETICA_BOLD_OBLIQUE.getBaseFont(), PDType1Font.HELVETICA_BOLD_OBLIQUE);
        STANDARD_14.put(PDType1Font.COURIER.getBaseFont(), PDType1Font.COURIER);
        STANDARD_14.put(PDType1Font.COURIER_BOLD.getBaseFont(), PDType1Font.COURIER_BOLD);
        STANDARD_14.put(PDType1Font.COURIER_OBLIQUE.getBaseFont(), PDType1Font.COURIER_OBLIQUE);
        STANDARD_14.put(PDType1Font.COURIER_BOLD_OBLIQUE.getBaseFont(), PDType1Font.COURIER_BOLD_OBLIQUE);
        STANDARD_14.put(PDType1Font.SYMBOL.getBaseFont(), PDType1Font.SYMBOL);
        STANDARD_14.put(PDType1Font.ZAPF_DINGBATS.getBaseFont(), PDType1Font.ZAPF_DINGBATS);
    }
}

