/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.tools;

import java.awt.RenderingHints;
import java.awt.print.Pageable;
import java.awt.print.PrinterException;
import java.awt.print.PrinterJob;
import java.io.File;
import java.io.IOException;
import java.util.HashMap;
import javax.print.PrintService;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.printing.Orientation;
import org.apache.pdfbox.printing.PDFPageable;

public final class PrintPDF {
    private static final String PASSWORD = "-password";
    private static final String SILENT = "-silentPrint";
    private static final String PRINTER_NAME = "-printerName";
    private static final String ORIENTATION = "-orientation";
    private static final String BORDER = "-border";
    private static final String DPI = "-dpi";
    private static final String NOCOLOROPT = "-noColorOpt";

    private PrintPDF() {
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static void main(String[] args) throws PrinterException, IOException {
        System.setProperty("apple.awt.UIElement", "true");
        String password = "";
        String pdfFile = null;
        boolean silentPrint = false;
        String printerName = null;
        Orientation orientation = Orientation.AUTO;
        boolean showPageBorder = false;
        int dpi = 0;
        HashMap<String, Orientation> orientationMap = new HashMap<String, Orientation>();
        orientationMap.put("auto", Orientation.AUTO);
        orientationMap.put("landscape", Orientation.LANDSCAPE);
        orientationMap.put("portrait", Orientation.PORTRAIT);
        RenderingHints renderingHints = null;
        for (int i = 0; i < args.length; ++i) {
            if (args[i].equals(PASSWORD)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                password = args[i];
                continue;
            }
            if (args[i].equals(PRINTER_NAME)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                printerName = args[i];
                continue;
            }
            if (args[i].equals(SILENT)) {
                silentPrint = true;
                continue;
            }
            if (args[i].equals(ORIENTATION)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                if ((orientation = (Orientation)orientationMap.get(args[i])) != null) continue;
                PrintPDF.usage();
                continue;
            }
            if (args[i].equals(BORDER)) {
                showPageBorder = true;
                continue;
            }
            if (args[i].equals(NOCOLOROPT)) {
                renderingHints = new RenderingHints(null);
                renderingHints.put(RenderingHints.KEY_INTERPOLATION, RenderingHints.VALUE_INTERPOLATION_NEAREST_NEIGHBOR);
                renderingHints.put(RenderingHints.KEY_RENDERING, RenderingHints.VALUE_RENDER_QUALITY);
                renderingHints.put(RenderingHints.KEY_ANTIALIASING, RenderingHints.VALUE_ANTIALIAS_OFF);
                continue;
            }
            if (args[i].equals(DPI)) {
                if (++i >= args.length) {
                    PrintPDF.usage();
                }
                dpi = Integer.parseInt(args[i]);
                continue;
            }
            pdfFile = args[i];
        }
        if (pdfFile == null) {
            PrintPDF.usage();
        }
        PDDocument document = null;
        try {
            document = PDDocument.load((File)new File(pdfFile), (String)password);
            PrinterJob printJob = PrinterJob.getPrinterJob();
            printJob.setJobName(new File(pdfFile).getName());
            if (printerName != null) {
                PrintService[] printServices = PrinterJob.lookupPrintServices();
                boolean printerFound = false;
                for (int i = 0; !printerFound && i < printServices.length; ++i) {
                    if (!printServices[i].getName().equals(printerName)) continue;
                    printJob.setPrintService(printServices[i]);
                    printerFound = true;
                }
                if (!printerFound) {
                    System.err.println("printer '" + printerName + "' not found, using default");
                    PrintPDF.showAvailablePrinters();
                }
            }
            PDFPageable pageable = new PDFPageable(document, orientation, showPageBorder, (float)dpi);
            pageable.setRenderingHints(renderingHints);
            printJob.setPageable((Pageable)pageable);
            if (silentPrint || printJob.printDialog()) {
                printJob.print();
            }
        }
        finally {
            if (document != null) {
                document.close();
            }
        }
    }

    private static void usage() {
        String message = "Usage: java -jar pdfbox-app-x.y.z.jar PrintPDF [options] <inputfile>\n\nOptions:\n  -password  <password>                : Password to decrypt document\n  -printerName <name>                  : Print to specific printer\n  -orientation auto|portrait|landscape : Print using orientation\n                                           (default: auto)\n  -border                              : Print with border\n  -dpi                                 : Render into intermediate image with\n                                           specific dpi and then print\n  -noColorOpt                          : Disable color optimizations\n                                           (useful when printing barcodes)\n  -silentPrint                         : Print without printer dialog box\n";
        System.err.println(message);
        PrintPDF.showAvailablePrinters();
        System.exit(1);
    }

    private static void showAvailablePrinters() {
        PrintService[] printServices;
        System.err.println("Available printer names:");
        for (PrintService printService : printServices = PrinterJob.lookupPrintServices()) {
            System.err.println("    " + printService.getName());
        }
    }
}

