/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.io;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.channels.FileChannel;
import java.nio.file.StandardOpenOption;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.concurrent.ConcurrentHashMap;
import java.util.concurrent.ConcurrentMap;
import org.apache.pdfbox.io.IOUtils;
import org.apache.pdfbox.io.RandomAccessRead;
import org.apache.pdfbox.io.RandomAccessReadView;

public class RandomAccessReadBufferedFile
implements RandomAccessRead {
    private static final int PAGE_SIZE_SHIFT = 12;
    private static final int PAGE_SIZE = 4096;
    private static final long PAGE_OFFSET_MASK = -4096L;
    private static final int MAX_CACHED_PAGES = 1000;
    private final ConcurrentMap<Long, RandomAccessReadBufferedFile> rafCopies = new ConcurrentHashMap<Long, RandomAccessReadBufferedFile>();
    private ByteBuffer lastRemovedCachePage = null;
    private final Map<Long, ByteBuffer> pageCache = new LinkedHashMap<Long, ByteBuffer>(1000, 0.75f, true){
        private static final long serialVersionUID = -6302488539257741101L;

        @Override
        protected boolean removeEldestEntry(Map.Entry<Long, ByteBuffer> eldest) {
            boolean doRemove;
            boolean bl = doRemove = this.size() > 1000;
            if (doRemove) {
                RandomAccessReadBufferedFile.this.lastRemovedCachePage = eldest.getValue();
                RandomAccessReadBufferedFile.this.lastRemovedCachePage.clear();
            }
            return doRemove;
        }
    };
    private long curPageOffset = -1L;
    private ByteBuffer curPage;
    private int offsetWithinPage = 0;
    private final FileChannel fileChannel;
    private final File file;
    private final long fileLength;
    private long fileOffset = 0L;
    private boolean isClosed;

    public RandomAccessReadBufferedFile(String filename) throws IOException {
        this(new File(filename));
    }

    public RandomAccessReadBufferedFile(File file) throws IOException {
        this.file = file;
        this.fileChannel = FileChannel.open(file.toPath(), StandardOpenOption.READ);
        this.fileLength = file.length();
        this.seek(0L);
    }

    @Override
    public long getPosition() throws IOException {
        this.checkClosed();
        return this.fileOffset;
    }

    @Override
    public void seek(long position) throws IOException {
        this.checkClosed();
        if (position < 0L) {
            throw new IOException("Invalid position " + position);
        }
        long newPageOffset = position & 0xFFFFFFFFFFFFF000L;
        if (newPageOffset != this.curPageOffset) {
            ByteBuffer newPage = this.pageCache.get(newPageOffset);
            if (newPage == null) {
                this.fileChannel.position(newPageOffset);
                newPage = this.readPage();
                this.pageCache.put(newPageOffset, newPage);
            }
            this.curPageOffset = newPageOffset;
            this.curPage = newPage;
        }
        this.fileOffset = Math.min(position, this.fileLength);
        this.offsetWithinPage = (int)(this.fileOffset - this.curPageOffset);
    }

    private ByteBuffer readPage() throws IOException {
        int curBytesRead;
        ByteBuffer page;
        if (this.lastRemovedCachePage != null) {
            page = this.lastRemovedCachePage;
            this.lastRemovedCachePage = null;
        } else {
            page = ByteBuffer.allocate(4096);
        }
        for (int readBytes = 0; readBytes < 4096 && (curBytesRead = this.fileChannel.read(page)) >= 0; readBytes += curBytesRead) {
        }
        return page;
    }

    @Override
    public int read() throws IOException {
        this.checkClosed();
        if (this.fileOffset >= this.fileLength) {
            return -1;
        }
        if (this.offsetWithinPage == 4096) {
            this.seek(this.fileOffset);
        }
        ++this.fileOffset;
        return this.curPage.get(this.offsetWithinPage++) & 0xFF;
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.checkClosed();
        if (this.fileOffset >= this.fileLength) {
            return -1;
        }
        if (this.offsetWithinPage == 4096) {
            this.seek(this.fileOffset);
        }
        int commonLen = Math.min(4096 - this.offsetWithinPage, len);
        if (this.fileLength - this.fileOffset < 4096L) {
            commonLen = Math.min(commonLen, (int)(this.fileLength - this.fileOffset));
        }
        this.curPage.position(this.offsetWithinPage);
        this.curPage.get(b, off, commonLen);
        this.offsetWithinPage += commonLen;
        this.fileOffset += (long)commonLen;
        return commonLen;
    }

    @Override
    public long length() throws IOException {
        return this.fileLength;
    }

    @Override
    public void close() throws IOException {
        this.rafCopies.values().forEach(IOUtils::closeQuietly);
        this.rafCopies.clear();
        this.fileChannel.close();
        this.pageCache.clear();
        this.isClosed = true;
    }

    @Override
    public boolean isClosed() {
        return this.isClosed;
    }

    private void checkClosed() throws IOException {
        if (this.isClosed) {
            throw new IOException(this.getClass().getName() + " already closed");
        }
    }

    @Override
    public boolean isEOF() throws IOException {
        return this.peek() == -1;
    }

    @Override
    public RandomAccessReadView createView(long startPosition, long streamLength) throws IOException {
        this.checkClosed();
        Long currentThreadID = Thread.currentThread().getId();
        RandomAccessReadBufferedFile randomAccessReadBufferedFile = (RandomAccessReadBufferedFile)this.rafCopies.get(currentThreadID);
        if (randomAccessReadBufferedFile == null || randomAccessReadBufferedFile.isClosed()) {
            randomAccessReadBufferedFile = new RandomAccessReadBufferedFile(this.file);
            this.rafCopies.put(currentThreadID, randomAccessReadBufferedFile);
        }
        return new RandomAccessReadView(randomAccessReadBufferedFile, startPosition, streamLength);
    }
}

