/*
 * Decompiled with CFR 0.152.
 */
package org.apache.pdfbox.debugger.pagepane;

import java.awt.Color;
import java.awt.Component;
import java.awt.Font;
import java.awt.Image;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.image.BufferedImage;
import java.io.IOException;
import java.util.concurrent.ExecutionException;
import javax.swing.BoxLayout;
import javax.swing.ImageIcon;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.SwingWorker;
import javax.swing.event.AncestorEvent;
import javax.swing.event.AncestorListener;
import org.apache.pdfbox.cos.COSDictionary;
import org.apache.pdfbox.debugger.ui.ImageUtil;
import org.apache.pdfbox.debugger.ui.RotationMenu;
import org.apache.pdfbox.debugger.ui.ZoomMenu;
import org.apache.pdfbox.pdmodel.PDDocument;
import org.apache.pdfbox.pdmodel.PDPage;
import org.apache.pdfbox.rendering.PDFRenderer;

public class PagePane
implements ActionListener,
AncestorListener,
MouseMotionListener,
MouseListener {
    private JPanel panel;
    private int pageIndex = -1;
    private final PDDocument document;
    private JLabel label;
    private ZoomMenu zoomMenu;
    private RotationMenu rotationMenu;
    private final JLabel statuslabel;
    private final PDPage page;

    public PagePane(PDDocument document, COSDictionary pageDict, JLabel statuslabel) {
        this.page = new PDPage(pageDict);
        this.pageIndex = document.getPages().indexOf(this.page);
        this.document = document;
        this.statuslabel = statuslabel;
        this.initUI();
    }

    private void initUI() {
        this.panel = new JPanel();
        this.panel.setLayout(new BoxLayout(this.panel, 1));
        String pageLabelText = this.pageIndex < 0 ? "Page number not found" : "Page " + (this.pageIndex + 1);
        JLabel pageLabel = new JLabel(pageLabelText);
        pageLabel.setAlignmentX(0.5f);
        pageLabel.setFont(new Font("Monospaced", 1, 30));
        pageLabel.setBackground(Color.GREEN);
        this.panel.add(pageLabel);
        this.label = new JLabel();
        this.label.addMouseMotionListener(this);
        this.label.addMouseListener(this);
        this.label.setBackground(this.panel.getBackground());
        this.label.setAlignmentX(0.5f);
        this.panel.add(this.label);
        this.panel.addAncestorListener(this);
        this.zoomMenu = ZoomMenu.getInstance();
        this.zoomMenu.changeZoomSelection(this.zoomMenu.getPageZoomScale());
        new RenderWorker(this.zoomMenu.getPageZoomScale(), 0).execute();
    }

    public Component getPanel() {
        return this.panel;
    }

    @Override
    public void actionPerformed(ActionEvent actionEvent) {
        String actionCommand = actionEvent.getActionCommand();
        if (ZoomMenu.isZoomMenu(actionCommand) || RotationMenu.isRotationMenu(actionCommand)) {
            new RenderWorker(ZoomMenu.getZoomScale(), RotationMenu.getRotationDegrees()).execute();
            this.zoomMenu.setPageZoomScale(ZoomMenu.getZoomScale());
        }
    }

    @Override
    public void ancestorAdded(AncestorEvent ancestorEvent) {
        this.zoomMenu.addMenuListeners(this);
        this.zoomMenu.setEnableMenu(true);
        this.rotationMenu = RotationMenu.getInstance();
        this.rotationMenu.addMenuListeners(this);
        this.rotationMenu.setRotationSelection("0\u00b0");
        this.rotationMenu.setEnableMenu(true);
    }

    @Override
    public void ancestorRemoved(AncestorEvent ancestorEvent) {
        this.zoomMenu.setEnableMenu(false);
        this.rotationMenu.setEnableMenu(false);
    }

    @Override
    public void ancestorMoved(AncestorEvent ancestorEvent) {
    }

    @Override
    public void mouseDragged(MouseEvent e) {
    }

    @Override
    public void mouseMoved(MouseEvent e) {
        int y1;
        int x1;
        float height = this.page.getCropBox().getHeight();
        float width = this.page.getCropBox().getWidth();
        float offsetX = this.page.getCropBox().getLowerLeftX();
        float offsetY = this.page.getCropBox().getLowerLeftY();
        float zoomScale = this.zoomMenu.getPageZoomScale();
        float x = (float)e.getX() / zoomScale;
        float y = (float)e.getY() / zoomScale;
        switch ((RotationMenu.getRotationDegrees() + this.page.getRotation()) % 360) {
            case 90: {
                x1 = (int)(y + offsetX);
                y1 = (int)(x + offsetY);
                break;
            }
            case 180: {
                x1 = (int)(width - x + offsetX);
                y1 = (int)(y - offsetY);
                break;
            }
            case 270: {
                x1 = (int)(width - y + offsetX);
                y1 = (int)(height - x + offsetY);
                break;
            }
            default: {
                x1 = (int)(x + offsetX);
                y1 = (int)(height - y + offsetY);
            }
        }
        this.statuslabel.setText(x1 + "," + y1);
    }

    @Override
    public void mouseClicked(MouseEvent e) {
    }

    @Override
    public void mousePressed(MouseEvent e) {
    }

    @Override
    public void mouseReleased(MouseEvent e) {
    }

    @Override
    public void mouseEntered(MouseEvent e) {
    }

    @Override
    public void mouseExited(MouseEvent e) {
        this.statuslabel.setText("");
    }

    private final class RenderWorker
    extends SwingWorker<BufferedImage, Integer> {
        private final float scale;
        private final int rotation;

        private RenderWorker(float scale, int rotation) {
            this.scale = scale;
            this.rotation = rotation;
        }

        @Override
        protected BufferedImage doInBackground() throws IOException {
            PagePane.this.label.setIcon(null);
            PagePane.this.label.setText("Rendering...");
            PDFRenderer renderer = new PDFRenderer(PagePane.this.document);
            long t0 = System.currentTimeMillis();
            PagePane.this.statuslabel.setText("Rendering...");
            BufferedImage bim = renderer.renderImage(PagePane.this.pageIndex, this.scale);
            float t = (float)(System.currentTimeMillis() - t0) / 1000.0f;
            PagePane.this.statuslabel.setText("Rendered in " + t + " second" + (t > 1.0f ? "s" : ""));
            return ImageUtil.getRotatedImage(bim, this.rotation);
        }

        @Override
        protected void done() {
            try {
                PagePane.this.label.setIcon(new ImageIcon((Image)this.get()));
                PagePane.this.label.setText(null);
            }
            catch (InterruptedException e) {
                PagePane.this.label.setText(e.getMessage());
                throw new RuntimeException(e);
            }
            catch (ExecutionException e) {
                PagePane.this.label.setText(e.getMessage());
                throw new RuntimeException(e);
            }
        }
    }
}

