/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.variant;

import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.HashMap;
import org.apache.parquet.variant.Metadata;
import org.apache.parquet.variant.VariantBuilder;
import org.apache.parquet.variant.VariantUtil;

public class MetadataBuilder
implements Metadata {
    private HashMap<String, Integer> dictionary = new HashMap();
    private ArrayList<byte[]> dictionaryKeys = new ArrayList();

    @Override
    public ByteBuffer getEncodedBuffer() {
        int numKeys = this.dictionaryKeys.size();
        long dictionaryTotalDataSize = 0L;
        for (byte[] key : this.dictionaryKeys) {
            dictionaryTotalDataSize += (long)key.length;
        }
        long maxSize = Math.max(dictionaryTotalDataSize, (long)numKeys);
        int offsetSize = VariantBuilder.getMinIntegerSize((int)maxSize);
        int offsetListOffset = 1 + offsetSize;
        int dataOffset = offsetListOffset + (numKeys + 1) * offsetSize;
        long metadataSize = (long)dataOffset + dictionaryTotalDataSize;
        byte[] metadata = new byte[(int)metadataSize];
        int headerByte = 1 | offsetSize - 1 << 6;
        VariantUtil.writeLong(metadata, 0, headerByte, 1);
        VariantUtil.writeLong(metadata, 1, numKeys, offsetSize);
        int currentOffset = 0;
        for (int i = 0; i < numKeys; ++i) {
            VariantUtil.writeLong(metadata, offsetListOffset + i * offsetSize, currentOffset, offsetSize);
            byte[] key = this.dictionaryKeys.get(i);
            System.arraycopy(key, 0, metadata, dataOffset + currentOffset, key.length);
            currentOffset += key.length;
        }
        VariantUtil.writeLong(metadata, offsetListOffset + numKeys * offsetSize, currentOffset, offsetSize);
        return ByteBuffer.wrap(metadata);
    }

    @Override
    public int getOrInsert(String key) {
        return this.dictionary.computeIfAbsent(key, newKey -> {
            int id = this.dictionaryKeys.size();
            this.dictionaryKeys.add(newKey.getBytes(StandardCharsets.UTF_8));
            return id;
        });
    }
}

