/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.pig;

import java.io.IOException;
import java.util.Properties;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.OutputFormat;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.hadoop.mapreduce.lib.output.FileOutputFormat;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.io.ParquetEncodingException;
import org.apache.parquet.pig.TupleWriteSupport;
import org.apache.pig.ResourceSchema;
import org.apache.pig.ResourceStatistics;
import org.apache.pig.StoreFunc;
import org.apache.pig.StoreMetadata;
import org.apache.pig.data.Tuple;
import org.apache.pig.impl.logicalLayer.schema.Schema;
import org.apache.pig.impl.util.UDFContext;
import org.apache.pig.impl.util.Utils;
import org.apache.pig.parser.ParserException;

public class ParquetStorer
extends StoreFunc
implements StoreMetadata {
    private static final String SCHEMA = "schema";
    private RecordWriter<Void, Tuple> recordWriter;
    private String signature;

    private Properties getProperties() {
        UDFContext udfc = UDFContext.getUDFContext();
        Properties p = udfc.getUDFProperties(((Object)((Object)this)).getClass(), new String[]{this.signature});
        return p;
    }

    private Schema getSchema() {
        try {
            String schemaString = this.getProperties().getProperty(SCHEMA);
            if (schemaString == null) {
                throw new ParquetEncodingException("Can not store relation in Parquet as the schema is unknown");
            }
            return Utils.getSchemaFromString((String)schemaString);
        }
        catch (ParserException e) {
            throw new ParquetEncodingException("can not get schema from context", e);
        }
    }

    public void setStoreFuncUDFContextSignature(String signature) {
        super.setStoreFuncUDFContextSignature(signature);
        this.signature = signature;
    }

    public void checkSchema(ResourceSchema s) throws IOException {
        this.getProperties().setProperty(SCHEMA, s.toString());
    }

    public OutputFormat<Void, Tuple> getOutputFormat() throws IOException {
        Schema pigSchema = this.getSchema();
        return new ParquetOutputFormat(new TupleWriteSupport(pigSchema));
    }

    public void prepareToWrite(RecordWriter recordWriter) throws IOException {
        this.recordWriter = recordWriter;
    }

    public void putNext(Tuple tuple) throws IOException {
        try {
            this.recordWriter.write(null, (Object)tuple);
        }
        catch (InterruptedException e) {
            Thread.interrupted();
            throw new ParquetEncodingException("Interrupted while writing", e);
        }
    }

    public void setStoreLocation(String location, Job job) throws IOException {
        FileOutputFormat.setOutputPath((Job)job, (Path)new Path(location));
    }

    public void storeSchema(ResourceSchema schema, String location, Job job) throws IOException {
    }

    public void storeStatistics(ResourceStatistics resourceStatistics, String location, Job job) throws IOException {
    }
}

