/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.statistics;

import java.io.IOException;
import java.util.Arrays;
import java.util.Collection;
import java.util.List;
import java.util.Random;
import java.util.function.Supplier;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.GroupFactory;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ColumnIndexValidator;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveComparator;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.parquet.statistics.RandomValues;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestColumnIndexes {
    private static final int MAX_TOTAL_ROWS = 100000;
    private static final MessageType SCHEMA = new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "i32"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "i64"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT96, "i96"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.FLOAT, "sngl"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "dbl"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "strings"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "binary"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 17, "fixed-binary"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "unconstrained-i32"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "unconstrained-i64"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FLOAT, "unconstrained-sngl"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.DOUBLE, "unconstrained-dbl"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true))).named("int8"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)false))).named("uint8"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true))).named("int16"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)false))).named("uint16"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)32, (boolean)true))).named("int32"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)32, (boolean)false))).named("uint32"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)64, (boolean)true))).named("int64"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)64, (boolean)false))).named("uint64"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)2, (int)9))).named("decimal-int32"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)4, (int)18))).named("decimal-int64"), (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(19)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)25, (int)45))).named("decimal-fixed"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)20, (int)38))).named("decimal-binary"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("utf8"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType())).named("enum"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.jsonType())).named("json"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.bsonType())).named("bson"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType())).named("date"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("time-millis"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("time-micros"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("timestamp-millis"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS))).named("timestamp-nanos"), (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(12)).as(OriginalType.INTERVAL)).named("interval"), (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(16)).as((LogicalTypeAnnotation)LogicalTypeAnnotation.uuidType())).named("uuid"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("always-null")});
    private static final Logger LOGGER = LoggerFactory.getLogger(TestColumnIndexes.class);
    @Rule
    public TemporaryFolder tmp = new TemporaryFolder();
    private final WriteContext context;

    private static List<Supplier<?>> buildGenerators(int recordCount, Random random) {
        int fieldIndex = 0;
        return Arrays.asList(TestColumnIndexes.sortedOrRandom(new RandomValues.IntGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.LongGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(RandomValues.int96Generator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.FloatGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.DoubleGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(RandomValues.binaryStringGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.BinaryGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.FixedGenerator(random.nextLong(), 17), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.UnconstrainedIntGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.UnconstrainedLongGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.UnconstrainedFloatGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.UnconstrainedDoubleGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.IntGenerator(random.nextLong(), -128, 127), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.UIntGenerator(random.nextLong(), -128, 127), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.IntGenerator(random.nextLong(), Short.MIN_VALUE, Short.MAX_VALUE), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.UIntGenerator(random.nextLong(), Short.MIN_VALUE, Short.MAX_VALUE), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.UnconstrainedIntGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.UnconstrainedIntGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.UnconstrainedLongGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.UnconstrainedLongGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.UnconstrainedIntGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.UnconstrainedLongGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.FixedGenerator(random.nextLong(), 19), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.BinaryGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(RandomValues.binaryStringGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(RandomValues.binaryStringGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(RandomValues.binaryStringGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.BinaryGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.IntGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.IntGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.LongGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.LongGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.LongGenerator(random.nextLong()), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.FixedGenerator(random.nextLong(), 12), random, recordCount, fieldIndex++), TestColumnIndexes.sortedOrRandom(new RandomValues.FixedGenerator(random.nextLong(), 16), random, recordCount, fieldIndex++), null);
    }

    private static <T> Supplier<T> sortedOrRandom(Supplier<T> generator, Random random, int recordCount, int fieldIndex) {
        PrimitiveComparator cmp = SCHEMA.getType(fieldIndex).asPrimitiveType().comparator();
        switch (random.nextInt(5)) {
            case 1: {
                return RandomValues.wrapSorted(generator, recordCount, true, cmp);
            }
            case 2: {
                return RandomValues.wrapSorted(generator, recordCount, false, cmp);
            }
        }
        return generator;
    }

    @Parameterized.Parameters
    public static Collection<WriteContext> getContexts() {
        return Arrays.asList(new WriteContext(System.nanoTime(), 1000, 8), new WriteContext(System.nanoTime(), 20000, 64), new WriteContext(System.nanoTime(), 50000, 10));
    }

    public TestColumnIndexes(WriteContext context) {
        this.context = context;
    }

    @Test
    public void testColumnIndexes() throws IOException {
        LOGGER.info("Starting test with context: {}", (Object)this.context);
        Path file = null;
        try {
            file = this.context.write(new Path(this.tmp.getRoot().getAbsolutePath()));
            LOGGER.info("Parquet file \"{}\" is successfully created for the context: {}", (Object)file, (Object)this.context);
            List violations = ColumnIndexValidator.checkContractViolations((InputFile)HadoopInputFile.fromPath((Path)file, (Configuration)new Configuration()));
            Assert.assertTrue((String)violations.toString(), (boolean)violations.isEmpty());
        }
        finally {
            if (file != null) {
                file.getFileSystem(new Configuration()).delete(file, false);
            }
        }
    }

    public static class WriteContext {
        private static final GroupFactory FACTORY = new SimpleGroupFactory(TestColumnIndexes.access$000());
        private final long seed;
        private final int pageRowCountLimit;
        private final int columnIndexTruncateLength;

        private WriteContext(long seed, int pageRowCountLimit, int columnIndexTruncateLength) {
            this.seed = seed;
            this.pageRowCountLimit = pageRowCountLimit;
            this.columnIndexTruncateLength = columnIndexTruncateLength;
        }

        public Path write(Path directory) throws IOException {
            Path file = new Path(directory, "testColumnIndexes_" + this + ".parquet");
            Random random = new Random(this.seed);
            int recordCount = random.nextInt(100000) + 1;
            List generators = TestColumnIndexes.buildGenerators(recordCount, random);
            Configuration conf = new Configuration();
            ParquetOutputFormat.setColumnIndexTruncateLength((Configuration)conf, (int)this.columnIndexTruncateLength);
            try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)file).withType(SCHEMA).withPageRowCountLimit(this.pageRowCountLimit)).withConf(conf)).build();){
                for (int i = 0; i < recordCount; ++i) {
                    writer.write((Object)this.createGroup(generators, random));
                }
            }
            return file;
        }

        private Group createGroup(List<Supplier<?>> generators, Random random) {
            Group group = FACTORY.newGroup();
            int columnCnt = SCHEMA.getFieldCount();
            block8: for (int column = 0; column < columnCnt; ++column) {
                Type type = SCHEMA.getType(column);
                Supplier<?> generator = generators.get(column);
                if (generator == null || type.isRepetition(Type.Repetition.OPTIONAL) && random.nextInt(50) == 0) continue;
                switch (type.asPrimitiveType().getPrimitiveTypeName()) {
                    case BINARY: 
                    case FIXED_LEN_BYTE_ARRAY: 
                    case INT96: {
                        group.append(type.getName(), (Binary)generator.get());
                        continue block8;
                    }
                    case INT32: {
                        group.append(type.getName(), ((Integer)generator.get()).intValue());
                        continue block8;
                    }
                    case INT64: {
                        group.append(type.getName(), ((Long)generator.get()).longValue());
                        continue block8;
                    }
                    case FLOAT: {
                        group.append(type.getName(), ((Float)generator.get()).floatValue());
                        continue block8;
                    }
                    case DOUBLE: {
                        group.append(type.getName(), ((Double)generator.get()).doubleValue());
                        continue block8;
                    }
                    case BOOLEAN: {
                        group.append(type.getName(), ((Boolean)generator.get()).booleanValue());
                    }
                }
            }
            return group;
        }

        public String toString() {
            return "seed=" + this.seed + ",pageRowCountLimit=" + this.pageRowCountLimit + ",columnIndexTruncateLength=" + this.columnIndexTruncateLength;
        }
    }
}

