/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.statistics;

import com.google.common.collect.ImmutableSet;
import java.io.File;
import java.io.IOException;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;

public class DataGenerationContext {
    public static void writeAndTest(WriteContext context) throws IOException {
        int pageSize;
        Configuration configuration = new Configuration();
        int blockSize = context.blockSize;
        int dictionaryPageSize = pageSize = context.pageSize;
        boolean enableDictionary = context.enableDictionary;
        boolean enableValidation = context.enableValidation;
        ParquetProperties.WriterVersion writerVersion = context.version;
        CompressionCodecName codec = CompressionCodecName.UNCOMPRESSED;
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)context.fsPath).withType(context.schema).withCompressionCodec(codec)).withRowGroupSize(blockSize)).withPageSize(pageSize)).withDictionaryPageSize(dictionaryPageSize)).withDictionaryEncoding(enableDictionary)).withValidation(enableValidation)).withWriterVersion(writerVersion)).withConf(configuration)).build();){
            context.write((ParquetWriter<Group>)writer);
        }
        context.test();
        context.path.delete();
    }

    public static abstract class WriteContext {
        protected final File path;
        protected final Path fsPath;
        protected final MessageType schema;
        protected final int blockSize;
        protected final int pageSize;
        protected final boolean enableDictionary;
        protected final boolean enableValidation;
        protected final ParquetProperties.WriterVersion version;
        protected final Set<String> disableColumnStatistics;
        protected final boolean disableAllStatistics;

        public WriteContext(File path, MessageType schema, int blockSize, int pageSize, boolean enableDictionary, boolean enableValidation, ParquetProperties.WriterVersion version, Set<String> disableColumnStatistics, boolean disableAllStatistics) throws IOException {
            this.path = path;
            this.fsPath = new Path(path.toString());
            this.schema = schema;
            this.blockSize = blockSize;
            this.pageSize = pageSize;
            this.enableDictionary = enableDictionary;
            this.enableValidation = enableValidation;
            this.version = version;
            this.disableColumnStatistics = disableColumnStatistics;
            this.disableAllStatistics = disableAllStatistics;
        }

        public WriteContext(File path, MessageType schema, int blockSize, int pageSize, boolean enableDictionary, boolean enableValidation, ParquetProperties.WriterVersion version) throws IOException {
            this(path, schema, blockSize, pageSize, enableDictionary, enableValidation, version, (Set<String>)ImmutableSet.of(), false);
        }

        public WriteContext(File path, MessageType schema, int blockSize, int pageSize, boolean enableDictionary, boolean enableValidation, ParquetProperties.WriterVersion version, Set<String> disableColumnStatistics) throws IOException {
            this(path, schema, blockSize, pageSize, enableDictionary, enableValidation, version, disableColumnStatistics, false);
        }

        public abstract void write(ParquetWriter<Group> var1) throws IOException;

        public abstract void test() throws IOException;
    }
}

