/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.HashMap;
import java.util.Map;
import org.apache.parquet.crypto.ColumnEncryptionProperties;
import org.apache.parquet.crypto.DecryptionKeyRetriever;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.hadoop.metadata.ColumnPath;

public class EncDecProperties {
    private static final byte[] FOOTER_KEY = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    private static final byte[] FOOTER_KEY_METADATA = "footkey".getBytes(StandardCharsets.UTF_8);
    private static final byte[] COL_KEY = new byte[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    private static final byte[] COL_KEY_METADATA = "col".getBytes(StandardCharsets.UTF_8);

    public static FileDecryptionProperties getFileDecryptionProperties() throws IOException {
        DecryptionKeyRetrieverMock keyRetriever = new DecryptionKeyRetrieverMock();
        keyRetriever.putKey("footkey", FOOTER_KEY);
        keyRetriever.putKey("col", COL_KEY);
        return FileDecryptionProperties.builder().withPlaintextFilesAllowed().withKeyRetriever((DecryptionKeyRetriever)keyRetriever).build();
    }

    public static FileEncryptionProperties getFileEncryptionProperties(String[] encryptColumns, ParquetCipher cipher, Boolean encryptFooter) {
        if (encryptColumns.length == 0) {
            return null;
        }
        HashMap<ColumnPath, ColumnEncryptionProperties> columnPropertyMap = new HashMap<ColumnPath, ColumnEncryptionProperties>();
        for (String encryptColumn : encryptColumns) {
            ColumnPath columnPath = ColumnPath.fromDotString((String)encryptColumn);
            ColumnEncryptionProperties columnEncryptionProperties = ColumnEncryptionProperties.builder((ColumnPath)columnPath).withKey(COL_KEY).withKeyMetaData(COL_KEY_METADATA).build();
            columnPropertyMap.put(columnPath, columnEncryptionProperties);
        }
        FileEncryptionProperties.Builder encryptionPropertiesBuilder = FileEncryptionProperties.builder((byte[])FOOTER_KEY).withFooterKeyMetadata(FOOTER_KEY_METADATA).withAlgorithm(cipher).withEncryptedColumns(columnPropertyMap);
        if (!encryptFooter.booleanValue()) {
            encryptionPropertiesBuilder.withPlaintextFooter();
        }
        return encryptionPropertiesBuilder.build();
    }

    public static class DecryptionKeyRetrieverMock
    implements DecryptionKeyRetriever {
        private final Map<String, byte[]> keyMap = new HashMap<String, byte[]>();

        public DecryptionKeyRetrieverMock putKey(String keyId, byte[] keyBytes) {
            this.keyMap.put(keyId, keyBytes);
            return this;
        }

        public byte[] getKey(byte[] keyMetaData) {
            String keyId = new String(keyMetaData, StandardCharsets.UTF_8);
            return this.keyMap.get(keyId);
        }
    }
}

