/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.InterOpTester;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.Test;

public class TestInterOpReadFloat16 {
    private static String FLOAT16_NONZEROS_NANS_FILE = "float16_nonzeros_and_nans.parquet";
    private static String FLOAT16_ZEROS_NANS_FILE = "float16_zeros_and_nans.parquet";
    private static final String CHANGESET = "da467da";
    private InterOpTester interop = new InterOpTester();

    @Test
    public void testInterOpReadFloat16NonZerosAndNansParquetFiles() throws IOException {
        Path filePath = this.interop.GetInterOpFile(FLOAT16_NONZEROS_NANS_FILE, CHANGESET);
        int expectRows = 8;
        Binary[] c0ExpectValues = new Binary[]{null, Binary.fromConstantByteArray((byte[])new byte[]{0, 60}), Binary.fromConstantByteArray((byte[])new byte[]{0, -64}), Binary.fromConstantByteArray((byte[])new byte[]{0, 126}), Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, -68}), Binary.fromConstantByteArray((byte[])new byte[]{0, -128}), Binary.fromConstantByteArray((byte[])new byte[]{0, 64})};
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)filePath, (Configuration)new Configuration()));){
            ColumnChunkMetaData column = (ColumnChunkMetaData)((BlockMetaData)reader.getFooter().getBlocks().get(0)).getColumns().get(0);
            Assert.assertArrayEquals((byte[])new byte[]{0, -64}, (byte[])column.getStatistics().getMinBytes());
            Assert.assertArrayEquals((byte[])new byte[]{0, 64}, (byte[])column.getStatistics().getMaxBytes());
        }
        reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)filePath).build();
        var5_5 = null;
        try {
            for (int i = 0; i < 8; ++i) {
                Group group = (Group)reader.read();
                if (group == null) {
                    Assert.fail((String)"Should not reach end of file before 8 rows");
                }
                if (group.getFieldRepetitionCount(0) != 0) {
                    Assert.assertEquals((Object)c0ExpectValues[i], (Object)group.getBinary(0, 0));
                    continue;
                }
                Assert.assertEquals((long)0L, (long)i);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var5_5 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }

    @Test
    public void testInterOpReadFloat16ZerosAndNansParquetFiles() throws IOException {
        Path filePath = this.interop.GetInterOpFile(FLOAT16_ZEROS_NANS_FILE, CHANGESET);
        int expectRows = 3;
        Binary[] c0ExpectValues = new Binary[]{null, Binary.fromConstantByteArray((byte[])new byte[]{0, 0}), Binary.fromConstantByteArray((byte[])new byte[]{0, 126})};
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)filePath, (Configuration)new Configuration()));){
            ColumnChunkMetaData column = (ColumnChunkMetaData)((BlockMetaData)reader.getFooter().getBlocks().get(0)).getColumns().get(0);
            Assert.assertArrayEquals((byte[])new byte[]{0, -128}, (byte[])column.getStatistics().getMinBytes());
            Assert.assertArrayEquals((byte[])new byte[]{0, 0}, (byte[])column.getStatistics().getMaxBytes());
        }
        reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)filePath).build();
        var5_5 = null;
        try {
            for (int i = 0; i < 3; ++i) {
                Group group = (Group)reader.read();
                if (group == null) {
                    Assert.fail((String)"Should not reach end of file before 3 rows");
                }
                if (group.getFieldRepetitionCount(0) != 0) {
                    Assert.assertEquals((Object)c0ExpectValues[i], (Object)group.getBinary(0, 0));
                    continue;
                }
                Assert.assertEquals((long)0L, (long)i);
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
        finally {
            if (reader != null) {
                if (var5_5 != null) {
                    try {
                        reader.close();
                    }
                    catch (Throwable throwable) {
                        var5_5.addSuppressed(throwable);
                    }
                } else {
                    reader.close();
                }
            }
        }
    }
}

