/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.format.converter;

import com.google.common.collect.Lists;
import com.google.common.collect.Sets;
import it.unimi.dsi.fastutil.longs.LongArrayList;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.math.BigInteger;
import java.nio.ByteBuffer;
import java.nio.charset.Charset;
import java.security.SecureRandom;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.HashSet;
import java.util.List;
import java.util.Optional;
import java.util.Random;
import java.util.Set;
import java.util.TreeSet;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.FixedBinaryTestUtils;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.BooleanStatistics;
import org.apache.parquet.column.statistics.DoubleStatistics;
import org.apache.parquet.column.statistics.FloatStatistics;
import org.apache.parquet.column.statistics.IntStatistics;
import org.apache.parquet.column.statistics.LongStatistics;
import org.apache.parquet.crypto.DecryptionPropertiesFactory;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.InternalFileDecryptor;
import org.apache.parquet.example.Paper;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.format.ColumnChunk;
import org.apache.parquet.format.ColumnIndex;
import org.apache.parquet.format.ColumnMetaData;
import org.apache.parquet.format.ColumnOrder;
import org.apache.parquet.format.CompressionCodec;
import org.apache.parquet.format.ConvertedType;
import org.apache.parquet.format.DecimalType;
import org.apache.parquet.format.Encoding;
import org.apache.parquet.format.FieldRepetitionType;
import org.apache.parquet.format.FileMetaData;
import org.apache.parquet.format.LogicalType;
import org.apache.parquet.format.MapType;
import org.apache.parquet.format.OffsetIndex;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.PageType;
import org.apache.parquet.format.RowGroup;
import org.apache.parquet.format.SchemaElement;
import org.apache.parquet.format.SizeStatistics;
import org.apache.parquet.format.Statistics;
import org.apache.parquet.format.StringType;
import org.apache.parquet.format.Type;
import org.apache.parquet.format.Util;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.FileMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.internal.column.columnindex.BoundaryOrder;
import org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.parquet.internal.column.columnindex.OffsetIndexBuilder;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestParquetMetadataConverter {
    private static SecureRandom random = new SecureRandom();
    private static final String CHAR_LOWER = "abcdefghijklmnopqrstuvwxyz";
    private static final String CHAR_UPPER = "abcdefghijklmnopqrstuvwxyz".toUpperCase();
    private static final String NUMBER = "0123456789";
    private static final String DATA_FOR_RANDOM_STRING = "abcdefghijklmnopqrstuvwxyz" + CHAR_UPPER + "0123456789";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();

    @Test
    public void testPageHeader() throws IOException {
        ByteArrayOutputStream out = new ByteArrayOutputStream();
        PageType type = PageType.DATA_PAGE;
        int compSize = 10;
        int uncSize = 20;
        PageHeader pageHeader = new PageHeader(type, uncSize, compSize);
        Util.writePageHeader((PageHeader)pageHeader, (OutputStream)out);
        PageHeader readPageHeader = Util.readPageHeader((InputStream)new ByteArrayInputStream(out.toByteArray()));
        Assert.assertEquals((Object)pageHeader, (Object)readPageHeader);
    }

    @Test
    public void testSchemaConverter() {
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        List parquetSchema = parquetMetadataConverter.toParquetSchema(Paper.schema);
        MessageType schema = parquetMetadataConverter.fromParquetSchema(parquetSchema, null);
        Assert.assertEquals((Object)Paper.schema, (Object)schema);
    }

    @Test
    public void testSchemaConverterDecimal() {
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        List schemaElements = parquetMetadataConverter.toParquetSchema((MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(9)).scale(2)).named("aBinaryDecimal")).optional(PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(4)).as(OriginalType.DECIMAL)).precision(9)).scale(2)).named("aFixedDecimal")).named("Message"));
        ArrayList expected = Lists.newArrayList((Object[])new SchemaElement[]{new SchemaElement("Message").setNum_children(2), new SchemaElement("aBinaryDecimal").setRepetition_type(FieldRepetitionType.REQUIRED).setType(Type.BYTE_ARRAY).setConverted_type(ConvertedType.DECIMAL).setLogicalType(LogicalType.DECIMAL((DecimalType)new DecimalType(2, 9))).setPrecision(9).setScale(2), new SchemaElement("aFixedDecimal").setRepetition_type(FieldRepetitionType.OPTIONAL).setType(Type.FIXED_LEN_BYTE_ARRAY).setType_length(4).setConverted_type(ConvertedType.DECIMAL).setLogicalType(LogicalType.DECIMAL((DecimalType)new DecimalType(2, 9))).setPrecision(9).setScale(2)});
        Assert.assertEquals((Object)expected, (Object)schemaElements);
    }

    @Test
    public void testParquetMetadataConverterWithDictionary() throws IOException {
        ParquetMetadata parquetMetaData = TestParquetMetadataConverter.createParquetMetaData(org.apache.parquet.column.Encoding.PLAIN_DICTIONARY, org.apache.parquet.column.Encoding.PLAIN);
        this.testParquetMetadataConverterWithDictionary(parquetMetaData);
    }

    @Test
    public void testParquetMetadataConverterWithDictionaryAndWithoutEncodingStats() throws IOException {
        ParquetMetadata parquetMetaData = TestParquetMetadataConverter.createParquetMetaData(org.apache.parquet.column.Encoding.PLAIN_DICTIONARY, org.apache.parquet.column.Encoding.PLAIN, false);
        this.testParquetMetadataConverterWithDictionary(parquetMetaData);
    }

    private void testParquetMetadataConverterWithDictionary(ParquetMetadata parquetMetaData) throws IOException {
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        FileMetaData fmd1 = converter.toParquetMetadata(1, parquetMetaData);
        fmd1.row_groups.forEach(rowGroup -> rowGroup.columns.forEach(column -> Assert.assertTrue((boolean)column.meta_data.isSetDictionary_page_offset())));
        ByteArrayOutputStream metaDataOutputStream = new ByteArrayOutputStream();
        Util.writeFileMetaData((FileMetaData)fmd1, (OutputStream)metaDataOutputStream);
        ByteArrayInputStream metaDataInputStream = new ByteArrayInputStream(metaDataOutputStream.toByteArray());
        FileMetaData fmd2 = Util.readFileMetaData((InputStream)metaDataInputStream);
        ParquetMetadata parquetMetaDataConverted = converter.fromParquetMetadata(fmd2);
        long dicOffsetOriginal = ((ColumnChunkMetaData)((BlockMetaData)parquetMetaData.getBlocks().get(0)).getColumns().get(0)).getDictionaryPageOffset();
        long dicOffsetConverted = ((ColumnChunkMetaData)((BlockMetaData)parquetMetaDataConverted.getBlocks().get(0)).getColumns().get(0)).getDictionaryPageOffset();
        Assert.assertEquals((long)dicOffsetOriginal, (long)dicOffsetConverted);
    }

    @Test
    public void testParquetMetadataConverterWithoutDictionary() throws IOException {
        ParquetMetadata parquetMetaData = TestParquetMetadataConverter.createParquetMetaData(null, org.apache.parquet.column.Encoding.PLAIN);
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        FileMetaData fmd1 = converter.toParquetMetadata(1, parquetMetaData);
        fmd1.row_groups.forEach(rowGroup -> rowGroup.columns.forEach(column -> Assert.assertFalse((boolean)column.meta_data.isSetDictionary_page_offset())));
        ByteArrayOutputStream metaDataOutputStream = new ByteArrayOutputStream();
        Util.writeFileMetaData((FileMetaData)fmd1, (OutputStream)metaDataOutputStream);
        ByteArrayInputStream metaDataInputStream = new ByteArrayInputStream(metaDataOutputStream.toByteArray());
        FileMetaData fmd2 = Util.readFileMetaData((InputStream)metaDataInputStream);
        ParquetMetadata pmd2 = converter.fromParquetMetadata(fmd2);
        long dicOffsetConverted = ((ColumnChunkMetaData)((BlockMetaData)pmd2.getBlocks().get(0)).getColumns().get(0)).getDictionaryPageOffset();
        Assert.assertEquals((long)0L, (long)dicOffsetConverted);
    }

    @Test
    public void testBloomFilterOffset() throws IOException {
        ParquetMetadata origMetaData = TestParquetMetadataConverter.createParquetMetaData(null, org.apache.parquet.column.Encoding.PLAIN);
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        FileMetaData footer = converter.toParquetMetadata(1, origMetaData);
        Assert.assertFalse((boolean)((ColumnChunk)((RowGroup)footer.getRow_groups().get(0)).getColumns().get(0)).getMeta_data().isSetBloom_filter_offset());
        ParquetMetadata convertedMetaData = converter.fromParquetMetadata(footer);
        Assert.assertTrue((((ColumnChunkMetaData)((BlockMetaData)convertedMetaData.getBlocks().get(0)).getColumns().get(0)).getBloomFilterOffset() < 0L ? 1 : 0) != 0);
        ((ColumnChunkMetaData)((BlockMetaData)origMetaData.getBlocks().get(0)).getColumns().get(0)).setBloomFilterOffset(1234L);
        footer = converter.toParquetMetadata(1, origMetaData);
        Assert.assertTrue((boolean)((ColumnChunk)((RowGroup)footer.getRow_groups().get(0)).getColumns().get(0)).getMeta_data().isSetBloom_filter_offset());
        Assert.assertEquals((long)1234L, (long)((ColumnChunk)((RowGroup)footer.getRow_groups().get(0)).getColumns().get(0)).getMeta_data().getBloom_filter_offset());
        convertedMetaData = converter.fromParquetMetadata(footer);
        Assert.assertEquals((long)1234L, (long)((ColumnChunkMetaData)((BlockMetaData)convertedMetaData.getBlocks().get(0)).getColumns().get(0)).getBloomFilterOffset());
    }

    @Test
    public void testBloomFilterLength() throws IOException {
        ParquetMetadata origMetaData = TestParquetMetadataConverter.createParquetMetaData(null, org.apache.parquet.column.Encoding.PLAIN);
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        FileMetaData footer = converter.toParquetMetadata(1, origMetaData);
        Assert.assertFalse((boolean)((ColumnChunk)((RowGroup)footer.getRow_groups().get(0)).getColumns().get(0)).getMeta_data().isSetBloom_filter_length());
        ParquetMetadata convertedMetaData = converter.fromParquetMetadata(footer);
        Assert.assertTrue((((ColumnChunkMetaData)((BlockMetaData)convertedMetaData.getBlocks().get(0)).getColumns().get(0)).getBloomFilterLength() < 0 ? 1 : 0) != 0);
        ((ColumnChunkMetaData)((BlockMetaData)origMetaData.getBlocks().get(0)).getColumns().get(0)).setBloomFilterLength(1024);
        footer = converter.toParquetMetadata(1, origMetaData);
        Assert.assertTrue((boolean)((ColumnChunk)((RowGroup)footer.getRow_groups().get(0)).getColumns().get(0)).getMeta_data().isSetBloom_filter_length());
        Assert.assertEquals((long)1024L, (long)((ColumnChunk)((RowGroup)footer.getRow_groups().get(0)).getColumns().get(0)).getMeta_data().getBloom_filter_length());
        convertedMetaData = converter.fromParquetMetadata(footer);
        Assert.assertEquals((long)1024L, (long)((ColumnChunkMetaData)((BlockMetaData)convertedMetaData.getBlocks().get(0)).getColumns().get(0)).getBloomFilterLength());
    }

    @Test
    public void testLogicalTypesBackwardCompatibleWithConvertedTypes() {
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(9)).scale(2)).named("aBinaryDecimal")).named("Message");
        List parquetSchema = parquetMetadataConverter.toParquetSchema(expected);
        ((SchemaElement)parquetSchema.get(1)).setLogicalType(null);
        MessageType schema = parquetMetadataConverter.fromParquetSchema(parquetSchema, null);
        Assert.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    public void testIncompatibleLogicalAndConvertedTypes() {
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(9)).scale(2)).named("aBinary")).named("Message");
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.jsonType())).named("aBinary")).named("Message");
        List parquetSchema = parquetMetadataConverter.toParquetSchema(schema);
        ((SchemaElement)parquetSchema.get(1)).setConverted_type(ConvertedType.JSON);
        MessageType actual = parquetMetadataConverter.fromParquetSchema(parquetSchema, null);
        Assert.assertEquals((Object)expected, (Object)actual);
    }

    @Test
    public void testTimeLogicalTypes() {
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("aTimestampNonUtcMillis")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("aTimestampUtcMillis")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("aTimestampNonUtcMicros")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("aTimestampUtcMicros")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS))).named("aTimestampNonUtcNanos")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS))).named("aTimestampUtcNanos")).required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("aTimeNonUtcMillis")).required(PrimitiveType.PrimitiveTypeName.INT32).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS))).named("aTimeUtcMillis")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("aTimeNonUtcMicros")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS))).named("aTimeUtcMicros")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS))).named("aTimeNonUtcNanos")).required(PrimitiveType.PrimitiveTypeName.INT64).as((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS))).named("aTimeUtcNanos")).named("Message");
        List parquetSchema = parquetMetadataConverter.toParquetSchema(expected);
        MessageType schema = parquetMetadataConverter.fromParquetSchema(parquetSchema, null);
        Assert.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    public void testLogicalToConvertedTypeConversion() {
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        Assert.assertEquals((Object)ConvertedType.UTF8, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType()));
        Assert.assertEquals((Object)ConvertedType.ENUM, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.enumType()));
        Assert.assertEquals((Object)ConvertedType.INT_8, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)true)));
        Assert.assertEquals((Object)ConvertedType.INT_16, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)true)));
        Assert.assertEquals((Object)ConvertedType.INT_32, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)32, (boolean)true)));
        Assert.assertEquals((Object)ConvertedType.INT_64, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)64, (boolean)true)));
        Assert.assertEquals((Object)ConvertedType.UINT_8, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)8, (boolean)false)));
        Assert.assertEquals((Object)ConvertedType.UINT_16, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)16, (boolean)false)));
        Assert.assertEquals((Object)ConvertedType.UINT_32, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)32, (boolean)false)));
        Assert.assertEquals((Object)ConvertedType.UINT_64, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.intType((int)64, (boolean)false)));
        Assert.assertEquals((Object)ConvertedType.DECIMAL, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.decimalType((int)8, (int)16)));
        Assert.assertEquals((Object)ConvertedType.TIMESTAMP_MILLIS, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS)));
        Assert.assertEquals((Object)ConvertedType.TIMESTAMP_MICROS, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)));
        Assert.assertNull((Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS)));
        Assert.assertEquals((Object)ConvertedType.TIMESTAMP_MILLIS, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS)));
        Assert.assertEquals((Object)ConvertedType.TIMESTAMP_MICROS, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)));
        Assert.assertNull((Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.timestampType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS)));
        Assert.assertEquals((Object)ConvertedType.TIME_MILLIS, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS)));
        Assert.assertEquals((Object)ConvertedType.TIME_MICROS, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)));
        Assert.assertNull((Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)true, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS)));
        Assert.assertEquals((Object)ConvertedType.TIME_MILLIS, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MILLIS)));
        Assert.assertEquals((Object)ConvertedType.TIME_MICROS, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.MICROS)));
        Assert.assertNull((Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.timeType((boolean)false, (LogicalTypeAnnotation.TimeUnit)LogicalTypeAnnotation.TimeUnit.NANOS)));
        Assert.assertEquals((Object)ConvertedType.DATE, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.dateType()));
        Assert.assertEquals((Object)ConvertedType.INTERVAL, (Object)parquetMetadataConverter.convertToConvertedType(LogicalTypeAnnotation.IntervalLogicalTypeAnnotation.getInstance()));
        Assert.assertEquals((Object)ConvertedType.JSON, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.jsonType()));
        Assert.assertEquals((Object)ConvertedType.BSON, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.bsonType()));
        Assert.assertNull((Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.uuidType()));
        Assert.assertEquals((Object)ConvertedType.LIST, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.listType()));
        Assert.assertEquals((Object)ConvertedType.MAP, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType()));
        Assert.assertEquals((Object)ConvertedType.MAP_KEY_VALUE, (Object)parquetMetadataConverter.convertToConvertedType((LogicalTypeAnnotation)LogicalTypeAnnotation.MapKeyValueTypeAnnotation.getInstance()));
    }

    @Test
    public void testEnumEquivalence() {
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        for (org.apache.parquet.column.Encoding encoding : org.apache.parquet.column.Encoding.values()) {
            Assert.assertEquals((Object)encoding, (Object)parquetMetadataConverter.getEncoding(parquetMetadataConverter.getEncoding(encoding)));
        }
        for (org.apache.parquet.column.Encoding encoding : Encoding.values()) {
            Assert.assertEquals((Object)encoding, (Object)parquetMetadataConverter.getEncoding(parquetMetadataConverter.getEncoding((Encoding)encoding)));
        }
        for (org.apache.parquet.column.Encoding encoding : Type.Repetition.values()) {
            Assert.assertEquals((Object)encoding, (Object)parquetMetadataConverter.fromParquetRepetition(parquetMetadataConverter.toParquetRepetition((Type.Repetition)encoding)));
        }
        for (org.apache.parquet.column.Encoding encoding : FieldRepetitionType.values()) {
            Assert.assertEquals((Object)encoding, (Object)parquetMetadataConverter.toParquetRepetition(parquetMetadataConverter.fromParquetRepetition((FieldRepetitionType)encoding)));
        }
        for (org.apache.parquet.column.Encoding encoding : PrimitiveType.PrimitiveTypeName.values()) {
            Assert.assertEquals((Object)encoding, (Object)parquetMetadataConverter.getPrimitive(parquetMetadataConverter.getType((PrimitiveType.PrimitiveTypeName)encoding)));
        }
        for (org.apache.parquet.column.Encoding encoding : Type.values()) {
            Assert.assertEquals((Object)encoding, (Object)parquetMetadataConverter.getType(parquetMetadataConverter.getPrimitive((Type)encoding)));
        }
        for (org.apache.parquet.column.Encoding encoding : OriginalType.values()) {
            Assert.assertEquals((Object)encoding, (Object)parquetMetadataConverter.getLogicalTypeAnnotation(parquetMetadataConverter.convertToConvertedType(LogicalTypeAnnotation.fromOriginalType((OriginalType)encoding, null)), null).toOriginalType());
        }
        for (org.apache.parquet.column.Encoding encoding : ConvertedType.values()) {
            Assert.assertEquals((Object)encoding, (Object)parquetMetadataConverter.convertToConvertedType(parquetMetadataConverter.getLogicalTypeAnnotation((ConvertedType)encoding, null)));
        }
    }

    private FileMetaData metadata(long ... sizes) {
        List schema = Collections.emptyList();
        ArrayList<RowGroup> rowGroups = new ArrayList<RowGroup>();
        long offset = 0L;
        for (long size : sizes) {
            ColumnChunk columnChunk = new ColumnChunk(offset);
            columnChunk.setMeta_data(new ColumnMetaData(Type.INT32, Collections.emptyList(), Collections.emptyList(), CompressionCodec.UNCOMPRESSED, 10L, size * 2L, size, offset));
            rowGroups.add(new RowGroup(Arrays.asList(columnChunk), size, 1L));
            offset += size;
        }
        return new FileMetaData(1, schema, (long)sizes.length, rowGroups);
    }

    private FileMetaData filter(FileMetaData md, long start, long end) {
        return ParquetMetadataConverter.filterFileMetaDataByMidpoint((FileMetaData)new FileMetaData(md), (ParquetMetadataConverter.RangeMetadataFilter)new ParquetMetadataConverter.RangeMetadataFilter(start, end));
    }

    private FileMetaData find(FileMetaData md, Long ... blockStart) {
        return ParquetMetadataConverter.filterFileMetaDataByStart((FileMetaData)new FileMetaData(md), (ParquetMetadataConverter.OffsetMetadataFilter)new ParquetMetadataConverter.OffsetMetadataFilter((Set)Sets.newHashSet((Object[])blockStart)));
    }

    private FileMetaData find(FileMetaData md, long blockStart) {
        return ParquetMetadataConverter.filterFileMetaDataByStart((FileMetaData)new FileMetaData(md), (ParquetMetadataConverter.OffsetMetadataFilter)new ParquetMetadataConverter.OffsetMetadataFilter((Set)Sets.newHashSet((Object[])new Long[]{blockStart})));
    }

    private void verifyMD(FileMetaData md, long ... offsets) {
        Assert.assertEquals((long)offsets.length, (long)md.row_groups.size());
        for (int i = 0; i < offsets.length; ++i) {
            long offset = offsets[i];
            RowGroup rowGroup = (RowGroup)md.getRow_groups().get(i);
            Assert.assertEquals((long)offset, (long)ParquetMetadataConverter.getOffset((RowGroup)rowGroup));
        }
    }

    private void verifyAllFilters(FileMetaData md, long splitWidth) {
        TreeSet<Long> offsetsFound = new TreeSet<Long>();
        for (long start = 0L; start < this.fileSize(md); start += splitWidth) {
            FileMetaData filtered = this.filter(md, start, start + splitWidth);
            for (RowGroup rg : filtered.getRow_groups()) {
                long o = ParquetMetadataConverter.getOffset((RowGroup)rg);
                if (offsetsFound.contains(o)) {
                    Assert.fail((String)("found the offset twice: " + o));
                    continue;
                }
                offsetsFound.add(o);
            }
        }
        if (offsetsFound.size() != md.row_groups.size()) {
            Assert.fail((String)("missing row groups, found: " + offsetsFound + "\nexpected " + md.getRow_groups()));
        }
    }

    private long fileSize(FileMetaData md) {
        long size = 0L;
        for (RowGroup rg : md.getRow_groups()) {
            size += rg.total_byte_size;
        }
        return size;
    }

    @Test
    public void testFilterMetaData() {
        this.verifyMD(this.filter(this.metadata(50L, 50L, 50L), 0L, 50L), 0L);
        this.verifyMD(this.filter(this.metadata(50L, 50L, 50L), 50L, 100L), 50L);
        this.verifyMD(this.filter(this.metadata(50L, 50L, 50L), 100L, 150L), 100L);
        this.verifyMD(this.filter(this.metadata(50L, 50L, 50L), 25L, 75L), 0L);
        this.verifyMD(this.filter(this.metadata(50L, 50L, 50L), 26L, 75L), new long[0]);
        this.verifyMD(this.filter(this.metadata(50L, 50L, 50L), 26L, 76L), 50L);
        this.verifyAllFilters(this.metadata(50L, 50L, 50L), 10L);
        this.verifyAllFilters(this.metadata(50L, 50L, 50L), 51L);
        this.verifyAllFilters(this.metadata(50L, 50L, 50L), 25L);
        this.verifyAllFilters(this.metadata(50L, 50L, 50L), 24L);
        this.verifyAllFilters(this.metadata(50L, 50L, 50L), 26L);
        this.verifyAllFilters(this.metadata(50L, 50L, 50L), 110L);
        this.verifyAllFilters(this.metadata(10L, 50L, 500L), 110L);
        this.verifyAllFilters(this.metadata(10L, 50L, 500L), 10L);
        this.verifyAllFilters(this.metadata(10L, 50L, 500L), 600L);
        this.verifyAllFilters(this.metadata(11L, 9L, 10L), 10L);
        this.verifyAllFilters(this.metadata(11L, 9L, 10L), 9L);
        this.verifyAllFilters(this.metadata(11L, 9L, 10L), 8L);
    }

    @Test
    public void testFindRowGroups() {
        this.verifyMD(this.find(this.metadata(50L, 50L, 50L), 0L), 0L);
        this.verifyMD(this.find(this.metadata(50L, 50L, 50L), 50L), 50L);
        this.verifyMD(this.find(this.metadata(50L, 50L, 50L), 100L), 100L);
        this.verifyMD(this.find(this.metadata(50L, 50L, 50L), 0L, 50L), 0L, 50L);
        this.verifyMD(this.find(this.metadata(50L, 50L, 50L), 0L, 50L, 100L), 0L, 50L, 100L);
        this.verifyMD(this.find(this.metadata(50L, 50L, 50L), 50L, 100L), 50L, 100L);
        this.verifyMD(this.find(this.metadata(50L, 50L, 50L), 10L), new long[0]);
    }

    @Test
    public void randomTestFilterMetaData() {
        Random random = new Random(42L);
        for (int j = 0; j < 100; ++j) {
            long[] rgs = new long[random.nextInt(50)];
            for (int i = 0; i < rgs.length; ++i) {
                rgs[i] = random.nextInt(10000) + 1;
            }
            int splitSize = random.nextInt(10000) + 1;
            try {
                this.verifyAllFilters(this.metadata(rgs), splitSize);
                continue;
            }
            catch (AssertionError e) {
                throw (AssertionError)((Object)((Throwable)((Object)new AssertionError((Object)("fail verifyAllFilters(metadata(" + Arrays.toString(rgs) + "), " + splitSize + ")")))).initCause((Throwable)((Object)e)));
            }
        }
    }

    @Test
    public void testFieldMetadataDebugLogging() {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { optional binary some_null_field; }");
        org.apache.parquet.hadoop.metadata.FileMetaData fileMetaData = new org.apache.parquet.hadoop.metadata.FileMetaData(schema, new HashMap(), null, FileMetaData.EncryptionType.UNENCRYPTED, null);
        ArrayList<BlockMetaData> blockMetaDataList = new ArrayList<BlockMetaData>();
        BlockMetaData blockMetaData = new BlockMetaData();
        blockMetaData.addColumn(this.createColumnChunkMetaData());
        blockMetaDataList.add(blockMetaData);
        ParquetMetadata metadata = new ParquetMetadata(fileMetaData, blockMetaDataList);
        ParquetMetadata.toJSON((ParquetMetadata)metadata);
    }

    @Test
    public void testEncryptedFieldMetadataDebugLogging() {
        Configuration conf = new Configuration();
        conf.set("parquet.crypto.factory.class", "org.apache.parquet.crypto.SampleDecryptionPropertiesFactory");
        DecryptionPropertiesFactory decryptionPropertiesFactory = DecryptionPropertiesFactory.loadFactory((Configuration)conf);
        FileDecryptionProperties decryptionProperties = decryptionPropertiesFactory.getFileDecryptionProperties(conf, null);
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { optional binary some_null_field; }");
        org.apache.parquet.hadoop.metadata.FileMetaData fileMetaData = new org.apache.parquet.hadoop.metadata.FileMetaData(schema, new HashMap(), null, FileMetaData.EncryptionType.ENCRYPTED_FOOTER, new InternalFileDecryptor(decryptionProperties));
        ArrayList blockMetaDataList = new ArrayList();
        ParquetMetadata metadata = new ParquetMetadata(fileMetaData, blockMetaDataList);
        ParquetMetadata.toJSON((ParquetMetadata)metadata);
        System.out.println(ParquetMetadata.toPrettyJSON((ParquetMetadata)metadata));
    }

    @Test
    public void testMetadataToJson() {
        ParquetMetadata metadata = new ParquetMetadata(null, null);
        Assert.assertEquals((Object)"{\"fileMetaData\":null,\"blocks\":null}", (Object)ParquetMetadata.toJSON((ParquetMetadata)metadata));
        Assert.assertEquals((Object)"{\n  \"fileMetaData\" : null,\n  \"blocks\" : null\n}".replace("\n", System.lineSeparator()), (Object)ParquetMetadata.toPrettyJSON((ParquetMetadata)metadata));
    }

    private ColumnChunkMetaData createColumnChunkMetaData() {
        HashSet e = new HashSet();
        PrimitiveType.PrimitiveTypeName t = PrimitiveType.PrimitiveTypeName.BINARY;
        ColumnPath p = ColumnPath.get((String[])new String[]{"foo"});
        CompressionCodecName c = CompressionCodecName.GZIP;
        BinaryStatistics s = new BinaryStatistics();
        ColumnChunkMetaData md = ColumnChunkMetaData.get((ColumnPath)p, (PrimitiveType.PrimitiveTypeName)t, (CompressionCodecName)c, e, (org.apache.parquet.column.statistics.Statistics)s, (long)0L, (long)0L, (long)0L, (long)0L, (long)0L);
        return md;
    }

    @Test
    public void testEncodingsCache() {
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        List<Encoding> formatEncodingsCopy1 = Arrays.asList(Encoding.BIT_PACKED, Encoding.RLE_DICTIONARY, Encoding.DELTA_LENGTH_BYTE_ARRAY);
        List<Encoding> formatEncodingsCopy2 = Arrays.asList(Encoding.BIT_PACKED, Encoding.RLE_DICTIONARY, Encoding.DELTA_LENGTH_BYTE_ARRAY);
        HashSet<org.apache.parquet.column.Encoding> expected = new HashSet<org.apache.parquet.column.Encoding>();
        expected.add(org.apache.parquet.column.Encoding.BIT_PACKED);
        expected.add(org.apache.parquet.column.Encoding.RLE_DICTIONARY);
        expected.add(org.apache.parquet.column.Encoding.DELTA_LENGTH_BYTE_ARRAY);
        Set res1 = parquetMetadataConverter.fromFormatEncodings(formatEncodingsCopy1);
        Set res2 = parquetMetadataConverter.fromFormatEncodings(formatEncodingsCopy1);
        Set res3 = parquetMetadataConverter.fromFormatEncodings(formatEncodingsCopy2);
        Assert.assertEquals(expected, (Object)res1);
        Assert.assertEquals(expected, (Object)res2);
        Assert.assertEquals(expected, (Object)res3);
        Assert.assertSame((Object)res1, (Object)res2);
        Assert.assertSame((Object)res1, (Object)res3);
        Assert.assertEquals((Object)"java.util.Collections$UnmodifiableSet", (Object)res1.getClass().getName());
        Assert.assertEquals((Object)"java.util.Collections$UnmodifiableSet", (Object)res2.getClass().getName());
        Assert.assertEquals((Object)"java.util.Collections$UnmodifiableSet", (Object)res3.getClass().getName());
    }

    @Test
    public void testBinaryStatsV1() {
        this.testBinaryStats(StatsHelper.V1);
    }

    @Test
    public void testBinaryStatsV2() {
        this.testBinaryStats(StatsHelper.V2);
    }

    private void testBinaryStats(StatsHelper helper) {
        BinaryStatistics stats = new BinaryStatistics();
        stats.incrementNumNulls(3004L);
        byte[] min = new byte[904];
        byte[] max = new byte[2388];
        stats.updateStats(Binary.fromConstantByteArray((byte[])min));
        stats.updateStats(Binary.fromConstantByteArray((byte[])max));
        long totalLen = min.length + max.length;
        Assert.assertFalse((String)"Should not be smaller than min + max size", (boolean)stats.isSmallerThan(totalLen));
        Assert.assertTrue((String)"Should be smaller than min + max size + 1", (boolean)stats.isSmallerThan(totalLen + 1L));
        Statistics formatStats = helper.toParquetStatistics((org.apache.parquet.column.statistics.Statistics<?>)stats);
        Assert.assertFalse((String)"Min should not be set", (boolean)formatStats.isSetMin());
        Assert.assertFalse((String)"Max should not be set", (boolean)formatStats.isSetMax());
        if (helper == StatsHelper.V2) {
            Assert.assertArrayEquals((String)"Min_value should match", (byte[])min, (byte[])formatStats.getMin_value());
            Assert.assertArrayEquals((String)"Max_value should match", (byte[])max, (byte[])formatStats.getMax_value());
        }
        Assert.assertEquals((String)"Num nulls should match", (long)3004L, (long)formatStats.getNull_count());
        stats.setMinMaxFromBytes(max, max);
        formatStats = helper.toParquetStatistics((org.apache.parquet.column.statistics.Statistics<?>)stats);
        Assert.assertFalse((String)"Min should not be set", (boolean)formatStats.isSetMin());
        Assert.assertFalse((String)"Max should not be set", (boolean)formatStats.isSetMax());
        Assert.assertFalse((String)"Min_value should not be set", (boolean)formatStats.isSetMin_value());
        Assert.assertFalse((String)"Max_value should not be set", (boolean)formatStats.isSetMax_value());
        Assert.assertFalse((String)"Num nulls should not be set", (boolean)formatStats.isSetNull_count());
        org.apache.parquet.column.statistics.Statistics roundTripStats = ParquetMetadataConverter.fromParquetStatisticsInternal((String)"parquet-mr version 1.15.1 (build c7257b8faff5699e13bbc781679dc03f48c1102a)", (Statistics)formatStats, (PrimitiveType)new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, ""), (ParquetMetadataConverter.SortOrder)ParquetMetadataConverter.SortOrder.SIGNED);
        Assert.assertTrue((boolean)roundTripStats.isEmpty());
    }

    @Test
    public void testBinaryStatsWithTruncation() {
        int[] invalidLengths;
        int[] validLengths;
        int defaultTruncLen = Integer.MAX_VALUE;
        for (int len : validLengths = new int[]{1, 2, 16, 64, defaultTruncLen - 1}) {
            this.testBinaryStatsWithTruncation(len, 60, 70);
            this.testBinaryStatsWithTruncation(len, 4096, 190);
            this.testBinaryStatsWithTruncation(len, 280, 4096);
            this.testBinaryStatsWithTruncation(len, 4096, 4096);
        }
        for (int len : invalidLengths = new int[]{-1, 0, Integer.MIN_VALUE}) {
            try {
                this.testBinaryStatsWithTruncation(len, 80, 20);
                Assert.fail((String)"Expected IllegalArgumentException but didn't happen");
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
        }
    }

    private void testBinaryStatsWithTruncation(int truncateLen, int minLen, int maxLen) {
        BinaryStatistics stats = new BinaryStatistics();
        byte[] min = TestParquetMetadataConverter.generateRandomString("a", minLen).getBytes();
        byte[] max = TestParquetMetadataConverter.generateRandomString("b", maxLen).getBytes();
        stats.updateStats(Binary.fromConstantByteArray((byte[])min));
        stats.updateStats(Binary.fromConstantByteArray((byte[])max));
        ParquetMetadataConverter metadataConverter = new ParquetMetadataConverter(truncateLen);
        Statistics formatStats = ParquetMetadataConverter.toParquetStatistics((org.apache.parquet.column.statistics.Statistics)stats);
        if ((long)(minLen + maxLen) >= 4096L) {
            Assert.assertNull((Object)formatStats.getMin_value());
            Assert.assertNull((Object)formatStats.getMax_value());
        } else {
            String minString = new String(min, Charset.forName("UTF-8"));
            String minStatString = new String(formatStats.getMin_value(), Charset.forName("UTF-8"));
            Assert.assertTrue((minStatString.compareTo(minString) <= 0 ? 1 : 0) != 0);
            String maxString = new String(max, Charset.forName("UTF-8"));
            String maxStatString = new String(formatStats.getMax_value(), Charset.forName("UTF-8"));
            Assert.assertTrue((maxStatString.compareTo(maxString) >= 0 ? 1 : 0) != 0);
        }
    }

    private static String generateRandomString(String prefix, int length) {
        Assert.assertTrue((prefix.length() <= length ? 1 : 0) != 0);
        StringBuilder sb = new StringBuilder(length);
        sb.append(prefix);
        for (int i = 0; i < length - prefix.length(); ++i) {
            int rndCharAt = random.nextInt(DATA_FOR_RANDOM_STRING.length());
            char rndChar = DATA_FOR_RANDOM_STRING.charAt(rndCharAt);
            sb.append(rndChar);
        }
        return sb.toString();
    }

    @Test
    public void testIntegerStatsV1() {
        this.testIntegerStats(StatsHelper.V1);
    }

    @Test
    public void testIntegerStatsV2() {
        this.testIntegerStats(StatsHelper.V2);
    }

    private void testIntegerStats(StatsHelper helper) {
        IntStatistics stats = new IntStatistics();
        stats.incrementNumNulls(3004L);
        int min = Integer.MIN_VALUE;
        int max = Integer.MAX_VALUE;
        stats.updateStats(min);
        stats.updateStats(max);
        Statistics formatStats = helper.toParquetStatistics((org.apache.parquet.column.statistics.Statistics<?>)stats);
        Assert.assertEquals((String)"Min should match", (long)min, (long)BytesUtils.bytesToInt((byte[])formatStats.getMin()));
        Assert.assertEquals((String)"Max should match", (long)max, (long)BytesUtils.bytesToInt((byte[])formatStats.getMax()));
        Assert.assertEquals((String)"Num nulls should match", (long)3004L, (long)formatStats.getNull_count());
    }

    @Test
    public void testLongStatsV1() {
        this.testLongStats(StatsHelper.V1);
    }

    @Test
    public void testLongStatsV2() {
        this.testLongStats(StatsHelper.V2);
    }

    private void testLongStats(StatsHelper helper) {
        LongStatistics stats = new LongStatistics();
        stats.incrementNumNulls(3004L);
        long min = Long.MIN_VALUE;
        long max = Long.MAX_VALUE;
        stats.updateStats(min);
        stats.updateStats(max);
        Statistics formatStats = helper.toParquetStatistics((org.apache.parquet.column.statistics.Statistics<?>)stats);
        Assert.assertEquals((String)"Min should match", (long)min, (long)BytesUtils.bytesToLong((byte[])formatStats.getMin()));
        Assert.assertEquals((String)"Max should match", (long)max, (long)BytesUtils.bytesToLong((byte[])formatStats.getMax()));
        Assert.assertEquals((String)"Num nulls should match", (long)3004L, (long)formatStats.getNull_count());
    }

    @Test
    public void testFloatStatsV1() {
        this.testFloatStats(StatsHelper.V1);
    }

    @Test
    public void testFloatStatsV2() {
        this.testFloatStats(StatsHelper.V2);
    }

    private void testFloatStats(StatsHelper helper) {
        FloatStatistics stats = new FloatStatistics();
        stats.incrementNumNulls(3004L);
        float min = Float.MIN_VALUE;
        float max = Float.MAX_VALUE;
        stats.updateStats(min);
        stats.updateStats(max);
        Statistics formatStats = helper.toParquetStatistics((org.apache.parquet.column.statistics.Statistics<?>)stats);
        Assert.assertEquals((String)"Min should match", (double)min, (double)Float.intBitsToFloat(BytesUtils.bytesToInt((byte[])formatStats.getMin())), (double)1.0E-6);
        Assert.assertEquals((String)"Max should match", (double)max, (double)Float.intBitsToFloat(BytesUtils.bytesToInt((byte[])formatStats.getMax())), (double)1.0E-6);
        Assert.assertEquals((String)"Num nulls should match", (long)3004L, (long)formatStats.getNull_count());
    }

    @Test
    public void testDoubleStatsV1() {
        this.testDoubleStats(StatsHelper.V1);
    }

    @Test
    public void testDoubleStatsV2() {
        this.testDoubleStats(StatsHelper.V2);
    }

    private void testDoubleStats(StatsHelper helper) {
        DoubleStatistics stats = new DoubleStatistics();
        stats.incrementNumNulls(3004L);
        double min = Double.MIN_VALUE;
        double max = Double.MAX_VALUE;
        stats.updateStats(min);
        stats.updateStats(max);
        Statistics formatStats = helper.toParquetStatistics((org.apache.parquet.column.statistics.Statistics<?>)stats);
        Assert.assertEquals((String)"Min should match", (double)min, (double)Double.longBitsToDouble(BytesUtils.bytesToLong((byte[])formatStats.getMin())), (double)1.0E-6);
        Assert.assertEquals((String)"Max should match", (double)max, (double)Double.longBitsToDouble(BytesUtils.bytesToLong((byte[])formatStats.getMax())), (double)1.0E-6);
        Assert.assertEquals((String)"Num nulls should match", (long)3004L, (long)formatStats.getNull_count());
    }

    @Test
    public void testBooleanStatsV1() {
        this.testBooleanStats(StatsHelper.V1);
    }

    @Test
    public void testBooleanStatsV2() {
        this.testBooleanStats(StatsHelper.V2);
    }

    private void testBooleanStats(StatsHelper helper) {
        BooleanStatistics stats = new BooleanStatistics();
        stats.incrementNumNulls(3004L);
        boolean min = Boolean.FALSE;
        boolean max = Boolean.TRUE;
        stats.updateStats(min);
        stats.updateStats(max);
        Statistics formatStats = helper.toParquetStatistics((org.apache.parquet.column.statistics.Statistics<?>)stats);
        Assert.assertEquals((String)"Min should match", (Object)min, (Object)BytesUtils.bytesToBool((byte[])formatStats.getMin()));
        Assert.assertEquals((String)"Max should match", (Object)max, (Object)BytesUtils.bytesToBool((byte[])formatStats.getMax()));
        Assert.assertEquals((String)"Num nulls should match", (long)3004L, (long)formatStats.getNull_count());
    }

    @Test
    public void testIgnoreStatsWithSignedSortOrder() {
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        BinaryStatistics stats = new BinaryStatistics();
        stats.incrementNumNulls();
        stats.updateStats(Binary.fromString((String)"A"));
        stats.incrementNumNulls();
        stats.updateStats(Binary.fromString((String)"z"));
        stats.incrementNumNulls();
        PrimitiveType binaryType = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("b");
        org.apache.parquet.column.statistics.Statistics convertedStats = converter.fromParquetStatistics("parquet-mr version 1.15.1 (build c7257b8faff5699e13bbc781679dc03f48c1102a)", StatsHelper.V1.toParquetStatistics((org.apache.parquet.column.statistics.Statistics<?>)stats), binaryType);
        Assert.assertFalse((String)("Stats should not include min/max: " + convertedStats), (boolean)convertedStats.hasNonNullValue());
        Assert.assertTrue((String)("Stats should have null count: " + convertedStats), (boolean)convertedStats.isNumNullsSet());
        Assert.assertEquals((String)("Stats should have 3 nulls: " + convertedStats), (long)3L, (long)convertedStats.getNumNulls());
    }

    @Test
    public void testStillUseStatsWithSignedSortOrderIfSingleValueV1() {
        this.testStillUseStatsWithSignedSortOrderIfSingleValue(StatsHelper.V1);
    }

    @Test
    public void testStillUseStatsWithSignedSortOrderIfSingleValueV2() {
        this.testStillUseStatsWithSignedSortOrderIfSingleValue(StatsHelper.V2);
    }

    private void testStillUseStatsWithSignedSortOrderIfSingleValue(StatsHelper helper) {
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        BinaryStatistics stats = new BinaryStatistics();
        stats.incrementNumNulls();
        stats.updateStats(Binary.fromString((String)"A"));
        stats.incrementNumNulls();
        stats.updateStats(Binary.fromString((String)"A"));
        stats.incrementNumNulls();
        PrimitiveType binaryType = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("b");
        org.apache.parquet.column.statistics.Statistics convertedStats = converter.fromParquetStatistics("parquet-mr version 1.15.1 (build c7257b8faff5699e13bbc781679dc03f48c1102a)", ParquetMetadataConverter.toParquetStatistics((org.apache.parquet.column.statistics.Statistics)stats), binaryType);
        Assert.assertFalse((String)("Stats should not be empty: " + convertedStats), (boolean)convertedStats.isEmpty());
        Assert.assertArrayEquals((String)("min == max: " + convertedStats), (byte[])convertedStats.getMaxBytes(), (byte[])convertedStats.getMinBytes());
    }

    @Test
    public void testUseStatsWithSignedSortOrderV1() {
        this.testUseStatsWithSignedSortOrder(StatsHelper.V1);
    }

    @Test
    public void testUseStatsWithSignedSortOrderV2() {
        this.testUseStatsWithSignedSortOrder(StatsHelper.V2);
    }

    private void testUseStatsWithSignedSortOrder(StatsHelper helper) {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.strings.signed-min-max.enabled", true);
        ParquetMetadataConverter converter = new ParquetMetadataConverter(conf);
        BinaryStatistics stats = new BinaryStatistics();
        stats.incrementNumNulls();
        stats.updateStats(Binary.fromString((String)"A"));
        stats.incrementNumNulls();
        stats.updateStats(Binary.fromString((String)"z"));
        stats.incrementNumNulls();
        PrimitiveType binaryType = (PrimitiveType)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("b");
        org.apache.parquet.column.statistics.Statistics convertedStats = converter.fromParquetStatistics("parquet-mr version 1.15.1 (build c7257b8faff5699e13bbc781679dc03f48c1102a)", helper.toParquetStatistics((org.apache.parquet.column.statistics.Statistics<?>)stats), binaryType);
        Assert.assertFalse((String)"Stats should not be empty", (boolean)convertedStats.isEmpty());
        Assert.assertTrue((boolean)convertedStats.isNumNullsSet());
        Assert.assertEquals((String)"Should have 3 nulls", (long)3L, (long)convertedStats.getNumNulls());
        if (helper == StatsHelper.V1) {
            Assert.assertFalse((String)"Min-max should be null for V1 stats", (boolean)convertedStats.hasNonNullValue());
        } else {
            Assert.assertEquals((String)"Should have correct min (unsigned sort)", (Object)Binary.fromString((String)"A"), (Object)convertedStats.genericGetMin());
            Assert.assertEquals((String)"Should have correct max (unsigned sort)", (Object)Binary.fromString((String)"z"), (Object)convertedStats.genericGetMax());
        }
    }

    @Test
    public void testFloat16Stats() {
        org.apache.parquet.column.statistics.Statistics stats = org.apache.parquet.column.statistics.Statistics.createStats((org.apache.parquet.schema.Type)new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, 2, "float16").withLogicalTypeAnnotation((LogicalTypeAnnotation)LogicalTypeAnnotation.float16Type()));
        stats.updateStats(this.toBinary(255, 3));
        stats.updateStats(this.toBinary(255, 123));
        String expectedMinStr = "6.097555E-5";
        String expectedMaxStr = "65504.0";
        Assert.assertEquals((Object)expectedMinStr, (Object)stats.minAsString());
        Assert.assertEquals((Object)expectedMaxStr, (Object)stats.maxAsString());
    }

    private Binary toBinary(int ... bytes) {
        byte[] array = new byte[bytes.length];
        for (int i = 0; i < array.length; ++i) {
            array[i] = (byte)bytes[i];
        }
        return Binary.fromConstantByteArray((byte[])array);
    }

    @Test
    public void testMissingValuesFromStats() {
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        PrimitiveType type = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("test_int32");
        Statistics formatStats = new Statistics();
        org.apache.parquet.column.statistics.Statistics stats = converter.fromParquetStatistics("parquet-mr version 1.15.1 (build c7257b8faff5699e13bbc781679dc03f48c1102a)", formatStats, type);
        Assert.assertFalse((boolean)stats.isNumNullsSet());
        Assert.assertFalse((boolean)stats.hasNonNullValue());
        Assert.assertTrue((boolean)stats.isEmpty());
        Assert.assertEquals((long)-1L, (long)stats.getNumNulls());
        formatStats.clear();
        formatStats.setMin(BytesUtils.intToBytes((int)-100));
        formatStats.setMax(BytesUtils.intToBytes((int)100));
        stats = converter.fromParquetStatistics("parquet-mr version 1.15.1 (build c7257b8faff5699e13bbc781679dc03f48c1102a)", formatStats, type);
        Assert.assertFalse((boolean)stats.isNumNullsSet());
        Assert.assertTrue((boolean)stats.hasNonNullValue());
        Assert.assertFalse((boolean)stats.isEmpty());
        Assert.assertEquals((long)-1L, (long)stats.getNumNulls());
        Assert.assertEquals((Object)-100, (Object)stats.genericGetMin());
        Assert.assertEquals((Object)100, (Object)stats.genericGetMax());
        formatStats.clear();
        formatStats.setNull_count(2000L);
        stats = converter.fromParquetStatistics("parquet-mr version 1.15.1 (build c7257b8faff5699e13bbc781679dc03f48c1102a)", formatStats, type);
        Assert.assertTrue((boolean)stats.isNumNullsSet());
        Assert.assertFalse((boolean)stats.hasNonNullValue());
        Assert.assertFalse((boolean)stats.isEmpty());
        Assert.assertEquals((long)2000L, (long)stats.getNumNulls());
    }

    @Test
    public void testSkippedV2Stats() {
        this.testSkippedV2Stats((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(12)).as(OriginalType.INTERVAL)).named(""), new BigInteger("12345678"), new BigInteger("12345679"));
        this.testSkippedV2Stats((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named(""), new BigInteger("-75687987"), new BigInteger("45367657"));
    }

    private void testSkippedV2Stats(PrimitiveType type, Object min, Object max) {
        org.apache.parquet.column.statistics.Statistics<?> stats = TestParquetMetadataConverter.createStats(type, min, max);
        Statistics statistics = ParquetMetadataConverter.toParquetStatistics(stats);
        Assert.assertFalse((boolean)statistics.isSetMin());
        Assert.assertFalse((boolean)statistics.isSetMax());
        Assert.assertFalse((boolean)statistics.isSetMin_value());
        Assert.assertFalse((boolean)statistics.isSetMax_value());
    }

    @Test
    public void testV2OnlyStats() {
        this.testV2OnlyStats((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_8)).named(""), 127, 128);
        this.testV2OnlyStats((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_16)).named(""), Short.MAX_VALUE, 32768);
        this.testV2OnlyStats((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_32)).named(""), Integer.MAX_VALUE, Integer.MIN_VALUE);
        this.testV2OnlyStats((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.UINT_64)).named(""), Long.MAX_VALUE, Long.MIN_VALUE);
        this.testV2OnlyStats((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(6)).named(""), new BigInteger("-765875"), new BigInteger("876856"));
        this.testV2OnlyStats((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(14)).as(OriginalType.DECIMAL)).precision(7)).named(""), new BigInteger("-6769643"), new BigInteger("9864675"));
    }

    private void testV2OnlyStats(PrimitiveType type, Object min, Object max) {
        org.apache.parquet.column.statistics.Statistics<?> stats = TestParquetMetadataConverter.createStats(type, min, max);
        Statistics statistics = ParquetMetadataConverter.toParquetStatistics(stats);
        Assert.assertFalse((boolean)statistics.isSetMin());
        Assert.assertFalse((boolean)statistics.isSetMax());
        Assert.assertEquals((Object)ByteBuffer.wrap(stats.getMinBytes()), (Object)statistics.min_value);
        Assert.assertEquals((Object)ByteBuffer.wrap(stats.getMaxBytes()), (Object)statistics.max_value);
    }

    @Test
    public void testV2StatsEqualMinMax() {
        this.testV2StatsEqualMinMax((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_8)).named(""), 93, 93);
        this.testV2StatsEqualMinMax((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_16)).named(""), -5892, -5892);
        this.testV2StatsEqualMinMax((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_32)).named(""), 234998934, 234998934);
        this.testV2StatsEqualMinMax((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.UINT_64)).named(""), -2389943895984985L, -2389943895984985L);
        this.testV2StatsEqualMinMax((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(6)).named(""), new BigInteger("823749"), new BigInteger("823749"));
        this.testV2StatsEqualMinMax((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(14)).as(OriginalType.DECIMAL)).precision(7)).named(""), new BigInteger("-8752832"), new BigInteger("-8752832"));
        this.testV2StatsEqualMinMax((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named(""), new BigInteger("81032984"), new BigInteger("81032984"));
    }

    private void testV2StatsEqualMinMax(PrimitiveType type, Object min, Object max) {
        org.apache.parquet.column.statistics.Statistics<?> stats = TestParquetMetadataConverter.createStats(type, min, max);
        Statistics statistics = ParquetMetadataConverter.toParquetStatistics(stats);
        Assert.assertEquals((Object)ByteBuffer.wrap(stats.getMinBytes()), (Object)statistics.min);
        Assert.assertEquals((Object)ByteBuffer.wrap(stats.getMaxBytes()), (Object)statistics.max);
        Assert.assertEquals((Object)ByteBuffer.wrap(stats.getMinBytes()), (Object)statistics.min_value);
        Assert.assertEquals((Object)ByteBuffer.wrap(stats.getMaxBytes()), (Object)statistics.max_value);
    }

    private static <T> org.apache.parquet.column.statistics.Statistics<?> createStats(PrimitiveType type, T min, T max) {
        Class<?> c = min.getClass();
        if (c == Integer.class) {
            return TestParquetMetadataConverter.createStatsTyped(type, (Integer)min, (Integer)max);
        }
        if (c == Long.class) {
            return TestParquetMetadataConverter.createStatsTyped(type, (Long)min, (Long)max);
        }
        if (c == BigInteger.class) {
            return TestParquetMetadataConverter.createStatsTyped(type, (BigInteger)min, (BigInteger)max);
        }
        Assert.fail((String)"Not implemented");
        return null;
    }

    private static org.apache.parquet.column.statistics.Statistics<?> createStatsTyped(PrimitiveType type, int min, int max) {
        org.apache.parquet.column.statistics.Statistics stats = org.apache.parquet.column.statistics.Statistics.createStats((org.apache.parquet.schema.Type)type);
        stats.updateStats(max);
        stats.updateStats(min);
        Assert.assertEquals((Object)min, (Object)stats.genericGetMin());
        Assert.assertEquals((Object)max, (Object)stats.genericGetMax());
        return stats;
    }

    private static org.apache.parquet.column.statistics.Statistics<?> createStatsTyped(PrimitiveType type, long min, long max) {
        org.apache.parquet.column.statistics.Statistics stats = org.apache.parquet.column.statistics.Statistics.createStats((org.apache.parquet.schema.Type)type);
        stats.updateStats(max);
        stats.updateStats(min);
        Assert.assertEquals((Object)min, (Object)stats.genericGetMin());
        Assert.assertEquals((Object)max, (Object)stats.genericGetMax());
        return stats;
    }

    private static org.apache.parquet.column.statistics.Statistics<?> createStatsTyped(PrimitiveType type, BigInteger min, BigInteger max) {
        org.apache.parquet.column.statistics.Statistics stats = org.apache.parquet.column.statistics.Statistics.createStats((org.apache.parquet.schema.Type)type);
        Binary minBinary = FixedBinaryTestUtils.getFixedBinary((PrimitiveType)type, (BigInteger)min);
        Binary maxBinary = FixedBinaryTestUtils.getFixedBinary((PrimitiveType)type, (BigInteger)max);
        stats.updateStats(maxBinary);
        stats.updateStats(minBinary);
        Assert.assertEquals((Object)minBinary, (Object)stats.genericGetMin());
        Assert.assertEquals((Object)maxBinary, (Object)stats.genericGetMax());
        return stats;
    }

    private static ParquetMetadata createParquetMetaData(org.apache.parquet.column.Encoding dicEncoding, org.apache.parquet.column.Encoding dataEncoding) {
        return TestParquetMetadataConverter.createParquetMetaData(dicEncoding, dataEncoding, true);
    }

    private static ParquetMetadata createParquetMetaData(org.apache.parquet.column.Encoding dicEncoding, org.apache.parquet.column.Encoding dataEncoding, boolean includeEncodingStats) {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message schema { optional int32 col (INT_32); }");
        org.apache.parquet.hadoop.metadata.FileMetaData fileMetaData = new org.apache.parquet.hadoop.metadata.FileMetaData(schema, new HashMap(), null);
        ArrayList<BlockMetaData> blockMetaDataList = new ArrayList<BlockMetaData>();
        BlockMetaData blockMetaData = new BlockMetaData();
        EncodingStats es = null;
        if (includeEncodingStats) {
            EncodingStats.Builder builder = new EncodingStats.Builder();
            if (dicEncoding != null) {
                builder.addDictEncoding(dicEncoding).build();
            }
            builder.addDataEncoding(dataEncoding);
            es = builder.build();
        }
        HashSet<org.apache.parquet.column.Encoding> e = new HashSet<org.apache.parquet.column.Encoding>();
        if (!includeEncodingStats) {
            if (dicEncoding != null) {
                e.add(dicEncoding);
            }
            e.add(dataEncoding);
        }
        PrimitiveType.PrimitiveTypeName t = PrimitiveType.PrimitiveTypeName.INT32;
        ColumnPath p = ColumnPath.get((String[])new String[]{"col"});
        CompressionCodecName c = CompressionCodecName.UNCOMPRESSED;
        BinaryStatistics s = new BinaryStatistics();
        ColumnChunkMetaData md = ColumnChunkMetaData.get((ColumnPath)p, (PrimitiveType.PrimitiveTypeName)t, (CompressionCodecName)c, (EncodingStats)es, e, (org.apache.parquet.column.statistics.Statistics)s, (long)20L, (long)30L, (long)0L, (long)0L, (long)0L);
        blockMetaData.addColumn(md);
        blockMetaDataList.add(blockMetaData);
        return new ParquetMetadata(fileMetaData, blockMetaDataList);
    }

    @Test
    public void testColumnOrders() throws IOException {
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test {  optional binary binary_col;  optional group map_col (MAP) {    repeated group map (MAP_KEY_VALUE) {        required binary key (UTF8);        optional group list_col (LIST) {          repeated group list {            optional int96 array_element;          }        }    }  }}");
        org.apache.parquet.hadoop.metadata.FileMetaData fileMetaData = new org.apache.parquet.hadoop.metadata.FileMetaData(schema, new HashMap(), null);
        ParquetMetadata metadata = new ParquetMetadata(fileMetaData, new ArrayList());
        ParquetMetadataConverter converter = new ParquetMetadataConverter();
        FileMetaData formatMetadata = converter.toParquetMetadata(1, metadata);
        List columnOrders = formatMetadata.getColumn_orders();
        Assert.assertEquals((long)3L, (long)columnOrders.size());
        for (ColumnOrder columnOrder : columnOrders) {
            Assert.assertTrue((boolean)columnOrder.isSetTYPE_ORDER());
        }
        ((ColumnOrder)columnOrders.get(1)).clear();
        MessageType resultSchema = converter.fromParquetMetadata(formatMetadata).getFileMetaData().getSchema();
        List columns = resultSchema.getColumns();
        Assert.assertEquals((long)3L, (long)columns.size());
        Assert.assertEquals((Object)org.apache.parquet.schema.ColumnOrder.typeDefined(), (Object)((ColumnDescriptor)columns.get(0)).getPrimitiveType().columnOrder());
        Assert.assertEquals((Object)org.apache.parquet.schema.ColumnOrder.undefined(), (Object)((ColumnDescriptor)columns.get(1)).getPrimitiveType().columnOrder());
        Assert.assertEquals((Object)org.apache.parquet.schema.ColumnOrder.undefined(), (Object)((ColumnDescriptor)columns.get(2)).getPrimitiveType().columnOrder());
    }

    @Test
    public void testOffsetIndexConversion() {
        for (boolean withSizeStats : new boolean[]{false, true}) {
            OffsetIndexBuilder builder = OffsetIndexBuilder.getBuilder();
            builder.add(1000L, 10000, 0L, withSizeStats ? Optional.of(11L) : Optional.empty());
            builder.add(22000L, 12000, 100L, withSizeStats ? Optional.of(22L) : Optional.empty());
            org.apache.parquet.internal.column.columnindex.OffsetIndex offsetIndex = ParquetMetadataConverter.fromParquetOffsetIndex((OffsetIndex)ParquetMetadataConverter.toParquetOffsetIndex((org.apache.parquet.internal.column.columnindex.OffsetIndex)builder.build(100000L)));
            Assert.assertEquals((long)2L, (long)offsetIndex.getPageCount());
            Assert.assertEquals((long)101000L, (long)offsetIndex.getOffset(0));
            Assert.assertEquals((long)10000L, (long)offsetIndex.getCompressedPageSize(0));
            Assert.assertEquals((long)0L, (long)offsetIndex.getFirstRowIndex(0));
            Assert.assertEquals((long)122000L, (long)offsetIndex.getOffset(1));
            Assert.assertEquals((long)12000L, (long)offsetIndex.getCompressedPageSize(1));
            Assert.assertEquals((long)100L, (long)offsetIndex.getFirstRowIndex(1));
            if (withSizeStats) {
                Assert.assertEquals(Optional.of(11L), (Object)offsetIndex.getUnencodedByteArrayDataBytes(0));
                Assert.assertEquals(Optional.of(22L), (Object)offsetIndex.getUnencodedByteArrayDataBytes(1));
                continue;
            }
            Assert.assertFalse((boolean)offsetIndex.getUnencodedByteArrayDataBytes(0).isPresent());
            Assert.assertFalse((boolean)offsetIndex.getUnencodedByteArrayDataBytes(1).isPresent());
        }
    }

    @Test
    public void testColumnIndexConversion() {
        for (boolean withSizeStats : new boolean[]{false, true}) {
            PrimitiveType type = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("test_int64");
            ColumnIndexBuilder builder = ColumnIndexBuilder.getBuilder((PrimitiveType)type, (int)Integer.MAX_VALUE);
            org.apache.parquet.column.statistics.Statistics stats = org.apache.parquet.column.statistics.Statistics.createStats((org.apache.parquet.schema.Type)type);
            stats.incrementNumNulls(16L);
            stats.updateStats(-100L);
            stats.updateStats(100L);
            builder.add(stats, withSizeStats ? new org.apache.parquet.column.statistics.SizeStatistics(type, 0L, (List)LongArrayList.of((long[])new long[]{1L, 2L}), (List)LongArrayList.of((long[])new long[]{6L, 5L})) : null);
            stats = org.apache.parquet.column.statistics.Statistics.createStats((org.apache.parquet.schema.Type)type);
            stats.incrementNumNulls(111L);
            builder.add(stats, withSizeStats ? new org.apache.parquet.column.statistics.SizeStatistics(type, 0L, (List)LongArrayList.of((long[])new long[]{3L, 4L}), (List)LongArrayList.of((long[])new long[]{4L, 3L})) : null);
            stats = org.apache.parquet.column.statistics.Statistics.createStats((org.apache.parquet.schema.Type)type);
            stats.updateStats(200L);
            stats.updateStats(500L);
            builder.add(stats, withSizeStats ? new org.apache.parquet.column.statistics.SizeStatistics(type, 0L, (List)LongArrayList.of((long[])new long[]{5L, 6L}), (List)LongArrayList.of((long[])new long[]{2L, 1L})) : null);
            ColumnIndex parquetColumnIndex = ParquetMetadataConverter.toParquetColumnIndex((PrimitiveType)type, (org.apache.parquet.internal.column.columnindex.ColumnIndex)builder.build());
            org.apache.parquet.internal.column.columnindex.ColumnIndex columnIndex = ParquetMetadataConverter.fromParquetColumnIndex((PrimitiveType)type, (ColumnIndex)parquetColumnIndex);
            Assert.assertEquals((Object)BoundaryOrder.ASCENDING, (Object)columnIndex.getBoundaryOrder());
            Assert.assertTrue((boolean)Arrays.asList(false, true, false).equals(columnIndex.getNullPages()));
            Assert.assertTrue((boolean)Arrays.asList(16L, 111L, 0L).equals(columnIndex.getNullCounts()));
            Assert.assertTrue((boolean)Arrays.asList(ByteBuffer.wrap(BytesUtils.longToBytes((long)-100L)), ByteBuffer.allocate(0), ByteBuffer.wrap(BytesUtils.longToBytes((long)200L))).equals(columnIndex.getMinValues()));
            Assert.assertTrue((boolean)Arrays.asList(ByteBuffer.wrap(BytesUtils.longToBytes((long)100L)), ByteBuffer.allocate(0), ByteBuffer.wrap(BytesUtils.longToBytes((long)500L))).equals(columnIndex.getMaxValues()));
            Assert.assertNull((String)"Should handle null column index", (Object)ParquetMetadataConverter.toParquetColumnIndex((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("test_int32")), null));
            Assert.assertNull((String)"Should ignore unsupported types", (Object)ParquetMetadataConverter.toParquetColumnIndex((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT96).named("test_int96")), (org.apache.parquet.internal.column.columnindex.ColumnIndex)columnIndex));
            Assert.assertNull((String)"Should ignore unsupported types", (Object)ParquetMetadataConverter.fromParquetColumnIndex((PrimitiveType)((PrimitiveType)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(12)).as(OriginalType.INTERVAL)).named("test_interval")), (ColumnIndex)parquetColumnIndex));
            if (withSizeStats) {
                Assert.assertEquals((Object)LongArrayList.of((long[])new long[]{1L, 2L, 3L, 4L, 5L, 6L}), (Object)columnIndex.getRepetitionLevelHistogram());
                Assert.assertEquals((Object)LongArrayList.of((long[])new long[]{6L, 5L, 4L, 3L, 2L, 1L}), (Object)columnIndex.getDefinitionLevelHistogram());
                continue;
            }
            Assert.assertEquals((Object)LongArrayList.of(), (Object)columnIndex.getRepetitionLevelHistogram());
            Assert.assertEquals((Object)LongArrayList.of(), (Object)columnIndex.getDefinitionLevelHistogram());
        }
    }

    @Test
    public void testMapLogicalType() {
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        MessageType expected = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().requiredGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).repeatedGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.MapKeyValueTypeAnnotation.getInstance())).required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("key")).required(PrimitiveType.PrimitiveTypeName.INT32).named("value")).named("key_value")).named("testMap")).named("Message");
        List parquetSchema = parquetMetadataConverter.toParquetSchema(expected);
        Assert.assertEquals((long)5L, (long)parquetSchema.size());
        Assert.assertEquals((Object)new SchemaElement("Message").setNum_children(1), parquetSchema.get(0));
        Assert.assertEquals((Object)new SchemaElement("testMap").setRepetition_type(FieldRepetitionType.REQUIRED).setNum_children(1).setConverted_type(ConvertedType.MAP).setLogicalType(LogicalType.MAP((MapType)new MapType())), parquetSchema.get(1));
        Assert.assertEquals((Object)new SchemaElement("key_value").setRepetition_type(FieldRepetitionType.REPEATED).setNum_children(2).setConverted_type(ConvertedType.MAP_KEY_VALUE).setLogicalType(null), parquetSchema.get(2));
        Assert.assertEquals((Object)new SchemaElement("key").setType(Type.BYTE_ARRAY).setRepetition_type(FieldRepetitionType.REQUIRED).setConverted_type(ConvertedType.UTF8).setLogicalType(LogicalType.STRING((StringType)new StringType())), parquetSchema.get(3));
        Assert.assertEquals((Object)new SchemaElement("value").setType(Type.INT32).setRepetition_type(FieldRepetitionType.REQUIRED).setConverted_type(null).setLogicalType(null), parquetSchema.get(4));
        MessageType schema = parquetMetadataConverter.fromParquetSchema(parquetSchema, null);
        Assert.assertEquals((Object)expected, (Object)schema);
    }

    @Test
    public void testMapLogicalTypeReadWrite() throws Exception {
        MessageType messageType = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().requiredGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.mapType())).repeatedGroup().as((LogicalTypeAnnotation)LogicalTypeAnnotation.MapKeyValueTypeAnnotation.getInstance())).required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("key")).required(PrimitiveType.PrimitiveTypeName.INT64).named("value")).named("key_value")).named("testMap")).named("example");
        this.verifyMapMessageType(messageType, "key_value");
    }

    @Test
    public void testMapConvertedTypeReadWrite() throws Exception {
        ArrayList<SchemaElement> oldConvertedTypeSchemaElements = new ArrayList<SchemaElement>();
        oldConvertedTypeSchemaElements.add(new SchemaElement("example").setNum_children(1));
        oldConvertedTypeSchemaElements.add(new SchemaElement("testMap").setRepetition_type(FieldRepetitionType.REQUIRED).setNum_children(1).setConverted_type(ConvertedType.MAP).setLogicalType(null));
        oldConvertedTypeSchemaElements.add(new SchemaElement("map").setRepetition_type(FieldRepetitionType.REPEATED).setNum_children(2).setConverted_type(ConvertedType.MAP_KEY_VALUE).setLogicalType(null));
        oldConvertedTypeSchemaElements.add(new SchemaElement("key").setType(Type.BYTE_ARRAY).setRepetition_type(FieldRepetitionType.REQUIRED).setConverted_type(ConvertedType.UTF8).setLogicalType(null));
        oldConvertedTypeSchemaElements.add(new SchemaElement("value").setType(Type.INT64).setRepetition_type(FieldRepetitionType.REQUIRED).setConverted_type(null).setLogicalType(null));
        ParquetMetadataConverter parquetMetadataConverter = new ParquetMetadataConverter();
        MessageType messageType = parquetMetadataConverter.fromParquetSchema(oldConvertedTypeSchemaElements, null);
        this.verifyMapMessageType(messageType, "map");
    }

    private void verifyMapMessageType(MessageType messageType, String keyValueName) throws IOException {
        int index;
        SimpleGroup group;
        Path file = new Path(this.temporaryFolder.newFolder("verifyMapMessageType").getPath(), keyValueName + ".parquet");
        try (ParquetWriter writer = ExampleParquetWriter.builder((Path)file).withType(messageType).build();){
            group = new SimpleGroup((GroupType)messageType);
            Group mapGroup = group.addGroup("testMap");
            for (index = 0; index < 5; ++index) {
                Group keyValueGroup = mapGroup.addGroup(keyValueName);
                keyValueGroup.add("key", Binary.fromString((String)("key" + index)));
                keyValueGroup.add("value", 100L + (long)index);
            }
            writer.write((Object)group);
        }
        var5_5 = null;
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).build();){
            group = (Group)reader.read();
            Assert.assertNotNull((Object)group);
            Group testMap = group.getGroup("testMap", 0);
            Assert.assertNotNull((Object)testMap);
            Assert.assertEquals((long)5L, (long)testMap.getFieldRepetitionCount(keyValueName));
            for (index = 0; index < 5; ++index) {
                Assert.assertEquals((Object)("key" + index), (Object)testMap.getGroup(keyValueName, index).getString("key", 0));
                Assert.assertEquals((long)(100L + (long)index), (long)testMap.getGroup(keyValueName, index).getLong("value", 0));
            }
        }
        catch (Throwable throwable) {
            var5_5 = throwable;
            throw throwable;
        }
    }

    @Test
    public void testSizeStatisticsConversion() {
        PrimitiveType type = (PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("test");
        List<Long> repLevelHistogram = Arrays.asList(1L, 2L, 3L, 4L, 5L);
        List<Long> defLevelHistogram = Arrays.asList(6L, 7L, 8L, 9L, 10L);
        org.apache.parquet.column.statistics.SizeStatistics sizeStatistics = ParquetMetadataConverter.fromParquetSizeStatistics((SizeStatistics)ParquetMetadataConverter.toParquetSizeStatistics((org.apache.parquet.column.statistics.SizeStatistics)new org.apache.parquet.column.statistics.SizeStatistics(type, 1024L, repLevelHistogram, defLevelHistogram)), (PrimitiveType)type);
        Assert.assertEquals((Object)type, (Object)sizeStatistics.getType());
        Assert.assertEquals(Optional.of(1024L), (Object)sizeStatistics.getUnencodedByteArrayDataBytes());
        Assert.assertEquals(repLevelHistogram, (Object)sizeStatistics.getRepetitionLevelHistogram());
        Assert.assertEquals(defLevelHistogram, (Object)sizeStatistics.getDefinitionLevelHistogram());
    }

    private static enum StatsHelper {
        V1{

            @Override
            public Statistics toParquetStatistics(org.apache.parquet.column.statistics.Statistics<?> stats) {
                Statistics statistics = ParquetMetadataConverter.toParquetStatistics(stats);
                statistics.unsetMin_value();
                statistics.unsetMax_value();
                return statistics;
            }
        }
        ,
        V2{

            @Override
            public Statistics toParquetStatistics(org.apache.parquet.column.statistics.Statistics<?> stats) {
                return ParquetMetadataConverter.toParquetStatistics(stats);
            }
        };


        public abstract Statistics toParquetStatistics(org.apache.parquet.column.statistics.Statistics<?> var1);
    }
}

