/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.util.List;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.Test;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestInteropBloomFilter {
    private static final String PARQUET_TESTING_REPO = "https://github.com/apache/parquet-testing/raw/d69d979/data/";
    private static String PARQUET_TESTING_PATH = "target/parquet-testing/data";
    private static String DATA_INDEX_BLOOM_FILE = "data_index_bloom_encoding_stats.parquet";
    private static String DATA_INDEX_BLOOM_WITH_LENGTH_FILE = "data_index_bloom_encoding_with_length.parquet";
    private static final Logger LOG = LoggerFactory.getLogger(TestInteropBloomFilter.class);
    private OkHttpClient httpClient = new OkHttpClient();

    @Test
    public void testReadDataIndexBloomParquetFiles() throws IOException {
        Path rootPath = new Path(PARQUET_TESTING_PATH);
        LOG.info("======== testReadDataIndexBloomParquetFiles {} ========", (Object)rootPath);
        Path filePath = this.downloadInterOpFiles(rootPath, DATA_INDEX_BLOOM_FILE, this.httpClient);
        int expectedRowCount = 14;
        String[] expectedValues = new String[]{"Hello", "This is", "a", "test", "How", "are you", "doing ", "today", "the quick", "brown fox", "jumps", "over", "the lazy", "dog"};
        String[] unexpectedValues = new String[]{"b", "c", "d"};
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)filePath).build();){
            for (int i = 0; i < expectedRowCount; ++i) {
                Group group = (Group)reader.read();
                if (group == null) {
                    Assert.fail((String)"Should not reach end of file");
                }
                Assert.assertEquals((Object)expectedValues[i], (Object)group.getString(0, 0));
            }
        }
        reader = new ParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)filePath, (Configuration)new Configuration()), ParquetReadOptions.builder().build());
        List blocks = reader.getRowGroups();
        blocks.forEach(arg_0 -> TestInteropBloomFilter.lambda$testReadDataIndexBloomParquetFiles$0((ParquetFileReader)reader, expectedRowCount, expectedValues, unexpectedValues, arg_0));
    }

    @Test
    public void testReadDataIndexBloomWithLengthParquetFiles() throws IOException {
        Path rootPath = new Path(PARQUET_TESTING_PATH);
        LOG.info("======== testReadDataIndexBloomWithLengthParquetFiles {} ========", (Object)rootPath);
        Path filePath = this.downloadInterOpFiles(rootPath, DATA_INDEX_BLOOM_WITH_LENGTH_FILE, this.httpClient);
        int expectedRowCount = 14;
        String[] expectedValues = new String[]{"Hello", "This is", "a", "test", "How", "are you", "doing ", "today", "the quick", "brown fox", "jumps", "over", "the lazy", "dog"};
        String[] unexpectedValues = new String[]{"b", "c", "d"};
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)filePath).build();){
            for (int i = 0; i < expectedRowCount; ++i) {
                Group group = (Group)reader.read();
                if (group == null) {
                    Assert.fail((String)"Should not reach end of file");
                }
                Assert.assertEquals((Object)expectedValues[i], (Object)group.getString(0, 0));
            }
        }
        reader = new ParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)filePath, (Configuration)new Configuration()), ParquetReadOptions.builder().build());
        List blocks = reader.getRowGroups();
        blocks.forEach(arg_0 -> TestInteropBloomFilter.lambda$testReadDataIndexBloomWithLengthParquetFiles$1((ParquetFileReader)reader, expectedRowCount, expectedValues, unexpectedValues, arg_0));
    }

    private Path downloadInterOpFiles(Path rootPath, String fileName, OkHttpClient httpClient) throws IOException {
        Path file;
        LOG.info("Download interOp files if needed");
        Configuration conf = new Configuration();
        FileSystem fs = rootPath.getFileSystem(conf);
        LOG.info(rootPath + " exists?: " + fs.exists(rootPath));
        if (!fs.exists(rootPath)) {
            LOG.info("Create folder for interOp files: " + rootPath);
            if (!fs.mkdirs(rootPath)) {
                throw new IOException("Cannot create path " + rootPath);
            }
        }
        if (!fs.exists(file = new Path(rootPath, fileName))) {
            String downloadUrl = PARQUET_TESTING_REPO + fileName;
            LOG.info("Download interOp file: " + downloadUrl);
            Request request = new Request.Builder().url(downloadUrl).build();
            Response response = httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new IOException("Failed to download file: " + response);
            }
            try (FSDataOutputStream fdos = fs.create(file);){
                fdos.write(response.body().bytes());
            }
        }
        return file;
    }

    private static /* synthetic */ void lambda$testReadDataIndexBloomWithLengthParquetFiles$1(ParquetFileReader reader, int expectedRowCount, String[] expectedValues, String[] unexpectedValues, BlockMetaData block) {
        try {
            int i;
            Assert.assertEquals((long)14L, (long)block.getRowCount());
            ColumnChunkMetaData idMeta = (ColumnChunkMetaData)block.getColumns().get(0);
            BloomFilter bloomFilter = reader.readBloomFilter(idMeta);
            Assert.assertNotNull((Object)bloomFilter);
            Assert.assertEquals((long)253L, (long)idMeta.getBloomFilterOffset());
            Assert.assertEquals((long)2064L, (long)idMeta.getBloomFilterLength());
            for (i = 0; i < expectedRowCount; ++i) {
                Assert.assertTrue((boolean)bloomFilter.findHash(bloomFilter.hash(Binary.fromString((String)expectedValues[i]))));
            }
            for (i = 0; i < unexpectedValues.length; ++i) {
                Assert.assertFalse((boolean)bloomFilter.findHash(bloomFilter.hash(Binary.fromString((String)unexpectedValues[i]))));
            }
            Assert.assertEquals((long)199L, (long)idMeta.getTotalSize());
            Assert.assertEquals((long)199L, (long)idMeta.getTotalUncompressedSize());
            Assert.assertEquals((long)2342L, (long)idMeta.getOffsetIndexReference().getOffset());
            Assert.assertEquals((long)11L, (long)idMeta.getOffsetIndexReference().getLength());
            Assert.assertEquals((long)2317L, (long)idMeta.getColumnIndexReference().getOffset());
            Assert.assertEquals((long)25L, (long)idMeta.getColumnIndexReference().getLength());
        }
        catch (Exception e) {
            Assert.fail((String)("Should not throw exception: " + e.getMessage()));
        }
    }

    private static /* synthetic */ void lambda$testReadDataIndexBloomParquetFiles$0(ParquetFileReader reader, int expectedRowCount, String[] expectedValues, String[] unexpectedValues, BlockMetaData block) {
        try {
            int i;
            Assert.assertEquals((long)14L, (long)block.getRowCount());
            ColumnChunkMetaData idMeta = (ColumnChunkMetaData)block.getColumns().get(0);
            BloomFilter bloomFilter = reader.readBloomFilter(idMeta);
            Assert.assertNotNull((Object)bloomFilter);
            Assert.assertEquals((long)192L, (long)idMeta.getBloomFilterOffset());
            Assert.assertEquals((long)-1L, (long)idMeta.getBloomFilterLength());
            for (i = 0; i < expectedRowCount; ++i) {
                Assert.assertTrue((boolean)bloomFilter.findHash(bloomFilter.hash(Binary.fromString((String)expectedValues[i]))));
            }
            for (i = 0; i < unexpectedValues.length; ++i) {
                Assert.assertFalse((boolean)bloomFilter.findHash(bloomFilter.hash(Binary.fromString((String)unexpectedValues[i]))));
            }
            Assert.assertEquals((long)152L, (long)idMeta.getTotalSize());
            Assert.assertEquals((long)163L, (long)idMeta.getTotalUncompressedSize());
            Assert.assertEquals((long)181L, (long)idMeta.getOffsetIndexReference().getOffset());
            Assert.assertEquals((long)11L, (long)idMeta.getOffsetIndexReference().getLength());
            Assert.assertEquals((long)156L, (long)idMeta.getColumnIndexReference().getOffset());
            Assert.assertEquals((long)25L, (long)idMeta.getColumnIndexReference().getLength());
        }
        catch (IOException e) {
            Assert.fail((String)("Should not throw exception: " + e.getMessage()));
        }
    }
}

