/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.HashMap;
import java.util.List;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.bytes.LittleEndianDataInputStream;
import org.apache.parquet.bytes.TrackingByteBufferAllocator;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.page.PageWriter;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.SizeStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.compression.CompressionCodecFactory;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ColumnChunkPageWriteStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndexBuilder;
import org.apache.parquet.io.OutputFile;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.After;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Test;
import org.mockito.InOrder;
import org.mockito.Matchers;
import org.mockito.Mockito;

public class TestColumnChunkPageWriteStore {
    private int pageSize = 1024;
    private int initialSize = 1024;
    private Configuration conf;
    private TrackingByteBufferAllocator allocator;

    @Before
    public void initConfiguration() {
        this.conf = new Configuration();
    }

    @After
    public void closeAllocator() {
        this.allocator.close();
    }

    @Test
    public void test() throws Exception {
        this.allocator = TrackingByteBufferAllocator.wrap((ByteBufferAllocator)new HeapByteBufferAllocator());
        this.test(this.conf, (ByteBufferAllocator)this.allocator);
    }

    @Test
    public void testWithDirectBuffers() throws Exception {
        Configuration config = new Configuration(this.conf);
        config.set("parquet.decrypt.off-heap.buffer.enabled", "true");
        this.allocator = TrackingByteBufferAllocator.wrap((ByteBufferAllocator)new DirectByteBufferAllocator());
        this.test(config, (ByteBufferAllocator)this.allocator);
    }

    public void test(Configuration config, ByteBufferAllocator allocator) throws Exception {
        long pageSize;
        Path file = new Path("target/test/TestColumnChunkPageWriteStore/test.parquet");
        Path root = file.getParent();
        FileSystem fs = file.getFileSystem(config);
        if (fs.exists(root)) {
            fs.delete(root, true);
        }
        fs.mkdirs(root);
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { repeated binary bar; }");
        ColumnDescriptor col = (ColumnDescriptor)schema.getColumns().get(0);
        Encoding dataEncoding = Encoding.PLAIN;
        int valueCount = 10;
        int d = 1;
        int r = 2;
        int v = 3;
        BytesInput definitionLevels = BytesInput.fromInt((int)d);
        BytesInput repetitionLevels = BytesInput.fromInt((int)r);
        Statistics statistics = Statistics.getBuilderForReading((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).named("test_binary"))).build();
        BytesInput data = BytesInput.fromInt((int)v);
        int rowCount = 5;
        int nullCount = 1;
        statistics.incrementNumNulls((long)nullCount);
        statistics.setMinMaxFromBytes(new byte[]{0, 1, 2}, new byte[]{0, 1, 2, 3});
        OutputFileForTesting outputFile = new OutputFileForTesting(file, config);
        ParquetFileWriter writer = new ParquetFileWriter((OutputFile)outputFile, schema, ParquetFileWriter.Mode.CREATE, 0x8000000L, 0x800000, null, ParquetProperties.builder().withAllocator(allocator).build());
        writer.start();
        writer.startBlock((long)rowCount);
        long pageOffset = outputFile.out().getPos();
        try (ColumnChunkPageWriteStore store = new ColumnChunkPageWriteStore(this.compressor(CompressionCodecName.GZIP), schema, allocator, Integer.MAX_VALUE);){
            PageWriter pageWriter = store.getPageWriter(col);
            pageWriter.writePageV2(rowCount, nullCount, valueCount, repetitionLevels, definitionLevels, dataEncoding, data, statistics);
            store.flushToFileWriter(writer);
            pageSize = outputFile.out().getPos() - pageOffset;
        }
        writer.endBlock();
        writer.end(new HashMap());
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)this.conf, (Path)file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        ParquetFileReader reader = new ParquetFileReader(config, footer.getFileMetaData(), file, footer.getBlocks(), schema.getColumns());
        PageReadStore rowGroup = reader.readNextRowGroup();
        PageReader pageReader = rowGroup.getPageReader(col);
        DataPageV2 page = (DataPageV2)pageReader.readPage();
        Assert.assertEquals((long)rowCount, (long)page.getRowCount());
        Assert.assertEquals((long)nullCount, (long)page.getNullCount());
        Assert.assertEquals((long)valueCount, (long)page.getValueCount());
        Assert.assertEquals((long)d, (long)this.intValue(page.getDefinitionLevels()));
        Assert.assertEquals((long)r, (long)this.intValue(page.getRepetitionLevels()));
        Assert.assertEquals((Object)dataEncoding, (Object)page.getDataEncoding());
        Assert.assertEquals((long)v, (long)this.intValue(page.getData()));
        ColumnChunkMetaData column = (ColumnChunkMetaData)((BlockMetaData)footer.getBlocks().get(0)).getColumns().get(0);
        ColumnIndex columnIndex = reader.readColumnIndex(column);
        Assert.assertArrayEquals((byte[])statistics.getMinBytes(), (byte[])((ByteBuffer)columnIndex.getMinValues().get(0)).array());
        Assert.assertArrayEquals((byte[])statistics.getMaxBytes(), (byte[])((ByteBuffer)columnIndex.getMaxValues().get(0)).array());
        Assert.assertEquals((long)statistics.getNumNulls(), (long)((Long)columnIndex.getNullCounts().get(0)));
        Assert.assertFalse((boolean)((Boolean)columnIndex.getNullPages().get(0)));
        OffsetIndex offsetIndex = reader.readOffsetIndex(column);
        Assert.assertEquals((long)1L, (long)offsetIndex.getPageCount());
        Assert.assertEquals((long)pageSize, (long)offsetIndex.getCompressedPageSize(0));
        Assert.assertEquals((long)0L, (long)offsetIndex.getFirstRowIndex(0));
        Assert.assertEquals((long)pageOffset, (long)offsetIndex.getOffset(0));
        reader.close();
    }

    private int intValue(BytesInput in) throws IOException {
        ByteArrayOutputStream baos = new ByteArrayOutputStream();
        in.writeAllTo((OutputStream)baos);
        LittleEndianDataInputStream os = new LittleEndianDataInputStream((InputStream)new ByteArrayInputStream(baos.toByteArray()));
        int i = os.readInt();
        os.close();
        return i;
    }

    @Test
    public void testColumnOrderV1() throws IOException {
        ParquetFileWriter mockFileWriter = (ParquetFileWriter)Mockito.mock(ParquetFileWriter.class);
        InOrder inOrder = Mockito.inOrder((Object[])new Object[]{mockFileWriter});
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("a_string")).required(PrimitiveType.PrimitiveTypeName.INT32).named("an_int")).required(PrimitiveType.PrimitiveTypeName.INT64).named("a_long")).required(PrimitiveType.PrimitiveTypeName.FLOAT).named("a_float")).required(PrimitiveType.PrimitiveTypeName.DOUBLE).named("a_double")).named("order_test");
        BytesInput fakeData = BytesInput.fromInt((int)34);
        int fakeCount = 3;
        BinaryStatistics fakeStats = new BinaryStatistics();
        this.allocator = TrackingByteBufferAllocator.wrap((ByteBufferAllocator)new HeapByteBufferAllocator());
        try (ColumnChunkPageWriteStore store = new ColumnChunkPageWriteStore(this.compressor(CompressionCodecName.UNCOMPRESSED), schema, (ByteBufferAllocator)this.allocator, Integer.MAX_VALUE);){
            for (ColumnDescriptor col : schema.getColumns()) {
                PageWriter pageWriter = store.getPageWriter(col);
                pageWriter.writePage(fakeData, fakeCount, (Statistics)fakeStats, Encoding.RLE, Encoding.RLE, Encoding.PLAIN);
            }
            store.flushToFileWriter(mockFileWriter);
        }
        for (ColumnDescriptor col : schema.getColumns()) {
            ((ParquetFileWriter)inOrder.verify((Object)mockFileWriter)).writeColumnChunk((ColumnDescriptor)Matchers.eq((Object)col), Matchers.eq((long)fakeCount), (CompressionCodecName)Matchers.eq((Object)CompressionCodecName.UNCOMPRESSED), (DictionaryPage)Matchers.isNull(DictionaryPage.class), (BytesInput)Matchers.any(), Matchers.eq((long)fakeData.size()), Matchers.eq((long)fakeData.size()), (Statistics)Matchers.eq((Object)fakeStats), (SizeStatistics)Matchers.any(), (ColumnIndexBuilder)Matchers.same((Object)ColumnIndexBuilder.getNoOpBuilder()), (OffsetIndexBuilder)Matchers.same((Object)OffsetIndexBuilder.getNoOpBuilder()), (BloomFilter)Matchers.any(), (Set)Matchers.any(), (Set)Matchers.any(), (List)Matchers.any());
        }
    }

    private CompressionCodecFactory.BytesInputCompressor compressor(CompressionCodecName codec) {
        return new CodecFactory(this.conf, this.pageSize).getCompressor(codec);
    }

    private static class OutputFileForTesting
    implements OutputFile {
        private PositionOutputStream out;
        private final HadoopOutputFile file;

        OutputFileForTesting(Path path, Configuration conf) throws IOException {
            this.file = HadoopOutputFile.fromPath((Path)path, (Configuration)conf);
        }

        PositionOutputStream out() {
            return this.out;
        }

        public PositionOutputStream create(long blockSizeHint) throws IOException {
            this.out = this.file.create(blockSizeHint);
            return this.out;
        }

        public PositionOutputStream createOrOverwrite(long blockSizeHint) throws IOException {
            this.out = this.file.createOrOverwrite(blockSizeHint);
            return this.out;
        }

        public boolean supportsBlockSize() {
            return this.file.supportsBlockSize();
        }

        public long defaultBlockSize() {
            return this.file.defaultBlockSize();
        }

        public String getPath() {
            return this.file.getPath();
        }
    }
}

