/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.statistics;

import java.io.File;
import java.io.IOException;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;

public class DataGenerationContext {
    public static void writeAndTest(WriteContext context) throws IOException {
        int pageSize;
        Configuration configuration = new Configuration();
        GroupWriteSupport.setSchema((MessageType)context.schema, (Configuration)configuration);
        GroupWriteSupport groupWriteSupport = new GroupWriteSupport();
        int blockSize = context.blockSize;
        int dictionaryPageSize = pageSize = context.pageSize;
        boolean enableDictionary = context.enableDictionary;
        boolean enableValidation = context.enableValidation;
        ParquetProperties.WriterVersion writerVersion = context.version;
        CompressionCodecName codec = CompressionCodecName.UNCOMPRESSED;
        try (ParquetWriter writer = new ParquetWriter(context.fsPath, (WriteSupport)groupWriteSupport, codec, blockSize, pageSize, dictionaryPageSize, enableDictionary, enableValidation, writerVersion, configuration);){
            context.write((ParquetWriter<Group>)writer);
        }
        context.test();
        context.path.delete();
    }

    public static abstract class WriteContext {
        protected final File path;
        protected final Path fsPath;
        protected final MessageType schema;
        protected final int blockSize;
        protected final int pageSize;
        protected final boolean enableDictionary;
        protected final boolean enableValidation;
        protected final ParquetProperties.WriterVersion version;

        public WriteContext(File path, MessageType schema, int blockSize, int pageSize, boolean enableDictionary, boolean enableValidation, ParquetProperties.WriterVersion version) throws IOException {
            this.path = path;
            this.fsPath = new Path(path.toString());
            this.schema = schema;
            this.blockSize = blockSize;
            this.pageSize = pageSize;
            this.enableDictionary = enableDictionary;
            this.enableValidation = enableValidation;
            this.version = version;
        }

        public abstract void write(ParquetWriter<Group> var1) throws IOException;

        public abstract void test() throws IOException;
    }
}

