/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.filter2.recordlevel.PhoneBookWriter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.TestBloomFiltering;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.InputFile;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestStoreBloomFilter {
    private static final Path FILE_V1 = TestStoreBloomFilter.createTempFile("v1");
    private static final Path FILE_V2 = TestStoreBloomFilter.createTempFile("v2");
    private static final List<PhoneBookWriter.User> DATA = Collections.unmodifiableList(TestBloomFiltering.generateDictionaryData(10000));
    private final Path file;
    private final String version;

    public TestStoreBloomFilter(Path file, String version) {
        this.file = file;
        this.version = version;
    }

    @Parameterized.Parameters(name="Run {index}: parquet {1}")
    public static Collection<Object[]> params() {
        return Arrays.asList({FILE_V1, "v1"}, {FILE_V2, "v2"});
    }

    @BeforeClass
    public static void createFiles() throws IOException {
        TestStoreBloomFilter.writePhoneBookToFile(FILE_V1, ParquetProperties.WriterVersion.PARQUET_1_0);
        TestStoreBloomFilter.writePhoneBookToFile(FILE_V2, ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    @AfterClass
    public static void deleteFiles() throws IOException {
        TestStoreBloomFilter.deleteFile(FILE_V1);
        TestStoreBloomFilter.deleteFile(FILE_V2);
    }

    @Test
    public void testStoreBloomFilter() throws IOException {
        ParquetFileReader reader = new ParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)this.file, (Configuration)new Configuration()), ParquetReadOptions.builder().build());
        List blocks = reader.getRowGroups();
        blocks.forEach(block -> {
            try {
                ColumnChunkMetaData idMeta = (ColumnChunkMetaData)block.getColumns().get(0);
                EncodingStats idEncoding = idMeta.getEncodingStats();
                Assert.assertTrue((boolean)idEncoding.hasNonDictionaryEncodedPages());
                Assert.assertNotNull((Object)reader.readBloomFilter(idMeta));
                ColumnChunkMetaData nameMeta = (ColumnChunkMetaData)block.getColumns().get(1);
                EncodingStats nameEncoding = nameMeta.getEncodingStats();
                Assert.assertFalse((boolean)nameEncoding.hasNonDictionaryEncodedPages());
                Assert.assertNull((Object)reader.readBloomFilter(nameMeta));
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        });
    }

    private static Path createTempFile(String version) {
        try {
            return new Path(Files.createTempFile("test-store-bloom-filter-" + version, ".parquet", new FileAttribute[0]).toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw new AssertionError("Unable to create temporary file", e);
        }
    }

    private static void deleteFile(Path file) throws IOException {
        file.getFileSystem(new Configuration()).delete(file, false);
    }

    private static void writePhoneBookToFile(Path file, ParquetProperties.WriterVersion parquetVersion) throws IOException {
        int pageSize = DATA.size() / 100;
        int rowGroupSize = pageSize * 4;
        PhoneBookWriter.write(((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)file).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withRowGroupSize(rowGroupSize)).withPageSize(pageSize)).withBloomFilterNDV("id", 10000L)).withBloomFilterNDV("name", 10000L)).withWriterVersion(parquetVersion), DATA);
    }
}

