/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.io.IOException;
import java.nio.ByteBuffer;
import java.util.Collections;
import java.util.List;
import java.util.stream.Collectors;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.Preconditions;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestParquetWriterTruncation {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testTruncateColumnIndex() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")).named("msg");
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        Path path = this.newTempPath();
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withPageRowCountLimit(10)).withConf(conf)).withDictionaryEncoding(false)).withColumnIndexTruncateLength(10)).build();){
            writer.write((Object)factory.newGroup().append("name", "1234567890abcdefghijklmnopqrstuvwxyz"));
        }
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));){
            ColumnChunkMetaData column = (ColumnChunkMetaData)((BlockMetaData)reader.getFooter().getBlocks().get(0)).getColumns().get(0);
            ColumnIndex index = reader.readColumnIndex(column);
            Assert.assertEquals(Collections.singletonList("1234567890"), TestParquetWriterTruncation.asStrings(index.getMinValues()));
            Assert.assertEquals(Collections.singletonList("1234567891"), TestParquetWriterTruncation.asStrings(index.getMaxValues()));
        }
    }

    @Test
    public void testTruncateStatistics() throws IOException {
        MessageType schema = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("name")).named("msg");
        Configuration conf = new Configuration();
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory factory = new SimpleGroupFactory(schema);
        Path path = this.newTempPath();
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withPageRowCountLimit(10)).withConf(conf)).withDictionaryEncoding(false)).withStatisticsTruncateLength(10)).build();){
            writer.write((Object)factory.newGroup().append("name", "1234567890abcdefghijklmnopqrstuvwxyz"));
        }
        try (ParquetFileReader reader = ParquetFileReader.open((InputFile)HadoopInputFile.fromPath((Path)path, (Configuration)new Configuration()));){
            ColumnChunkMetaData column = (ColumnChunkMetaData)((BlockMetaData)reader.getFooter().getBlocks().get(0)).getColumns().get(0);
            Statistics statistics = column.getStatistics();
            Assert.assertEquals((Object)"1234567890", (Object)new String(statistics.getMinBytes()));
            Assert.assertEquals((Object)"1234567891", (Object)new String(statistics.getMaxBytes()));
        }
    }

    private Path newTempPath() throws IOException {
        File file = this.temp.newFile();
        Preconditions.checkArgument((boolean)file.delete(), (String)"Could not remove temp file");
        return new Path(file.getAbsolutePath());
    }

    private static List<String> asStrings(List<ByteBuffer> buffers) {
        return buffers.stream().map(buffer -> new String(buffer.array())).collect(Collectors.toList());
    }
}

