/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.io.IOException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collections;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.example.data.simple.convert.GroupRecordConverter;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.io.ColumnIOFactory;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.MessageColumnIO;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.RecordReader;
import org.apache.parquet.io.api.RecordMaterializer;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.statistics.DataGenerationContext;
import org.apache.parquet.statistics.RandomValues;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestParquetReaderRandomAccess {
    private static final int KILOBYTE = 1024;
    private static final long RANDOM_SEED = 7174252115631550700L;
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void test() throws IOException {
        Random random = new Random(7174252115631550700L);
        File file = this.temp.newFile("test_file.parquet");
        file.delete();
        int blockSize = 51200;
        int pageSize = 2048;
        ArrayList<DataContext> contexts = new ArrayList<DataContext>();
        for (boolean enableDictionary : new boolean[]{false, true}) {
            for (ParquetProperties.WriterVersion writerVersion : new ParquetProperties.WriterVersion[]{ParquetProperties.WriterVersion.PARQUET_1_0, ParquetProperties.WriterVersion.PARQUET_2_0}) {
                contexts.add(new DataContextRandom(random.nextLong(), file, blockSize, pageSize, enableDictionary, writerVersion));
                contexts.add(new DataContextRandomAndSequential(random.nextLong(), file, blockSize, pageSize, enableDictionary, writerVersion));
            }
        }
        Object object = contexts.iterator();
        while (object.hasNext()) {
            DataContext context = (DataContext)object.next();
            DataGenerationContext.writeAndTest(context);
        }
    }

    public static class DataContextRandomAndSequential
    extends DataContext {
        public DataContextRandomAndSequential(long seed, File path, int blockSize, int pageSize, boolean enableDictionary, ParquetProperties.WriterVersion version) throws IOException {
            super(seed, path, blockSize, pageSize, enableDictionary, version);
        }

        @Override
        protected void test(ParquetFileReader reader, List<Integer> indexes, List<Long> fromNumber, List<Long> toNumber, int blockAmount) throws IOException {
            PageReadStore pages;
            int index;
            int splitPoint = indexes.size() / 2;
            PageReadStore pages2 = reader.readNextRowGroup();
            this.assertValues(pages2, fromNumber, toNumber, 0, blockAmount);
            for (int i = 0; i < splitPoint; ++i) {
                index = indexes.get(i);
                pages = reader.readRowGroup(index);
                this.assertValues(pages, fromNumber, toNumber, index, blockAmount);
            }
            pages = reader.readNextRowGroup();
            this.assertValues(pages, fromNumber, toNumber, 1, blockAmount);
            for (int i = splitPoint; i < indexes.size(); ++i) {
                index = indexes.get(i);
                pages = reader.readRowGroup(index);
                this.assertValues(pages, fromNumber, toNumber, index, blockAmount);
            }
            pages = reader.readNextRowGroup();
            this.assertValues(pages, fromNumber, toNumber, 2, blockAmount);
        }

        @Override
        protected void testFiltered(ParquetFileReader reader, List<Integer> indexes, List<Long> fromNumber, List<Long> toNumber, int blockAmount) throws IOException {
            PageReadStore pages;
            int index;
            int splitPoint = indexes.size() / 2;
            PageReadStore pages2 = reader.readNextFilteredRowGroup();
            this.assertFilteredValues(pages2, fromNumber, toNumber, 0, blockAmount);
            for (int i = 0; i < splitPoint; ++i) {
                index = indexes.get(i);
                pages = reader.readFilteredRowGroup(index);
                this.assertFilteredValues(pages, fromNumber, toNumber, index, blockAmount);
            }
            pages = reader.readNextFilteredRowGroup();
            this.assertFilteredValues(pages, fromNumber, toNumber, 1, blockAmount);
            for (int i = splitPoint; i < indexes.size(); ++i) {
                index = indexes.get(i);
                pages = reader.readFilteredRowGroup(index);
                this.assertFilteredValues(pages, fromNumber, toNumber, index, blockAmount);
            }
            pages = reader.readNextFilteredRowGroup();
            this.assertFilteredValues(pages, fromNumber, toNumber, 2, blockAmount);
        }
    }

    public static class DataContextRandom
    extends DataContext {
        public DataContextRandom(long seed, File path, int blockSize, int pageSize, boolean enableDictionary, ParquetProperties.WriterVersion version) throws IOException {
            super(seed, path, blockSize, pageSize, enableDictionary, version);
        }

        @Override
        protected void test(ParquetFileReader reader, List<Integer> indexes, List<Long> fromNumber, List<Long> toNumber, int blockAmount) throws IOException {
            for (int index : indexes) {
                PageReadStore pages = reader.readRowGroup(index);
                this.assertValues(pages, fromNumber, toNumber, index, blockAmount);
            }
        }

        @Override
        protected void testFiltered(ParquetFileReader reader, List<Integer> indexes, List<Long> fromNumber, List<Long> toNumber, int blockAmount) throws IOException {
            for (int index : indexes) {
                PageReadStore pages = reader.readFilteredRowGroup(index);
                this.assertFilteredValues(pages, fromNumber, toNumber, index, blockAmount);
            }
        }
    }

    public static abstract class DataContext
    extends DataGenerationContext.WriteContext {
        private static final int recordCount = 1000000;
        private final List<RandomValues.RandomValueGenerator<?>> randomGenerators;
        private final Random random;
        private final FilterCompat.Filter filter;

        public DataContext(long seed, File path, int blockSize, int pageSize, boolean enableDictionary, ParquetProperties.WriterVersion version) throws IOException {
            super(path, DataContext.buildSchema(), blockSize, pageSize, enableDictionary, true, version);
            this.random = new Random(seed);
            this.randomGenerators = Arrays.asList(new SequentialLongGenerator(), new SequentialFlippingLongGenerator());
            this.filter = FilterCompat.get((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"i64_flip"), (Comparable)Long.valueOf(1L)));
        }

        private static MessageType buildSchema() {
            return new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "i64"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "i64_flip")});
        }

        @Override
        public void write(ParquetWriter<Group> writer) throws IOException {
            for (int index = 0; index < 1000000; ++index) {
                SimpleGroup group = new SimpleGroup((GroupType)this.schema);
                int columnCnt = this.schema.getFieldCount();
                for (int column = 0; column < columnCnt; ++column) {
                    Type type = this.schema.getType(column);
                    RandomValues.RandomValueGenerator<?> generator = this.randomGenerators.get(column);
                    if (type.isRepetition(Type.Repetition.OPTIONAL) && generator.shouldGenerateNull()) continue;
                    group.append(type.getName(), ((Long)generator.nextValue()).longValue());
                }
                writer.write((Object)group);
            }
        }

        @Override
        public void test() throws IOException {
            int blockAmount;
            Configuration configuration = new Configuration();
            ParquetReadOptions options = ParquetReadOptions.builder().build();
            ParquetReadOptions filterOptions = ParquetReadOptions.builder().copy(options).withRecordFilter(this.filter).useDictionaryFilter(true).useStatsFilter(true).useRecordFilter(true).useColumnIndexFilter(true).build();
            ArrayList<Long> fromNumber = new ArrayList<Long>();
            ArrayList<Long> toNumber = new ArrayList<Long>();
            try (ParquetFileReader reader = new ParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)this.fsPath, (Configuration)configuration), options);){
                PageReadStore pages;
                blockAmount = reader.getRowGroups().size();
                while ((pages = reader.readNextRowGroup()) != null) {
                    MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(this.schema);
                    RecordReader recordReader = columnIO.getRecordReader(pages, (RecordMaterializer)new GroupRecordConverter(this.schema));
                    long rowCount = pages.getRowCount();
                    long from = ((Group)recordReader.read()).getLong("i64", 0);
                    int i = 1;
                    while ((long)i < rowCount - 1L) {
                        recordReader.read();
                        ++i;
                    }
                    Group group = (Group)recordReader.read();
                    long to = group == null ? from : group.getLong("i64", 0);
                    fromNumber.add(from);
                    toNumber.add(to);
                }
            }
            ArrayList<Integer> indexes = new ArrayList<Integer>();
            for (int j = 0; j < 4; ++j) {
                for (int i = 0; i < blockAmount; ++i) {
                    indexes.add(i);
                }
                indexes.add(-1);
                indexes.add(blockAmount);
                indexes.add(blockAmount + 1);
            }
            Collections.shuffle(indexes, this.random);
            try (ParquetFileReader reader = new ParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)this.fsPath, (Configuration)configuration), options);){
                this.test(reader, indexes, fromNumber, toNumber, blockAmount);
            }
            reader = new ParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)this.fsPath, (Configuration)configuration), filterOptions);
            try {
                this.testFiltered(reader, indexes, fromNumber, toNumber, blockAmount);
            }
            finally {
                reader.close();
            }
        }

        public void assertValues(PageReadStore pages, List<Long> fromNumber, List<Long> toNumber, int index, int blockAmount) {
            if (index < 0 || index >= blockAmount) {
                Assert.assertNull((Object)pages);
                return;
            }
            long firstValue = fromNumber.get(index);
            long lastValue = toNumber.get(index);
            MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(this.schema);
            RecordReader recordReader = columnIO.getRecordReader(pages, (RecordMaterializer)new GroupRecordConverter(this.schema));
            for (long i = firstValue; i <= lastValue; ++i) {
                Group group = (Group)recordReader.read();
                Assert.assertEquals((long)i, (long)group.getLong("i64", 0));
                Assert.assertEquals((long)(i % 2L == 0L ? 1L : 0L), (long)group.getLong("i64_flip", 0));
            }
            boolean exceptionThrown = false;
            try {
                recordReader.read();
            }
            catch (ParquetDecodingException e) {
                exceptionThrown = true;
            }
            Assert.assertTrue((boolean)exceptionThrown);
        }

        public void assertFilteredValues(PageReadStore pages, List<Long> fromNumber, List<Long> toNumber, int index, int blockAmount) {
            if (index < 0 || index >= blockAmount) {
                Assert.assertNull((Object)pages);
                return;
            }
            long firstValue = fromNumber.get(index);
            long lastValue = toNumber.get(index);
            MessageColumnIO columnIO = new ColumnIOFactory().getColumnIO(this.schema);
            RecordReader recordReader = columnIO.getRecordReader(pages, (RecordMaterializer)new GroupRecordConverter(this.schema), this.filter);
            for (long i = firstValue; i <= lastValue; ++i) {
                Group group = (Group)recordReader.read();
                if (i % 2L == 0L) {
                    Assert.assertEquals((long)i, (long)group.getLong("i64", 0));
                    Assert.assertEquals((long)1L, (long)group.getLong("i64_flip", 0));
                    continue;
                }
                Assert.assertTrue((group == null || recordReader.shouldSkipCurrentRecord() ? 1 : 0) != 0);
            }
            boolean exceptionThrown = false;
            try {
                recordReader.read();
            }
            catch (ParquetDecodingException e) {
                exceptionThrown = true;
            }
            Assert.assertTrue((boolean)exceptionThrown);
        }

        protected abstract void test(ParquetFileReader var1, List<Integer> var2, List<Long> var3, List<Long> var4, int var5) throws IOException;

        protected abstract void testFiltered(ParquetFileReader var1, List<Integer> var2, List<Long> var3, List<Long> var4, int var5) throws IOException;
    }

    public static class SequentialFlippingLongGenerator
    extends RandomValues.RandomValueGenerator<Long> {
        private long value = 0L;

        protected SequentialFlippingLongGenerator() {
            super(0L);
        }

        @Override
        public Long nextValue() {
            this.value = this.value == 0L ? 1L : 0L;
            return this.value;
        }
    }

    public static class SequentialLongGenerator
    extends RandomValues.RandomValueGenerator<Long> {
        private long value = 0L;

        protected SequentialLongGenerator() {
            super(0L);
        }

        @Override
        public Long nextValue() {
            return this.value++;
        }
    }
}

