/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import okhttp3.OkHttpClient;
import okhttp3.Request;
import okhttp3.Response;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FSDataOutputStream;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.crypto.ColumnDecryptionProperties;
import org.apache.parquet.crypto.ColumnEncryptionProperties;
import org.apache.parquet.crypto.DecryptionKeyRetriever;
import org.apache.parquet.crypto.DecryptionKeyRetrieverMock;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.crypto.SingleRow;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.rules.TemporaryFolder;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public class TestEncryptionOptions {
    private static final Logger LOG = LoggerFactory.getLogger(TestEncryptionOptions.class);
    private static final String PARQUET_TESTING_REPO = "https://github.com/apache/parquet-testing/raw/40379b3/data/";
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ErrorCollector localErrorCollector = new ErrorCollector();
    private ErrorCollector errorCollector;
    private static String PARQUET_TESTING_PATH = "target/parquet-testing/data";
    private static final byte[] FOOTER_ENCRYPTION_KEY = "0123456789012345".getBytes();
    private static final byte[][] COLUMN_ENCRYPTION_KEYS = new byte[][]{"1234567890123450".getBytes(), "1234567890123451".getBytes(), "1234567890123452".getBytes(), "1234567890123453".getBytes(), "1234567890123454".getBytes(), "1234567890123455".getBytes()};
    private static final String[] COLUMN_ENCRYPTION_KEY_IDS = new String[]{"kc1", "kc2", "kc3", "kc4", "kc5", "kc6"};
    private static final String FOOTER_ENCRYPTION_KEY_ID = "kf";
    private static final String AAD_PREFIX_STRING = "tester";
    private static final byte[] footerKeyMetadata = "kf".getBytes(StandardCharsets.UTF_8);
    private static final byte[] AADPrefix = "tester".getBytes(StandardCharsets.UTF_8);
    private static final int ROW_COUNT = 10000;
    private static final List<SingleRow> DATA = Collections.unmodifiableList(SingleRow.generateRandomData(10000));
    private static final List<SingleRow> LINEAR_DATA = Collections.unmodifiableList(SingleRow.generateLinearData(250));
    private static final MessageType SCHEMA = SingleRow.getSchema();
    private static final DecryptionKeyRetrieverMock decryptionKeyRetrieverMock = new DecryptionKeyRetrieverMock().putKey("kf", FOOTER_ENCRYPTION_KEY).putKey(COLUMN_ENCRYPTION_KEY_IDS[0], COLUMN_ENCRYPTION_KEYS[0]).putKey(COLUMN_ENCRYPTION_KEY_IDS[1], COLUMN_ENCRYPTION_KEYS[1]).putKey(COLUMN_ENCRYPTION_KEY_IDS[2], COLUMN_ENCRYPTION_KEYS[2]).putKey(COLUMN_ENCRYPTION_KEY_IDS[3], COLUMN_ENCRYPTION_KEYS[3]).putKey(COLUMN_ENCRYPTION_KEY_IDS[4], COLUMN_ENCRYPTION_KEYS[4]).putKey(COLUMN_ENCRYPTION_KEY_IDS[5], COLUMN_ENCRYPTION_KEYS[5]);

    @Test
    public void testWriteReadEncryptedParquetFiles() throws IOException {
        this.errorCollector = this.localErrorCollector;
        Path rootPath = new Path(this.temporaryFolder.getRoot().getPath());
        LOG.info("======== testWriteReadEncryptedParquetFiles {} ========", (Object)rootPath.toString());
        byte[] AADPrefix = AAD_PREFIX_STRING.getBytes(StandardCharsets.UTF_8);
        this.testWriteEncryptedParquetFiles(rootPath, DATA);
        this.testReadEncryptedParquetFiles(rootPath, DATA);
    }

    public void testInteropReadEncryptedParquetFiles(ErrorCollector errorCollector, OkHttpClient httpClient) throws IOException {
        this.errorCollector = errorCollector;
        Path rootPath = new Path(PARQUET_TESTING_PATH);
        LOG.info("======== testInteropReadEncryptedParquetFiles {} ========", (Object)rootPath.toString());
        boolean readOnlyEncrypted = true;
        this.downloadInteropFiles(rootPath, readOnlyEncrypted, httpClient);
        byte[] AADPrefix = AAD_PREFIX_STRING.getBytes(StandardCharsets.UTF_8);
        this.testInteropReadEncryptedParquetFiles(rootPath, readOnlyEncrypted, LINEAR_DATA);
    }

    private void testWriteEncryptedParquetFiles(Path root, List<SingleRow> data) throws IOException {
        EncryptionConfiguration[] encryptionConfigurations;
        Configuration conf = new Configuration();
        int pageSize = data.size() / 10;
        int rowGroupSize = pageSize * 6 * 5;
        SimpleGroupFactory f = new SimpleGroupFactory(SCHEMA);
        for (EncryptionConfiguration encryptionConfiguration : encryptionConfigurations = EncryptionConfiguration.values()) {
            Path file = new Path(root, this.getFileName(encryptionConfiguration));
            FileEncryptionProperties encryptionProperties = encryptionConfiguration.getEncryptionProperties();
            LOG.info("\nWrite " + file.toString());
            try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)file).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withRowGroupSize(rowGroupSize)).withPageSize(pageSize)).withType(SCHEMA).withConf(conf)).withEncryption(encryptionProperties)).build();){
                for (SingleRow singleRow : data) {
                    writer.write((Object)f.newGroup().append("boolean_field", singleRow.boolean_field).append("int32_field", singleRow.int32_field).append("float_field", singleRow.float_field).append("double_field", singleRow.double_field).append("ba_field", Binary.fromConstantByteArray((byte[])singleRow.ba_field)).append("flba_field", Binary.fromConstantByteArray((byte[])singleRow.flba_field)).append("plain_int32_field", singleRow.plaintext_int32_field.intValue()));
                }
            }
        }
    }

    private String getFileName(EncryptionConfiguration encryptionConfiguration) {
        return encryptionConfiguration.toString().toLowerCase() + ".parquet.encrypted";
    }

    private void testReadEncryptedParquetFiles(Path root, List<SingleRow> data) {
        DecryptionConfiguration[] decryptionConfigurations;
        Configuration conf = new Configuration();
        for (DecryptionConfiguration decryptionConfiguration : decryptionConfigurations = DecryptionConfiguration.values()) {
            EncryptionConfiguration[] encryptionConfigurations;
            for (EncryptionConfiguration encryptionConfiguration : encryptionConfigurations = EncryptionConfiguration.values()) {
                Path file = new Path(root, this.getFileName(encryptionConfiguration));
                LOG.info("==> Decryption configuration {}", (Object)decryptionConfiguration);
                FileDecryptionProperties fileDecryptionProperties = decryptionConfiguration.getDecryptionProperties();
                LOG.info("--> Read file {} {}", (Object)file.toString(), (Object)encryptionConfiguration);
                if (decryptionConfiguration == DecryptionConfiguration.NO_DECRYPTION && encryptionConfiguration == EncryptionConfiguration.ENCRYPT_COLUMNS_PLAINTEXT_FOOTER) {
                    conf.set("parquet.read.schema", ((MessageType)((Types.GroupBuilder)Types.buildMessage().optional(PrimitiveType.PrimitiveTypeName.INT32).named("plain_int32_field")).named("FormatTestObject")).toString());
                }
                int rowNum = 0;
                try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).withConf(conf).withDecryption(fileDecryptionProperties).build();){
                    Group group = (Group)reader.read();
                    while (group != null) {
                        SingleRow rowExpected = data.get(rowNum++);
                        if (rowExpected.plaintext_int32_field.intValue() != group.getInteger("plain_int32_field", 0)) {
                            this.addErrorToErrorCollectorAndLog("Wrong int", encryptionConfiguration, decryptionConfiguration);
                        }
                        if (decryptionConfiguration != DecryptionConfiguration.NO_DECRYPTION) {
                            if (rowExpected.boolean_field != group.getBoolean("boolean_field", 0)) {
                                this.addErrorToErrorCollectorAndLog("Wrong bool", encryptionConfiguration, decryptionConfiguration);
                            }
                            if (rowExpected.int32_field != group.getInteger("int32_field", 0)) {
                                this.addErrorToErrorCollectorAndLog("Wrong int", encryptionConfiguration, decryptionConfiguration);
                            }
                            if (rowExpected.float_field != group.getFloat("float_field", 0)) {
                                this.addErrorToErrorCollectorAndLog("Wrong float", encryptionConfiguration, decryptionConfiguration);
                            }
                            if (rowExpected.double_field != group.getDouble("double_field", 0)) {
                                this.addErrorToErrorCollectorAndLog("Wrong double", encryptionConfiguration, decryptionConfiguration);
                            }
                            if (null != rowExpected.ba_field && !Arrays.equals(rowExpected.ba_field, group.getBinary("ba_field", 0).getBytes())) {
                                this.addErrorToErrorCollectorAndLog("Wrong byte array", encryptionConfiguration, decryptionConfiguration);
                            }
                            if (!Arrays.equals(rowExpected.flba_field, group.getBinary("flba_field", 0).getBytes())) {
                                this.addErrorToErrorCollectorAndLog("Wrong fixed-length byte array", encryptionConfiguration, decryptionConfiguration);
                            }
                        }
                        group = (Group)reader.read();
                    }
                }
                catch (ParquetCryptoRuntimeException e) {
                    this.checkResult(file.getName(), decryptionConfiguration, e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.addErrorToErrorCollectorAndLog("Unexpected exception: " + e.getClass().getName() + " with message: " + e.getMessage(), encryptionConfiguration, decryptionConfiguration);
                }
                conf.unset("parquet.read.schema");
            }
        }
    }

    private void downloadInteropFiles(Path rootPath, boolean readOnlyEncrypted, OkHttpClient httpClient) throws IOException {
        EncryptionConfiguration[] encryptionConfigurations;
        LOG.info("Download interop files if needed");
        Configuration conf = new Configuration();
        FileSystem fs = rootPath.getFileSystem(conf);
        LOG.info(rootPath + " exists?: " + fs.exists(rootPath));
        if (!fs.exists(rootPath)) {
            LOG.info("Create folder for interop files: " + rootPath);
            if (!fs.mkdirs(rootPath)) {
                throw new IOException("Cannot create path " + rootPath);
            }
        }
        for (EncryptionConfiguration encryptionConfiguration : encryptionConfigurations = EncryptionConfiguration.values()) {
            String fileName;
            Path file;
            if (readOnlyEncrypted && EncryptionConfiguration.NO_ENCRYPTION == encryptionConfiguration || EncryptionConfiguration.UNIFORM_ENCRYPTION_PLAINTEXT_FOOTER == encryptionConfiguration || fs.exists(file = new Path(rootPath, fileName = this.getFileName(encryptionConfiguration)))) continue;
            String downloadUrl = PARQUET_TESTING_REPO + fileName;
            LOG.info("Download interop file: " + downloadUrl);
            Request request = new Request.Builder().url(downloadUrl).build();
            Response response = httpClient.newCall(request).execute();
            if (!response.isSuccessful()) {
                throw new IOException("Failed to download file: " + response);
            }
            try (FSDataOutputStream fdos = fs.create(file);){
                fdos.write(response.body().bytes());
            }
        }
    }

    private void testInteropReadEncryptedParquetFiles(Path root, boolean readOnlyEncrypted, List<SingleRow> data) throws IOException {
        DecryptionConfiguration[] decryptionConfigurations;
        Configuration conf = new Configuration();
        for (DecryptionConfiguration decryptionConfiguration : decryptionConfigurations = DecryptionConfiguration.values()) {
            EncryptionConfiguration[] encryptionConfigurations;
            for (EncryptionConfiguration encryptionConfiguration : encryptionConfigurations = EncryptionConfiguration.values()) {
                if (readOnlyEncrypted && EncryptionConfiguration.NO_ENCRYPTION == encryptionConfiguration || EncryptionConfiguration.UNIFORM_ENCRYPTION_PLAINTEXT_FOOTER == encryptionConfiguration) continue;
                Path file = new Path(root, this.getFileName(encryptionConfiguration));
                LOG.info("==> Decryption configuration {}", (Object)decryptionConfiguration);
                FileDecryptionProperties fileDecryptionProperties = decryptionConfiguration.getDecryptionProperties();
                LOG.info("--> Read file {} {}", (Object)file.toString(), (Object)encryptionConfiguration);
                if (decryptionConfiguration == DecryptionConfiguration.NO_DECRYPTION && encryptionConfiguration == EncryptionConfiguration.ENCRYPT_COLUMNS_PLAINTEXT_FOOTER) {
                    conf.set("parquet.read.schema", ((MessageType)((Types.GroupBuilder)((Types.GroupBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BOOLEAN).named("boolean_field")).required(PrimitiveType.PrimitiveTypeName.INT32).named("int32_field")).named("FormatTestObject")).toString());
                }
                int rowNum = 0;
                try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).withConf(conf).withDecryption(fileDecryptionProperties).build();){
                    Group group = (Group)reader.read();
                    while (group != null) {
                        SingleRow rowExpected = data.get(rowNum++);
                        if (rowExpected.boolean_field != group.getBoolean("boolean_field", 0)) {
                            this.addErrorToErrorCollectorAndLog("Wrong bool", encryptionConfiguration, decryptionConfiguration);
                        }
                        if (rowExpected.int32_field != group.getInteger("int32_field", 0)) {
                            this.addErrorToErrorCollectorAndLog("Wrong int", encryptionConfiguration, decryptionConfiguration);
                        }
                        if (decryptionConfiguration != DecryptionConfiguration.NO_DECRYPTION) {
                            if (rowExpected.float_field != group.getFloat("float_field", 0)) {
                                this.addErrorToErrorCollectorAndLog("Wrong float", encryptionConfiguration, decryptionConfiguration);
                            }
                            if (rowExpected.double_field != group.getDouble("double_field", 0)) {
                                this.addErrorToErrorCollectorAndLog("Wrong double", encryptionConfiguration, decryptionConfiguration);
                            }
                        }
                        group = (Group)reader.read();
                    }
                }
                catch (ParquetCryptoRuntimeException e) {
                    this.checkResult(file.getName(), decryptionConfiguration, e);
                }
                catch (Exception e) {
                    e.printStackTrace();
                    this.addErrorToErrorCollectorAndLog("Unexpected exception: " + e.getClass().getName() + " with message: " + e.getMessage(), encryptionConfiguration, decryptionConfiguration);
                }
                conf.unset("parquet.read.schema");
            }
        }
    }

    private void checkResult(String file, DecryptionConfiguration decryptionConfiguration, ParquetCryptoRuntimeException exception) {
        String errorMessage = exception.getMessage();
        String exceptionMsg = null == errorMessage ? exception.toString() : errorMessage;
        EncryptionConfiguration encryptionConfiguration = this.getEncryptionConfigurationFromFilename(file);
        if (encryptionConfiguration == EncryptionConfiguration.ENCRYPT_COLUMNS_AND_FOOTER_DISABLE_AAD_STORAGE && (decryptionConfiguration == DecryptionConfiguration.DECRYPT_WITH_KEY_RETRIEVER || decryptionConfiguration == DecryptionConfiguration.DECRYPT_WITH_EXPLICIT_KEYS)) {
            if (!exceptionMsg.contains("AAD")) {
                this.addErrorToErrorCollectorAndLog("Expecting AAD related exception", exceptionMsg, encryptionConfiguration, decryptionConfiguration);
            } else {
                LOG.info("Exception as expected: " + exceptionMsg);
            }
            return;
        }
        if (decryptionConfiguration == DecryptionConfiguration.DECRYPT_WITH_KEY_RETRIEVER_AAD && encryptionConfiguration != EncryptionConfiguration.ENCRYPT_COLUMNS_AND_FOOTER_DISABLE_AAD_STORAGE && encryptionConfiguration != EncryptionConfiguration.ENCRYPT_COLUMNS_AND_FOOTER_AAD && encryptionConfiguration != EncryptionConfiguration.NO_ENCRYPTION) {
            if (!exceptionMsg.contains("AAD")) {
                this.addErrorToErrorCollectorAndLog("Expecting AAD related exception", exceptionMsg, encryptionConfiguration, decryptionConfiguration);
            } else {
                LOG.info("Exception as expected: " + exceptionMsg);
            }
            return;
        }
        if (encryptionConfiguration == EncryptionConfiguration.NO_ENCRYPTION && (decryptionConfiguration == DecryptionConfiguration.DECRYPT_WITH_KEY_RETRIEVER || decryptionConfiguration == DecryptionConfiguration.DECRYPT_WITH_KEY_RETRIEVER_AAD || decryptionConfiguration == DecryptionConfiguration.DECRYPT_WITH_EXPLICIT_KEYS)) {
            if (!exceptionMsg.endsWith("Applying decryptor on plaintext file")) {
                this.addErrorToErrorCollectorAndLog("Expecting exception Applying decryptor on plaintext file", exceptionMsg, encryptionConfiguration, decryptionConfiguration);
            } else {
                LOG.info("Exception as expected: " + exceptionMsg);
            }
            return;
        }
        if (decryptionConfiguration == DecryptionConfiguration.NO_DECRYPTION && encryptionConfiguration != EncryptionConfiguration.NO_ENCRYPTION && encryptionConfiguration != EncryptionConfiguration.ENCRYPT_COLUMNS_PLAINTEXT_FOOTER) {
            if (!(exceptionMsg.endsWith("No keys available") || exceptionMsg.endsWith("Null File Decryptor") || exceptionMsg.endsWith("Footer key unavailable"))) {
                this.addErrorToErrorCollectorAndLog("Expecting No keys available exception", exceptionMsg, encryptionConfiguration, decryptionConfiguration);
            } else {
                LOG.info("Exception as expected: " + exceptionMsg);
            }
            return;
        }
        exception.printStackTrace();
        this.addErrorToErrorCollectorAndLog("Didn't expect an exception", exceptionMsg, encryptionConfiguration, decryptionConfiguration);
    }

    private EncryptionConfiguration getEncryptionConfigurationFromFilename(String file) {
        if (!file.endsWith(".parquet.encrypted")) {
            return null;
        }
        String fileNamePrefix = file.replaceFirst(".parquet.encrypted", "");
        try {
            EncryptionConfiguration encryptionConfiguration = EncryptionConfiguration.valueOf(fileNamePrefix.toUpperCase());
            return encryptionConfiguration;
        }
        catch (IllegalArgumentException e) {
            LOG.error("File name doesn't match any known encryption configuration: " + file);
            this.errorCollector.addError((Throwable)e);
            return null;
        }
    }

    private void addErrorToErrorCollectorAndLog(String errorMessage, String exceptionMessage, EncryptionConfiguration encryptionConfiguration, DecryptionConfiguration decryptionConfiguration) {
        String fullErrorMessage = String.format("%s - %s Error: %s, but got [%s]", new Object[]{encryptionConfiguration, decryptionConfiguration, errorMessage, exceptionMessage});
        this.errorCollector.addError(new Throwable(fullErrorMessage));
        LOG.error(fullErrorMessage);
    }

    private void addErrorToErrorCollectorAndLog(String errorMessage, EncryptionConfiguration encryptionConfiguration, DecryptionConfiguration decryptionConfiguration) {
        String fullErrorMessage = String.format("%s - %s Error: %s", new Object[]{encryptionConfiguration, decryptionConfiguration, errorMessage});
        this.errorCollector.addError(new Throwable(fullErrorMessage));
        LOG.error(fullErrorMessage);
    }

    private static Map<ColumnPath, ColumnEncryptionProperties> getColumnEncryptionPropertiesMap() {
        HashMap<ColumnPath, ColumnEncryptionProperties> columnPropertiesMap = new HashMap<ColumnPath, ColumnEncryptionProperties>();
        ColumnEncryptionProperties columnPropertiesDouble = ColumnEncryptionProperties.builder((String)"double_field").withKey(COLUMN_ENCRYPTION_KEYS[0]).withKeyID(COLUMN_ENCRYPTION_KEY_IDS[0]).build();
        columnPropertiesMap.put(columnPropertiesDouble.getPath(), columnPropertiesDouble);
        ColumnEncryptionProperties columnPropertiesFloat = ColumnEncryptionProperties.builder((String)"float_field").withKey(COLUMN_ENCRYPTION_KEYS[1]).withKeyID(COLUMN_ENCRYPTION_KEY_IDS[1]).build();
        columnPropertiesMap.put(columnPropertiesFloat.getPath(), columnPropertiesFloat);
        ColumnEncryptionProperties columnPropertiesBool = ColumnEncryptionProperties.builder((String)"boolean_field").withKey(COLUMN_ENCRYPTION_KEYS[2]).withKeyID(COLUMN_ENCRYPTION_KEY_IDS[2]).build();
        columnPropertiesMap.put(columnPropertiesBool.getPath(), columnPropertiesBool);
        ColumnEncryptionProperties columnPropertiesInt32 = ColumnEncryptionProperties.builder((String)"int32_field").withKey(COLUMN_ENCRYPTION_KEYS[3]).withKeyID(COLUMN_ENCRYPTION_KEY_IDS[3]).build();
        columnPropertiesMap.put(columnPropertiesInt32.getPath(), columnPropertiesInt32);
        ColumnEncryptionProperties columnPropertiesBinary = ColumnEncryptionProperties.builder((String)"ba_field").withKey(COLUMN_ENCRYPTION_KEYS[4]).withKeyID(COLUMN_ENCRYPTION_KEY_IDS[4]).build();
        columnPropertiesMap.put(columnPropertiesBinary.getPath(), columnPropertiesBinary);
        ColumnEncryptionProperties columnPropertiesFixed = ColumnEncryptionProperties.builder((String)"flba_field").withKey(COLUMN_ENCRYPTION_KEYS[5]).withKeyID(COLUMN_ENCRYPTION_KEY_IDS[5]).build();
        columnPropertiesMap.put(columnPropertiesFixed.getPath(), columnPropertiesFixed);
        return columnPropertiesMap;
    }

    private static Map<ColumnPath, ColumnDecryptionProperties> getColumnDecryptionPropertiesMap() {
        HashMap<ColumnPath, ColumnDecryptionProperties> columnMap = new HashMap<ColumnPath, ColumnDecryptionProperties>();
        ColumnDecryptionProperties columnDecryptionPropsDouble = ColumnDecryptionProperties.builder((String)"double_field").withKey(COLUMN_ENCRYPTION_KEYS[0]).build();
        columnMap.put(columnDecryptionPropsDouble.getPath(), columnDecryptionPropsDouble);
        ColumnDecryptionProperties columnDecryptionPropsFloat = ColumnDecryptionProperties.builder((String)"float_field").withKey(COLUMN_ENCRYPTION_KEYS[1]).build();
        columnMap.put(columnDecryptionPropsFloat.getPath(), columnDecryptionPropsFloat);
        ColumnDecryptionProperties columnDecryptionPropsBool = ColumnDecryptionProperties.builder((String)"boolean_field").withKey(COLUMN_ENCRYPTION_KEYS[2]).build();
        columnMap.put(columnDecryptionPropsBool.getPath(), columnDecryptionPropsBool);
        ColumnDecryptionProperties columnDecryptionPropsInt32 = ColumnDecryptionProperties.builder((String)"int32_field").withKey(COLUMN_ENCRYPTION_KEYS[3]).build();
        columnMap.put(columnDecryptionPropsInt32.getPath(), columnDecryptionPropsInt32);
        ColumnDecryptionProperties columnDecryptionPropsBinary = ColumnDecryptionProperties.builder((String)"ba_field").withKey(COLUMN_ENCRYPTION_KEYS[4]).build();
        columnMap.put(columnDecryptionPropsBinary.getPath(), columnDecryptionPropsBinary);
        ColumnDecryptionProperties columnDecryptionPropsFixed = ColumnDecryptionProperties.builder((String)"flba_field").withKey(COLUMN_ENCRYPTION_KEYS[5]).build();
        columnMap.put(columnDecryptionPropsFixed.getPath(), columnDecryptionPropsFixed);
        return columnMap;
    }

    public static enum DecryptionConfiguration {
        DECRYPT_WITH_KEY_RETRIEVER{

            @Override
            public FileDecryptionProperties getDecryptionProperties() {
                return FileDecryptionProperties.builder().withKeyRetriever((DecryptionKeyRetriever)decryptionKeyRetrieverMock).build();
            }
        }
        ,
        DECRYPT_WITH_KEY_RETRIEVER_AAD{

            @Override
            public FileDecryptionProperties getDecryptionProperties() {
                return FileDecryptionProperties.builder().withKeyRetriever((DecryptionKeyRetriever)decryptionKeyRetrieverMock).withAADPrefix(AADPrefix).build();
            }
        }
        ,
        DECRYPT_WITH_EXPLICIT_KEYS{

            @Override
            public FileDecryptionProperties getDecryptionProperties() {
                Map columnMap = TestEncryptionOptions.getColumnDecryptionPropertiesMap();
                return FileDecryptionProperties.builder().withColumnKeys(columnMap).withFooterKey(FOOTER_ENCRYPTION_KEY).build();
            }
        }
        ,
        NO_DECRYPTION{

            @Override
            public FileDecryptionProperties getDecryptionProperties() {
                return null;
            }
        };


        public abstract FileDecryptionProperties getDecryptionProperties();
    }

    public static enum EncryptionConfiguration {
        UNIFORM_ENCRYPTION{

            @Override
            public FileEncryptionProperties getEncryptionProperties() {
                return FileEncryptionProperties.builder((byte[])FOOTER_ENCRYPTION_KEY).withFooterKeyMetadata(footerKeyMetadata).build();
            }
        }
        ,
        ENCRYPT_COLUMNS_AND_FOOTER{

            @Override
            public FileEncryptionProperties getEncryptionProperties() {
                Map columnPropertiesMap = TestEncryptionOptions.getColumnEncryptionPropertiesMap();
                return FileEncryptionProperties.builder((byte[])FOOTER_ENCRYPTION_KEY).withFooterKeyMetadata(footerKeyMetadata).withEncryptedColumns(columnPropertiesMap).build();
            }
        }
        ,
        ENCRYPT_COLUMNS_PLAINTEXT_FOOTER{

            @Override
            public FileEncryptionProperties getEncryptionProperties() {
                Map columnPropertiesMap = TestEncryptionOptions.getColumnEncryptionPropertiesMap();
                return FileEncryptionProperties.builder((byte[])FOOTER_ENCRYPTION_KEY).withFooterKeyMetadata(footerKeyMetadata).withEncryptedColumns(columnPropertiesMap).withPlaintextFooter().build();
            }
        }
        ,
        ENCRYPT_COLUMNS_AND_FOOTER_AAD{

            @Override
            public FileEncryptionProperties getEncryptionProperties() {
                Map columnPropertiesMap = TestEncryptionOptions.getColumnEncryptionPropertiesMap();
                return FileEncryptionProperties.builder((byte[])FOOTER_ENCRYPTION_KEY).withFooterKeyMetadata(footerKeyMetadata).withEncryptedColumns(columnPropertiesMap).withAADPrefix(AADPrefix).build();
            }
        }
        ,
        ENCRYPT_COLUMNS_AND_FOOTER_DISABLE_AAD_STORAGE{

            @Override
            public FileEncryptionProperties getEncryptionProperties() {
                Map columnPropertiesMap = TestEncryptionOptions.getColumnEncryptionPropertiesMap();
                return FileEncryptionProperties.builder((byte[])FOOTER_ENCRYPTION_KEY).withFooterKeyMetadata(footerKeyMetadata).withEncryptedColumns(columnPropertiesMap).withAADPrefix(AADPrefix).withoutAADPrefixStorage().build();
            }
        }
        ,
        ENCRYPT_COLUMNS_AND_FOOTER_CTR{

            @Override
            public FileEncryptionProperties getEncryptionProperties() {
                Map columnPropertiesMap = TestEncryptionOptions.getColumnEncryptionPropertiesMap();
                return FileEncryptionProperties.builder((byte[])FOOTER_ENCRYPTION_KEY).withFooterKeyMetadata(footerKeyMetadata).withEncryptedColumns(columnPropertiesMap).withAlgorithm(ParquetCipher.AES_GCM_CTR_V1).build();
            }
        }
        ,
        UNIFORM_ENCRYPTION_PLAINTEXT_FOOTER{

            @Override
            public FileEncryptionProperties getEncryptionProperties() {
                return FileEncryptionProperties.builder((byte[])FOOTER_ENCRYPTION_KEY).withPlaintextFooter().withFooterKeyMetadata(footerKeyMetadata).build();
            }
        }
        ,
        NO_ENCRYPTION{

            @Override
            public FileEncryptionProperties getEncryptionProperties() {
                return null;
            }
        };


        public abstract FileEncryptionProperties getEncryptionProperties();
    }
}

