/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.Collections;
import java.util.HashMap;
import java.util.List;
import java.util.Random;
import java.util.zip.CRC32;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.Page;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageWriter;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.ColumnChunkPageWriteStore;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.codec.SnappyCompressor;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.ParquetDecodingException;
import org.apache.parquet.io.PositionOutputStream;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestDataPageV1Checksums {
    @Rule
    public final TemporaryFolder tempFolder = new TemporaryFolder();
    private static final Statistics<?> EMPTY_STATS_INT32 = Statistics.getBuilderForReading((PrimitiveType)((PrimitiveType)Types.required((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("a"))).build();
    private CRC32 crc = new CRC32();
    private static final int PAGE_SIZE = 0x100000;
    private static final MessageType schemaSimple = MessageTypeParser.parseMessageType((String)"message m {  required int32 a;  required int32 b;}");
    private static final ColumnDescriptor colADesc = (ColumnDescriptor)schemaSimple.getColumns().get(0);
    private static final ColumnDescriptor colBDesc = (ColumnDescriptor)schemaSimple.getColumns().get(1);
    private static final byte[] colAPage1Bytes = new byte[0x100000];
    private static final byte[] colAPage2Bytes = new byte[0x100000];
    private static final byte[] colBPage1Bytes = new byte[0x100000];
    private static final byte[] colBPage2Bytes = new byte[0x100000];
    private static final int numRecordsLargeFile = 524288;
    private static final MessageType schemaNestedWithNulls = MessageTypeParser.parseMessageType((String)"message m {  optional group c {    required int64 id;    required group d {      repeated int32 val;    }  }}");
    private static final ColumnDescriptor colCIdDesc = (ColumnDescriptor)schemaNestedWithNulls.getColumns().get(0);
    private static final ColumnDescriptor colDValDesc = (ColumnDescriptor)schemaNestedWithNulls.getColumns().get(1);
    private static final double nullRatio = 0.3;
    private static final int numRecordsNestedWithNullsFile = 2000;

    private Path writeSimpleParquetFile(Configuration conf, CompressionCodecName compression) throws IOException {
        File file = this.tempFolder.newFile();
        file.delete();
        Path path = new Path(file.toURI());
        for (int i = 0; i < 0x100000; ++i) {
            TestDataPageV1Checksums.colAPage1Bytes[i] = (byte)i;
            TestDataPageV1Checksums.colAPage2Bytes[i] = (byte)(-i);
            TestDataPageV1Checksums.colBPage1Bytes[i] = (byte)(i + 100);
            TestDataPageV1Checksums.colBPage2Bytes[i] = (byte)(i - 100);
        }
        ParquetFileWriter writer = new ParquetFileWriter(conf, schemaSimple, path, 0x8000000L, 0x800000);
        writer.start();
        writer.startBlock(524288L);
        CodecFactory codecFactory = new CodecFactory(conf, 0x100000);
        CodecFactory.BytesCompressor compressor = codecFactory.getCompressor(compression);
        ColumnChunkPageWriteStore writeStore = new ColumnChunkPageWriteStore(compressor, schemaSimple, (ByteBufferAllocator)new HeapByteBufferAllocator(), Integer.MAX_VALUE, ParquetOutputFormat.getPageWriteChecksumEnabled((Configuration)conf));
        PageWriter pageWriter = writeStore.getPageWriter(colADesc);
        pageWriter.writePage(BytesInput.from((byte[])colAPage1Bytes), 262144, 262144, EMPTY_STATS_INT32, Encoding.RLE, Encoding.RLE, Encoding.PLAIN);
        pageWriter.writePage(BytesInput.from((byte[])colAPage2Bytes), 262144, 262144, EMPTY_STATS_INT32, Encoding.RLE, Encoding.RLE, Encoding.PLAIN);
        pageWriter = writeStore.getPageWriter(colBDesc);
        pageWriter.writePage(BytesInput.from((byte[])colBPage1Bytes), 262144, 262144, EMPTY_STATS_INT32, Encoding.RLE, Encoding.RLE, Encoding.PLAIN);
        pageWriter.writePage(BytesInput.from((byte[])colBPage2Bytes), 262144, 262144, EMPTY_STATS_INT32, Encoding.RLE, Encoding.RLE, Encoding.PLAIN);
        writeStore.flushToFileWriter(writer);
        writer.endBlock();
        writer.end(new HashMap());
        codecFactory.release();
        return path;
    }

    private Path writeNestedWithNullsSampleParquetFile(Configuration conf, boolean dictionaryEncoding, CompressionCodecName compression) throws IOException {
        File file = this.tempFolder.newFile();
        file.delete();
        Path path = new Path(file.toURI());
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withConf(conf)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withCompressionCodec(compression)).withDictionaryEncoding(dictionaryEncoding)).withType(schemaNestedWithNulls).withPageWriteChecksumEnabled(ParquetOutputFormat.getPageWriteChecksumEnabled((Configuration)conf))).build();){
            SimpleGroupFactory groupFactory = new SimpleGroupFactory(schemaNestedWithNulls);
            Random rand = new Random(42L);
            for (int i = 0; i < 2000; ++i) {
                Group group = groupFactory.newGroup();
                if (rand.nextDouble() > 0.3) {
                    if (rand.nextDouble() > 0.5) {
                        group.addGroup("c").append("id", (long)i).addGroup("d").append("val", rand.nextInt() % 10);
                    } else {
                        group.addGroup("c").append("id", (long)i).addGroup("d").append("val", rand.nextInt() % 10).append("val", rand.nextInt() % 10).append("val", rand.nextInt() % 10);
                    }
                }
                writer.write((Object)group);
            }
        }
        return path;
    }

    @Test
    public void testWriteOnVerifyOff() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", true);
        conf.setBoolean("parquet.page.verify-checksum.enabled", false);
        Path path = this.writeSimpleParquetFile(conf, CompressionCodecName.UNCOMPRESSED);
        try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));){
            PageReadStore pageReadStore = reader.readNextRowGroup();
            DataPageV1 colAPage1 = this.readNextPage(colADesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colAPage1, colAPage1Bytes);
            this.assertCorrectContent(colAPage1.getBytes().toByteArray(), colAPage1Bytes);
            DataPageV1 colAPage2 = this.readNextPage(colADesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colAPage2, colAPage2Bytes);
            this.assertCorrectContent(colAPage2.getBytes().toByteArray(), colAPage2Bytes);
            DataPageV1 colBPage1 = this.readNextPage(colBDesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colBPage1, colBPage1Bytes);
            this.assertCorrectContent(colBPage1.getBytes().toByteArray(), colBPage1Bytes);
            DataPageV1 colBPage2 = this.readNextPage(colBDesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colBPage2, colBPage2Bytes);
            this.assertCorrectContent(colBPage2.getBytes().toByteArray(), colBPage2Bytes);
        }
    }

    @Test
    public void testWriteOffVerifyOff() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", false);
        conf.setBoolean("parquet.page.verify-checksum.enabled", false);
        Path path = this.writeSimpleParquetFile(conf, CompressionCodecName.UNCOMPRESSED);
        try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));){
            PageReadStore pageReadStore = reader.readNextRowGroup();
            this.assertCrcNotSet((Page)this.readNextPage(colADesc, pageReadStore));
            this.assertCrcNotSet((Page)this.readNextPage(colADesc, pageReadStore));
            this.assertCrcNotSet((Page)this.readNextPage(colBDesc, pageReadStore));
            this.assertCrcNotSet((Page)this.readNextPage(colBDesc, pageReadStore));
        }
    }

    @Test
    public void testWriteOffVerifyOn() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", false);
        conf.setBoolean("parquet.page.verify-checksum.enabled", true);
        Path path = this.writeSimpleParquetFile(conf, CompressionCodecName.UNCOMPRESSED);
        try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));){
            PageReadStore pageReadStore = reader.readNextRowGroup();
            this.assertCorrectContent(this.readNextPage(colADesc, pageReadStore).getBytes().toByteArray(), colAPage1Bytes);
            this.assertCorrectContent(this.readNextPage(colADesc, pageReadStore).getBytes().toByteArray(), colAPage2Bytes);
            this.assertCorrectContent(this.readNextPage(colBDesc, pageReadStore).getBytes().toByteArray(), colBPage1Bytes);
            this.assertCorrectContent(this.readNextPage(colBDesc, pageReadStore).getBytes().toByteArray(), colBPage2Bytes);
        }
    }

    @Test
    public void testWriteOnVerifyOn() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", true);
        conf.setBoolean("parquet.page.verify-checksum.enabled", true);
        Path path = this.writeSimpleParquetFile(conf, CompressionCodecName.UNCOMPRESSED);
        try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));){
            PageReadStore pageReadStore = reader.readNextRowGroup();
            DataPageV1 colAPage1 = this.readNextPage(colADesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colAPage1, colAPage1Bytes);
            this.assertCorrectContent(colAPage1.getBytes().toByteArray(), colAPage1Bytes);
            DataPageV1 colAPage2 = this.readNextPage(colADesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colAPage2, colAPage2Bytes);
            this.assertCorrectContent(colAPage2.getBytes().toByteArray(), colAPage2Bytes);
            DataPageV1 colBPage1 = this.readNextPage(colBDesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colBPage1, colBPage1Bytes);
            this.assertCorrectContent(colBPage1.getBytes().toByteArray(), colBPage1Bytes);
            DataPageV1 colBPage2 = this.readNextPage(colBDesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colBPage2, colBPage2Bytes);
            this.assertCorrectContent(colBPage2.getBytes().toByteArray(), colBPage2Bytes);
        }
    }

    @Test
    public void testCorruptedPage() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", true);
        Path path = this.writeSimpleParquetFile(conf, CompressionCodecName.UNCOMPRESSED);
        HadoopInputFile inputFile = HadoopInputFile.fromPath((Path)path, (Configuration)conf);
        try (SeekableInputStream inputStream = inputFile.newStream();){
            int fileLen = (int)inputFile.getLength();
            byte[] fileBytes = new byte[fileLen];
            inputStream.readFully(fileBytes);
            inputStream.close();
            int n = fileLen / 8;
            fileBytes[n] = (byte)(fileBytes[n] + 1);
            int n2 = fileLen / 8 + fileLen / 4 * 3;
            fileBytes[n2] = (byte)(fileBytes[n2] + 1);
            HadoopOutputFile outputFile = HadoopOutputFile.fromPath((Path)path, (Configuration)conf);
            try (PositionOutputStream outputStream = outputFile.createOrOverwrite(0x100000L);){
                outputStream.write(fileBytes);
                outputStream.close();
                conf.setBoolean("parquet.page.verify-checksum.enabled", false);
                try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));){
                    PageReadStore pageReadStore = reader.readNextRowGroup();
                    DataPageV1 colAPage1 = this.readNextPage(colADesc, pageReadStore);
                    Assert.assertFalse((String)"Data in page was not corrupted", (boolean)Arrays.equals(colAPage1.getBytes().toByteArray(), colAPage1Bytes));
                    this.readNextPage(colADesc, pageReadStore);
                    this.readNextPage(colBDesc, pageReadStore);
                    DataPageV1 colBPage2 = this.readNextPage(colBDesc, pageReadStore);
                    Assert.assertFalse((String)"Data in page was not corrupted", (boolean)Arrays.equals(colBPage2.getBytes().toByteArray(), colBPage2Bytes));
                }
                conf.setBoolean("parquet.page.verify-checksum.enabled", true);
                reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));
                try {
                    this.assertVerificationFailed(reader);
                }
                finally {
                    if (reader != null) {
                        reader.close();
                    }
                }
            }
        }
    }

    @Test
    public void testCompression() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", true);
        conf.setBoolean("parquet.page.verify-checksum.enabled", true);
        Path path = this.writeSimpleParquetFile(conf, CompressionCodecName.SNAPPY);
        try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colADesc, colBDesc));){
            PageReadStore pageReadStore = reader.readNextRowGroup();
            DataPageV1 colAPage1 = this.readNextPage(colADesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colAPage1, this.snappy(colAPage1Bytes));
            this.assertCorrectContent(colAPage1.getBytes().toByteArray(), colAPage1Bytes);
            DataPageV1 colAPage2 = this.readNextPage(colADesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colAPage2, this.snappy(colAPage2Bytes));
            this.assertCorrectContent(colAPage2.getBytes().toByteArray(), colAPage2Bytes);
            DataPageV1 colBPage1 = this.readNextPage(colBDesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colBPage1, this.snappy(colBPage1Bytes));
            this.assertCorrectContent(colBPage1.getBytes().toByteArray(), colBPage1Bytes);
            DataPageV1 colBPage2 = this.readNextPage(colBDesc, pageReadStore);
            this.assertCrcSetAndCorrect((Page)colBPage2, this.snappy(colBPage2Bytes));
            this.assertCorrectContent(colBPage2.getBytes().toByteArray(), colBPage2Bytes);
        }
    }

    @Test
    public void testNestedWithNulls() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", false);
        conf.setBoolean("parquet.page.verify-checksum.enabled", false);
        Path refPath = this.writeNestedWithNullsSampleParquetFile(conf, false, CompressionCodecName.SNAPPY);
        try (ParquetFileReader refReader = this.getParquetFileReader(refPath, conf, Arrays.asList(colCIdDesc, colDValDesc));){
            PageReadStore refPageReadStore = refReader.readNextRowGroup();
            byte[] colCIdPageBytes = this.readNextPage(colCIdDesc, refPageReadStore).getBytes().toByteArray();
            byte[] colDValPageBytes = this.readNextPage(colDValDesc, refPageReadStore).getBytes().toByteArray();
            conf.setBoolean("parquet.page.write-checksum.enabled", true);
            conf.setBoolean("parquet.page.verify-checksum.enabled", true);
            Path path = this.writeNestedWithNullsSampleParquetFile(conf, false, CompressionCodecName.SNAPPY);
            try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Arrays.asList(colCIdDesc, colDValDesc));){
                PageReadStore pageReadStore = reader.readNextRowGroup();
                DataPageV1 colCIdPage = this.readNextPage(colCIdDesc, pageReadStore);
                this.assertCrcSetAndCorrect((Page)colCIdPage, this.snappy(colCIdPageBytes));
                this.assertCorrectContent(colCIdPage.getBytes().toByteArray(), colCIdPageBytes);
                DataPageV1 colDValPage = this.readNextPage(colDValDesc, pageReadStore);
                this.assertCrcSetAndCorrect((Page)colDValPage, this.snappy(colDValPageBytes));
                this.assertCorrectContent(colDValPage.getBytes().toByteArray(), colDValPageBytes);
            }
        }
    }

    @Test
    public void testDictionaryEncoding() throws IOException {
        Configuration conf = new Configuration();
        conf.setBoolean("parquet.page.write-checksum.enabled", false);
        conf.setBoolean("parquet.page.verify-checksum.enabled", false);
        Path refPath = this.writeNestedWithNullsSampleParquetFile(conf, true, CompressionCodecName.SNAPPY);
        try (ParquetFileReader refReader = this.getParquetFileReader(refPath, conf, Collections.singletonList(colDValDesc));){
            PageReadStore refPageReadStore = refReader.readNextRowGroup();
            byte[] dictPageBytes = this.readDictPage(colDValDesc, refPageReadStore).getBytes().toByteArray();
            byte[] colDValPageBytes = this.readNextPage(colDValDesc, refPageReadStore).getBytes().toByteArray();
            conf.setBoolean("parquet.page.write-checksum.enabled", true);
            conf.setBoolean("parquet.page.verify-checksum.enabled", true);
            Path path = this.writeNestedWithNullsSampleParquetFile(conf, true, CompressionCodecName.SNAPPY);
            try (ParquetFileReader reader = this.getParquetFileReader(path, conf, Collections.singletonList(colDValDesc));){
                PageReadStore pageReadStore = reader.readNextRowGroup();
                DictionaryPage dictPage = this.readDictPage(colDValDesc, pageReadStore);
                this.assertCrcSetAndCorrect((Page)dictPage, this.snappy(dictPageBytes));
                this.assertCorrectContent(dictPage.getBytes().toByteArray(), dictPageBytes);
                DataPageV1 colDValPage = this.readNextPage(colDValDesc, pageReadStore);
                this.assertCrcSetAndCorrect((Page)colDValPage, this.snappy(colDValPageBytes));
                this.assertCorrectContent(colDValPage.getBytes().toByteArray(), colDValPageBytes);
            }
        }
    }

    private byte[] snappy(byte[] bytes) throws IOException {
        SnappyCompressor compressor = new SnappyCompressor();
        compressor.reset();
        compressor.setInput(bytes, 0, bytes.length);
        compressor.finish();
        byte[] buffer = new byte[bytes.length * 2];
        int compressedSize = compressor.compress(buffer, 0, buffer.length);
        return Arrays.copyOfRange(buffer, 0, compressedSize);
    }

    private ParquetFileReader getParquetFileReader(Path path, Configuration conf, List<ColumnDescriptor> columns) throws IOException {
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)conf, (Path)path);
        return new ParquetFileReader(conf, footer.getFileMetaData(), path, footer.getBlocks(), columns);
    }

    private DictionaryPage readDictPage(ColumnDescriptor colDesc, PageReadStore pageReadStore) {
        return pageReadStore.getPageReader(colDesc).readDictionaryPage();
    }

    private DataPageV1 readNextPage(ColumnDescriptor colDesc, PageReadStore pageReadStore) {
        return (DataPageV1)pageReadStore.getPageReader(colDesc).readPage();
    }

    private void assertCorrectContent(byte[] pageBytes, byte[] referenceBytes) {
        Assert.assertArrayEquals((String)"Read page content was different from expected page content", (byte[])referenceBytes, (byte[])pageBytes);
    }

    private void assertCrcSetAndCorrect(Page page, byte[] referenceBytes) {
        Assert.assertTrue((String)"Checksum was not set in page", (boolean)page.getCrc().isPresent());
        int crcFromPage = page.getCrc().getAsInt();
        this.crc.reset();
        this.crc.update(referenceBytes);
        Assert.assertEquals((String)"Checksum found in page did not match calculated reference checksum", (long)this.crc.getValue(), (long)((long)crcFromPage & 0xFFFFFFFFL));
    }

    private void assertCrcNotSet(Page page) {
        Assert.assertFalse((String)"Checksum was set in page", (boolean)page.getCrc().isPresent());
    }

    private void assertVerificationFailed(ParquetFileReader reader) {
        try {
            reader.readNextRowGroup();
            Assert.fail((String)"Expected checksum verification exception to be thrown");
        }
        catch (Exception e) {
            Assert.assertTrue((String)"Thrown exception is of incorrect type", (boolean)(e instanceof ParquetDecodingException));
            Assert.assertTrue((String)"Did not catch checksum verification ParquetDecodingException", (boolean)e.getMessage().contains("CRC checksum verification failed"));
        }
    }
}

