/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.statistics;

import java.io.File;
import java.io.IOException;
import java.math.BigInteger;
import java.util.Arrays;
import java.util.Comparator;
import java.util.List;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnReaderImpl;
import org.apache.parquet.column.page.DataPage;
import org.apache.parquet.column.page.DataPageV1;
import org.apache.parquet.column.page.DataPageV2;
import org.apache.parquet.column.page.DictionaryPage;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.column.page.PageReader;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.apache.parquet.statistics.DataGenerationContext;
import org.apache.parquet.statistics.RandomValues;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestStatistics {
    private static final int MEGABYTE = 0x100000;
    private static final long RANDOM_SEED = 1441990701846L;
    @Rule
    public final TemporaryFolder folder = new TemporaryFolder();

    private static <T extends Comparable<T>> Statistics<T> getStatisticsFromPageHeader(DataPage page) {
        return (Statistics)page.accept(new DataPage.Visitor<Statistics<T>>(){

            public Statistics<T> visit(DataPageV1 dataPageV1) {
                return dataPageV1.getStatistics();
            }

            public Statistics<T> visit(DataPageV2 dataPageV2) {
                return dataPageV2.getStatistics();
            }
        });
    }

    private static PrimitiveConverter getValidatingConverter(final DataPage page, PrimitiveType.PrimitiveTypeName type) {
        return (PrimitiveConverter)type.convert((PrimitiveType.PrimitiveTypeNameConverter)new PrimitiveType.PrimitiveTypeNameConverter<PrimitiveConverter, RuntimeException>(){

            public PrimitiveConverter convertFLOAT(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                final StatsValidator validator = new StatsValidator(page);
                return new PrimitiveConverter(){

                    public void addFloat(float value) {
                        validator.validate(Float.valueOf(value));
                    }
                };
            }

            public PrimitiveConverter convertDOUBLE(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                final StatsValidator validator = new StatsValidator(page);
                return new PrimitiveConverter(){

                    public void addDouble(double value) {
                        validator.validate(value);
                    }
                };
            }

            public PrimitiveConverter convertINT32(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                final StatsValidator validator = new StatsValidator(page);
                return new PrimitiveConverter(){

                    public void addInt(int value) {
                        validator.validate(value);
                    }
                };
            }

            public PrimitiveConverter convertINT64(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                final StatsValidator validator = new StatsValidator(page);
                return new PrimitiveConverter(){

                    public void addLong(long value) {
                        validator.validate(value);
                    }
                };
            }

            public PrimitiveConverter convertBOOLEAN(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                final StatsValidator validator = new StatsValidator(page);
                return new PrimitiveConverter(){

                    public void addBoolean(boolean value) {
                        validator.validate(value);
                    }
                };
            }

            public PrimitiveConverter convertINT96(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                return this.convertBINARY(primitiveTypeName);
            }

            public PrimitiveConverter convertFIXED_LEN_BYTE_ARRAY(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                return this.convertBINARY(primitiveTypeName);
            }

            public PrimitiveConverter convertBINARY(PrimitiveType.PrimitiveTypeName primitiveTypeName) {
                final StatsValidator validator = new StatsValidator(page);
                return new PrimitiveConverter(){

                    public void addBinary(Binary value) {
                        validator.validate(value);
                    }
                };
            }
        });
    }

    @Test
    public void testStatistics() throws IOException {
        File file = this.folder.newFile("test_file.parquet");
        file.delete();
        System.out.println(String.format("RANDOM SEED: %s", 1441990701846L));
        Random random = new Random(1441990701846L);
        int blockSize = (random.nextInt(54) + 10) * 0x100000;
        int pageSize = (random.nextInt(10) + 1) * 0x100000;
        List<DataContext> contexts = Arrays.asList(new DataContext(random.nextLong(), file, blockSize, pageSize, false, ParquetProperties.WriterVersion.PARQUET_1_0), new DataContext(random.nextLong(), file, blockSize, pageSize, true, ParquetProperties.WriterVersion.PARQUET_1_0), new DataContext(random.nextLong(), file, blockSize, pageSize, false, ParquetProperties.WriterVersion.PARQUET_2_0), new DataContext(random.nextLong(), file, blockSize, pageSize, true, ParquetProperties.WriterVersion.PARQUET_2_0));
        for (DataContext test : contexts) {
            DataGenerationContext.writeAndTest(test);
        }
    }

    public static class DataContext
    extends DataGenerationContext.WriteContext {
        private static final int MAX_TOTAL_ROWS = 1000000;
        private final Random random;
        private final int recordCount;
        private final List<RandomValues.RandomValueGenerator<?>> randomGenerators;

        public DataContext(long seed, File path, int blockSize, int pageSize, boolean enableDictionary, ParquetProperties.WriterVersion version) throws IOException {
            super(path, DataContext.buildSchema(seed), blockSize, pageSize, enableDictionary, true, version);
            this.random = new Random(seed);
            this.recordCount = this.random.nextInt(1000000);
            int fixedLength = this.schema.getType("fixed-binary").asPrimitiveType().getTypeLength();
            this.randomGenerators = Arrays.asList(new RandomValues.IntGenerator(this.random.nextLong()), new RandomValues.LongGenerator(this.random.nextLong()), new RandomValues.Int96Generator(this.random.nextLong()), new RandomValues.FloatGenerator(this.random.nextLong()), new RandomValues.DoubleGenerator(this.random.nextLong()), new RandomValues.StringGenerator(this.random.nextLong()), new RandomValues.BinaryGenerator(this.random.nextLong()), new RandomValues.FixedGenerator(this.random.nextLong(), fixedLength), new RandomValues.UnconstrainedIntGenerator(this.random.nextLong()), new RandomValues.UnconstrainedLongGenerator(this.random.nextLong()), new RandomValues.UnconstrainedFloatGenerator(this.random.nextLong()), new RandomValues.UnconstrainedDoubleGenerator(this.random.nextLong()), new RandomValues.IntGenerator(this.random.nextLong(), -128, 127), new RandomValues.UIntGenerator(this.random.nextLong(), -128, 127), new RandomValues.IntGenerator(this.random.nextLong(), Short.MIN_VALUE, Short.MAX_VALUE), new RandomValues.UIntGenerator(this.random.nextLong(), Short.MIN_VALUE, Short.MAX_VALUE), new RandomValues.UnconstrainedIntGenerator(this.random.nextLong()), new RandomValues.UnconstrainedIntGenerator(this.random.nextLong()), new RandomValues.UnconstrainedLongGenerator(this.random.nextLong()), new RandomValues.UnconstrainedLongGenerator(this.random.nextLong()), new RandomValues.UnconstrainedIntGenerator(this.random.nextLong()), new RandomValues.UnconstrainedLongGenerator(this.random.nextLong()), new RandomValues.FixedGenerator(this.random.nextLong(), fixedLength), new RandomValues.BinaryGenerator(this.random.nextLong()), new RandomValues.StringGenerator(this.random.nextLong()), new RandomValues.StringGenerator(this.random.nextLong()), new RandomValues.StringGenerator(this.random.nextLong()), new RandomValues.BinaryGenerator(this.random.nextLong()), new RandomValues.IntGenerator(this.random.nextLong()), new RandomValues.IntGenerator(this.random.nextLong()), new RandomValues.LongGenerator(this.random.nextLong()), new RandomValues.LongGenerator(this.random.nextLong()), new RandomValues.LongGenerator(this.random.nextLong()), new RandomValues.FixedGenerator(this.random.nextLong(), 12));
        }

        private static MessageType buildSchema(long seed) {
            Random random = new Random(seed);
            int fixedBinaryLength = random.nextInt(21) + 1;
            int fixedPrecision = DataContext.calculatePrecision(fixedBinaryLength);
            int fixedScale = fixedPrecision / 4;
            int binaryPrecision = DataContext.calculatePrecision(16);
            int binaryScale = binaryPrecision / 4;
            return new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT32, "i32"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "i64"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT96, "i96"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.FLOAT, "sngl"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.DOUBLE, "dbl"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "strings"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "binary"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY, fixedBinaryLength, "fixed-binary"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT32, "unconstrained-i32"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.INT64, "unconstrained-i64"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.FLOAT, "unconstrained-sngl"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.DOUBLE, "unconstrained-dbl"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.INT_8)).named("int8"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_8)).named("uint8"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.INT_16)).named("int16"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_16)).named("uint16"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.INT_32)).named("int32"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.UINT_32)).named("uint32"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.INT_64)).named("int64"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.UINT_64)).named("uint64"), (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DECIMAL)).precision(9)).scale(2)).named("decimal-int32"), (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.DECIMAL)).precision(18)).scale(4)).named("decimal-int64"), (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(fixedBinaryLength)).as(OriginalType.DECIMAL)).precision(fixedPrecision)).scale(fixedScale)).named("decimal-fixed"), (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.DECIMAL)).precision(binaryPrecision)).scale(binaryScale)).named("decimal-binary"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("utf8"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.ENUM)).named("enum"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.JSON)).named("json"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.BSON)).named("bson"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.DATE)).named("date"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).as(OriginalType.TIME_MILLIS)).named("time-millis"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.TIME_MICROS)).named("time-micros"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.TIMESTAMP_MILLIS)).named("timestamp-millis"), (Type)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).as(OriginalType.TIMESTAMP_MICROS)).named("timestamp-micros"), (Type)((Types.PrimitiveBuilder)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.FIXED_LEN_BYTE_ARRAY).length(12)).as(OriginalType.INTERVAL)).named("interval")});
        }

        private static int calculatePrecision(int byteCnt) {
            String maxValue = BigInteger.valueOf(2L).pow(8 * byteCnt - 1).toString();
            return maxValue.length() - 1;
        }

        @Override
        public void write(ParquetWriter<Group> writer) throws IOException {
            for (int index = 0; index < this.recordCount; ++index) {
                SimpleGroup group = new SimpleGroup((GroupType)this.schema);
                int columnCnt = this.schema.getFieldCount();
                block9: for (int column = 0; column < columnCnt; ++column) {
                    Type type = this.schema.getType(column);
                    RandomValues.RandomValueGenerator<?> generator = this.randomGenerators.get(column);
                    if (type.isRepetition(Type.Repetition.OPTIONAL) && generator.shouldGenerateNull()) continue;
                    switch (type.asPrimitiveType().getPrimitiveTypeName()) {
                        case BINARY: 
                        case FIXED_LEN_BYTE_ARRAY: 
                        case INT96: {
                            group.append(type.getName(), ((RandomValues.RandomBinaryBase)generator).nextBinaryValue());
                            continue block9;
                        }
                        case INT32: {
                            group.append(type.getName(), ((Integer)generator.nextValue()).intValue());
                            continue block9;
                        }
                        case INT64: {
                            group.append(type.getName(), ((Long)generator.nextValue()).longValue());
                            continue block9;
                        }
                        case FLOAT: {
                            group.append(type.getName(), ((Float)generator.nextValue()).floatValue());
                            continue block9;
                        }
                        case DOUBLE: {
                            group.append(type.getName(), ((Double)generator.nextValue()).doubleValue());
                            continue block9;
                        }
                        case BOOLEAN: {
                            group.append(type.getName(), ((Boolean)generator.nextValue()).booleanValue());
                        }
                    }
                }
                writer.write((Object)group);
            }
        }

        @Override
        public void test() throws IOException {
            Configuration configuration = new Configuration();
            ParquetMetadata metadata = ParquetFileReader.readFooter((Configuration)configuration, (Path)this.fsPath, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
            try (ParquetFileReader reader = new ParquetFileReader(configuration, metadata.getFileMetaData(), this.fsPath, metadata.getBlocks(), metadata.getFileMetaData().getSchema().getColumns());){
                PageReadStore pageReadStore;
                PageStatsValidator validator = new PageStatsValidator();
                while ((pageReadStore = reader.readNextRowGroup()) != null) {
                    validator.validate(metadata.getFileMetaData().getSchema(), pageReadStore);
                }
            }
        }
    }

    public static class PageStatsValidator {
        public void validate(MessageType schema, PageReadStore store) {
            for (ColumnDescriptor desc : schema.getColumns()) {
                DataPage page;
                PageReader reader = store.getPageReader(desc);
                DictionaryPage dict = reader.readDictionaryPage();
                while ((page = reader.readPage()) != null) {
                    this.validateStatsForPage(page, dict, desc);
                }
            }
        }

        private void validateStatsForPage(DataPage page, DictionaryPage dict, ColumnDescriptor desc) {
            SingletonPageReader reader = new SingletonPageReader(dict, page);
            PrimitiveConverter converter = TestStatistics.getValidatingConverter(page, desc.getType());
            Statistics stats = TestStatistics.getStatisticsFromPageHeader(page);
            Assert.assertEquals((String)"Statistics does not use the proper comparator", desc.getPrimitiveType().comparator().getClass(), stats.comparator().getClass());
            if (stats.isEmpty()) {
                return;
            }
            long numNulls = 0L;
            ColumnReaderImpl column = new ColumnReaderImpl(desc, (PageReader)reader, converter, null);
            int i = 0;
            while ((long)i < reader.getTotalValueCount()) {
                if (column.getCurrentDefinitionLevel() >= desc.getMaxDefinitionLevel()) {
                    column.writeCurrentValueToConverter();
                } else {
                    ++numNulls;
                }
                column.consume();
                ++i;
            }
            Assert.assertEquals((long)numNulls, (long)stats.getNumNulls());
        }
    }

    private static class StatsValidator<T extends Comparable<T>> {
        private final boolean hasNonNull;
        private final T min;
        private final T max;
        private final Comparator<T> comparator;

        public StatsValidator(DataPage page) {
            Statistics stats = TestStatistics.getStatisticsFromPageHeader(page);
            this.comparator = stats.comparator();
            this.hasNonNull = stats.hasNonNullValue();
            if (this.hasNonNull) {
                this.min = stats.genericGetMin();
                this.max = stats.genericGetMax();
            } else {
                this.min = null;
                this.max = null;
            }
        }

        public void validate(T value) {
            if (this.hasNonNull) {
                Assert.assertTrue((String)"min should be <= all values", (this.comparator.compare(this.min, value) <= 0 ? 1 : 0) != 0);
                Assert.assertTrue((String)"min should be >= all values", (this.comparator.compare(this.max, value) >= 0 ? 1 : 0) != 0);
            }
        }
    }

    public static class SingletonPageReader
    implements PageReader {
        private final DictionaryPage dict;
        private final DataPage data;

        public SingletonPageReader(DictionaryPage dict, DataPage data) {
            this.dict = dict;
            this.data = data;
        }

        public DictionaryPage readDictionaryPage() {
            return this.dict;
        }

        public long getTotalValueCount() {
            return this.data.getValueCount();
        }

        public DataPage readPage() {
            return this.data;
        }
    }
}

