/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.HashMap;
import java.util.Map;
import java.util.concurrent.ThreadLocalRandom;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroup;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.util.EncDecProperties;
import org.apache.parquet.hadoop.util.EncryptionTestFile;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;

public class TestFileBuilder {
    private MessageType schema;
    private Configuration conf;
    private Map<String, String> extraMeta = new HashMap<String, String>();
    private int numRecord = 100000;
    private ParquetProperties.WriterVersion writerVersion = ParquetProperties.WriterVersion.PARQUET_1_0;
    private int pageSize = 0x100000;
    private String codec = "ZSTD";
    private String[] encryptColumns = new String[0];
    private ParquetCipher cipher = ParquetCipher.AES_GCM_V1;
    private Boolean footerEncryption = false;

    public TestFileBuilder(Configuration conf, MessageType schema) {
        this.conf = conf;
        this.schema = schema;
        conf.set("parquet.example.schema", schema.toString());
    }

    public TestFileBuilder withNumRecord(int numRecord) {
        this.numRecord = numRecord;
        return this;
    }

    public TestFileBuilder withEncrytionAlgorithm(ParquetCipher cipher) {
        this.cipher = cipher;
        return this;
    }

    public TestFileBuilder withExtraMeta(Map<String, String> extraMeta) {
        this.extraMeta = extraMeta;
        return this;
    }

    public TestFileBuilder withWriterVersion(ParquetProperties.WriterVersion writerVersion) {
        this.writerVersion = writerVersion;
        return this;
    }

    public TestFileBuilder withPageSize(int pageSize) {
        this.pageSize = pageSize;
        return this;
    }

    public TestFileBuilder withCodec(String codec) {
        this.codec = codec;
        return this;
    }

    public TestFileBuilder withEncryptColumns(String[] encryptColumns) {
        this.encryptColumns = encryptColumns;
        return this;
    }

    public TestFileBuilder withFooterEncryption() {
        this.footerEncryption = true;
        return this;
    }

    public EncryptionTestFile build() throws IOException {
        String fileName = TestFileBuilder.createTempFile("test");
        SimpleGroup[] fileContent = this.createFileContent(this.schema);
        FileEncryptionProperties encryptionProperties = EncDecProperties.getFileEncryptionProperties(this.encryptColumns, this.cipher, this.footerEncryption);
        ExampleParquetWriter.Builder builder = (ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)new Path(fileName)).withConf(this.conf)).withWriterVersion(this.writerVersion)).withExtraMetaData(this.extraMeta).withValidation(true)).withPageSize(this.pageSize)).withEncryption(encryptionProperties)).withCompressionCodec(CompressionCodecName.valueOf((String)this.codec));
        try (ParquetWriter writer = builder.build();){
            for (int i = 0; i < fileContent.length; ++i) {
                writer.write((Object)fileContent[i]);
            }
        }
        return new EncryptionTestFile(fileName, fileContent);
    }

    private SimpleGroup[] createFileContent(MessageType schema) {
        SimpleGroup[] simpleGroups = new SimpleGroup[this.numRecord];
        for (int i = 0; i < simpleGroups.length; ++i) {
            SimpleGroup g = new SimpleGroup((GroupType)schema);
            for (Type type : schema.getFields()) {
                this.addValueToSimpleGroup((Group)g, type);
            }
            simpleGroups[i] = g;
        }
        return simpleGroups;
    }

    private void addValueToSimpleGroup(Group g, Type type) {
        block3: {
            block1: {
                PrimitiveType primitiveType;
                block4: {
                    block2: {
                        if (!type.isPrimitive()) break block1;
                        primitiveType = (PrimitiveType)type;
                        if (!primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT32)) break block2;
                        g.add(type.getName(), TestFileBuilder.getInt());
                        break block3;
                    }
                    if (!primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.INT64)) break block4;
                    g.add(type.getName(), TestFileBuilder.getLong());
                    break block3;
                }
                if (!primitiveType.getPrimitiveTypeName().equals((Object)PrimitiveType.PrimitiveTypeName.BINARY)) break block3;
                g.add(type.getName(), TestFileBuilder.getString());
                break block3;
            }
            GroupType groupType = (GroupType)type;
            Group parentGroup = g.addGroup(groupType.getName());
            for (Type field : groupType.getFields()) {
                this.addValueToSimpleGroup(parentGroup, field);
            }
        }
    }

    private static long getInt() {
        return ThreadLocalRandom.current().nextInt(10000);
    }

    private static long getLong() {
        return ThreadLocalRandom.current().nextLong(100000L);
    }

    private static String getString() {
        char[] chars = new char[]{'a', 'b', 'c', 'd', 'e', 'f', 'g', 'x', 'z', 'y'};
        StringBuilder sb = new StringBuilder();
        for (int i = 0; i < 100; ++i) {
            sb.append(chars[ThreadLocalRandom.current().nextInt(10)]);
        }
        return sb.toString();
    }

    public static String createTempFile(String prefix) {
        try {
            return Files.createTempDirectory(prefix, new FileAttribute[0]).toAbsolutePath().toString() + "/test.parquet";
        }
        catch (IOException e) {
            throw new AssertionError("Unable to create temporary file", e);
        }
    }
}

