/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop.util;

import java.io.IOException;
import java.nio.charset.StandardCharsets;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.HadoopReadOptions;
import org.apache.parquet.ParquetReadOptions;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.page.PageReadStore;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.format.DataPageHeader;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.ColumnEncryptor;
import org.apache.parquet.hadoop.util.CompressionConverter;
import org.apache.parquet.hadoop.util.EncDecProperties;
import org.apache.parquet.hadoop.util.EncryptionTestFile;
import org.apache.parquet.hadoop.util.HadoopInputFile;
import org.apache.parquet.hadoop.util.TestFileBuilder;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.io.InputFile;
import org.apache.parquet.io.SeekableInputStream;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Type;
import org.junit.Assert;
import org.junit.Test;

public class ColumnEncryptorTest {
    private Configuration conf = new Configuration();
    private ColumnEncryptor columnEncryptor = null;
    private final int numRecord = 100000;
    private EncryptionTestFile inputFile = null;
    private String outputFile = null;

    private void testSetup(String compression) throws IOException {
        MessageType schema = this.createSchema();
        this.columnEncryptor = new ColumnEncryptor(this.conf);
        this.inputFile = new TestFileBuilder(this.conf, schema).withNumRecord(100000).withCodec(compression).withPageSize(0x100000).build();
        this.outputFile = TestFileBuilder.createTempFile("test");
    }

    @Test
    public void testFlatColumn() throws IOException {
        String[] encryptColumns = new String[]{"DocId"};
        this.testSetup("GZIP");
        this.columnEncryptor.encryptColumns(this.inputFile.getFileName(), this.outputFile, Arrays.asList(encryptColumns), EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_CTR_V1, false));
        this.verifyResultDecryptionWithValidKey();
    }

    @Test
    public void testNestedColumn() throws IOException {
        String[] encryptColumns = new String[]{"Links.Forward"};
        this.testSetup("GZIP");
        this.columnEncryptor.encryptColumns(this.inputFile.getFileName(), this.outputFile, Arrays.asList(encryptColumns), EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_CTR_V1, false));
        this.verifyResultDecryptionWithValidKey();
    }

    @Test
    public void testNoEncryption() throws IOException {
        String[] encryptColumns = new String[]{};
        this.testSetup("GZIP");
        this.columnEncryptor.encryptColumns(this.inputFile.getFileName(), this.outputFile, Arrays.asList(encryptColumns), EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_CTR_V1, false));
        this.verifyResultDecryptionWithValidKey();
    }

    @Test
    public void testEncryptAllColumns() throws IOException {
        String[] encryptColumns = new String[]{"DocId", "Name", "Gender", "Links.Forward", "Links.Backward"};
        this.testSetup("GZIP");
        this.columnEncryptor.encryptColumns(this.inputFile.getFileName(), this.outputFile, Arrays.asList(encryptColumns), EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_CTR_V1, false));
        this.verifyResultDecryptionWithValidKey();
    }

    @Test
    public void testEncryptSomeColumns() throws IOException {
        String[] encryptColumns = new String[]{"DocId", "Name", "Links.Forward"};
        this.testSetup("GZIP");
        this.columnEncryptor.encryptColumns(this.inputFile.getFileName(), this.outputFile, Arrays.asList(encryptColumns), EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_CTR_V1, false));
        ParquetMetadata metaData = this.getParquetMetadata(EncDecProperties.getFileDecryptionProperties());
        Assert.assertTrue((metaData.getBlocks().size() > 0 ? 1 : 0) != 0);
        List columns = ((BlockMetaData)metaData.getBlocks().get(0)).getColumns();
        HashSet<String> set = new HashSet<String>(Arrays.asList(encryptColumns));
        for (ColumnChunkMetaData column : columns) {
            if (set.contains(column.getPath().toDotString())) {
                Assert.assertTrue((boolean)column.isEncrypted());
                continue;
            }
            Assert.assertFalse((boolean)column.isEncrypted());
        }
    }

    @Test
    public void testFooterEncryption() throws IOException {
        String[] encryptColumns = new String[]{"DocId"};
        this.testSetup("GZIP");
        this.columnEncryptor.encryptColumns(this.inputFile.getFileName(), this.outputFile, Arrays.asList(encryptColumns), EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_CTR_V1, true));
        this.verifyResultDecryptionWithValidKey();
    }

    @Test
    public void testAesGcm() throws IOException {
        String[] encryptColumns = new String[]{"DocId"};
        this.testSetup("GZIP");
        this.columnEncryptor.encryptColumns(this.inputFile.getFileName(), this.outputFile, Arrays.asList(encryptColumns), EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_V1, true));
        this.verifyResultDecryptionWithValidKey();
    }

    @Test
    public void testColumnIndex() throws IOException {
        String[] encryptColumns = new String[]{"Name"};
        this.testSetup("GZIP");
        this.columnEncryptor.encryptColumns(this.inputFile.getFileName(), this.outputFile, Arrays.asList(encryptColumns), EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_V1, false));
        this.verifyResultDecryptionWithValidKey();
        this.verifyOffsetIndexes();
    }

    @Test
    public void testDifferentCompression() throws IOException {
        String[] compressions;
        String[] encryptColumns = new String[]{"Links.Forward"};
        for (String compression : compressions = new String[]{"GZIP", "ZSTD", "SNAPPY", "UNCOMPRESSED"}) {
            this.testSetup(compression);
            this.columnEncryptor.encryptColumns(this.inputFile.getFileName(), this.outputFile, Arrays.asList(encryptColumns), EncDecProperties.getFileEncryptionProperties(encryptColumns, ParquetCipher.AES_GCM_CTR_V1, false));
            this.verifyResultDecryptionWithValidKey();
        }
    }

    private void verifyResultDecryptionWithValidKey() throws IOException {
        ParquetReader<Group> reader = this.createReader(this.outputFile);
        for (int i = 0; i < 100000; ++i) {
            Group group = (Group)reader.read();
            Assert.assertTrue((group.getLong("DocId", 0) == this.inputFile.getFileContent()[i].getLong("DocId", 0) ? 1 : 0) != 0);
            Assert.assertArrayEquals((byte[])group.getBinary("Name", 0).getBytes(), (byte[])this.inputFile.getFileContent()[i].getString("Name", 0).getBytes(StandardCharsets.UTF_8));
            Assert.assertArrayEquals((byte[])group.getBinary("Gender", 0).getBytes(), (byte[])this.inputFile.getFileContent()[i].getString("Gender", 0).getBytes(StandardCharsets.UTF_8));
            Group subGroupInRead = group.getGroup("Links", 0);
            Group expectedSubGroup = this.inputFile.getFileContent()[i].getGroup("Links", 0);
            Assert.assertArrayEquals((byte[])subGroupInRead.getBinary("Forward", 0).getBytes(), (byte[])expectedSubGroup.getBinary("Forward", 0).getBytes());
            Assert.assertArrayEquals((byte[])subGroupInRead.getBinary("Backward", 0).getBytes(), (byte[])expectedSubGroup.getBinary("Backward", 0).getBytes());
        }
        reader.close();
    }

    private void verifyOffsetIndexes() throws IOException {
        ParquetReadOptions readOptions = HadoopReadOptions.builder((Configuration)this.conf).withDecryption(EncDecProperties.getFileDecryptionProperties()).build();
        try (CompressionConverter.TransParquetFileReader inReader = this.createFileReader(this.inputFile.getFileName());
             CompressionConverter.TransParquetFileReader outReader = this.createFileReader(this.outputFile);){
            ParquetMetadata inMetaData = this.getMetadata(readOptions, this.inputFile.getFileName(), inReader);
            ParquetMetadata outMetaData = this.getMetadata(readOptions, this.outputFile, outReader);
            this.compareOffsetIndexes(inReader, outReader, inMetaData, outMetaData);
        }
    }

    private ParquetMetadata getMetadata(ParquetReadOptions readOptions, String file, CompressionConverter.TransParquetFileReader reader) throws IOException {
        return ParquetFileReader.readFooter((InputFile)HadoopInputFile.fromPath((Path)new Path(file), (Configuration)this.conf), (ParquetReadOptions)readOptions, (SeekableInputStream)reader.getStream());
    }

    private void compareOffsetIndexes(CompressionConverter.TransParquetFileReader inReader, CompressionConverter.TransParquetFileReader outReader, ParquetMetadata inMetaData, ParquetMetadata outMetaData) throws IOException {
        PageReadStore inStore = inReader.readNextRowGroup();
        PageReadStore outStore = outReader.readNextRowGroup();
        int blockIndex = 0;
        while (inStore != null && outStore != null) {
            List inColumns = ((BlockMetaData)inMetaData.getBlocks().get(blockIndex)).getColumns();
            List outColumns = ((BlockMetaData)outMetaData.getBlocks().get(blockIndex)).getColumns();
            Assert.assertEquals((long)inColumns.size(), (long)outColumns.size());
            this.validateColumns(inReader, outReader, inColumns, outColumns);
            inStore = inReader.readNextRowGroup();
            outStore = outReader.readNextRowGroup();
            ++blockIndex;
            if (inStore == null && outStore == null) continue;
            throw new IOException("Number of row groups are not equal");
        }
    }

    private void validateColumns(CompressionConverter.TransParquetFileReader inReader, CompressionConverter.TransParquetFileReader outReader, List<ColumnChunkMetaData> inColumns, List<ColumnChunkMetaData> outColumns) throws IOException {
        for (int i = 0; i < inColumns.size(); ++i) {
            ColumnChunkMetaData inChunk = inColumns.get(i);
            ColumnChunkMetaData outChunk = outColumns.get(i);
            OffsetIndex inOffsetIndex = inReader.readOffsetIndex(inChunk);
            OffsetIndex outOffsetIndex = outReader.readOffsetIndex(outChunk);
            Assert.assertEquals((long)inOffsetIndex.getPageCount(), (long)outOffsetIndex.getPageCount());
            if (outChunk.isEncrypted()) continue;
            this.validatePages(inReader, outReader, inOffsetIndex, outOffsetIndex);
        }
    }

    private void validatePages(CompressionConverter.TransParquetFileReader inReader, CompressionConverter.TransParquetFileReader outReader, OffsetIndex inOffsetIndex, OffsetIndex outOffsetIndex) throws IOException {
        for (int pageId = 0; pageId < inOffsetIndex.getPageCount(); ++pageId) {
            long inPageOffset = inOffsetIndex.getOffset(pageId);
            inReader.setStreamPosition(inPageOffset);
            long outPageOffset = outOffsetIndex.getOffset(pageId);
            outReader.setStreamPosition(outPageOffset);
            PageHeader inPageHeader = inReader.readPageHeader();
            PageHeader outPageHeader = outReader.readPageHeader();
            Assert.assertEquals((Object)inPageHeader, (Object)outPageHeader);
            DataPageHeader inHeaderV1 = inPageHeader.data_page_header;
            DataPageHeader outHeaderV1 = outPageHeader.data_page_header;
            Assert.assertEquals((Object)inHeaderV1, (Object)outHeaderV1);
            BytesInput inPageLoad = this.readBlockAllocate(inReader, inPageHeader.compressed_page_size);
            BytesInput outPageLoad = this.readBlockAllocate(outReader, outPageHeader.compressed_page_size);
            Assert.assertEquals((Object)inPageLoad.toByteBuffer(), (Object)outPageLoad.toByteBuffer());
        }
    }

    private BytesInput readBlockAllocate(CompressionConverter.TransParquetFileReader reader, int length) throws IOException {
        byte[] data = new byte[length];
        reader.blockRead(data, 0, length);
        return BytesInput.from((byte[])data, (int)0, (int)length);
    }

    private CompressionConverter.TransParquetFileReader createFileReader(String path) throws IOException {
        return new CompressionConverter.TransParquetFileReader((InputFile)HadoopInputFile.fromPath((Path)new Path(path), (Configuration)this.conf), HadoopReadOptions.builder((Configuration)this.conf).withDecryption(EncDecProperties.getFileDecryptionProperties()).build());
    }

    private ParquetReader<Group> createReader(String path) throws IOException {
        return ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)new Path(path)).withConf(this.conf).withDecryption(EncDecProperties.getFileDecryptionProperties()).build();
    }

    private ParquetMetadata getParquetMetadata(FileDecryptionProperties decryptionProperties) throws IOException {
        ParquetMetadata metaData;
        ParquetReadOptions readOptions = ParquetReadOptions.builder().withDecryption(decryptionProperties).build();
        HadoopInputFile file = HadoopInputFile.fromPath((Path)new Path(this.outputFile), (Configuration)this.conf);
        try (SeekableInputStream in = file.newStream();){
            metaData = ParquetFileReader.readFooter((InputFile)file, (ParquetReadOptions)readOptions, (SeekableInputStream)in);
        }
        return metaData;
    }

    private MessageType createSchema() {
        return new MessageType("schema", new Type[]{new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.INT64, "DocId"), new PrimitiveType(Type.Repetition.REQUIRED, PrimitiveType.PrimitiveTypeName.BINARY, "Name"), new PrimitiveType(Type.Repetition.OPTIONAL, PrimitiveType.PrimitiveTypeName.BINARY, "Gender"), new GroupType(Type.Repetition.OPTIONAL, "Links", new Type[]{new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Backward"), new PrimitiveType(Type.Repetition.REPEATED, PrimitiveType.PrimitiveTypeName.BINARY, "Forward")})});
    }
}

