/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.net.URISyntaxException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashSet;
import java.util.List;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.recordlevel.PhoneBookWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;

@RunWith(value=Parameterized.class)
public class TestParquetReader {
    private static final Path FILE_V1 = TestParquetReader.createTempFile();
    private static final Path FILE_V2 = TestParquetReader.createTempFile();
    private static final Path STATIC_FILE_WITHOUT_COL_INDEXES = TestParquetReader.createPathFromCP("/test-file-with-no-column-indexes-1.parquet");
    private static final List<PhoneBookWriter.User> DATA = Collections.unmodifiableList(TestParquetReader.makeUsers(1000));
    private final Path file;

    private static Path createPathFromCP(String path) {
        try {
            return new Path(TestParquetReader.class.getResource(path).toURI());
        }
        catch (URISyntaxException e) {
            throw new RuntimeException(e);
        }
    }

    public TestParquetReader(Path file) {
        this.file = file;
    }

    @Parameterized.Parameters
    public static Collection<Object[]> data() {
        Object[][] data = new Object[][]{{FILE_V1}, {FILE_V2}, {STATIC_FILE_WITHOUT_COL_INDEXES}};
        return Arrays.asList(data);
    }

    @BeforeClass
    public static void createFiles() throws IOException {
        TestParquetReader.writePhoneBookToFile(FILE_V1, ParquetProperties.WriterVersion.PARQUET_1_0);
        TestParquetReader.writePhoneBookToFile(FILE_V2, ParquetProperties.WriterVersion.PARQUET_2_0);
    }

    @AfterClass
    public static void deleteFiles() throws IOException {
        TestParquetReader.deleteFile(FILE_V1);
        TestParquetReader.deleteFile(FILE_V2);
    }

    private static void deleteFile(Path file) throws IOException {
        file.getFileSystem(new Configuration()).delete(file, false);
    }

    public static List<PhoneBookWriter.User> makeUsers(int rowCount) {
        ArrayList<PhoneBookWriter.User> users = new ArrayList<PhoneBookWriter.User>();
        for (int i = 0; i < rowCount; ++i) {
            PhoneBookWriter.Location location = null;
            if (i % 3 == 1) {
                location = new PhoneBookWriter.Location(Double.valueOf(i), (double)i * 2.0);
            }
            if (i % 3 == 2) {
                location = new PhoneBookWriter.Location(Double.valueOf(i), null);
            }
            users.add(new PhoneBookWriter.User(i, "p" + i, Arrays.asList(new PhoneBookWriter.PhoneNumber(i, "cell")), location));
        }
        return users;
    }

    private static Path createTempFile() {
        try {
            return new Path(Files.createTempFile("test-ci_", ".parquet", new FileAttribute[0]).toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw new AssertionError("Unable to create temporary file", e);
        }
    }

    private static void writePhoneBookToFile(Path file, ParquetProperties.WriterVersion parquetVersion) throws IOException {
        int pageSize = DATA.size() / 10;
        int rowGroupSize = pageSize * 6 * 5;
        PhoneBookWriter.write(((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)file).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withRowGroupSize(rowGroupSize)).withPageSize(pageSize)).withWriterVersion(parquetVersion), DATA);
    }

    private List<PhoneBookWriter.User> readUsers(FilterCompat.Filter filter, boolean useOtherFiltering, boolean useColumnIndexFilter) throws IOException {
        return PhoneBookWriter.readUsers((ParquetReader.Builder<Group>)ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)this.file).withFilter(filter).useDictionaryFilter(useOtherFiltering).useStatsFilter(useOtherFiltering).useRecordFilter(useOtherFiltering).useColumnIndexFilter(useColumnIndexFilter), true);
    }

    @Test
    public void testCurrentRowIndex() throws Exception {
        ParquetReader<Group> reader = PhoneBookWriter.createReader(this.file, FilterCompat.NOOP);
        Assert.assertEquals((long)reader.getCurrentRowIndex(), (long)-1L);
        reader.read();
        Assert.assertEquals((long)reader.getCurrentRowIndex(), (long)0L);
        Assert.assertEquals((long)reader.getCurrentRowIndex(), (long)0L);
        reader.read();
        Assert.assertEquals((long)reader.getCurrentRowIndex(), (long)1L);
        Assert.assertEquals((long)reader.getCurrentRowIndex(), (long)1L);
        long expectedCurrentRowIndex = 2L;
        while (reader.read() != null) {
            Assert.assertEquals((long)reader.getCurrentRowIndex(), (long)expectedCurrentRowIndex);
            ++expectedCurrentRowIndex;
        }
        Assert.assertEquals((long)reader.getCurrentRowIndex(), (long)-1L);
    }

    @Test
    public void testSimpleFiltering() throws Exception {
        HashSet<Long> idSet = new HashSet<Long>();
        idSet.add(123L);
        idSet.add(567L);
        List<PhoneBookWriter.User> filteredUsers1 = this.readUsers(FilterCompat.get((FilterPredicate)FilterApi.in((Operators.Column)FilterApi.longColumn((String)"id"), idSet)), true, true);
        Assert.assertEquals((long)filteredUsers1.size(), (long)2L);
        List<PhoneBookWriter.User> filteredUsers2 = this.readUsers(FilterCompat.get((FilterPredicate)FilterApi.in((Operators.Column)FilterApi.longColumn((String)"id"), idSet)), true, false);
        Assert.assertEquals((long)filteredUsers2.size(), (long)2L);
        List<PhoneBookWriter.User> filteredUsers3 = this.readUsers(FilterCompat.get((FilterPredicate)FilterApi.in((Operators.Column)FilterApi.longColumn((String)"id"), idSet)), false, false);
        Assert.assertEquals((long)filteredUsers3.size(), (long)1000L);
    }

    @Test
    public void testNoFiltering() throws Exception {
        Assert.assertEquals(DATA, this.readUsers(FilterCompat.NOOP, false, false));
        Assert.assertEquals(DATA, this.readUsers(FilterCompat.NOOP, true, false));
        Assert.assertEquals(DATA, this.readUsers(FilterCompat.NOOP, false, true));
        Assert.assertEquals(DATA, this.readUsers(FilterCompat.NOOP, true, true));
    }
}

