/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto;

import java.util.HashMap;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.crypto.ColumnDecryptionProperties;
import org.apache.parquet.crypto.DecryptionPropertiesFactory;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.ParquetCryptoRuntimeException;
import org.apache.parquet.hadoop.metadata.ColumnPath;

public class SampleDecryptionPropertiesFactory
implements DecryptionPropertiesFactory {
    public static final byte[] FOOTER_KEY = new byte[]{1, 2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16};
    public static final ColumnPath COL1 = ColumnPath.fromDotString((String)"col_1");
    public static final byte[] COL1_KEY = new byte[]{2, 3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17};
    public static final ColumnDecryptionProperties COL1_ENCR_PROPERTIES = ColumnDecryptionProperties.builder((String)COL1.toDotString()).withKey(COL1_KEY).build();
    public static final ColumnPath COL2 = ColumnPath.fromDotString((String)"col_2");
    public static final byte[] COL2_KEY = new byte[]{3, 4, 5, 6, 7, 8, 9, 10, 11, 12, 13, 14, 15, 16, 17, 18};
    public static final ColumnDecryptionProperties COL2_ENCR_PROPERTIES = ColumnDecryptionProperties.builder((String)COL2.toDotString()).withKey(COL2_KEY).build();

    public FileDecryptionProperties getFileDecryptionProperties(Configuration hadoopConfig, Path filePath) throws ParquetCryptoRuntimeException {
        HashMap<ColumnPath, ColumnDecryptionProperties> columnDecPropertiesMap = new HashMap<ColumnPath, ColumnDecryptionProperties>();
        columnDecPropertiesMap.put(COL1, COL1_ENCR_PROPERTIES);
        columnDecPropertiesMap.put(COL2, COL2_ENCR_PROPERTIES);
        FileDecryptionProperties.Builder fileDecBuilder = FileDecryptionProperties.builder();
        return fileDecBuilder.withFooterKey(FOOTER_KEY).withColumnKeys(columnDecPropertiesMap).build();
    }
}

