/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import java.nio.file.Files;
import java.nio.file.attribute.FileAttribute;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Random;
import java.util.function.Predicate;
import java.util.stream.Collectors;
import java.util.stream.Stream;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.crypto.ColumnEncryptionProperties;
import org.apache.parquet.crypto.DecryptionKeyRetriever;
import org.apache.parquet.crypto.DecryptionKeyRetrieverMock;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.recordlevel.PhoneBookWriter;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.io.api.Binary;
import org.junit.AfterClass;
import org.junit.Assert;
import org.junit.BeforeClass;
import org.junit.Test;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestBloomFiltering {
    private static final Path FILE_V1 = TestBloomFiltering.createTempFile(false);
    private static final Path FILE_V2 = TestBloomFiltering.createTempFile(false);
    private static final Path FILE_V1_E = TestBloomFiltering.createTempFile(true);
    private static final Path FILE_V2_E = TestBloomFiltering.createTempFile(true);
    private static final Logger LOGGER = LoggerFactory.getLogger(TestBloomFiltering.class);
    private static final Random RANDOM = new Random(42L);
    private static final String[] PHONE_KINDS = new String[]{null, "mobile", "home", "work"};
    private static final List<PhoneBookWriter.User> DATA = Collections.unmodifiableList(TestBloomFiltering.generateData(10000));
    private static final byte[] FOOTER_ENCRYPTION_KEY = "0123456789012345".getBytes();
    private static final byte[] COLUMN_ENCRYPTION_KEY1 = "1234567890123450".getBytes();
    private static final byte[] COLUMN_ENCRYPTION_KEY2 = "1234567890123451".getBytes();
    private static final String FOOTER_ENCRYPTION_KEY_ID = "kf";
    private static final String COLUMN_ENCRYPTION_KEY1_ID = "kc1";
    private static final String COLUMN_ENCRYPTION_KEY2_ID = "kc2";
    private final Path file;
    private final boolean isEncrypted;

    public TestBloomFiltering(Path file, boolean isEncrypted) {
        this.file = file;
        this.isEncrypted = isEncrypted;
    }

    private static Path createTempFile(boolean encrypted) {
        String suffix = encrypted ? ".parquet.encrypted" : ".parquet";
        try {
            return new Path(Files.createTempFile("test-bloom-filter_", suffix, new FileAttribute[0]).toAbsolutePath().toString());
        }
        catch (IOException e) {
            throw new AssertionError("Unable to create temporary file", e);
        }
    }

    @Parameterized.Parameters(name="Run {index}: isEncrypted={1}")
    public static Collection<Object[]> params() {
        return Arrays.asList({FILE_V1, false}, {FILE_V2, false}, {FILE_V1_E, true}, {FILE_V2_E, true});
    }

    private static List<PhoneBookWriter.User> generateData(int rowCount) {
        ArrayList<PhoneBookWriter.User> users = new ArrayList<PhoneBookWriter.User>();
        List<String> names = TestBloomFiltering.generateNames(rowCount);
        for (int i = 0; i < rowCount; ++i) {
            users.add(new PhoneBookWriter.User(i, names.get(i), TestBloomFiltering.generatePhoneNumbers(), TestBloomFiltering.generateLocation(i, rowCount)));
        }
        return users;
    }

    private static List<String> generateNames(int rowCount) {
        int i;
        ArrayList<String> list = new ArrayList<String>();
        list.add("anderson");
        list.add("anderson");
        list.add("miller");
        list.add("miller");
        list.add("miller");
        list.add("thomas");
        list.add("thomas");
        list.add("williams");
        int nullCount = rowCount / 100;
        String alphabet = "aabcdeefghiijklmnoopqrstuuvwxyz";
        int maxLength = 8;
        for (i = rowCount - list.size() - nullCount; i >= 0; --i) {
            int l = RANDOM.nextInt(maxLength);
            StringBuilder builder = new StringBuilder(l);
            for (int j = 0; j < l; ++j) {
                builder.append(alphabet.charAt(RANDOM.nextInt(alphabet.length())));
            }
            list.add(builder.toString());
        }
        list.sort((str1, str2) -> -str1.compareTo((String)str2));
        for (i = 0; i < nullCount; ++i) {
            list.add(RANDOM.nextInt(list.size()), null);
        }
        return list;
    }

    private static List<PhoneBookWriter.PhoneNumber> generatePhoneNumbers() {
        int length = RANDOM.nextInt(5) - 1;
        if (length < 0) {
            return null;
        }
        ArrayList<PhoneBookWriter.PhoneNumber> phoneNumbers = new ArrayList<PhoneBookWriter.PhoneNumber>(length);
        for (int i = 0; i < length; ++i) {
            long number = Math.abs(RANDOM.nextLong() % 900000L) + 100000L;
            phoneNumbers.add(new PhoneBookWriter.PhoneNumber(number, PHONE_KINDS[RANDOM.nextInt(PHONE_KINDS.length)]));
        }
        return phoneNumbers;
    }

    private static PhoneBookWriter.Location generateLocation(int id, int rowCount) {
        if (RANDOM.nextDouble() < 0.01) {
            return null;
        }
        if (RANDOM.nextDouble() < 0.001) {
            return new PhoneBookWriter.Location(99.9, 99.9);
        }
        double lat = RANDOM.nextDouble() * 90.0 - (id < rowCount / 2 ? 90.0 : 0.0);
        double lon = RANDOM.nextDouble() * 90.0 - (id < rowCount / 4 || id >= 3 * rowCount / 4 ? 90.0 : 0.0);
        return new PhoneBookWriter.Location(RANDOM.nextDouble() < 0.01 ? null : Double.valueOf(lat), RANDOM.nextDouble() < 0.01 ? null : Double.valueOf(lon));
    }

    private List<PhoneBookWriter.User> readUsers(FilterPredicate filter, boolean useOtherFiltering, boolean useBloomFilter) throws IOException {
        FileDecryptionProperties fileDecryptionProperties = null;
        if (this.isEncrypted) {
            DecryptionKeyRetrieverMock decryptionKeyRetrieverMock = new DecryptionKeyRetrieverMock().putKey(FOOTER_ENCRYPTION_KEY_ID, FOOTER_ENCRYPTION_KEY).putKey(COLUMN_ENCRYPTION_KEY1_ID, COLUMN_ENCRYPTION_KEY1).putKey(COLUMN_ENCRYPTION_KEY2_ID, COLUMN_ENCRYPTION_KEY2);
            fileDecryptionProperties = FileDecryptionProperties.builder().withKeyRetriever((DecryptionKeyRetriever)decryptionKeyRetrieverMock).build();
        }
        return PhoneBookWriter.readUsers((ParquetReader.Builder<Group>)ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)this.file).withFilter(FilterCompat.get((FilterPredicate)filter)).withDecryption(fileDecryptionProperties).useDictionaryFilter(useOtherFiltering).useStatsFilter(useOtherFiltering).useRecordFilter(useOtherFiltering).useBloomFilter(useBloomFilter).useColumnIndexFilter(useOtherFiltering));
    }

    private static void assertContains(Stream<PhoneBookWriter.User> expected, List<PhoneBookWriter.User> actual) {
        Iterator expIt = expected.iterator();
        if (!expIt.hasNext()) {
            return;
        }
        PhoneBookWriter.User exp = (PhoneBookWriter.User)expIt.next();
        for (PhoneBookWriter.User act : actual) {
            if (!act.equals(exp)) continue;
            if (!expIt.hasNext()) break;
            exp = (PhoneBookWriter.User)expIt.next();
        }
        Assert.assertFalse((String)("Not all expected elements are in the actual list. E.g.: " + exp), (boolean)expIt.hasNext());
    }

    private void assertCorrectFiltering(Predicate<PhoneBookWriter.User> expectedFilter, FilterPredicate actualFilter) throws IOException {
        List<PhoneBookWriter.User> result = this.readUsers(actualFilter, false, true);
        Assert.assertTrue((String)"Bloom filtering should drop some row groups", (result.size() < DATA.size() ? 1 : 0) != 0);
        LOGGER.info("{}/{} records read; filtering ratio: {}%", new Object[]{result.size(), DATA.size(), 100 * result.size() / DATA.size()});
        TestBloomFiltering.assertContains(DATA.stream().filter(expectedFilter), result);
        TestBloomFiltering.assertContains(result.stream(), DATA);
        result = this.readUsers(actualFilter, true, false);
        Assert.assertEquals(DATA.stream().filter(expectedFilter).collect(Collectors.toList()), result);
    }

    private static FileEncryptionProperties getFileEncryptionProperties() {
        ColumnEncryptionProperties columnProperties1 = ColumnEncryptionProperties.builder((String)"id").withKey(COLUMN_ENCRYPTION_KEY1).withKeyID(COLUMN_ENCRYPTION_KEY1_ID).build();
        ColumnEncryptionProperties columnProperties2 = ColumnEncryptionProperties.builder((String)"name").withKey(COLUMN_ENCRYPTION_KEY2).withKeyID(COLUMN_ENCRYPTION_KEY2_ID).build();
        HashMap<ColumnPath, ColumnEncryptionProperties> columnPropertiesMap = new HashMap<ColumnPath, ColumnEncryptionProperties>();
        columnPropertiesMap.put(columnProperties1.getPath(), columnProperties1);
        columnPropertiesMap.put(columnProperties2.getPath(), columnProperties2);
        FileEncryptionProperties encryptionProperties = FileEncryptionProperties.builder((byte[])FOOTER_ENCRYPTION_KEY).withFooterKeyID(FOOTER_ENCRYPTION_KEY_ID).withEncryptedColumns(columnPropertiesMap).build();
        return encryptionProperties;
    }

    private static void writePhoneBookToFile(Path file, ParquetProperties.WriterVersion parquetVersion, FileEncryptionProperties encryptionProperties) throws IOException {
        int pageSize = DATA.size() / 100;
        int rowGroupSize = pageSize * 4;
        PhoneBookWriter.write(((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)file).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withRowGroupSize(rowGroupSize)).withPageSize(pageSize)).withBloomFilterNDV("location.lat", 10000L)).withBloomFilterNDV("name", 10000L)).withBloomFilterNDV("id", 10000L)).withEncryption(encryptionProperties)).withWriterVersion(parquetVersion), DATA);
    }

    private static void deleteFile(Path file) throws IOException {
        file.getFileSystem(new Configuration()).delete(file, false);
    }

    @BeforeClass
    public static void createFiles() throws IOException {
        TestBloomFiltering.writePhoneBookToFile(FILE_V1, ParquetProperties.WriterVersion.PARQUET_1_0, null);
        TestBloomFiltering.writePhoneBookToFile(FILE_V2, ParquetProperties.WriterVersion.PARQUET_2_0, null);
        FileEncryptionProperties encryptionProperties = TestBloomFiltering.getFileEncryptionProperties();
        TestBloomFiltering.writePhoneBookToFile(FILE_V1_E, ParquetProperties.WriterVersion.PARQUET_1_0, encryptionProperties);
        TestBloomFiltering.writePhoneBookToFile(FILE_V2_E, ParquetProperties.WriterVersion.PARQUET_2_0, encryptionProperties);
    }

    @AfterClass
    public static void deleteFiles() throws IOException {
        TestBloomFiltering.deleteFile(FILE_V1);
        TestBloomFiltering.deleteFile(FILE_V2);
        TestBloomFiltering.deleteFile(FILE_V1_E);
        TestBloomFiltering.deleteFile(FILE_V2_E);
    }

    @Test
    public void testSimpleFiltering() throws IOException {
        this.assertCorrectFiltering(record -> record.getId() == 1234L, (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"id"), (Comparable)Long.valueOf(1234L)));
        this.assertCorrectFiltering(record -> "miller".equals(record.getName()), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"name"), (Comparable)Binary.fromString((String)"miller")));
    }

    @Test
    public void testNestedFiltering() throws IOException {
        this.assertCorrectFiltering(record -> {
            PhoneBookWriter.Location location = record.getLocation();
            return location != null && location.getLat() != null && location.getLat() == 99.9;
        }, (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.doubleColumn((String)"location.lat"), (Comparable)Double.valueOf(99.9)));
    }
}

