/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.crypto;

import java.io.FileInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Base64;
import java.util.Collection;
import java.util.Collections;
import java.util.List;
import java.util.concurrent.CountDownLatch;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Executors;
import java.util.concurrent.TimeUnit;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.FileSystem;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.crypto.DecryptionPropertiesFactory;
import org.apache.parquet.crypto.EncryptionPropertiesFactory;
import org.apache.parquet.crypto.FileDecryptionProperties;
import org.apache.parquet.crypto.FileEncryptionProperties;
import org.apache.parquet.crypto.ParquetCipher;
import org.apache.parquet.crypto.SingleRow;
import org.apache.parquet.crypto.keytools.KeyToolkit;
import org.apache.parquet.crypto.keytools.PropertiesDrivenCryptoFactory;
import org.apache.parquet.crypto.keytools.mocks.InMemoryKMS;
import org.apache.parquet.crypto.keytools.mocks.LocalWrapInMemoryKMS;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileWriter;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.ErrorCollector;
import org.junit.rules.TemporaryFolder;
import org.junit.runner.RunWith;
import org.junit.runners.Parameterized;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

@RunWith(value=Parameterized.class)
public class TestPropertiesDrivenEncryption {
    @Parameterized.Parameter
    public boolean isKeyMaterialInternalStorage;
    @Parameterized.Parameter(value=1)
    public boolean isDoubleWrapping;
    @Parameterized.Parameter(value=2)
    public boolean isWrapLocally;
    private static final Logger LOG = LoggerFactory.getLogger(TestPropertiesDrivenEncryption.class);
    @Rule
    public TemporaryFolder temporaryFolder = new TemporaryFolder();
    @Rule
    public ErrorCollector errorCollector = new ErrorCollector();
    private static final Base64.Encoder encoder = Base64.getEncoder();
    private static final String FOOTER_MASTER_KEY = encoder.encodeToString("0123456789012345".getBytes(StandardCharsets.UTF_8));
    private static final String[] COLUMN_MASTER_KEYS = new String[]{encoder.encodeToString("1234567890123450".getBytes(StandardCharsets.UTF_8)), encoder.encodeToString("1234567890123451".getBytes(StandardCharsets.UTF_8)), encoder.encodeToString("1234567890123452".getBytes(StandardCharsets.UTF_8)), encoder.encodeToString("1234567890123453".getBytes(StandardCharsets.UTF_8)), encoder.encodeToString("1234567890123454".getBytes(StandardCharsets.UTF_8)), encoder.encodeToString("1234567890123455".getBytes(StandardCharsets.UTF_8))};
    private static final String[] COLUMN_MASTER_KEY_IDS = new String[]{"kc1", "kc2", "kc3", "kc4", "kc5", "kc6"};
    private static final String FOOTER_MASTER_KEY_ID = "kf";
    private static final String KEY_LIST = COLUMN_MASTER_KEY_IDS[0] + ": " + COLUMN_MASTER_KEYS[0] + ", " + COLUMN_MASTER_KEY_IDS[1] + ": " + COLUMN_MASTER_KEYS[1] + ", " + COLUMN_MASTER_KEY_IDS[2] + ": " + COLUMN_MASTER_KEYS[2] + ", " + COLUMN_MASTER_KEY_IDS[3] + ": " + COLUMN_MASTER_KEYS[3] + ", " + COLUMN_MASTER_KEY_IDS[4] + ": " + COLUMN_MASTER_KEYS[4] + ", " + COLUMN_MASTER_KEY_IDS[5] + ": " + COLUMN_MASTER_KEYS[5] + ", " + "kf" + ": " + FOOTER_MASTER_KEY;
    private static final String NEW_FOOTER_MASTER_KEY = encoder.encodeToString("9123456789012345".getBytes(StandardCharsets.UTF_8));
    private static final String[] NEW_COLUMN_MASTER_KEYS = new String[]{encoder.encodeToString("9234567890123450".getBytes(StandardCharsets.UTF_8)), encoder.encodeToString("9234567890123451".getBytes(StandardCharsets.UTF_8)), encoder.encodeToString("9234567890123452".getBytes(StandardCharsets.UTF_8)), encoder.encodeToString("9234567890123453".getBytes(StandardCharsets.UTF_8)), encoder.encodeToString("9234567890123454".getBytes(StandardCharsets.UTF_8)), encoder.encodeToString("9234567890123455".getBytes(StandardCharsets.UTF_8))};
    private static final String NEW_KEY_LIST = COLUMN_MASTER_KEY_IDS[0] + ": " + NEW_COLUMN_MASTER_KEYS[0] + ", " + COLUMN_MASTER_KEY_IDS[1] + ": " + NEW_COLUMN_MASTER_KEYS[1] + ", " + COLUMN_MASTER_KEY_IDS[2] + ": " + NEW_COLUMN_MASTER_KEYS[2] + ", " + COLUMN_MASTER_KEY_IDS[3] + ": " + NEW_COLUMN_MASTER_KEYS[3] + ", " + COLUMN_MASTER_KEY_IDS[4] + ": " + NEW_COLUMN_MASTER_KEYS[4] + ", " + COLUMN_MASTER_KEY_IDS[5] + ": " + NEW_COLUMN_MASTER_KEYS[5] + ", " + "kf" + ": " + NEW_FOOTER_MASTER_KEY;
    private static final String COLUMN_KEY_MAPPING = COLUMN_MASTER_KEY_IDS[0] + ": " + "double_field" + "; " + COLUMN_MASTER_KEY_IDS[1] + ": " + "float_field" + "; " + COLUMN_MASTER_KEY_IDS[2] + ": " + "boolean_field" + "; " + COLUMN_MASTER_KEY_IDS[3] + ": " + "int32_field" + "; " + COLUMN_MASTER_KEY_IDS[4] + ": " + "ba_field" + "; " + COLUMN_MASTER_KEY_IDS[5] + ": " + "flba_field";
    private static final int NUM_THREADS = 4;
    private static final int WAIT_FOR_WRITE_TO_END_SECONDS = 5;
    private static final int WAIT_FOR_READ_TO_END_SECONDS = 5;
    private static final boolean plaintextFilesAllowed = true;
    private static final int ROW_COUNT = 10000;
    private static final List<SingleRow> DATA = Collections.unmodifiableList(SingleRow.generateRandomData(10000));

    @Parameterized.Parameters(name="Run {index}: isKeyMaterialInternalStorage={0} isDoubleWrapping={1} isWrapLocally={2}")
    public static Collection<Object[]> data() {
        boolean[] flagValues;
        ArrayList<Object[]> list = new ArrayList<Object[]>(8);
        for (boolean keyMaterialInternalStorage : flagValues = new boolean[]{false, true}) {
            for (boolean doubleWrapping : flagValues) {
                for (boolean wrapLocally : flagValues) {
                    Object[] vector = new Object[]{keyMaterialInternalStorage, doubleWrapping, wrapLocally};
                    list.add(vector);
                }
            }
        }
        return list;
    }

    private static Configuration getCryptoProperties(TestPropertiesDrivenEncryption test) {
        Configuration conf = new Configuration();
        conf.set("parquet.crypto.factory.class", PropertiesDrivenCryptoFactory.class.getName());
        if (test.isWrapLocally) {
            conf.set("parquet.encryption.kms.client.class", LocalWrapInMemoryKMS.class.getName());
        } else {
            conf.set("parquet.encryption.kms.client.class", InMemoryKMS.class.getName());
        }
        conf.set("parquet.encryption.key.list", KEY_LIST);
        conf.set("parquet.encryption.new.key.list", NEW_KEY_LIST);
        conf.setBoolean("parquet.encryption.key.material.store.internally", test.isKeyMaterialInternalStorage);
        conf.setBoolean("parquet.encryption.double.wrapping", test.isDoubleWrapping);
        return conf;
    }

    private static void setEncryptionKeys(Configuration conf) {
        conf.set("parquet.encryption.column.keys", COLUMN_KEY_MAPPING);
        conf.set("parquet.encryption.footer.key", FOOTER_MASTER_KEY_ID);
    }

    @Test
    public void testWriteReadEncryptedParquetFiles() throws IOException {
        Path rootPath = new Path(this.temporaryFolder.getRoot().getPath());
        LOG.info("======== testWriteReadEncryptedParquetFiles {} ========", (Object)rootPath.toString());
        LOG.info("Run: isKeyMaterialInternalStorage={} isDoubleWrapping={} isWrapLocally={}", new Object[]{this.isKeyMaterialInternalStorage, this.isDoubleWrapping, this.isWrapLocally});
        KeyToolkit.removeCacheEntriesForAllTokens();
        ExecutorService threadPool = Executors.newFixedThreadPool(4);
        try {
            this.testWriteEncryptedParquetFiles(rootPath, DATA, threadPool);
            this.testReadEncryptedParquetFiles(rootPath, DATA, threadPool);
        }
        finally {
            threadPool.shutdown();
        }
    }

    private void testWriteEncryptedParquetFiles(Path root, List<SingleRow> data, ExecutorService threadPool) throws IOException {
        EncryptionConfiguration[] encryptionConfigurations;
        for (EncryptionConfiguration encryptionConfiguration : encryptionConfigurations = EncryptionConfiguration.values()) {
            Configuration conf;
            Path encryptionConfigurationFolderPath = new Path(root, encryptionConfiguration.name());
            FileSystem fs = encryptionConfigurationFolderPath.getFileSystem(conf = new Configuration());
            if (fs.exists(encryptionConfigurationFolderPath)) {
                fs.delete(encryptionConfigurationFolderPath, true);
            }
            fs.mkdirs(encryptionConfigurationFolderPath);
            KeyToolkit.removeCacheEntriesForAllTokens();
            CountDownLatch latch = new CountDownLatch(4);
            int i = 0;
            while (i < 4) {
                int threadNumber = i++;
                threadPool.execute(() -> {
                    this.writeEncryptedParquetFile(encryptionConfigurationFolderPath, data, encryptionConfiguration, threadNumber);
                    latch.countDown();
                });
            }
            try {
                latch.await(5L, TimeUnit.SECONDS);
            }
            catch (InterruptedException e) {
                Thread.currentThread().interrupt();
            }
        }
    }

    private void writeEncryptedParquetFile(Path root, List<SingleRow> data, EncryptionConfiguration encryptionConfiguration, int threadNumber) {
        MessageType schema = SingleRow.getSchema();
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        int pageSize = data.size() / 10;
        int rowGroupSize = pageSize * 6 * 5;
        Path file = new Path(root, this.getFileName(root, encryptionConfiguration, threadNumber));
        LOG.info("\nWrite " + file.toString());
        Configuration conf = encryptionConfiguration.getHadoopConfiguration(this);
        FileEncryptionProperties fileEncryptionProperties = null;
        try {
            if (null == conf) {
                conf = new Configuration();
            } else {
                EncryptionPropertiesFactory cryptoFactory = EncryptionPropertiesFactory.loadFactory((Configuration)conf);
                fileEncryptionProperties = cryptoFactory.getFileEncryptionProperties(conf, file, null);
            }
        }
        catch (Exception e) {
            this.addErrorToErrorCollectorAndLog("Failed writing " + file.toString(), e, encryptionConfiguration, null);
            return;
        }
        try (ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)file).withConf(conf)).withWriteMode(ParquetFileWriter.Mode.OVERWRITE)).withType(schema).withPageSize(pageSize)).withRowGroupSize(rowGroupSize)).withEncryption(fileEncryptionProperties)).build();){
            for (SingleRow singleRow : data) {
                writer.write((Object)f.newGroup().append("boolean_field", singleRow.boolean_field).append("int32_field", singleRow.int32_field).append("float_field", singleRow.float_field).append("double_field", singleRow.double_field).append("ba_field", Binary.fromConstantByteArray((byte[])singleRow.ba_field)).append("flba_field", Binary.fromConstantByteArray((byte[])singleRow.flba_field)).append("plain_int32_field", singleRow.plaintext_int32_field.intValue()));
            }
        }
        catch (Exception e) {
            this.addErrorToErrorCollectorAndLog("Failed writing " + file.toString(), e, encryptionConfiguration, null);
        }
    }

    private Path getFileName(Path root, EncryptionConfiguration encryptionConfiguration, int threadNumber) {
        String suffix = EncryptionConfiguration.NO_ENCRYPTION == encryptionConfiguration ? ".parquet" : ".parquet.encrypted";
        return new Path(root, encryptionConfiguration.toString() + "_" + threadNumber + suffix);
    }

    private void testReadEncryptedParquetFiles(Path root, List<SingleRow> data, ExecutorService threadPool) throws IOException {
        EncryptionConfiguration[] encryptionConfigurations;
        this.readFilesMultithreaded(root, data, threadPool, false);
        if (this.isWrapLocally) {
            return;
        }
        LOG.info("--> Start master key rotation");
        Configuration hadoopConfigForRotation = EncryptionConfiguration.ENCRYPT_COLUMNS_AND_FOOTER.getHadoopConfiguration(this);
        hadoopConfigForRotation.set("parquet.encryption.new.key.list", NEW_KEY_LIST);
        InMemoryKMS.startKeyRotation(hadoopConfigForRotation);
        for (EncryptionConfiguration encryptionConfiguration : encryptionConfigurations = EncryptionConfiguration.values()) {
            if (EncryptionConfiguration.NO_ENCRYPTION == encryptionConfiguration) continue;
            Path encryptionConfigurationFolderPath = new Path(root, encryptionConfiguration.name());
            try {
                LOG.info("Rotate master keys in folder: " + encryptionConfigurationFolderPath.toString());
                KeyToolkit.rotateMasterKeys((String)encryptionConfigurationFolderPath.toString(), (Configuration)hadoopConfigForRotation);
            }
            catch (UnsupportedOperationException e) {
                if (this.isKeyMaterialInternalStorage || this.isWrapLocally) {
                    LOG.info("Key material file not found, as expected");
                } else {
                    this.errorCollector.addError((Throwable)e);
                }
                return;
            }
            catch (Exception e) {
                this.errorCollector.addError((Throwable)e);
                return;
            }
        }
        InMemoryKMS.finishKeyRotation();
        LOG.info("--> Finish master key rotation");
        LOG.info("--> Read files again with new keys");
        this.readFilesMultithreaded(root, data, threadPool, true);
    }

    private void readFilesMultithreaded(Path root, List<SingleRow> data, ExecutorService threadPool, boolean keysRotated) {
        DecryptionConfiguration[] decryptionConfigurations;
        for (DecryptionConfiguration decryptionConfiguration : decryptionConfigurations = DecryptionConfiguration.values()) {
            EncryptionConfiguration[] encryptionConfigurations;
            LOG.info("\n\n");
            LOG.info("==> Decryption configuration {}\n", (Object)decryptionConfiguration);
            Configuration hadoopConfig = decryptionConfiguration.getHadoopConfiguration(this);
            if (null != hadoopConfig) {
                KeyToolkit.removeCacheEntriesForAllTokens();
            }
            for (EncryptionConfiguration encryptionConfiguration : encryptionConfigurations = EncryptionConfiguration.values()) {
                Path encryptionConfigurationFolderPath = new Path(root, encryptionConfiguration.name());
                CountDownLatch latch = new CountDownLatch(4);
                int i = 0;
                while (i < 4) {
                    int threadNumber = i++;
                    threadPool.execute(() -> {
                        Path file = this.getFileName(encryptionConfigurationFolderPath, encryptionConfiguration, threadNumber);
                        LOG.info("--> Read file {} {}", (Object)file.toString(), (Object)encryptionConfiguration);
                        this.readFileAndCheckResult(hadoopConfig, encryptionConfiguration, decryptionConfiguration, data, file, keysRotated);
                        latch.countDown();
                    });
                }
                try {
                    latch.await(5L, TimeUnit.SECONDS);
                }
                catch (InterruptedException e) {
                    Thread.currentThread().interrupt();
                }
            }
        }
    }

    private void readFileAndCheckResult(Configuration hadoopConfig, EncryptionConfiguration encryptionConfiguration, DecryptionConfiguration decryptionConfiguration, List<SingleRow> data, Path file, boolean keysRotated) {
        FileDecryptionProperties fileDecryptionProperties = null;
        if (null == hadoopConfig) {
            hadoopConfig = new Configuration();
        } else {
            DecryptionPropertiesFactory cryptoFactory = DecryptionPropertiesFactory.loadFactory((Configuration)hadoopConfig);
            fileDecryptionProperties = cryptoFactory.getFileDecryptionProperties(hadoopConfig, file);
        }
        if (decryptionConfiguration == DecryptionConfiguration.NO_DECRYPTION && encryptionConfiguration == EncryptionConfiguration.ENCRYPT_COLUMNS_PLAINTEXT_FOOTER) {
            hadoopConfig.set("parquet.read.schema", ((MessageType)((Types.GroupBuilder)Types.buildMessage().optional(PrimitiveType.PrimitiveTypeName.INT32).named("plain_int32_field")).named("FormatTestObject")).toString());
        }
        if (encryptionConfiguration != EncryptionConfiguration.NO_ENCRYPTION && encryptionConfiguration != EncryptionConfiguration.ENCRYPT_COLUMNS_PLAINTEXT_FOOTER) {
            byte[] magic = new byte[ParquetFileWriter.MAGIC.length];
            try (FileInputStream is = new FileInputStream(file.toString());){
                if (((InputStream)is).read(magic) != magic.length) {
                    throw new RuntimeException("ERROR");
                }
                if (!Arrays.equals(ParquetFileWriter.EFMAGIC, magic)) {
                    this.addErrorToErrorCollectorAndLog("File doesn't start with PARE", encryptionConfiguration, decryptionConfiguration);
                }
            }
            catch (IOException e) {
                this.addErrorToErrorCollectorAndLog("Failed to read magic string at the beginning of file", e, encryptionConfiguration, decryptionConfiguration);
            }
        }
        if (keysRotated && null != hadoopConfig.get("parquet.encryption.key.list")) {
            hadoopConfig.set("parquet.encryption.key.list", NEW_KEY_LIST);
        }
        int rowNum = 0;
        try (ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).withConf(hadoopConfig).withDecryption(fileDecryptionProperties).build();){
            Group group = (Group)reader.read();
            while (group != null) {
                SingleRow rowExpected = data.get(rowNum++);
                if (rowExpected.plaintext_int32_field.intValue() != group.getInteger("plain_int32_field", 0)) {
                    this.addErrorToErrorCollectorAndLog("Wrong int", encryptionConfiguration, decryptionConfiguration);
                }
                if (decryptionConfiguration != DecryptionConfiguration.NO_DECRYPTION) {
                    if (rowExpected.boolean_field != group.getBoolean("boolean_field", 0)) {
                        this.addErrorToErrorCollectorAndLog("Wrong bool", encryptionConfiguration, decryptionConfiguration);
                    }
                    if (rowExpected.int32_field != group.getInteger("int32_field", 0)) {
                        this.addErrorToErrorCollectorAndLog("Wrong int", encryptionConfiguration, decryptionConfiguration);
                    }
                    if (rowExpected.float_field != group.getFloat("float_field", 0)) {
                        this.addErrorToErrorCollectorAndLog("Wrong float", encryptionConfiguration, decryptionConfiguration);
                    }
                    if (rowExpected.double_field != group.getDouble("double_field", 0)) {
                        this.addErrorToErrorCollectorAndLog("Wrong double", encryptionConfiguration, decryptionConfiguration);
                    }
                    if (null != rowExpected.ba_field && !Arrays.equals(rowExpected.ba_field, group.getBinary("ba_field", 0).getBytes())) {
                        this.addErrorToErrorCollectorAndLog("Wrong byte array", encryptionConfiguration, decryptionConfiguration);
                    }
                    if (!Arrays.equals(rowExpected.flba_field, group.getBinary("flba_field", 0).getBytes())) {
                        this.addErrorToErrorCollectorAndLog("Wrong fixed-length byte array", encryptionConfiguration, decryptionConfiguration);
                    }
                }
                group = (Group)reader.read();
            }
        }
        catch (Exception e) {
            this.checkResult(file.getName(), decryptionConfiguration, e);
        }
        hadoopConfig.unset("parquet.read.schema");
    }

    private void checkResult(String file, DecryptionConfiguration decryptionConfiguration, Exception exception) {
        String errorMessage = exception.getMessage();
        String exceptionMsg = null == errorMessage ? exception.getClass().getName() : errorMessage;
        EncryptionConfiguration encryptionConfiguration = this.getEncryptionConfigurationFromFilename(file);
        if (decryptionConfiguration == DecryptionConfiguration.NO_DECRYPTION && encryptionConfiguration != EncryptionConfiguration.NO_ENCRYPTION && encryptionConfiguration != EncryptionConfiguration.ENCRYPT_COLUMNS_PLAINTEXT_FOOTER) {
            if (!exceptionMsg.endsWith("No encryption key list") && !exceptionMsg.endsWith("No keys available")) {
                this.addErrorToErrorCollectorAndLog("Expecting  No keys available exception", exceptionMsg, encryptionConfiguration, decryptionConfiguration);
            } else {
                LOG.info("Exception as expected: " + exceptionMsg);
            }
            return;
        }
        exception.printStackTrace();
        this.addErrorToErrorCollectorAndLog("Didn't expect an exception", exceptionMsg, encryptionConfiguration, decryptionConfiguration);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private EncryptionConfiguration getEncryptionConfigurationFromFilename(String file) {
        if (!file.endsWith(".parquet.encrypted")) {
            return null;
        }
        String fileNamePrefix = file.replaceFirst("(.*)_[0-9]+.parquet.encrypted", "$1");
        try {
            EncryptionConfiguration encryptionConfiguration = EncryptionConfiguration.valueOf(fileNamePrefix.toUpperCase());
            return encryptionConfiguration;
        }
        catch (IllegalArgumentException e) {
            LOG.error("File name doesn't match any known encryption configuration: " + file);
            ErrorCollector errorCollector = this.errorCollector;
            synchronized (errorCollector) {
                this.errorCollector.addError((Throwable)e);
            }
            return null;
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addErrorToErrorCollectorAndLog(String errorMessage, String exceptionMessage, EncryptionConfiguration encryptionConfiguration, DecryptionConfiguration decryptionConfiguration) {
        String fullErrorMessage = String.format("%s - %s Error: %s, but got [%s]", new Object[]{encryptionConfiguration, decryptionConfiguration, errorMessage, exceptionMessage});
        ErrorCollector errorCollector = this.errorCollector;
        synchronized (errorCollector) {
            this.errorCollector.addError(new Throwable(fullErrorMessage));
        }
        LOG.error(fullErrorMessage);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void addErrorToErrorCollectorAndLog(String errorMessage, EncryptionConfiguration encryptionConfiguration, DecryptionConfiguration decryptionConfiguration) {
        String fullErrorMessage = String.format("%s - %s Error: %s", new Object[]{encryptionConfiguration, decryptionConfiguration, errorMessage});
        ErrorCollector errorCollector = this.errorCollector;
        synchronized (errorCollector) {
            this.errorCollector.addError(new Throwable(fullErrorMessage));
        }
        LOG.error(fullErrorMessage);
    }

    private void addErrorToErrorCollectorAndLog(String errorMessage, Throwable exception, EncryptionConfiguration encryptionConfiguration, DecryptionConfiguration decryptionConfiguration) {
        String errorMessageWithExceptionDetails = String.format("%s %s %s", errorMessage, exception.getClass().getName(), exception.getMessage());
        this.addErrorToErrorCollectorAndLog(errorMessageWithExceptionDetails, encryptionConfiguration, decryptionConfiguration);
        exception.printStackTrace();
    }

    public static enum DecryptionConfiguration {
        DECRYPT_WITH_KEY_RETRIEVER{

            @Override
            public Configuration getHadoopConfiguration(TestPropertiesDrivenEncryption test) {
                Configuration conf = TestPropertiesDrivenEncryption.getCryptoProperties(test);
                return conf;
            }
        }
        ,
        NO_DECRYPTION{

            @Override
            public Configuration getHadoopConfiguration(TestPropertiesDrivenEncryption test) {
                return null;
            }
        };


        public abstract Configuration getHadoopConfiguration(TestPropertiesDrivenEncryption var1);
    }

    public static enum EncryptionConfiguration {
        ENCRYPT_COLUMNS_AND_FOOTER{

            @Override
            public Configuration getHadoopConfiguration(TestPropertiesDrivenEncryption test) {
                Configuration conf = TestPropertiesDrivenEncryption.getCryptoProperties(test);
                TestPropertiesDrivenEncryption.setEncryptionKeys(conf);
                return conf;
            }
        }
        ,
        ENCRYPT_COLUMNS_PLAINTEXT_FOOTER{

            @Override
            public Configuration getHadoopConfiguration(TestPropertiesDrivenEncryption test) {
                Configuration conf = TestPropertiesDrivenEncryption.getCryptoProperties(test);
                TestPropertiesDrivenEncryption.setEncryptionKeys(conf);
                conf.setBoolean("parquet.encryption.plaintext.footer", true);
                return conf;
            }
        }
        ,
        ENCRYPT_COLUMNS_AND_FOOTER_CTR{

            @Override
            public Configuration getHadoopConfiguration(TestPropertiesDrivenEncryption test) {
                Configuration conf = TestPropertiesDrivenEncryption.getCryptoProperties(test);
                TestPropertiesDrivenEncryption.setEncryptionKeys(conf);
                conf.set("parquet.encryption.algorithm", ParquetCipher.AES_GCM_CTR_V1.toString());
                return conf;
            }
        }
        ,
        NO_ENCRYPTION{

            @Override
            public Configuration getHadoopConfiguration(TestPropertiesDrivenEncryption test) {
                return null;
            }
        };


        public abstract Configuration getHadoopConfiguration(TestPropertiesDrivenEncryption var1);
    }
}

