/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.io.IOException;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.EncodingStats;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestReadWriteEncodingStats {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();
    private static final Configuration CONF = new Configuration();
    private static final int NUM_RECORDS = 1000;
    private static final MessageType SCHEMA = MessageTypeParser.parseMessageType((String)"message test { required binary dict_binary_field; required int32 plain_int32_field; required binary fallback_binary_field; } ");
    private static final String ALPHABET = "abcdefghijklmnopqrstuvwxyz";

    private static void writeData(ParquetWriter<Group> writer) throws IOException {
        SimpleGroupFactory f = new SimpleGroupFactory(SCHEMA);
        for (int i = 0; i < 1000; ++i) {
            int index = i % ALPHABET.length();
            Group group = f.newGroup().append("dict_binary_field", ALPHABET.substring(index, index + 1)).append("plain_int32_field", i).append("fallback_binary_field", i < 500 ? ALPHABET.substring(index, index + 1) : UUID.randomUUID().toString());
            writer.write((Object)group);
        }
    }

    @Test
    public void testReadWrite() throws Exception {
        File file = this.temp.newFile("encoding-stats.parquet");
        Assert.assertTrue((boolean)file.delete());
        Path path = new Path(file.toString());
        ParquetWriter writer = ((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)((ExampleParquetWriter.Builder)ExampleParquetWriter.builder((Path)path).withWriterVersion(ParquetProperties.WriterVersion.PARQUET_1_0)).withPageSize(1024)).enableDictionaryEncoding()).withDictionaryPageSize(2048)).withConf(CONF)).withType(SCHEMA).build();
        TestReadWriteEncodingStats.writeData((ParquetWriter<Group>)writer);
        writer.close();
        ParquetFileReader reader = ParquetFileReader.open((Configuration)CONF, (Path)path);
        Assert.assertEquals((String)"Should have one row group", (long)1L, (long)reader.getRowGroups().size());
        BlockMetaData rowGroup = (BlockMetaData)reader.getRowGroups().get(0);
        ColumnChunkMetaData dictColumn = (ColumnChunkMetaData)rowGroup.getColumns().get(0);
        EncodingStats dictStats = dictColumn.getEncodingStats();
        Assert.assertNotNull((String)"Dict column should have non-null encoding stats", (Object)dictStats);
        Assert.assertTrue((String)"Dict column should have a dict page", (boolean)dictStats.hasDictionaryPages());
        Assert.assertTrue((String)"Dict column should have dict-encoded pages", (boolean)dictStats.hasDictionaryEncodedPages());
        Assert.assertFalse((String)"Dict column should not have non-dict pages", (boolean)dictStats.hasNonDictionaryEncodedPages());
        ColumnChunkMetaData plainColumn = (ColumnChunkMetaData)rowGroup.getColumns().get(1);
        EncodingStats plainStats = plainColumn.getEncodingStats();
        Assert.assertNotNull((String)"Plain column should have non-null encoding stats", (Object)plainStats);
        Assert.assertFalse((String)"Plain column should not have a dict page", (boolean)plainStats.hasDictionaryPages());
        Assert.assertFalse((String)"Plain column should not have dict-encoded pages", (boolean)plainStats.hasDictionaryEncodedPages());
        Assert.assertTrue((String)"Plain column should have non-dict pages", (boolean)plainStats.hasNonDictionaryEncodedPages());
        ColumnChunkMetaData fallbackColumn = (ColumnChunkMetaData)rowGroup.getColumns().get(2);
        EncodingStats fallbackStats = fallbackColumn.getEncodingStats();
        Assert.assertNotNull((String)"Fallback column should have non-null encoding stats", (Object)fallbackStats);
        Assert.assertTrue((String)"Fallback column should have a dict page", (boolean)fallbackStats.hasDictionaryPages());
        Assert.assertTrue((String)"Fallback column should have dict-encoded pages", (boolean)fallbackStats.hasDictionaryEncodedPages());
        Assert.assertTrue((String)"Fallback column should have non-dict pages", (boolean)fallbackStats.hasNonDictionaryEncodedPages());
    }
}

