/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.io.IOException;
import java.util.Arrays;
import java.util.HashMap;
import java.util.concurrent.Callable;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetReader;
import org.apache.parquet.hadoop.ParquetWriter;
import org.apache.parquet.hadoop.TestUtils;
import org.apache.parquet.hadoop.api.ReadSupport;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.example.ExampleParquetWriter;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.GroupType;
import org.apache.parquet.schema.InvalidSchemaException;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.apache.parquet.schema.Type;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestParquetWriter {
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void test() throws Exception {
        Configuration conf = new Configuration();
        Path root = new Path("target/tests/TestParquetWriter/");
        TestUtils.enforceEmptyDir(conf, root);
        MessageType schema = MessageTypeParser.parseMessageType((String)"message test { required binary binary_field; required int32 int32_field; required int64 int64_field; required boolean boolean_field; required float float_field; required double double_field; required fixed_len_byte_array(3) flba_field; required int96 int96_field; } ");
        GroupWriteSupport.setSchema((MessageType)schema, (Configuration)conf);
        SimpleGroupFactory f = new SimpleGroupFactory(schema);
        HashMap<String, Encoding> expected = new HashMap<String, Encoding>();
        expected.put("10-" + ParquetProperties.WriterVersion.PARQUET_1_0, Encoding.PLAIN_DICTIONARY);
        expected.put("1000-" + ParquetProperties.WriterVersion.PARQUET_1_0, Encoding.PLAIN);
        expected.put("10-" + ParquetProperties.WriterVersion.PARQUET_2_0, Encoding.RLE_DICTIONARY);
        expected.put("1000-" + ParquetProperties.WriterVersion.PARQUET_2_0, Encoding.DELTA_BYTE_ARRAY);
        for (int modulo : Arrays.asList(10, 1000)) {
            for (ParquetProperties.WriterVersion version : ParquetProperties.WriterVersion.values()) {
                Path file = new Path(root, version.name() + "_" + modulo);
                ParquetWriter writer = new ParquetWriter(file, (WriteSupport)new GroupWriteSupport(), CompressionCodecName.UNCOMPRESSED, 1024, 1024, 512, true, false, version, conf);
                for (int i = 0; i < 1000; ++i) {
                    writer.write((Object)f.newGroup().append("binary_field", "test" + i % modulo).append("int32_field", 32).append("int64_field", 64L).append("boolean_field", true).append("float_field", 1.0f).append("double_field", 2.0).append("flba_field", "foo").append("int96_field", Binary.fromConstantByteArray((byte[])new byte[12])));
                }
                writer.close();
                ParquetReader reader = ParquetReader.builder((ReadSupport)new GroupReadSupport(), (Path)file).withConf(conf).build();
                for (int i = 0; i < 1000; ++i) {
                    Group group = (Group)reader.read();
                    Assert.assertEquals((Object)("test" + i % modulo), (Object)group.getBinary("binary_field", 0).toStringUsingUTF8());
                    Assert.assertEquals((long)32L, (long)group.getInteger("int32_field", 0));
                    Assert.assertEquals((long)64L, (long)group.getLong("int64_field", 0));
                    Assert.assertEquals((Object)true, (Object)group.getBoolean("boolean_field", 0));
                    Assert.assertEquals((double)1.0, (double)group.getFloat("float_field", 0), (double)0.001);
                    Assert.assertEquals((double)2.0, (double)group.getDouble("double_field", 0), (double)0.001);
                    Assert.assertEquals((Object)"foo", (Object)group.getBinary("flba_field", 0).toStringUsingUTF8());
                    Assert.assertEquals((Object)Binary.fromConstantByteArray((byte[])new byte[12]), (Object)group.getInt96("int96_field", 0));
                }
                reader.close();
                ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)conf, (Path)file, (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
                for (BlockMetaData blockMetaData : footer.getBlocks()) {
                    for (ColumnChunkMetaData column : blockMetaData.getColumns()) {
                        if (!column.getPath().toDotString().equals("binary_field")) continue;
                        String key = modulo + "-" + version;
                        Encoding expectedEncoding = (Encoding)expected.get(key);
                        Assert.assertTrue((String)(key + ":" + column.getEncodings() + " should contain " + expectedEncoding), (boolean)column.getEncodings().contains(expectedEncoding));
                    }
                }
                Assert.assertEquals((String)"Object model property should be example", (Object)"example", footer.getFileMetaData().getKeyValueMetaData().get("writer.model.name"));
            }
        }
    }

    @Test
    public void testBadWriteSchema() throws IOException {
        final File file = this.temp.newFile("test.parquet");
        file.delete();
        TestUtils.assertThrows("Should reject a schema with an empty group", InvalidSchemaException.class, new Callable<Void>(){

            @Override
            public Void call() throws IOException {
                ExampleParquetWriter.builder((Path)new Path(file.toString())).withType((MessageType)((Types.GroupBuilder)Types.buildMessage().addField((Type)new GroupType(Type.Repetition.REQUIRED, "invalid_group", new Type[0]))).named("invalid_message")).build();
                return null;
            }
        });
        Assert.assertFalse((String)"Should not create a file when schema is rejected", (boolean)file.exists());
    }
}

