/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.lang.management.ManagementFactory;
import java.util.Set;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.mapreduce.RecordWriter;
import org.apache.parquet.hadoop.InternalParquetRecordWriter;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.api.WriteSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.MessageTypeParser;
import org.junit.Assert;
import org.junit.Before;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestMemoryManager {
    Configuration conf = new Configuration();
    String writeSchema = "message example {\nrequired int32 line;\nrequired binary content;\n}";
    long expectedPoolSize;
    ParquetOutputFormat parquetOutputFormat;
    int counter = 0;
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Before
    public void setUp() throws Exception {
        this.parquetOutputFormat = new ParquetOutputFormat((WriteSupport)new GroupWriteSupport());
        GroupWriteSupport.setSchema((MessageType)MessageTypeParser.parseMessageType((String)this.writeSchema), (Configuration)this.conf);
        this.expectedPoolSize = Math.round((double)ManagementFactory.getMemoryMXBean().getHeapMemoryUsage().getMax() * (double)0.95f);
        long rowGroupSize = this.expectedPoolSize / 2L;
        this.conf.setLong("parquet.block.size", rowGroupSize);
        this.createWriter(0).close(null);
    }

    @Test
    public void testMemoryManagerUpperLimit() {
        long poolSize = ParquetOutputFormat.getMemoryManager().getTotalMemoryPool();
        Assert.assertTrue((String)("Pool size should be within 10% of the expected value (expected = " + this.expectedPoolSize + " actual = " + poolSize + ")"), (Math.abs(this.expectedPoolSize - poolSize) < (long)((double)this.expectedPoolSize * 0.1) ? 1 : 0) != 0);
    }

    @Test
    public void testMemoryManager() throws Exception {
        long poolSize = ParquetOutputFormat.getMemoryManager().getTotalMemoryPool();
        long rowGroupSize = poolSize / 2L;
        this.conf.setLong("parquet.block.size", rowGroupSize);
        Assert.assertTrue((String)"Pool should hold 2 full row groups", (2L * rowGroupSize <= poolSize ? 1 : 0) != 0);
        Assert.assertTrue((String)"Pool should not hold 3 full row groups", (poolSize < 3L * rowGroupSize ? 1 : 0) != 0);
        Assert.assertEquals((String)"Allocations should start out at 0", (long)0L, (long)this.getTotalAllocation());
        RecordWriter writer1 = this.createWriter(1);
        Assert.assertTrue((String)"Allocations should never exceed pool size", (this.getTotalAllocation() <= poolSize ? 1 : 0) != 0);
        Assert.assertEquals((String)"First writer should be limited by row group size", (long)rowGroupSize, (long)this.getTotalAllocation());
        RecordWriter writer2 = this.createWriter(2);
        Assert.assertTrue((String)"Allocations should never exceed pool size", (this.getTotalAllocation() <= poolSize ? 1 : 0) != 0);
        Assert.assertEquals((String)"Second writer should be limited by row group size", (long)(2L * rowGroupSize), (long)this.getTotalAllocation());
        RecordWriter writer3 = this.createWriter(3);
        Assert.assertTrue((String)"Allocations should never exceed pool size", (this.getTotalAllocation() <= poolSize ? 1 : 0) != 0);
        writer1.close(null);
        Assert.assertTrue((String)"Allocations should never exceed pool size", (this.getTotalAllocation() <= poolSize ? 1 : 0) != 0);
        Assert.assertEquals((String)"Allocations should be increased to the row group size", (long)(2L * rowGroupSize), (long)this.getTotalAllocation());
        writer2.close(null);
        Assert.assertTrue((String)"Allocations should never exceed pool size", (this.getTotalAllocation() <= poolSize ? 1 : 0) != 0);
        Assert.assertEquals((String)"Allocations should be increased to the row group size", (long)rowGroupSize, (long)this.getTotalAllocation());
        writer3.close(null);
        Assert.assertEquals((String)"Allocations should be increased to the row group size", (long)0L, (long)this.getTotalAllocation());
    }

    @Test
    public void testReallocationCallback() throws Exception {
        long poolSize = ParquetOutputFormat.getMemoryManager().getTotalMemoryPool();
        long rowGroupSize = poolSize / 2L;
        this.conf.setLong("parquet.block.size", rowGroupSize);
        Assert.assertTrue((String)"Pool should hold 2 full row groups", (2L * rowGroupSize <= poolSize ? 1 : 0) != 0);
        Assert.assertTrue((String)"Pool should not hold 3 full row groups", (poolSize < 3L * rowGroupSize ? 1 : 0) != 0);
        Runnable callback = new Runnable(){

            @Override
            public void run() {
                ++TestMemoryManager.this.counter;
            }
        };
        ParquetOutputFormat.getMemoryManager().registerScaleCallBack("increment-test-counter", callback);
        try {
            ParquetOutputFormat.getMemoryManager().registerScaleCallBack("increment-test-counter", callback);
            Assert.fail((String)"Duplicated registering callback should throw duplicates exception.");
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        RecordWriter writer1 = this.createWriter(1);
        RecordWriter writer2 = this.createWriter(2);
        RecordWriter writer3 = this.createWriter(3);
        writer1.close(null);
        writer2.close(null);
        writer3.close(null);
        Assert.assertEquals((String)"Allocations should be adjusted once", (long)1L, (long)this.counter);
        Assert.assertEquals((String)"Should not allow duplicate callbacks", (long)1L, (long)ParquetOutputFormat.getMemoryManager().getScaleCallBacks().size());
    }

    private RecordWriter createWriter(int index) throws Exception {
        File file = this.temp.newFile(String.valueOf(index) + ".parquet");
        if (!file.delete()) {
            throw new RuntimeException("Could not delete file: " + file);
        }
        RecordWriter writer = this.parquetOutputFormat.getRecordWriter(this.conf, new Path(file.toString()), CompressionCodecName.UNCOMPRESSED);
        return writer;
    }

    private long getTotalAllocation() {
        Set writers = ParquetOutputFormat.getMemoryManager().getWriterList().keySet();
        long total = 0L;
        for (InternalParquetRecordWriter writer : writers) {
            total += writer.getRowGroupSizeThreshold();
        }
        return total;
    }
}

