/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.nio.charset.Charset;
import java.util.UUID;
import org.apache.hadoop.conf.Configuration;
import org.apache.hadoop.fs.Path;
import org.apache.hadoop.io.LongWritable;
import org.apache.hadoop.io.Text;
import org.apache.hadoop.mapreduce.Job;
import org.apache.hadoop.mapreduce.JobContext;
import org.apache.hadoop.mapreduce.Mapper;
import org.apache.hadoop.mapreduce.lib.input.TextInputFormat;
import org.apache.hadoop.mapreduce.lib.output.TextOutputFormat;
import org.apache.parquet.Files;
import org.apache.parquet.example.data.Group;
import org.apache.parquet.example.data.simple.SimpleGroupFactory;
import org.apache.parquet.format.converter.ParquetMetadataConverter;
import org.apache.parquet.hadoop.ParquetFileReader;
import org.apache.parquet.hadoop.ParquetInputFormat;
import org.apache.parquet.hadoop.ParquetOutputFormat;
import org.apache.parquet.hadoop.example.GroupReadSupport;
import org.apache.parquet.hadoop.example.GroupWriteSupport;
import org.apache.parquet.hadoop.metadata.BlockMetaData;
import org.apache.parquet.hadoop.metadata.ParquetMetadata;
import org.apache.parquet.hadoop.util.HadoopOutputFile;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.MessageType;
import org.apache.parquet.schema.OriginalType;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestInputOutputFormatWithPadding {
    public static final String FILE_CONTENT = "abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ,abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ,abcdefghijklmnopqrstuvwxyzABCDEFGHIJKLMNOPQRSTUVWXYZ";
    public static MessageType PARQUET_TYPE = (MessageType)((Types.GroupBuilder)((Types.PrimitiveBuilder)((Types.GroupBuilder)((Types.PrimitiveBuilder)Types.buildMessage().required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("uuid")).required(PrimitiveType.PrimitiveTypeName.BINARY).as(OriginalType.UTF8)).named("char")).named("FormatTestObject");
    private static final Charset UTF_8 = Charset.forName("UTF-8");
    @Rule
    public TemporaryFolder temp = new TemporaryFolder();

    @Test
    public void testBasicBehaviorWithPadding() throws Exception {
        HadoopOutputFile.getBlockFileSystems().add("file");
        File inputFile = this.temp.newFile();
        FileOutputStream out = new FileOutputStream(inputFile);
        out.write(FILE_CONTENT.getBytes("UTF-8"));
        out.close();
        File tempFolder = this.temp.newFolder();
        tempFolder.delete();
        Path tempPath = new Path(tempFolder.toURI());
        File outputFolder = this.temp.newFile();
        outputFolder.delete();
        Configuration conf = new Configuration();
        conf.set("dfs.block.size", "1024");
        conf.set("dfs.blocksize", "1024");
        conf.set("dfs.blockSize", "1024");
        conf.set("fs.local.block.size", "1024");
        conf.set("fs.file.impl.disable.cache", "true");
        conf.set("parquet.enable.summary-metadata", "false");
        conf.set("parquet.example.schema", PARQUET_TYPE.toString());
        Job writeJob = new Job(conf, "write");
        writeJob.setInputFormatClass(TextInputFormat.class);
        TextInputFormat.addInputPath((Job)writeJob, (Path)new Path(inputFile.toString()));
        writeJob.setOutputFormatClass(ParquetOutputFormat.class);
        writeJob.setMapperClass(Writer.class);
        writeJob.setNumReduceTasks(0);
        ParquetOutputFormat.setWriteSupportClass((Job)writeJob, GroupWriteSupport.class);
        ParquetOutputFormat.setBlockSize((Job)writeJob, (int)1024);
        ParquetOutputFormat.setPageSize((Job)writeJob, (int)512);
        ParquetOutputFormat.setDictionaryPageSize((Job)writeJob, (int)512);
        ParquetOutputFormat.setEnableDictionary((Job)writeJob, (boolean)true);
        ParquetOutputFormat.setMaxPaddingSize((JobContext)writeJob, (int)1023);
        ParquetOutputFormat.setOutputPath((Job)writeJob, (Path)tempPath);
        this.waitForJob(writeJob);
        File parquetFile = this.getDataFile(tempFolder);
        ParquetMetadata footer = ParquetFileReader.readFooter((Configuration)conf, (Path)new Path(parquetFile.toString()), (ParquetMetadataConverter.MetadataFilter)ParquetMetadataConverter.NO_FILTER);
        for (BlockMetaData block : footer.getBlocks()) {
            Assert.assertTrue((String)"Block should start at a multiple of the block size", (block.getStartingPos() % 1024L == 0L ? 1 : 0) != 0);
        }
        Job readJob = new Job(conf, "read");
        readJob.setInputFormatClass(NoSplits.class);
        ParquetInputFormat.setReadSupportClass((Job)readJob, GroupReadSupport.class);
        TextInputFormat.addInputPath((Job)readJob, (Path)tempPath);
        readJob.setOutputFormatClass(TextOutputFormat.class);
        readJob.setMapperClass(Reader.class);
        readJob.setNumReduceTasks(0);
        TextOutputFormat.setOutputPath((Job)readJob, (Path)new Path(outputFolder.toString()));
        this.waitForJob(readJob);
        File dataFile = this.getDataFile(outputFolder);
        Assert.assertNotNull((String)"Should find a data file", (Object)dataFile);
        StringBuilder contentBuilder = new StringBuilder();
        for (String line : Files.readAllLines((File)dataFile, (Charset)UTF_8)) {
            contentBuilder.append(line);
        }
        String reconstructed = contentBuilder.toString();
        Assert.assertEquals((String)"Should match written file content", (Object)FILE_CONTENT, (Object)reconstructed);
        HadoopOutputFile.getBlockFileSystems().remove("file");
    }

    private void waitForJob(Job job) throws Exception {
        job.submit();
        while (!job.isComplete()) {
            Thread.sleep(100L);
        }
        if (!job.isSuccessful()) {
            throw new RuntimeException("job failed " + job.getJobName());
        }
    }

    private File getDataFile(File location) {
        File[] files = location.listFiles();
        File dataFile = null;
        if (files != null) {
            for (File file : files) {
                if (!file.getName().startsWith("part-")) continue;
                dataFile = file;
                break;
            }
        }
        return dataFile;
    }

    public static class Reader
    extends Mapper<Void, Group, LongWritable, Text> {
        protected void map(Void key, Group value, Mapper.Context context) throws IOException, InterruptedException {
            context.write(null, (Object)new Text(value.getString("char", 0)));
        }
    }

    public static class Writer
    extends Mapper<LongWritable, Text, Void, Group> {
        public static final SimpleGroupFactory GROUP_FACTORY = new SimpleGroupFactory(PARQUET_TYPE);

        protected void map(LongWritable key, Text value, Mapper.Context context) throws IOException, InterruptedException {
            String line = value.toString();
            for (int i = 0; i < line.length(); ++i) {
                Group group = GROUP_FACTORY.newGroup();
                group.add(0, Binary.fromString((String)UUID.randomUUID().toString()));
                group.add(1, Binary.fromString((String)line.substring(i, i + 1)));
                context.write(null, (Object)group);
            }
        }
    }

    private static class NoSplits
    extends ParquetInputFormat {
        private NoSplits() {
        }

        protected boolean isSplitable(JobContext context, Path filename) {
            return false;
        }
    }
}

