/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.nio.ByteBuffer;
import java.util.HashSet;
import java.util.Random;
import org.apache.hadoop.conf.Configuration;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.bytes.DirectByteBufferAllocator;
import org.apache.parquet.bytes.HeapByteBufferAllocator;
import org.apache.parquet.hadoop.CodecFactory;
import org.apache.parquet.hadoop.metadata.CompressionCodecName;
import org.junit.Assert;
import org.junit.Test;

public class TestDirectCodecFactory {
    private final int pageSize = 65536;

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private void test(int size, CompressionCodecName codec, boolean useOnHeapCompression, Decompression decomp) {
        DirectByteBufferAllocator allocator;
        ByteBuffer outBuf;
        ByteBuffer rawBuf;
        block20: {
            rawBuf = null;
            outBuf = null;
            allocator = null;
            try {
                allocator = new DirectByteBufferAllocator();
                CodecFactory codecFactory = CodecFactory.createDirectCodecFactory((Configuration)new Configuration(), (ByteBufferAllocator)allocator, (int)65536);
                rawBuf = allocator.allocate(size);
                byte[] rawArr = new byte[size];
                outBuf = allocator.allocate(size * 2);
                Random r = new Random();
                byte[] random = new byte[1024];
                for (int pos = 0; pos < size; pos += random.length) {
                    r.nextBytes(random);
                    rawBuf.put(random);
                    System.arraycopy(random, 0, rawArr, pos, random.length);
                }
                rawBuf.flip();
                CodecFactory.BytesCompressor c = codecFactory.getCompressor(codec);
                CodecFactory.BytesDecompressor d = codecFactory.getDecompressor(codec);
                BytesInput compressed = useOnHeapCompression ? c.compress(BytesInput.from((byte[])rawArr)) : c.compress(BytesInput.from((ByteBuffer[])new ByteBuffer[]{rawBuf}));
                switch (decomp) {
                    case OFF_HEAP: {
                        ByteBuffer buf = compressed.toByteBuffer();
                        ByteBuffer b = allocator.allocate(buf.capacity());
                        try {
                            b.put(buf);
                            b.flip();
                            d.decompress(b, (int)compressed.size(), outBuf, size);
                            for (int i = 0; i < size; ++i) {
                                Assert.assertTrue((String)("Data didn't match at " + i), (outBuf.get(i) == rawBuf.get(i) ? 1 : 0) != 0);
                            }
                            break;
                        }
                        finally {
                            allocator.release(b);
                        }
                    }
                    case OFF_HEAP_BYTES_INPUT: {
                        ByteBuffer buf = compressed.toByteBuffer();
                        ByteBuffer b = allocator.allocate(buf.limit());
                        try {
                            b.put(buf);
                            b.flip();
                            BytesInput input = d.decompress(BytesInput.from((ByteBuffer[])new ByteBuffer[]{b}), size);
                            Assert.assertArrayEquals((String)String.format("While testing codec %s", codec), (byte[])input.toByteArray(), (byte[])rawArr);
                            break;
                        }
                        finally {
                            allocator.release(b);
                        }
                    }
                    case ON_HEAP: {
                        byte[] buf = compressed.toByteArray();
                        BytesInput input = d.decompress(BytesInput.from((byte[])buf), size);
                        Assert.assertArrayEquals((byte[])input.toByteArray(), (byte[])rawArr);
                        break;
                    }
                }
                if (rawBuf == null) break block20;
            }
            catch (Exception e) {
                try {
                    String msg = String.format("Failure while testing Codec: %s, OnHeapCompressionInput: %s, Decompression Mode: %s, Data Size: %d", codec.name(), useOnHeapCompression, decomp.name(), size);
                    System.out.println(msg);
                    throw new RuntimeException(msg, e);
                }
                catch (Throwable throwable) {
                    if (rawBuf != null) {
                        allocator.release(rawBuf);
                    }
                    if (outBuf != null) {
                        allocator.release(rawBuf);
                    }
                    throw throwable;
                }
            }
            allocator.release(rawBuf);
        }
        if (outBuf != null) {
            allocator.release(rawBuf);
        }
    }

    @Test
    public void createDirectFactoryWithHeapAllocatorFails() {
        String errorMsg = "Test failed, creation of a direct codec factory should have failed when passed a non-direct allocator.";
        try {
            CodecFactory.createDirectCodecFactory((Configuration)new Configuration(), (ByteBufferAllocator)new HeapByteBufferAllocator(), (int)0);
            throw new RuntimeException(errorMsg);
        }
        catch (IllegalStateException ex) {
            Assert.assertTrue((String)"Missing expected error message.", (boolean)ex.getMessage().contains("A DirectCodecFactory requires a direct buffer allocator be provided."));
        }
        catch (Exception ex) {
            throw new RuntimeException(errorMsg + " Failed with the wrong error.");
        }
    }

    @Test
    public void compressionCodecs() throws Exception {
        int[] sizes = new int[]{4096, 0x100000};
        boolean[] comp = new boolean[]{true, false};
        HashSet<CompressionCodecName> codecsToSkip = new HashSet<CompressionCodecName>();
        codecsToSkip.add(CompressionCodecName.LZO);
        codecsToSkip.add(CompressionCodecName.LZ4);
        codecsToSkip.add(CompressionCodecName.ZSTD);
        for (int size : sizes) {
            for (boolean useOnHeapComp : comp) {
                for (Decompression decomp : Decompression.values()) {
                    for (CompressionCodecName codec : CompressionCodecName.values()) {
                        if (codecsToSkip.contains(codec)) continue;
                        this.test(size, codec, useOnHeapComp, decomp);
                    }
                }
            }
        }
    }

    private static enum Decompression {
        ON_HEAP,
        OFF_HEAP,
        OFF_HEAP_BYTES_INPUT;

    }
}

