/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.hadoop;

import java.io.IOException;
import org.apache.parquet.format.PageHeader;
import org.apache.parquet.format.Util;
import org.apache.parquet.hadoop.metadata.ColumnChunkMetaData;
import org.apache.parquet.io.SeekableInputStream;

class Offsets {
    public final long firstDataPageOffset;
    public final long dictionaryPageOffset;

    public static Offsets getOffsets(SeekableInputStream input, ColumnChunkMetaData chunk, long newChunkStart) throws IOException {
        long dictionaryPageOffset;
        long firstDataPageOffset;
        if (chunk.hasDictionaryPage()) {
            long dictionaryPageSize = chunk.getDictionaryPageOffset() == 0L || chunk.getFirstDataPageOffset() <= chunk.getDictionaryPageOffset() ? Offsets.readDictionaryPageSize(input, newChunkStart) : chunk.getFirstDataPageOffset() - chunk.getDictionaryPageOffset();
            firstDataPageOffset = newChunkStart + dictionaryPageSize;
            dictionaryPageOffset = newChunkStart;
        } else {
            firstDataPageOffset = newChunkStart;
            dictionaryPageOffset = 0L;
        }
        return new Offsets(firstDataPageOffset, dictionaryPageOffset);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    private static long readDictionaryPageSize(SeekableInputStream in, long pos) throws IOException {
        long origPos = -1L;
        try {
            origPos = in.getPos();
            PageHeader header = Util.readPageHeader(in);
            long headerSize = in.getPos() - origPos;
            long l = headerSize + (long)header.getCompressed_page_size();
            return l;
        }
        finally {
            if (origPos != -1L) {
                in.seek(origPos);
            }
        }
    }

    private Offsets(long firstDataPageOffset, long dictionaryPageOffset) {
        this.firstDataPageOffset = firstDataPageOffset;
        this.dictionaryPageOffset = dictionaryPageOffset;
    }
}

