/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.bytes;

import java.io.IOException;
import java.io.OutputStream;
import java.nio.ByteBuffer;
import java.util.ArrayList;
import java.util.List;
import org.apache.parquet.Log;
import org.apache.parquet.OutputStreamCloseException;
import org.apache.parquet.Preconditions;
import org.apache.parquet.bytes.ByteBufferAllocator;
import org.apache.parquet.bytes.HeapByteBufferAllocator;

public class CapacityByteArrayOutputStream
extends OutputStream {
    private static final Log LOG = Log.getLog(CapacityByteArrayOutputStream.class);
    private static final ByteBuffer EMPTY_SLAB = ByteBuffer.wrap(new byte[0]);
    private int initialSlabSize;
    private final int maxCapacityHint;
    private final List<ByteBuffer> slabs = new ArrayList<ByteBuffer>();
    private ByteBuffer currentSlab;
    private int currentSlabIndex;
    private int bytesAllocated = 0;
    private int bytesUsed = 0;
    private ByteBufferAllocator allocator;

    public static int initialSlabSizeHeuristic(int minSlabSize, int targetCapacity, int targetNumSlabs) {
        return Math.max(minSlabSize, (int)((double)targetCapacity / Math.pow(2.0, targetNumSlabs)));
    }

    public static CapacityByteArrayOutputStream withTargetNumSlabs(int minSlabSize, int maxCapacityHint, int targetNumSlabs) {
        return CapacityByteArrayOutputStream.withTargetNumSlabs(minSlabSize, maxCapacityHint, targetNumSlabs, (ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    public static CapacityByteArrayOutputStream withTargetNumSlabs(int minSlabSize, int maxCapacityHint, int targetNumSlabs, ByteBufferAllocator allocator) {
        return new CapacityByteArrayOutputStream(CapacityByteArrayOutputStream.initialSlabSizeHeuristic(minSlabSize, maxCapacityHint, targetNumSlabs), maxCapacityHint, allocator);
    }

    @Deprecated
    public CapacityByteArrayOutputStream(int initialSlabSize) {
        this(initialSlabSize, 0x100000, (ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    @Deprecated
    public CapacityByteArrayOutputStream(int initialSlabSize, ByteBufferAllocator allocator) {
        this(initialSlabSize, 0x100000, allocator);
    }

    @Deprecated
    public CapacityByteArrayOutputStream(int initialSlabSize, int maxCapacityHint) {
        this(initialSlabSize, maxCapacityHint, (ByteBufferAllocator)new HeapByteBufferAllocator());
    }

    public CapacityByteArrayOutputStream(int initialSlabSize, int maxCapacityHint, ByteBufferAllocator allocator) {
        Preconditions.checkArgument((initialSlabSize > 0 ? 1 : 0) != 0, (String)"initialSlabSize must be > 0");
        Preconditions.checkArgument((maxCapacityHint > 0 ? 1 : 0) != 0, (String)"maxCapacityHint must be > 0");
        Preconditions.checkArgument((maxCapacityHint >= initialSlabSize ? 1 : 0) != 0, (String)String.format("maxCapacityHint can't be less than initialSlabSize %d %d", initialSlabSize, maxCapacityHint));
        this.initialSlabSize = initialSlabSize;
        this.maxCapacityHint = maxCapacityHint;
        this.allocator = allocator;
        this.reset();
    }

    private void addSlab(int minimumSize) {
        int nextSlabSize = this.bytesUsed == 0 ? this.initialSlabSize : (this.bytesUsed > this.maxCapacityHint / 5 ? this.maxCapacityHint / 5 : this.bytesUsed);
        if (nextSlabSize < minimumSize) {
            if (Log.DEBUG) {
                LOG.debug((Object)String.format("slab size %,d too small for value of size %,d. Bumping up slab size", nextSlabSize, minimumSize));
            }
            nextSlabSize = minimumSize;
        }
        if (Log.DEBUG) {
            LOG.debug((Object)String.format("used %d slabs, adding new slab of size %d", this.slabs.size(), nextSlabSize));
        }
        this.currentSlab = this.allocator.allocate(nextSlabSize);
        this.slabs.add(this.currentSlab);
        this.bytesAllocated += nextSlabSize;
        this.currentSlabIndex = 0;
    }

    @Override
    public void write(int b) {
        if (!this.currentSlab.hasRemaining()) {
            this.addSlab(1);
        }
        this.currentSlab.put(this.currentSlabIndex, (byte)b);
        ++this.currentSlabIndex;
        this.currentSlab.position(this.currentSlabIndex);
        ++this.bytesUsed;
    }

    @Override
    public void write(byte[] b, int off, int len) {
        if (off < 0 || off > b.length || len < 0 || off + len - b.length > 0) {
            throw new IndexOutOfBoundsException(String.format("Given byte array of size %d, with requested length(%d) and offset(%d)", b.length, len, off));
        }
        if (len >= this.currentSlab.remaining()) {
            int length1 = this.currentSlab.remaining();
            this.currentSlab.put(b, off, length1);
            this.bytesUsed += length1;
            this.currentSlabIndex += length1;
            int length2 = len - length1;
            this.addSlab(length2);
            this.currentSlab.put(b, off + length1, length2);
            this.currentSlabIndex = length2;
            this.bytesUsed += length2;
        } else {
            this.currentSlab.put(b, off, len);
            this.currentSlabIndex += len;
            this.bytesUsed += len;
        }
    }

    private void writeToOutput(OutputStream out, ByteBuffer buf, int len) throws IOException {
        if (buf.hasArray()) {
            out.write(buf.array(), buf.arrayOffset(), len);
        } else {
            byte[] copy = new byte[len];
            buf.flip();
            buf.get(copy);
            out.write(copy);
        }
    }

    public void writeTo(OutputStream out) throws IOException {
        for (int i = 0; i < this.slabs.size() - 1; ++i) {
            this.writeToOutput(out, this.slabs.get(i), this.slabs.get(i).position());
        }
        this.writeToOutput(out, this.currentSlab, this.currentSlabIndex);
    }

    public long size() {
        return this.bytesUsed;
    }

    public int getCapacity() {
        return this.bytesAllocated;
    }

    public void reset() {
        this.initialSlabSize = Math.max(this.bytesUsed / 7, this.initialSlabSize);
        if (Log.DEBUG) {
            LOG.debug((Object)String.format("initial slab of size %d", this.initialSlabSize));
        }
        for (ByteBuffer slab : this.slabs) {
            this.allocator.release(slab);
        }
        this.slabs.clear();
        this.bytesAllocated = 0;
        this.bytesUsed = 0;
        this.currentSlab = EMPTY_SLAB;
        this.currentSlabIndex = 0;
    }

    public long getCurrentIndex() {
        Preconditions.checkArgument((this.bytesUsed > 0 ? 1 : 0) != 0, (String)"This is an empty stream");
        return this.bytesUsed - 1;
    }

    public void setByte(long index, byte value) {
        Preconditions.checkArgument((index < (long)this.bytesUsed ? 1 : 0) != 0, (String)("Index: " + index + " is >= the current size of: " + this.bytesUsed));
        long seen = 0L;
        for (int i = 0; i < this.slabs.size(); ++i) {
            ByteBuffer slab = this.slabs.get(i);
            if (index < seen + (long)slab.limit()) {
                slab.put((int)(index - seen), value);
                break;
            }
            seen += (long)slab.limit();
        }
    }

    public String memUsageString(String prefix) {
        return String.format("%s %s %d slabs, %,d bytes", prefix, this.getClass().getSimpleName(), this.slabs.size(), this.getCapacity());
    }

    int getSlabCount() {
        return this.slabs.size();
    }

    @Override
    public void close() {
        for (ByteBuffer slab : this.slabs) {
            this.allocator.release(slab);
        }
        try {
            super.close();
        }
        catch (IOException e) {
            throw new OutputStreamCloseException((Throwable)e);
        }
    }
}

