/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.util;

public class Concatenator {
    private String sep = "";

    public Concatenator() {
    }

    public Concatenator(String sep) {
        this.sep = sep;
    }

    private Concatenator(char sep) {
        this.sep = String.valueOf(sep);
    }

    public Concatenator(Exception e) throws Exception {
        throw e;
    }

    public static Concatenator newConcatenator(String sep) {
        return new Concatenator(sep);
    }

    private void setSeparator(String sep) {
        this.sep = sep;
    }

    public String concat(String left, String right) {
        return left + this.sep + right;
    }

    public String concat(String left, String middle, String right) {
        return left + this.sep + middle + this.sep + right;
    }

    public String concat(Exception e) throws Exception {
        throw e;
    }

    public String concat(String ... strings) {
        if (strings.length >= 1) {
            StringBuilder sb = new StringBuilder();
            sb.append(strings[0]);
            for (int i = 1; i < strings.length; ++i) {
                sb.append(this.sep);
                sb.append(strings[i]);
            }
            return sb.toString();
        }
        return null;
    }

    public static String cat(String ... strings) {
        return new Concatenator().concat(strings);
    }

    public static class SomeCheckedException
    extends Exception {
    }
}

