/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.io;

import java.io.EOFException;
import java.io.IOException;
import java.io.InputStream;
import java.nio.ByteBuffer;
import java.util.Arrays;
import org.apache.parquet.TestUtils;
import org.apache.parquet.io.DelegatingSeekableInputStream;
import org.apache.parquet.io.MockInputStream;
import org.junit.Assert;
import org.junit.Test;

public class TestDelegatingSeekableInputStream {
    private static final ThreadLocal<byte[]> TEMP = ThreadLocal.withInitial(() -> new byte[8192]);

    @Test
    public void testReadFully() throws Exception {
        byte[] buffer = new byte[5];
        MockInputStream stream = new MockInputStream(new int[0]);
        DelegatingSeekableInputStream.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertArrayEquals((String)"Byte array contents should match", (byte[])Arrays.copyOfRange(MockInputStream.TEST_ARRAY, 0, 5), (byte[])buffer);
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)5L, (long)stream.getPos());
    }

    @Test
    public void testReadFullySmallReads() throws Exception {
        byte[] buffer = new byte[5];
        MockInputStream stream = new MockInputStream(2, 3, 3);
        DelegatingSeekableInputStream.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertArrayEquals((String)"Byte array contents should match", (byte[])Arrays.copyOfRange(MockInputStream.TEST_ARRAY, 0, 5), (byte[])buffer);
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)5L, (long)stream.getPos());
    }

    @Test
    public void testReadFullyJustRight() throws Exception {
        byte[] buffer = new byte[10];
        MockInputStream stream = new MockInputStream(2, 3, 3);
        DelegatingSeekableInputStream.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertArrayEquals((String)"Byte array contents should match", (byte[])MockInputStream.TEST_ARRAY, (byte[])buffer);
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)10L, (long)stream.getPos());
        TestUtils.assertThrows("Should throw EOFException if no more bytes left", EOFException.class, () -> {
            DelegatingSeekableInputStream.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)1);
            return null;
        });
    }

    @Test
    public void testReadFullyUnderflow() throws Exception {
        byte[] buffer = new byte[11];
        MockInputStream stream = new MockInputStream(2, 3, 3);
        TestUtils.assertThrows("Should throw EOFException if no more bytes left", EOFException.class, () -> {
            DelegatingSeekableInputStream.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)buffer.length);
            return null;
        });
        Assert.assertArrayEquals((String)"Should have consumed bytes", (byte[])MockInputStream.TEST_ARRAY, (byte[])Arrays.copyOfRange(buffer, 0, 10));
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)10L, (long)stream.getPos());
    }

    @Test
    public void testReadFullyStartAndLength() throws IOException {
        byte[] buffer = new byte[10];
        MockInputStream stream = new MockInputStream(new int[0]);
        DelegatingSeekableInputStream.readFully((InputStream)stream, (byte[])buffer, (int)2, (int)5);
        Assert.assertArrayEquals((String)"Byte array contents should match", (byte[])Arrays.copyOfRange(MockInputStream.TEST_ARRAY, 0, 5), (byte[])Arrays.copyOfRange(buffer, 2, 7));
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)5L, (long)stream.getPos());
    }

    @Test
    public void testReadFullyZeroByteRead() throws IOException {
        byte[] buffer = new byte[]{};
        MockInputStream stream = new MockInputStream(new int[0]);
        DelegatingSeekableInputStream.readFully((InputStream)stream, (byte[])buffer, (int)0, (int)buffer.length);
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)0L, (long)stream.getPos());
    }

    @Test
    public void testReadFullySmallReadsWithStartAndLength() throws IOException {
        byte[] buffer = new byte[10];
        MockInputStream stream = new MockInputStream(2, 2, 3);
        DelegatingSeekableInputStream.readFully((InputStream)stream, (byte[])buffer, (int)2, (int)5);
        Assert.assertArrayEquals((String)"Byte array contents should match", (byte[])Arrays.copyOfRange(MockInputStream.TEST_ARRAY, 0, 5), (byte[])Arrays.copyOfRange(buffer, 2, 7));
        Assert.assertEquals((String)"Stream position should reflect bytes read", (long)5L, (long)stream.getPos());
    }

    @Test
    public void testHeapRead() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(20);
        MockInputStream stream = new MockInputStream(new int[0]);
        int len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)len);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)20L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)-1L, (long)len);
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testHeapSmallBuffer() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(5);
        MockInputStream stream = new MockInputStream(new int[0]);
        int len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)5L, (long)len);
        Assert.assertEquals((long)5L, (long)readBuffer.position());
        Assert.assertEquals((long)5L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)0L, (long)len);
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 5), (Object)readBuffer);
    }

    @Test
    public void testHeapSmallReads() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(10);
        MockInputStream stream = new MockInputStream(2, 3, 3);
        int len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)2L, (long)len);
        Assert.assertEquals((long)2L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)3L, (long)len);
        Assert.assertEquals((long)5L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)3L, (long)len);
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)2L, (long)len);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testHeapPosition() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(20);
        readBuffer.position(10);
        readBuffer.mark();
        MockInputStream stream = new MockInputStream(8);
        int len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)8L, (long)len);
        Assert.assertEquals((long)18L, (long)readBuffer.position());
        Assert.assertEquals((long)20L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)2L, (long)len);
        Assert.assertEquals((long)20L, (long)readBuffer.position());
        Assert.assertEquals((long)20L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)-1L, (long)len);
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testHeapLimit() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(20);
        readBuffer.limit(8);
        MockInputStream stream = new MockInputStream(7);
        int len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)len);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)8L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)1L, (long)len);
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)8L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)0L, (long)len);
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 8), (Object)readBuffer);
    }

    @Test
    public void testHeapPositionAndLimit() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(20);
        readBuffer.position(5);
        readBuffer.limit(13);
        readBuffer.mark();
        MockInputStream stream = new MockInputStream(7);
        int len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)len);
        Assert.assertEquals((long)12L, (long)readBuffer.position());
        Assert.assertEquals((long)13L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)1L, (long)len);
        Assert.assertEquals((long)13L, (long)readBuffer.position());
        Assert.assertEquals((long)13L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)0L, (long)len);
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 8), (Object)readBuffer);
    }

    @Test
    public void testDirectRead() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(20);
        MockInputStream stream = new MockInputStream(new int[0]);
        int len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)10L, (long)len);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)20L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)-1L, (long)len);
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testDirectSmallBuffer() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(5);
        MockInputStream stream = new MockInputStream(new int[0]);
        int len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)5L, (long)len);
        Assert.assertEquals((long)5L, (long)readBuffer.position());
        Assert.assertEquals((long)5L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)0L, (long)len);
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 5), (Object)readBuffer);
    }

    @Test
    public void testDirectSmallReads() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        MockInputStream stream = new MockInputStream(2, 3, 3);
        int len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)2L, (long)len);
        Assert.assertEquals((long)2L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)3L, (long)len);
        Assert.assertEquals((long)5L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)3L, (long)len);
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)2L, (long)len);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testDirectPosition() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(20);
        readBuffer.position(10);
        readBuffer.mark();
        MockInputStream stream = new MockInputStream(8);
        int len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)8L, (long)len);
        Assert.assertEquals((long)18L, (long)readBuffer.position());
        Assert.assertEquals((long)20L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)2L, (long)len);
        Assert.assertEquals((long)20L, (long)readBuffer.position());
        Assert.assertEquals((long)20L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)-1L, (long)len);
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testDirectLimit() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(20);
        readBuffer.limit(8);
        MockInputStream stream = new MockInputStream(7);
        int len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)7L, (long)len);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)8L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)1L, (long)len);
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)8L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)0L, (long)len);
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 8), (Object)readBuffer);
    }

    @Test
    public void testDirectPositionAndLimit() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(20);
        readBuffer.position(5);
        readBuffer.limit(13);
        readBuffer.mark();
        MockInputStream stream = new MockInputStream(7);
        int len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)7L, (long)len);
        Assert.assertEquals((long)12L, (long)readBuffer.position());
        Assert.assertEquals((long)13L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)1L, (long)len);
        Assert.assertEquals((long)13L, (long)readBuffer.position());
        Assert.assertEquals((long)13L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)0L, (long)len);
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 8), (Object)readBuffer);
    }

    @Test
    public void testDirectSmallTempBufferSmallReads() throws Exception {
        byte[] temp = new byte[2];
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        MockInputStream stream = new MockInputStream(2, 3, 3);
        int len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])temp);
        Assert.assertEquals((long)2L, (long)len);
        Assert.assertEquals((long)2L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])temp);
        Assert.assertEquals((long)3L, (long)len);
        Assert.assertEquals((long)5L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])temp);
        Assert.assertEquals((long)3L, (long)len);
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])temp);
        Assert.assertEquals((long)2L, (long)len);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])temp);
        Assert.assertEquals((long)-1L, (long)len);
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testDirectSmallTempBufferWithPositionAndLimit() throws Exception {
        byte[] temp = new byte[2];
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(20);
        readBuffer.position(5);
        readBuffer.limit(13);
        readBuffer.mark();
        MockInputStream stream = new MockInputStream(7);
        int len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])temp);
        Assert.assertEquals((long)7L, (long)len);
        Assert.assertEquals((long)12L, (long)readBuffer.position());
        Assert.assertEquals((long)13L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])temp);
        Assert.assertEquals((long)1L, (long)len);
        Assert.assertEquals((long)13L, (long)readBuffer.position());
        Assert.assertEquals((long)13L, (long)readBuffer.limit());
        len = DelegatingSeekableInputStream.readDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])temp);
        Assert.assertEquals((long)0L, (long)len);
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 8), (Object)readBuffer);
    }

    @Test
    public void testHeapReadFullySmallBuffer() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(8);
        MockInputStream stream = new MockInputStream(new int[0]);
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)8L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)8L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 8), (Object)readBuffer);
    }

    @Test
    public void testHeapReadFullyLargeBuffer() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(20);
        MockInputStream stream = new MockInputStream(new int[0]);
        TestUtils.assertThrows("Should throw EOFException", EOFException.class, () -> {
            DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
            return null;
        });
        Assert.assertEquals((long)0L, (long)readBuffer.position());
        Assert.assertEquals((long)20L, (long)readBuffer.limit());
    }

    @Test
    public void testHeapReadFullyJustRight() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(10);
        MockInputStream stream = new MockInputStream(new int[0]);
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testHeapReadFullySmallReads() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(10);
        MockInputStream stream = new MockInputStream(2, 3, 3);
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testHeapReadFullyPosition() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(10);
        readBuffer.position(3);
        readBuffer.mark();
        MockInputStream stream = new MockInputStream(2, 3, 3);
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
    }

    @Test
    public void testHeapReadFullyLimit() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(10);
        readBuffer.limit(7);
        MockInputStream stream = new MockInputStream(2, 3, 3);
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
        readBuffer.position(7);
        readBuffer.limit(10);
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testHeapReadFullyPositionAndLimit() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocate(10);
        readBuffer.position(3);
        readBuffer.limit(7);
        readBuffer.mark();
        MockInputStream stream = new MockInputStream(2, 3, 3);
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 4), (Object)readBuffer);
        readBuffer.position(7);
        readBuffer.limit(10);
        DelegatingSeekableInputStream.readFullyHeapBuffer((InputStream)stream, (ByteBuffer)readBuffer);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullySmallBuffer() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(8);
        MockInputStream stream = new MockInputStream(new int[0]);
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)8L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)8L, (long)readBuffer.position());
        Assert.assertEquals((long)8L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 8), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullyLargeBuffer() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(20);
        MockInputStream stream = new MockInputStream(new int[0]);
        TestUtils.assertThrows("Should throw EOFException", EOFException.class, () -> {
            DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
            return null;
        });
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)20L, (long)readBuffer.limit());
    }

    @Test
    public void testDirectReadFullyJustRight() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        MockInputStream stream = new MockInputStream(new int[0]);
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullySmallReads() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        MockInputStream stream = new MockInputStream(2, 3, 3);
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullyPosition() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        readBuffer.position(3);
        readBuffer.mark();
        MockInputStream stream = new MockInputStream(2, 3, 3);
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullyLimit() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        readBuffer.limit(7);
        MockInputStream stream = new MockInputStream(2, 3, 3);
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
        readBuffer.position(7);
        readBuffer.limit(10);
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.flip();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullyPositionAndLimit() throws Exception {
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        readBuffer.position(3);
        readBuffer.limit(7);
        readBuffer.mark();
        MockInputStream stream = new MockInputStream(2, 3, 3);
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 4), (Object)readBuffer);
        readBuffer.position(7);
        readBuffer.limit(10);
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])TEMP.get());
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
    }

    @Test
    public void testDirectReadFullySmallTempBufferWithPositionAndLimit() throws Exception {
        byte[] temp = new byte[2];
        ByteBuffer readBuffer = ByteBuffer.allocateDirect(10);
        readBuffer.position(3);
        readBuffer.limit(7);
        readBuffer.mark();
        MockInputStream stream = new MockInputStream(2, 3, 3);
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])temp);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])temp);
        Assert.assertEquals((long)7L, (long)readBuffer.position());
        Assert.assertEquals((long)7L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 4), (Object)readBuffer);
        readBuffer.position(7);
        readBuffer.limit(10);
        DelegatingSeekableInputStream.readFullyDirectBuffer((InputStream)stream, (ByteBuffer)readBuffer, (byte[])temp);
        Assert.assertEquals((long)10L, (long)readBuffer.position());
        Assert.assertEquals((long)10L, (long)readBuffer.limit());
        readBuffer.reset();
        Assert.assertEquals((String)"Buffer contents should match", (Object)ByteBuffer.wrap(MockInputStream.TEST_ARRAY, 0, 7), (Object)readBuffer);
    }
}

