/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.impl;

import java.lang.reflect.Field;
import java.util.ArrayList;
import org.apache.parquet.CorruptDeltaByteArrays;
import org.apache.parquet.SemanticVersion;
import org.apache.parquet.VersionParser;
import org.apache.parquet.bytes.BytesInput;
import org.apache.parquet.column.ColumnDescriptor;
import org.apache.parquet.column.Encoding;
import org.apache.parquet.column.ParquetProperties;
import org.apache.parquet.column.impl.ColumnReaderImpl;
import org.apache.parquet.column.page.PageWriter;
import org.apache.parquet.column.page.mem.MemPageStore;
import org.apache.parquet.column.statistics.BinaryStatistics;
import org.apache.parquet.column.statistics.Statistics;
import org.apache.parquet.column.values.ValuesReader;
import org.apache.parquet.column.values.ValuesWriter;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayReader;
import org.apache.parquet.column.values.deltastrings.DeltaByteArrayWriter;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.io.api.PrimitiveConverter;
import org.apache.parquet.schema.PrimitiveType;
import org.junit.Assert;
import org.junit.Test;

public class TestCorruptDeltaByteArrays {
    @Test
    public void testCorruptDeltaByteArrayVerisons() {
        Assert.assertTrue((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.6.0 (build abcd)", (Encoding)Encoding.DELTA_BYTE_ARRAY));
        Assert.assertTrue((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)null, (Encoding)Encoding.DELTA_BYTE_ARRAY));
        Assert.assertTrue((boolean)CorruptDeltaByteArrays.requiresSequentialReads((VersionParser.ParsedVersion)null, (Encoding)Encoding.DELTA_BYTE_ARRAY));
        Assert.assertTrue((boolean)CorruptDeltaByteArrays.requiresSequentialReads((SemanticVersion)null, (Encoding)Encoding.DELTA_BYTE_ARRAY));
        Assert.assertTrue((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.8.0-SNAPSHOT (build abcd)", (Encoding)Encoding.DELTA_BYTE_ARRAY));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.6.0 (build abcd)", (Encoding)Encoding.DELTA_BINARY_PACKED));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)null, (Encoding)Encoding.DELTA_LENGTH_BYTE_ARRAY));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((VersionParser.ParsedVersion)null, (Encoding)Encoding.PLAIN));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((SemanticVersion)null, (Encoding)Encoding.RLE));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.8.0-SNAPSHOT (build abcd)", (Encoding)Encoding.RLE_DICTIONARY));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.8.0-SNAPSHOT (build abcd)", (Encoding)Encoding.PLAIN_DICTIONARY));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.8.0-SNAPSHOT (build abcd)", (Encoding)Encoding.BIT_PACKED));
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((String)"parquet-mr version 1.8.0 (build abcd)", (Encoding)Encoding.DELTA_BYTE_ARRAY));
    }

    @Test
    public void testEncodingRequiresSequentailRead() {
        VersionParser.ParsedVersion impala = new VersionParser.ParsedVersion("impala", "1.2.0", "abcd");
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((VersionParser.ParsedVersion)impala, (Encoding)Encoding.DELTA_BYTE_ARRAY));
        VersionParser.ParsedVersion broken = new VersionParser.ParsedVersion("parquet-mr", "1.8.0-SNAPSHOT", "abcd");
        Assert.assertTrue((boolean)CorruptDeltaByteArrays.requiresSequentialReads((VersionParser.ParsedVersion)broken, (Encoding)Encoding.DELTA_BYTE_ARRAY));
        VersionParser.ParsedVersion fixed = new VersionParser.ParsedVersion("parquet-mr", "1.8.0", "abcd");
        Assert.assertFalse((boolean)CorruptDeltaByteArrays.requiresSequentialReads((VersionParser.ParsedVersion)fixed, (Encoding)Encoding.DELTA_BYTE_ARRAY));
    }

    @Test
    public void testReassemblyWithCorruptPage() throws Exception {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(10, 100);
        String lastValue = null;
        for (int i = 0; i < 10; ++i) {
            lastValue = this.str(i);
            writer.writeBytes(Binary.fromString((String)lastValue));
        }
        byte[] firstPageBytes = writer.getBytes().toByteArray();
        writer.reset();
        this.corruptWriter(writer, lastValue);
        for (int i = 10; i < 20; ++i) {
            writer.writeBytes(Binary.fromString((String)this.str(i)));
        }
        byte[] corruptPageBytes = writer.getBytes().toByteArray();
        DeltaByteArrayReader firstPageReader = new DeltaByteArrayReader();
        firstPageReader.initFromPage(10, firstPageBytes, 0);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)firstPageReader.readBytes().toStringUsingUTF8(), (Object)this.str(i));
        }
        DeltaByteArrayReader corruptPageReader = new DeltaByteArrayReader();
        corruptPageReader.initFromPage(10, corruptPageBytes, 0);
        try {
            corruptPageReader.readBytes();
            Assert.fail((String)"Corrupt page did not throw an exception when read");
        }
        catch (ArrayIndexOutOfBoundsException e) {
            // empty catch block
        }
        DeltaByteArrayReader secondPageReader = new DeltaByteArrayReader();
        secondPageReader.initFromPage(10, corruptPageBytes, 0);
        secondPageReader.setPreviousReader((ValuesReader)firstPageReader);
        for (int i = 10; i < 20; ++i) {
            Assert.assertEquals((Object)secondPageReader.readBytes().toStringUsingUTF8(), (Object)this.str(i));
        }
    }

    @Test
    public void testReassemblyWithoutCorruption() throws Exception {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(10, 100);
        for (int i = 0; i < 10; ++i) {
            writer.writeBytes(Binary.fromString((String)this.str(i)));
        }
        byte[] firstPageBytes = writer.getBytes().toByteArray();
        writer.reset();
        for (int i = 10; i < 20; ++i) {
            writer.writeBytes(Binary.fromString((String)this.str(i)));
        }
        byte[] secondPageBytes = writer.getBytes().toByteArray();
        DeltaByteArrayReader firstPageReader = new DeltaByteArrayReader();
        firstPageReader.initFromPage(10, firstPageBytes, 0);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)firstPageReader.readBytes().toStringUsingUTF8(), (Object)this.str(i));
        }
        DeltaByteArrayReader secondPageReader = new DeltaByteArrayReader();
        secondPageReader.initFromPage(10, secondPageBytes, 0);
        secondPageReader.setPreviousReader((ValuesReader)firstPageReader);
        for (int i = 10; i < 20; ++i) {
            Assert.assertEquals((Object)secondPageReader.readBytes().toStringUsingUTF8(), (Object)this.str(i));
        }
    }

    @Test
    public void testOldReassemblyWithoutCorruption() throws Exception {
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(10, 100);
        for (int i = 0; i < 10; ++i) {
            writer.writeBytes(Binary.fromString((String)this.str(i)));
        }
        byte[] firstPageBytes = writer.getBytes().toByteArray();
        writer.reset();
        for (int i = 10; i < 20; ++i) {
            writer.writeBytes(Binary.fromString((String)this.str(i)));
        }
        byte[] secondPageBytes = writer.getBytes().toByteArray();
        DeltaByteArrayReader firstPageReader = new DeltaByteArrayReader();
        firstPageReader.initFromPage(10, firstPageBytes, 0);
        for (int i = 0; i < 10; ++i) {
            Assert.assertEquals((Object)firstPageReader.readBytes().toStringUsingUTF8(), (Object)this.str(i));
        }
        DeltaByteArrayReader secondPageReader = new DeltaByteArrayReader();
        secondPageReader.initFromPage(10, secondPageBytes, 0);
        for (int i = 10; i < 20; ++i) {
            Assert.assertEquals((Object)secondPageReader.readBytes().toStringUsingUTF8(), (Object)this.str(i));
        }
    }

    @Test
    public void testColumnReaderImplWithCorruptPage() throws Exception {
        int i;
        ColumnDescriptor column = new ColumnDescriptor(new String[]{"s"}, PrimitiveType.PrimitiveTypeName.BINARY, 0, 0);
        MemPageStore pages = new MemPageStore(0L);
        PageWriter memWriter = pages.getPageWriter(column);
        ValuesWriter rdValues = ParquetProperties.getColumnDescriptorValuesWriter((int)0, (int)10, (int)100);
        for (int i2 = 0; i2 < 10; ++i2) {
            rdValues.writeInteger(0);
        }
        BytesInput rd = BytesInput.from((byte[])rdValues.getBytes().toByteArray());
        DeltaByteArrayWriter writer = new DeltaByteArrayWriter(10, 100);
        String lastValue = null;
        ArrayList<String> values = new ArrayList<String>();
        for (i = 0; i < 10; ++i) {
            lastValue = this.str(i);
            writer.writeBytes(Binary.fromString((String)lastValue));
            values.add(lastValue);
        }
        memWriter.writePage(BytesInput.concat((BytesInput[])new BytesInput[]{rd, rd, writer.getBytes()}), 10, (Statistics)new BinaryStatistics(), rdValues.getEncoding(), rdValues.getEncoding(), writer.getEncoding());
        pages.addRowCount(10L);
        writer.reset();
        this.corruptWriter(writer, lastValue);
        for (i = 10; i < 20; ++i) {
            String value = this.str(i);
            writer.writeBytes(Binary.fromString((String)value));
            values.add(value);
        }
        memWriter.writePage(BytesInput.concat((BytesInput[])new BytesInput[]{rd, rd, writer.getBytes()}), 10, (Statistics)new BinaryStatistics(), rdValues.getEncoding(), rdValues.getEncoding(), writer.getEncoding());
        pages.addRowCount(10L);
        final ArrayList actualValues = new ArrayList();
        PrimitiveConverter converter = new PrimitiveConverter(){

            public void addBinary(Binary value) {
                actualValues.add(value.toStringUsingUTF8());
            }
        };
        ColumnReaderImpl columnReader = new ColumnReaderImpl(column, pages.getPageReader(column), converter, new VersionParser.ParsedVersion("parquet-mr", "1.6.0", "abcd"));
        while ((long)actualValues.size() < columnReader.getTotalValueCount()) {
            columnReader.writeCurrentValueToConverter();
            columnReader.consume();
        }
        Assert.assertEquals(values, actualValues);
    }

    public void corruptWriter(DeltaByteArrayWriter writer, String data) throws Exception {
        Field previous = writer.getClass().getDeclaredField("previous");
        previous.setAccessible(true);
        previous.set(writer, Binary.fromString((String)data).getBytesUnsafe());
    }

    public String str(int i) {
        int c = 97;
        return "aaaaaaaaaaa" + (char)(c + i);
    }
}

