/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.internal.filter2.columnindex;

import it.unimi.dsi.fastutil.longs.LongArrayList;
import it.unimi.dsi.fastutil.longs.LongList;
import java.nio.ByteBuffer;
import java.nio.charset.StandardCharsets;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashSet;
import java.util.List;
import java.util.Set;
import java.util.stream.LongStream;
import org.apache.parquet.bytes.BytesUtils;
import org.apache.parquet.filter2.compat.FilterCompat;
import org.apache.parquet.filter2.predicate.FilterApi;
import org.apache.parquet.filter2.predicate.FilterPredicate;
import org.apache.parquet.filter2.predicate.LogicalInverter;
import org.apache.parquet.filter2.predicate.Operators;
import org.apache.parquet.filter2.predicate.Statistics;
import org.apache.parquet.filter2.predicate.UserDefinedPredicate;
import org.apache.parquet.hadoop.metadata.ColumnPath;
import org.apache.parquet.internal.column.columnindex.BoundaryOrder;
import org.apache.parquet.internal.column.columnindex.ColumnIndex;
import org.apache.parquet.internal.column.columnindex.ColumnIndexBuilder;
import org.apache.parquet.internal.column.columnindex.OffsetIndex;
import org.apache.parquet.internal.column.columnindex.OffsetIndexBuilder;
import org.apache.parquet.internal.column.columnindex.TestColumnIndexBuilder;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexFilter;
import org.apache.parquet.internal.filter2.columnindex.ColumnIndexStore;
import org.apache.parquet.internal.filter2.columnindex.RowRanges;
import org.apache.parquet.io.api.Binary;
import org.apache.parquet.schema.LogicalTypeAnnotation;
import org.apache.parquet.schema.PrimitiveType;
import org.apache.parquet.schema.Types;
import org.junit.Assert;
import org.junit.Test;

public class TestColumnIndexFilter {
    private static final long TOTAL_ROW_COUNT = 30L;
    private static final ColumnIndex COLUMN1_CI = new CIBuilder((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("column1"), BoundaryOrder.ASCENDING).addPage(0L, 1, 1).addPage(1L, 2, 6).addPage(0L, 7, 7).addPage(1L, 7, 10).addPage(0L, 11, 17).addPage(0L, 18, 23).addPage(0L, 24, 26).build();
    private static final OffsetIndex COLUMN1_OI = new OIBuilder().addPage(1L).addPage(6L).addPage(2L).addPage(5L).addPage(7L).addPage(6L).addPage(3L).build();
    private static final ColumnIndex COLUMN2_CI = new CIBuilder((PrimitiveType)((Types.PrimitiveBuilder)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.BINARY).as((LogicalTypeAnnotation)LogicalTypeAnnotation.stringType())).named("column2"), BoundaryOrder.DESCENDING).addPage(0L, "Zulu", "Zulu").addPage(0L, "Whiskey", "Yankee").addPage(1L, "Tango", "Victor").addNullPage(3L).addPage(0L, "Oscar", "Sierra").addPage(0L, "Juliett", "November").addPage(0L, "Bravo", "India").addPage(0L, "Alfa", "Alfa").build();
    private static final OffsetIndex COLUMN2_OI = new OIBuilder().addPage(1L).addPage(3L).addPage(4L).addPage(3L).addPage(5L).addPage(5L).addPage(8L).addPage(1L).build();
    private static final ColumnIndex COLUMN3_CI = new CIBuilder((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.DOUBLE).named("column3"), BoundaryOrder.UNORDERED).addPage(0L, 2.03, 2.03).addPage(0L, 0.56, 8.71).addPage(2L, 3.14, 3.5).addPage(0L, 2.71, 9.99).addPage(3L, 0.36, 5.32).addPage(0L, 4.17, 7.95).addNullPage(4L).build();
    private static final OffsetIndex COLUMN3_OI = new OIBuilder().addPage(1L).addPage(5L).addPage(4L).addPage(6L).addPage(7L).addPage(3L).addPage(4L).build();
    private static final ColumnIndex COLUMN4_CI = null;
    private static final OffsetIndex COLUMN4_OI = new OIBuilder().addPage(1L).addPage(3L).addPage(2L).addPage(1L).addPage(5L).addPage(4L).addPage(5L).addPage(7L).addPage(2L).build();
    private static final ColumnIndex COLUMN5_CI = new CIBuilder((PrimitiveType)Types.optional((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT64).named("column5"), BoundaryOrder.ASCENDING).addNullPage(1L).addNullPage(29L).build();
    private static final OffsetIndex COLUMN5_OI = new OIBuilder().addPage(1L).addPage(29L).build();
    private static final ColumnIndex COLUMN6_CI = new CIBuilder((PrimitiveType)Types.repeated((PrimitiveType.PrimitiveTypeName)PrimitiveType.PrimitiveTypeName.INT32).named("column6"), BoundaryOrder.ASCENDING).addPage(0L, 1, 1).addPage(1L, 2, 6).addPage(0L, 7, 7).addPage(1L, 7, 10).addPage(0L, 11, 17).addPage(0L, 18, 23).addPage(0L, 24, 26).build();
    private static final OffsetIndex COLUMN6_OI = new OIBuilder().addPage(1L).addPage(6L).addPage(2L).addPage(5L).addPage(7L).addPage(6L).addPage(3L).build();
    private static final ColumnIndexStore STORE = new ColumnIndexStore(){

        public ColumnIndex getColumnIndex(ColumnPath column) {
            switch (column.toDotString()) {
                case "column1": {
                    return COLUMN1_CI;
                }
                case "column2": {
                    return COLUMN2_CI;
                }
                case "column3": {
                    return COLUMN3_CI;
                }
                case "column4": {
                    return COLUMN4_CI;
                }
                case "column5": {
                    return COLUMN5_CI;
                }
                case "column6": {
                    return COLUMN6_CI;
                }
            }
            return null;
        }

        public OffsetIndex getOffsetIndex(ColumnPath column) {
            switch (column.toDotString()) {
                case "column1": {
                    return COLUMN1_OI;
                }
                case "column2": {
                    return COLUMN2_OI;
                }
                case "column3": {
                    return COLUMN3_OI;
                }
                case "column4": {
                    return COLUMN4_OI;
                }
                case "column5": {
                    return COLUMN5_OI;
                }
                case "column6": {
                    return COLUMN6_OI;
                }
            }
            throw new ColumnIndexStore.MissingOffsetIndexException(column);
        }
    };

    private static Set<ColumnPath> paths(String ... columns) {
        HashSet<ColumnPath> paths = new HashSet<ColumnPath>();
        for (String column : columns) {
            paths.add(ColumnPath.fromDotString((String)column));
        }
        return paths;
    }

    private static void assertAllRows(RowRanges ranges, long rowCount) {
        LongArrayList actualList = new LongArrayList();
        ranges.iterator().forEachRemaining(arg_0 -> TestColumnIndexFilter.lambda$assertAllRows$0((LongList)actualList, arg_0));
        LongArrayList expectedList = new LongArrayList();
        LongStream.range(0L, rowCount).forEach(arg_0 -> ((LongList)expectedList).add(arg_0));
        Assert.assertArrayEquals((String)(expectedList + " != " + actualList), (long[])expectedList.toLongArray(), (long[])actualList.toLongArray());
    }

    private static void assertRows(RowRanges ranges, long ... expectedRows) {
        LongArrayList actualList = new LongArrayList();
        ranges.iterator().forEachRemaining(arg_0 -> TestColumnIndexFilter.lambda$assertRows$1((LongList)actualList, arg_0));
        Assert.assertArrayEquals((String)(Arrays.toString(expectedRows) + " != " + actualList), (long[])expectedRows, (long[])actualList.toLongArray());
    }

    @Test
    public void testFiltering() {
        Set<ColumnPath> paths = TestColumnIndexFilter.paths("column1", "column2", "column3", "column4", "column6");
        TestColumnIndexFilter.assertAllRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.intColumn((String)"column1"), AnyInt.class)), (ColumnIndexStore)STORE, paths, (long)30L), 30L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.intColumn((String)"column6"), (Comparable)Integer.valueOf(7)))), (ColumnIndexStore)STORE, paths, (long)30L), 7L, 8L, 9L, 10L, 11L, 12L, 13L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.intColumn((String)"column6"), (Comparable)Integer.valueOf(7))), (FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.intColumn((String)"column6"), (Comparable)Integer.valueOf(10))))), (ColumnIndexStore)STORE, paths, (long)30L), 9L, 10L, 11L, 12L, 13L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.intColumn((String)"column6"), (Comparable)Integer.valueOf(7))), (FilterPredicate)FilterApi.contains((Operators.SingleColumnFilterPredicate)FilterApi.eq((Operators.Column)FilterApi.intColumn((String)"column6"), (Comparable)Integer.valueOf(20))))), (ColumnIndexStore)STORE, paths, (long)30L), 7L, 8L, 9L, 10L, 11L, 12L, 13L, 21L, 22L, 23L, 24L, 25L, 26L);
        HashSet<Integer> set1 = new HashSet<Integer>();
        set1.add(7);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.in((Operators.Column)FilterApi.intColumn((String)"column1"), set1)), (ColumnIndexStore)STORE, paths, (long)30L), 7L, 8L, 9L, 10L, 11L, 12L, 13L);
        set1.add(1);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.in((Operators.Column)FilterApi.intColumn((String)"column1"), set1)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.notIn((Operators.Column)FilterApi.intColumn((String)"column1"), set1)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L);
        HashSet<Binary> set2 = new HashSet<Binary>();
        set2.add(Binary.fromString((String)"Zulu"));
        set2.add(Binary.fromString((String)"Alfa"));
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.in((Operators.Column)FilterApi.binaryColumn((String)"column2"), set2)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.notIn((Operators.Column)FilterApi.binaryColumn((String)"column2"), set2)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L);
        HashSet<Double> set3 = new HashSet<Double>();
        set3.add(2.03);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.in((Operators.Column)FilterApi.doubleColumn((String)"column3"), set3)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 16L, 17L, 18L, 19L, 20L, 21L, 22L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.notIn((Operators.Column)FilterApi.doubleColumn((String)"column3"), set3)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L);
        set3.add(9.98);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.in((Operators.Column)FilterApi.doubleColumn((String)"column3"), set3)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.notIn((Operators.Column)FilterApi.doubleColumn((String)"column3"), set3)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L);
        set3.add(null);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.in((Operators.Column)FilterApi.doubleColumn((String)"column3"), set3)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.notIn((Operators.Column)FilterApi.doubleColumn((String)"column3"), set3)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L);
        HashSet<Object> set4 = new HashSet<Object>();
        set4.add(null);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.in((Operators.Column)FilterApi.booleanColumn((String)"column4"), set4)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.notIn((Operators.Column)FilterApi.booleanColumn((String)"column4"), set4)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L);
        HashSet<Integer> set5 = new HashSet<Integer>();
        set5.add(7);
        set5.add(20);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.in((Operators.Column)FilterApi.intColumn((String)"column5"), set5)), (ColumnIndexStore)STORE, paths, (long)30L), new long[0]);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.notIn((Operators.Column)FilterApi.intColumn((String)"column5"), set5)), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 8L, 9L, 10L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L, 26L, 27L, 28L, 29L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.intColumn((String)"column1"), null), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"column2"), null)), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.doubleColumn((String)"column3"), null), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.booleanColumn((String)"column4"), null)))), (ColumnIndexStore)STORE, paths, (long)30L), 6L, 9L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.intColumn((String)"column1"), null), (FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"column2"), null)), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.doubleColumn((String)"column3"), null), (FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.booleanColumn((String)"column4"), null)))), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 11L, 12L, 13L, 14L, 15L, 16L, 17L, 18L, 19L, 20L, 21L, 22L, 23L, 24L, 25L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.intColumn((String)"column1"), (Comparable)Integer.valueOf(20)), (FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.binaryColumn((String)"column2"), (Comparable)Binary.fromString((String)"Quebec"))), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gt((Operators.Column)FilterApi.doubleColumn((String)"column3"), (Comparable)Double.valueOf(5.32)), (FilterPredicate)FilterApi.ltEq((Operators.Column)FilterApi.binaryColumn((String)"column4"), (Comparable)Binary.fromString((String)"XYZ"))))), (ColumnIndexStore)STORE, paths, (long)30L), 0L, 1L, 2L, 3L, 4L, 5L, 6L, 7L, 10L, 11L, 12L, 13L, 14L, 15L, 23L, 24L, 25L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.intColumn((String)"column1"), (Comparable)Integer.valueOf(7)), (FilterPredicate)FilterApi.gt((Operators.Column)FilterApi.binaryColumn((String)"column2"), (Comparable)Binary.fromString((String)"India"))), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.doubleColumn((String)"column3"), null), (FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"column4"), null)))), (ColumnIndexStore)STORE, paths, (long)30L), 7L, 16L, 17L, 18L, 19L, 20L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.or((FilterPredicate)LogicalInverter.invert((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.intColumn((String)"column1"), AnyInt.class)), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"column2"), (Comparable)Binary.fromString((String)"Echo"))), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.doubleColumn((String)"column3"), (Comparable)Double.valueOf(6.0)))), (ColumnIndexStore)STORE, paths, (long)30L), 23L, 24L, 25L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.intColumn((String)"column1"), TestColumnIndexBuilder.IntegerIsDivisableWith3.class), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.binaryColumn((String)"column2"), TestColumnIndexBuilder.BinaryUtf8StartsWithB.class), (FilterPredicate)FilterApi.userDefined((Operators.Column)FilterApi.doubleColumn((String)"column3"), TestColumnIndexBuilder.DoubleIsInteger.class)))), (ColumnIndexStore)STORE, paths, (long)30L), 21L, 22L, 23L, 24L, 25L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.intColumn((String)"column1"), (Comparable)Integer.valueOf(7)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.intColumn((String)"column1"), (Comparable)Integer.valueOf(11))), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gt((Operators.Column)FilterApi.binaryColumn((String)"column2"), (Comparable)Binary.fromString((String)"Romeo")), (FilterPredicate)FilterApi.ltEq((Operators.Column)FilterApi.binaryColumn((String)"column2"), (Comparable)Binary.fromString((String)"Tango"))))), (ColumnIndexStore)STORE, paths, (long)30L), 7L, 11L, 12L, 13L);
    }

    @Test
    public void testFilteringOnMissingColumns() {
        Set<ColumnPath> paths = TestColumnIndexFilter.paths("column1", "column2", "column3", "column4");
        TestColumnIndexFilter.assertAllRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.intColumn((String)"missing_column"), (Comparable)Integer.valueOf(0))), (ColumnIndexStore)STORE, paths, (long)30L), 30L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.intColumn((String)"column1"), (Comparable)Integer.valueOf(7)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.intColumn((String)"column1"), (Comparable)Integer.valueOf(11))), (FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.binaryColumn((String)"missing_column"), null))), (ColumnIndexStore)STORE, paths, (long)30L), 7L, 8L, 9L, 10L, 11L, 12L, 13L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.intColumn((String)"column1"), (Comparable)Integer.valueOf(7)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.intColumn((String)"column1"), (Comparable)Integer.valueOf(11))), (FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.binaryColumn((String)"missing_column"), null))), (ColumnIndexStore)STORE, paths, (long)30L), 7L, 8L, 9L, 10L, 11L, 12L, 13L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.gt((Operators.Column)FilterApi.intColumn((String)"missing_column"), (Comparable)Integer.valueOf(0))), (ColumnIndexStore)STORE, paths, (long)30L), new long[0]);
    }

    @Test
    public void testFilteringWithMissingOffsetIndex() {
        Set<ColumnPath> paths = TestColumnIndexFilter.paths("column1", "column2", "column3", "column4", "column_wo_oi");
        TestColumnIndexFilter.assertAllRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.intColumn((String)"column1"), (Comparable)Integer.valueOf(7)), (FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.intColumn((String)"column1"), (Comparable)Integer.valueOf(11))), (FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.gt((Operators.Column)FilterApi.binaryColumn((String)"column2"), (Comparable)Binary.fromString((String)"Romeo")), (FilterPredicate)FilterApi.ltEq((Operators.Column)FilterApi.binaryColumn((String)"column_wo_oi"), (Comparable)Binary.fromString((String)"Tango"))))), (ColumnIndexStore)STORE, paths, (long)30L), 30L);
    }

    @Test
    public void testFilteringWithAllNullPages() {
        Set<ColumnPath> paths = TestColumnIndexFilter.paths("column1", "column5");
        TestColumnIndexFilter.assertAllRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.longColumn((String)"column5"), (Comparable)Long.valueOf(1234567L))), (ColumnIndexStore)STORE, paths, (long)30L), 30L);
        TestColumnIndexFilter.assertAllRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.or((FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.intColumn((String)"column1"), (Comparable)Integer.valueOf(10)), (FilterPredicate)FilterApi.notEq((Operators.Column)FilterApi.longColumn((String)"column5"), (Comparable)Long.valueOf(1234567L)))), (ColumnIndexStore)STORE, paths, (long)30L), 30L);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.eq((Operators.Column)FilterApi.longColumn((String)"column5"), (Comparable)Long.valueOf(1234567L))), (ColumnIndexStore)STORE, paths, (long)30L), new long[0]);
        TestColumnIndexFilter.assertRows(ColumnIndexFilter.calculateRowRanges((FilterCompat.Filter)FilterCompat.get((FilterPredicate)FilterApi.and((FilterPredicate)FilterApi.lt((Operators.Column)FilterApi.intColumn((String)"column1"), (Comparable)Integer.valueOf(20)), (FilterPredicate)FilterApi.gtEq((Operators.Column)FilterApi.longColumn((String)"column5"), (Comparable)Long.valueOf(1234567L)))), (ColumnIndexStore)STORE, paths, (long)30L), new long[0]);
    }

    private static /* synthetic */ void lambda$assertRows$1(LongList actualList, long value) {
        actualList.add(value);
    }

    private static /* synthetic */ void lambda$assertAllRows$0(LongList actualList, long value) {
        actualList.add(value);
    }

    public static class AnyInt
    extends UserDefinedPredicate<Integer> {
        public boolean keep(Integer value) {
            return true;
        }

        public boolean canDrop(Statistics<Integer> statistics) {
            return false;
        }

        public boolean inverseCanDrop(Statistics<Integer> statistics) {
            return true;
        }
    }

    private static class OIBuilder {
        private final OffsetIndexBuilder builder = OffsetIndexBuilder.getBuilder();

        private OIBuilder() {
        }

        OIBuilder addPage(long rowCount) {
            this.builder.add(1234, rowCount);
            return this;
        }

        OffsetIndex build() {
            return this.builder.build();
        }
    }

    private static class CIBuilder {
        private static final ByteBuffer EMPTY = ByteBuffer.wrap(new byte[0]);
        private final PrimitiveType type;
        private final BoundaryOrder order;
        private List<Boolean> nullPages = new ArrayList<Boolean>();
        private List<Long> nullCounts = new ArrayList<Long>();
        private List<ByteBuffer> minValues = new ArrayList<ByteBuffer>();
        private List<ByteBuffer> maxValues = new ArrayList<ByteBuffer>();

        CIBuilder(PrimitiveType type, BoundaryOrder order) {
            this.type = type;
            this.order = order;
        }

        CIBuilder addNullPage(long nullCount) {
            this.nullPages.add(true);
            this.nullCounts.add(nullCount);
            this.minValues.add(EMPTY);
            this.maxValues.add(EMPTY);
            return this;
        }

        CIBuilder addPage(long nullCount, int min, int max) {
            this.nullPages.add(false);
            this.nullCounts.add(nullCount);
            this.minValues.add(ByteBuffer.wrap(BytesUtils.intToBytes((int)min)));
            this.maxValues.add(ByteBuffer.wrap(BytesUtils.intToBytes((int)max)));
            return this;
        }

        CIBuilder addPage(long nullCount, String min, String max) {
            this.nullPages.add(false);
            this.nullCounts.add(nullCount);
            this.minValues.add(ByteBuffer.wrap(min.getBytes(StandardCharsets.UTF_8)));
            this.maxValues.add(ByteBuffer.wrap(max.getBytes(StandardCharsets.UTF_8)));
            return this;
        }

        CIBuilder addPage(long nullCount, double min, double max) {
            this.nullPages.add(false);
            this.nullCounts.add(nullCount);
            this.minValues.add(ByteBuffer.wrap(BytesUtils.longToBytes((long)Double.doubleToLongBits(min))));
            this.maxValues.add(ByteBuffer.wrap(BytesUtils.longToBytes((long)Double.doubleToLongBits(max))));
            return this;
        }

        ColumnIndex build() {
            return ColumnIndexBuilder.build((PrimitiveType)this.type, (BoundaryOrder)this.order, this.nullPages, this.nullCounts, this.minValues, this.maxValues);
        }
    }
}

