/*
 * Decompiled with CFR 0.152.
 */
package org.apache.parquet.column.values.bloomfilter;

import java.io.IOException;
import java.nio.ByteBuffer;
import java.nio.ByteOrder;
import java.util.HashSet;
import java.util.Random;
import java.util.UUID;
import net.openhft.hashing.LongHashFunction;
import org.apache.commons.lang3.RandomStringUtils;
import org.apache.parquet.column.values.bloomfilter.AdaptiveBlockSplitBloomFilter;
import org.apache.parquet.column.values.bloomfilter.BlockSplitBloomFilter;
import org.apache.parquet.column.values.bloomfilter.BloomFilter;
import org.apache.parquet.io.api.Binary;
import org.junit.Assert;
import org.junit.Rule;
import org.junit.Test;
import org.junit.rules.TemporaryFolder;

public class TestBlockSplitBloomFilter {
    @Rule
    public final TemporaryFolder temp = new TemporaryFolder();
    private static final long[] HASHES_OF_LOOPING_BYTES_WITH_SEED_0 = new long[]{-1205034819632174695L, -1642502924627794072L, 5216751715308240086L, -1889335612763511331L, -13835840860730338L, -2521325055659080948L, 4867868962443297827L, 1498682999415010002L, -8626056615231480947L, 7482827008138251355L, -617731006306969209L, 7289733825183505098L, 4776896707697368229L, 1428059224718910376L, 6690813482653982021L, -6248474067697161171L, 4951407828574235127L, 6198050452789369270L, 5776283192552877204L, -626480755095427154L, -6637184445929957204L, 8370873622748562952L, -1705978583731280501L, -7898818752540221055L, -2516210193198301541L, 8356900479849653862L, -4413748141896466000L, -6040072975510680789L, 1451490609699316991L, -7948005844616396060L, 8567048088357095527L, -4375578310507393311L};
    private static final long[] HASHES_OF_LOOPING_BYTES_WITH_SEED_42 = new long[]{-7444071767201028348L, -8959994473701255385L, 7116559933691734543L, 6019482000716350659L, -6625277557348586272L, -5507563483608914162L, 1540412690865189709L, 4522324563441226749L, -7143238906056518746L, -7989831429045113014L, -7103973673268129917L, -2319060423616348937L, -7576144055863289344L, -8903544572546912743L, 6376815151655939880L, 5913754614426879871L, 6466567997237536608L, -869838547529805462L, -2416009472486582019L, -3059673981515537339L, 4211239092494362041L, 1414635639471257331L, 166863084165354636L, -3761330575439628223L, 3524931906845391329L, 6070229753198168844L, -3740381894759773016L, -1268276809699008557L, 1518581707938531581L, 7988048690914090770L, -4510281763783422346L, -8988936099728967847L};

    @Test
    public void testConstructor() {
        BlockSplitBloomFilter bloomFilter1 = new BlockSplitBloomFilter(0);
        Assert.assertEquals((long)bloomFilter1.getBitsetSize(), (long)32L);
        BlockSplitBloomFilter bloomFilter3 = new BlockSplitBloomFilter(1000);
        Assert.assertEquals((long)bloomFilter3.getBitsetSize(), (long)1024L);
    }

    @Test
    public void testBloomFilterForString() {
        int numValues = 0x100000;
        int numBytes = BlockSplitBloomFilter.optimalNumOfBits((long)0x100000L, (double)0.01) / 8;
        BlockSplitBloomFilter bloomFilter = new BlockSplitBloomFilter(numBytes);
        HashSet<String> testStrings = new HashSet<String>();
        for (int i = 0; i < 0x100000; ++i) {
            String str = RandomStringUtils.randomAlphabetic((int)1, (int)64);
            bloomFilter.insertHash(bloomFilter.hash(Binary.fromString((String)str)));
            testStrings.add(str);
        }
        for (String testString : testStrings) {
            Assert.assertTrue((boolean)bloomFilter.findHash(bloomFilter.hash(Binary.fromString((String)testString))));
        }
    }

    @Test
    public void testBloomFilterForPrimitives() {
        for (int i = 0; i < 4; ++i) {
            long seed = System.nanoTime();
            this.testBloomFilterForPrimitives(seed);
        }
    }

    private void testBloomFilterForPrimitives(long seed) {
        Random random = new Random(seed);
        int numValues = 0x100000;
        int numBytes = BlockSplitBloomFilter.optimalNumOfBits((long)0x100000L, (double)(random.nextDouble() / 10.0)) / 8;
        BlockSplitBloomFilter bloomFilter = new BlockSplitBloomFilter(numBytes);
        HashSet<Integer> values = new HashSet<Integer>();
        for (int i = 0; i < 0x100000; ++i) {
            Number v;
            int n = random.nextInt(4);
            switch (n) {
                case 0: {
                    v = random.nextInt();
                    break;
                }
                case 1: {
                    v = random.nextLong();
                    break;
                }
                case 2: {
                    v = Float.valueOf(random.nextFloat());
                    break;
                }
                default: {
                    v = random.nextDouble();
                }
            }
            values.add((Integer)v);
            bloomFilter.insertHash(bloomFilter.hash((Object)v));
        }
        for (Object e : values) {
            Assert.assertTrue((String)String.format("the value %s should not be filtered, seed = %d", e, seed), (boolean)bloomFilter.findHash(bloomFilter.hash(e)));
        }
    }

    @Test
    public void testBloomFilterFPPAccuracy() {
        int totalCount = 100000;
        double FPP = 0.01;
        BlockSplitBloomFilter bloomFilter = new BlockSplitBloomFilter(BlockSplitBloomFilter.optimalNumOfBits((long)100000L, (double)0.01) / 8);
        HashSet<String> distinctStrings = new HashSet<String>();
        while (distinctStrings.size() < 100000) {
            String str = RandomStringUtils.randomAlphabetic((int)12);
            if (!distinctStrings.add(str)) continue;
            bloomFilter.insertHash(bloomFilter.hash(Binary.fromString((String)str)));
        }
        distinctStrings.clear();
        int exist = 0;
        while (distinctStrings.size() < 100000) {
            String str = RandomStringUtils.randomAlphabetic((int)10);
            if (!distinctStrings.add(str) || !bloomFilter.findHash(bloomFilter.hash(Binary.fromString((String)str)))) continue;
            ++exist;
        }
        Assert.assertTrue(((double)exist < 1200.0 ? 1 : 0) != 0);
    }

    @Test
    public void testEquals() {
        String[] words = new String[]{"hello", "parquet", "bloom", "filter"};
        BlockSplitBloomFilter bloomFilterOne = new BlockSplitBloomFilter(1024);
        BlockSplitBloomFilter bloomFilterTwo = new BlockSplitBloomFilter(1024);
        for (String word : words) {
            bloomFilterOne.insertHash(bloomFilterOne.hash(Binary.fromString((String)word)));
            bloomFilterTwo.insertHash(bloomFilterTwo.hash(Binary.fromString((String)word)));
        }
        Assert.assertEquals((Object)bloomFilterOne, (Object)bloomFilterTwo);
        BlockSplitBloomFilter bloomFilterThree = new BlockSplitBloomFilter(1024);
        bloomFilterThree.insertHash(bloomFilterThree.hash(Binary.fromString((String)"parquet")));
        Assert.assertNotEquals((Object)bloomFilterTwo, (Object)bloomFilterThree);
    }

    @Test
    public void testBloomFilterNDVs() {
        int ndv = 0x1000000;
        double fpp = 0.01;
        double numBits = (double)(-8 * ndv) / Math.log(1.0 - Math.pow(0.01, 0.125));
        int bytes = (int)numBits / 8;
        Assert.assertTrue((bytes < 0x1400000 ? 1 : 0) != 0);
        ndv = 0x8000000 / UUID.randomUUID().toString().length();
        numBits = (double)(-8 * ndv) / Math.log(1.0 - Math.pow(fpp, 0.125));
        bytes = (int)numBits / 8;
        Assert.assertTrue((bytes < 0x500000 ? 1 : 0) != 0);
    }

    @Test
    public void testAdaptiveBloomFilter() {
        int maxBloomFilterSize = 0x100000;
        int candidateNumber = 10;
        AdaptiveBlockSplitBloomFilter adaptiveBloomFilter = new AdaptiveBlockSplitBloomFilter(maxBloomFilterSize, candidateNumber, 0.01, null);
        Assert.assertEquals((long)candidateNumber, (long)adaptiveBloomFilter.getCandidates().size());
        HashSet<String> existedValue = new HashSet<String>();
        while (existedValue.size() < 10000) {
            String str = RandomStringUtils.randomAlphabetic((int)1, (int)64);
            adaptiveBloomFilter.insertHash(adaptiveBloomFilter.hash(Binary.fromString((String)str)));
            existedValue.add(str);
        }
        Assert.assertEquals((long)7L, (long)adaptiveBloomFilter.getCandidates().size());
        BlockSplitBloomFilter optimalCandidate = adaptiveBloomFilter.optimalCandidate().getBloomFilter();
        for (String value : existedValue) {
            Assert.assertTrue((boolean)optimalCandidate.findHash(optimalCandidate.hash(Binary.fromString((String)value))));
        }
        int maxCandidateNDV = ((AdaptiveBlockSplitBloomFilter.BloomFilterCandidate)adaptiveBloomFilter.getCandidates().stream().max(AdaptiveBlockSplitBloomFilter.BloomFilterCandidate::compareTo).get()).getExpectedNDV();
        while (existedValue.size() < maxCandidateNDV + 1) {
            String str = RandomStringUtils.randomAlphabetic((int)1, (int)64);
            adaptiveBloomFilter.insertHash(adaptiveBloomFilter.hash(Binary.fromString((String)str)));
            existedValue.add(str);
        }
        Assert.assertEquals((long)1L, (long)adaptiveBloomFilter.getCandidates().size());
    }

    @Test
    public void testMergeBloomFilter() throws IOException {
        int i;
        int numBytes = BlockSplitBloomFilter.optimalNumOfBits((long)5120L, (double)0.01) / 8;
        BlockSplitBloomFilter otherBloomFilter = new BlockSplitBloomFilter(numBytes);
        BlockSplitBloomFilter mergedBloomFilter = new BlockSplitBloomFilter(numBytes);
        for (i = 0; i < 1024; ++i) {
            mergedBloomFilter.insertHash(mergedBloomFilter.hash(i));
        }
        for (i = 1024; i < 2048; ++i) {
            otherBloomFilter.insertHash(otherBloomFilter.hash(i));
            Assert.assertFalse((boolean)mergedBloomFilter.findHash(mergedBloomFilter.hash(i)));
        }
        mergedBloomFilter.merge((BloomFilter)otherBloomFilter);
        for (i = 0; i < 2048; ++i) {
            Assert.assertTrue((boolean)mergedBloomFilter.findHash(mergedBloomFilter.hash(i)));
        }
        for (i = 2048; i < 3096; ++i) {
            Assert.assertFalse((boolean)otherBloomFilter.findHash(otherBloomFilter.hash(i)));
            Assert.assertFalse((boolean)mergedBloomFilter.findHash(mergedBloomFilter.hash(i)));
        }
    }

    @Test
    public void testMergeBloomFilterFailed() throws IOException {
        int numBytes = BlockSplitBloomFilter.optimalNumOfBits((long)5120L, (double)0.01) / 8;
        BlockSplitBloomFilter mergedBloomFilter = new BlockSplitBloomFilter(numBytes);
        BlockSplitBloomFilter otherBloomFilter = new BlockSplitBloomFilter(numBytes * 1024);
        try {
            mergedBloomFilter.merge((BloomFilter)otherBloomFilter);
            Assert.fail();
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
    }

    @Test
    public void testXxHashCorrectness() {
        byte[] data = new byte[32];
        for (int i = 0; i < data.length; ++i) {
            data[i] = (byte)i;
            ByteBuffer input = ByteBuffer.wrap(data, 0, i).order(ByteOrder.nativeOrder());
            Assert.assertEquals((long)HASHES_OF_LOOPING_BYTES_WITH_SEED_0[i], (long)LongHashFunction.xx((long)0L).hashBytes(input));
            Assert.assertEquals((long)HASHES_OF_LOOPING_BYTES_WITH_SEED_42[i], (long)LongHashFunction.xx((long)42L).hashBytes(input));
        }
    }
}

